package io.tacsio.mercadolivre.validation;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

@Documented
@Constraint(validatedBy = UniqueValidator.class)
@Target({ElementType.FIELD, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
public @interface Unique {
    String message() default "value already exists";

    Class<?> entityClass();

    String entityField();

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
