/*
 * Decompiled with CFR 0.152.
 */
package com.qq.taf.jce.dynamic;

import com.qq.taf.jce.JceDecodeException;
import com.qq.taf.jce.JceOutputStream;
import com.qq.taf.jce.dynamic.ByteArrayField;
import com.qq.taf.jce.dynamic.ByteField;
import com.qq.taf.jce.dynamic.DoubleField;
import com.qq.taf.jce.dynamic.FloatField;
import com.qq.taf.jce.dynamic.IntField;
import com.qq.taf.jce.dynamic.JceField;
import com.qq.taf.jce.dynamic.ListField;
import com.qq.taf.jce.dynamic.LongField;
import com.qq.taf.jce.dynamic.MapField;
import com.qq.taf.jce.dynamic.ShortField;
import com.qq.taf.jce.dynamic.StringField;
import com.qq.taf.jce.dynamic.StructField;
import com.qq.taf.jce.dynamic.ZeroField;
import java.nio.ByteBuffer;

public final class DynamicOutputStream
extends JceOutputStream {
    public DynamicOutputStream(ByteBuffer bs) {
        super(bs);
    }

    public DynamicOutputStream(int capacity) {
        super(capacity);
    }

    public DynamicOutputStream() {
    }

    public void write(JceField field) {
        int tag = field.getTag();
        if (field instanceof ZeroField) {
            this.write(0, tag);
        } else if (field instanceof IntField) {
            this.write(((IntField)field).get(), tag);
        } else if (field instanceof ShortField) {
            this.write(((ShortField)field).get(), tag);
        } else if (field instanceof ByteField) {
            this.write(((ByteField)field).get(), tag);
        } else if (field instanceof StringField) {
            this.write(((StringField)field).get(), tag);
        } else if (field instanceof ByteArrayField) {
            this.write(((ByteArrayField)field).get(), tag);
        } else if (field instanceof ListField) {
            ListField lf = (ListField)field;
            this.reserve(8);
            this.writeHead((byte)9, tag);
            this.write(lf.size(), 0);
            for (JceField jf : lf.get()) {
                this.write(jf);
            }
        } else if (field instanceof MapField) {
            MapField mf = (MapField)field;
            this.reserve(8);
            this.writeHead((byte)8, tag);
            int ns = mf.size();
            this.write(ns, 0);
            for (int i = 0; i < ns; ++i) {
                this.write(mf.getKey(i));
                this.write(mf.getValue(i));
            }
        } else if (field instanceof StructField) {
            StructField sf = (StructField)field;
            this.reserve(2);
            this.writeHead((byte)10, tag);
            for (JceField jf : sf.get()) {
                this.write(jf);
            }
            this.reserve(2);
            this.writeHead((byte)11, 0);
        } else if (field instanceof LongField) {
            this.write(((LongField)field).get(), tag);
        } else if (field instanceof FloatField) {
            this.write(((FloatField)field).get(), tag);
        } else if (field instanceof DoubleField) {
            this.write(((DoubleField)field).get(), tag);
        } else {
            throw new JceDecodeException("unknow JceField type: " + field.getClass().getName());
        }
    }
}

