/*
 * Decompiled with CFR 0.152.
 */
package com.qq.jce.wup;

import com.qq.jce.wup.ObjectCreateException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicClassTypeUtil {
    private static void addType(ArrayList<String> list, String type) {
        int point = type.length();
        while (type.charAt(point - 1) == '>' && --point != 0) {
        }
        list.add(0, BasicClassTypeUtil.uni2JavaType(type.substring(0, point)));
    }

    public static ArrayList<String> getTypeList(String fullType) {
        ArrayList<String> type = new ArrayList<String>();
        int point = 0;
        int splitPoint = fullType.indexOf("<");
        int mapPoint = -1;
        while (point < splitPoint) {
            BasicClassTypeUtil.addType(type, fullType.substring(point, splitPoint));
            point = splitPoint + 1;
            splitPoint = fullType.indexOf("<", point);
            mapPoint = fullType.indexOf(",", point);
            if (splitPoint == -1) {
                splitPoint = mapPoint;
            }
            if (mapPoint == -1 || mapPoint >= splitPoint) continue;
            splitPoint = mapPoint;
        }
        BasicClassTypeUtil.addType(type, fullType.substring(point, fullType.length()));
        return type;
    }

    public static void main(String[] args) {
        ArrayList<String> src = new ArrayList<String>();
        src.add("char");
        src.add("list<char>");
        src.add("list<list<char>>");
        src.add("map<short,string>");
        src.add("map<double,map<float,list<bool>>>");
        src.add("map<int64,list<Test.UserInfo>>");
        src.add("map<short,Test.FriendInfo>");
        for (String ss : src) {
            ArrayList<String> list = BasicClassTypeUtil.getTypeList(ss);
            for (String s : list) {
                System.out.println(s);
            }
            Collections.reverse(list);
            System.out.println("-------------finished " + BasicClassTypeUtil.transTypeList(list));
        }
    }

    public static String transTypeList(ArrayList<String> listTpye) {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < listTpye.size(); ++i) {
            listTpye.set(i, BasicClassTypeUtil.java2UniType(listTpye.get(i)));
        }
        Collections.reverse(listTpye);
        for (i = 0; i < listTpye.size(); ++i) {
            String type = listTpye.get(i);
            if (type.equals("list")) {
                listTpye.set(i - 1, "<" + listTpye.get(i - 1));
                listTpye.set(0, listTpye.get(0) + ">");
                continue;
            }
            if (type.equals("map")) {
                listTpye.set(i - 1, "<" + listTpye.get(i - 1) + ",");
                listTpye.set(0, listTpye.get(0) + ">");
                continue;
            }
            if (!type.equals("Array")) continue;
            listTpye.set(i - 1, "<" + listTpye.get(i - 1));
            listTpye.set(0, listTpye.get(0) + ">");
        }
        Collections.reverse(listTpye);
        for (String s : listTpye) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static Object createClassByUni(String className) throws ObjectCreateException {
        ArrayList<String> list = BasicClassTypeUtil.getTypeList(className);
        Object last = null;
        Object last2 = null;
        Object returnObject = null;
        for (String name : list) {
            returnObject = BasicClassTypeUtil.createClassByName(name);
            if (returnObject instanceof String) {
                if ("Array".equals((String)returnObject)) {
                    if (last != null) continue;
                    returnObject = Array.newInstance(Byte.class, 0);
                    continue;
                }
                if ("?".equals((String)returnObject)) continue;
                if (last == null) {
                    last = returnObject;
                    continue;
                }
                last2 = last;
                last = returnObject;
                continue;
            }
            if (returnObject instanceof List) {
                if (null != last && last instanceof Byte) {
                    returnObject = Array.newInstance(Byte.class, 1);
                    Array.set(returnObject, 0, last);
                    continue;
                }
                if (last != null) {
                    ((List)returnObject).add(last);
                }
                last = null;
                continue;
            }
            if (returnObject instanceof Map) {
                if (last != null & last2 != null) {
                    ((Map)returnObject).put(last, last2);
                }
                last = null;
                last2 = null;
                continue;
            }
            if (last == null) {
                last = returnObject;
                continue;
            }
            last2 = last;
            last = returnObject;
        }
        return returnObject;
    }

    public static Object createClassByName(String name) throws ObjectCreateException {
        if (name.equals("java.lang.Integer")) {
            return 0;
        }
        if (name.equals("java.lang.Boolean")) {
            return false;
        }
        if (name.equals("java.lang.Byte")) {
            return (byte)0;
        }
        if (name.equals("java.lang.Double")) {
            return 0.0;
        }
        if (name.equals("java.lang.Float")) {
            return Float.valueOf(0.0f);
        }
        if (name.equals("java.lang.Long")) {
            return 0L;
        }
        if (name.equals("java.lang.Short")) {
            return (short)0;
        }
        if (name.equals("java.lang.Character")) {
            throw new IllegalArgumentException("can not support java.lang.Character");
        }
        if (name.equals("java.lang.String")) {
            return "";
        }
        if (name.equals("java.util.List")) {
            return new ArrayList();
        }
        if (name.equals("java.util.Map")) {
            return new HashMap();
        }
        if (name.equals("Array")) {
            return "Array";
        }
        if (name.equals("?")) {
            return name;
        }
        try {
            Class<?> newoneClass = Class.forName(name);
            Constructor<?> cons = newoneClass.getConstructor(new Class[0]);
            return cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ObjectCreateException(e);
        }
    }

    public static String java2UniType(String srcType) {
        if (srcType.equals("java.lang.Integer") || srcType.equals("int")) {
            return "int32";
        }
        if (srcType.equals("java.lang.Boolean") || srcType.equals("boolean")) {
            return "bool";
        }
        if (srcType.equals("java.lang.Byte") || srcType.equals("byte")) {
            return "char";
        }
        if (srcType.equals("java.lang.Double") || srcType.equals("double")) {
            return "double";
        }
        if (srcType.equals("java.lang.Float") || srcType.equals("float")) {
            return "float";
        }
        if (srcType.equals("java.lang.Long") || srcType.equals("long")) {
            return "int64";
        }
        if (srcType.equals("java.lang.Short") || srcType.equals("short")) {
            return "short";
        }
        if (srcType.equals("java.lang.Character")) {
            throw new IllegalArgumentException("can not support java.lang.Character");
        }
        if (srcType.equals("java.lang.String")) {
            return "string";
        }
        if (srcType.equals("java.util.List")) {
            return "list";
        }
        if (srcType.equals("java.util.Map")) {
            return "map";
        }
        return srcType;
    }

    public static String uni2JavaType(String srcType) {
        if (srcType.equals("int32")) {
            return "java.lang.Integer";
        }
        if (srcType.equals("bool")) {
            return "java.lang.Boolean";
        }
        if (srcType.equals("char")) {
            return "java.lang.Byte";
        }
        if (srcType.equals("double")) {
            return "java.lang.Double";
        }
        if (srcType.equals("float")) {
            return "java.lang.Float";
        }
        if (srcType.equals("int64")) {
            return "java.lang.Long";
        }
        if (srcType.equals("short")) {
            return "java.lang.Short";
        }
        if (srcType.equals("string")) {
            return "java.lang.String";
        }
        if (srcType.equals("list")) {
            return "java.util.List";
        }
        if (srcType.equals("map")) {
            return "java.util.Map";
        }
        return srcType;
    }

    public static boolean isBasicType(String name) {
        if (name.equals("int")) {
            return true;
        }
        if (name.equals("boolean")) {
            return true;
        }
        if (name.equals("byte")) {
            return true;
        }
        if (name.equals("double")) {
            return true;
        }
        if (name.equals("float")) {
            return true;
        }
        if (name.equals("long")) {
            return true;
        }
        if (name.equals("short")) {
            return true;
        }
        if (name.equals("char")) {
            return true;
        }
        if (name.equals("Integer")) {
            return true;
        }
        if (name.equals("Boolean")) {
            return true;
        }
        if (name.equals("Byte")) {
            return true;
        }
        if (name.equals("Double")) {
            return true;
        }
        if (name.equals("Float")) {
            return true;
        }
        if (name.equals("Long")) {
            return true;
        }
        if (name.equals("Short")) {
            return true;
        }
        return name.equals("Char");
    }

    public static String getClassTransName(String name) {
        if (name.equals("int")) {
            name = "Integer";
        } else if (name.equals("boolean")) {
            name = "Boolean";
        } else if (name.equals("byte")) {
            name = "Byte";
        } else if (name.equals("double")) {
            name = "Double";
        } else if (name.equals("float")) {
            name = "Float";
        } else if (name.equals("long")) {
            name = "Long";
        } else if (name.equals("short")) {
            name = "Short";
        } else if (name.equals("char")) {
            name = "Character";
        }
        return name;
    }

    public static String getVariableInit(String name, String type) {
        if (type.equals("int")) {
            return type + " " + name + "=0 ;\n";
        }
        if (type.equals("boolean")) {
            return type + " " + name + "=false ;\n";
        }
        if (type.equals("byte")) {
            return type + " " + name + " ;\n";
        }
        if (type.equals("double")) {
            return type + " " + name + "=0 ;\n";
        }
        if (type.equals("float")) {
            return type + " " + name + "=0 ;\n";
        }
        if (type.equals("long")) {
            return type + " " + name + "=0 ;\n";
        }
        if (type.equals("short")) {
            return type + " " + name + "=0 ;\n";
        }
        if (type.equals("char")) {
            return type + " " + name + " ;\n";
        }
        return type + " " + name + " = null ;\n";
    }
}

