/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tesla.soload;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.tencent.tesla.soload.ConfigStruct;
import com.tencent.tesla.soload.MyZipEntry;
import com.tencent.tesla.soload.MyZipFile;
import dalvik.system.BaseDexClassLoader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SoLoadCore {
    private static final String CONFIGPATH = "soconfig.cfg";
    private static HashMap<String, Long> assestCrcConfigs = null;
    public static final int IF_GENERATE_CACHE_SUCCESS = 0x200000;
    public static final int IF_GET_AVAILIABLE_CRCVALUE = 0x100000;
    public static final int IF_TRY_LOAD_LIBRARY_SUCCESS = 524288;
    public static final int TRY_LOAD_LIBRARY_SUCCESS = 262144;
    public static final int IF_SO_CONFIG_EXIST = 131072;
    public static final int IF_READ_CONFIGFILE_SUCCESS = 65536;
    public static final int CONFIG_SO_PATH_IN_LIB = 32768;
    public static final int CONFIG_SO_PATH_IN_TXLIB = 16384;
    public static final int IF_CONFIG_SO_CRCCHECK_SUCCESS = 8192;
    public static final int IF_TRY_LOAD_CONFIG_SO_SUCCESS = 4096;
    public static final int IF_SOFILE_EXIST_IN_LIBPATH = 2048;
    public static final int IF_SOFILE_IN_LIB_CHECK_SUCCESS = 1024;
    public static final int IF_TRY_LOADSO_INLIBPATH_SUCCESS = 512;
    public static final int API_EUQAL_AND_ABOVE_14 = 256;
    public static final int API_BELOW_14 = 128;
    public static final int IF_RELEASE_BY_CLASSLOADER_SUCCESS = 64;
    public static final int IF_RELEASE_SOFILE_CHECK_SUCCESS = 32;
    public static final int IF_TRY_LOAD_RELEASESO_SUCCESS = 16;
    public static final int IF_RELEASE_BY_ZIP_CHECK_SUCCESS = 8;
    public static final int IF_TRY_LOAD_SO_BY_ZIP_SUCCESS = 4;
    public static final int LOAD_SO_SUCCESS_SAVE_AND_RETURN = 2;
    public static final String PATH_TX_LIB = "/txlib/";
    public static final String PATH_LIB = "/lib/";
    public static final String APP_ROOT = "/data/data/com.tencent.mobileqq/files";

    public static int loadSo(Context context, String lib) {
        String libname = SoLoadCore.getLibActualName(lib);
        int resultCode = 0x200000;
        long rightcrc = -1L;
        SoLoadCore.initAssestCrcConfigs(context);
        if (assestCrcConfigs != null && !assestCrcConfigs.isEmpty()) {
            resultCode |= 0x100000;
            Long crcLong = assestCrcConfigs.get(String.valueOf(SoLoadCore.getPlatformString()) + "/" + libname);
            if (crcLong != null && crcLong > 1L) {
                rightcrc = crcLong;
            } else {
                crcLong = assestCrcConfigs.get("armeabi/" + libname);
                if (crcLong != null && crcLong > 1L) {
                    rightcrc = crcLong;
                }
            }
        }
        if (rightcrc < 0L) {
            resultCode |= 0x80000;
            try {
                System.loadLibrary(lib);
                resultCode |= 0x40000;
            }
            catch (UnsatisfiedLinkError crcLong) {
                // empty catch block
            }
            return resultCode;
        }
        boolean loadResult = false;
        String configDir = context.getFilesDir() + "/" + "soconfigs";
        File dir = new File(configDir);
        dir.mkdirs();
        String configs = String.valueOf(configDir) + "/" + lib + ".cfg";
        resultCode |= 0x20000;
        File soConfig = new File(configs);
        if (soConfig.exists()) {
            ConfigStruct config = SoLoadCore.readConfig(soConfig);
            resultCode |= 0x10000;
            if (config != null) {
                resultCode = config.mSopath.contains(PATH_TX_LIB) ? (resultCode |= 0x4000) : (resultCode |= 0x8000);
                File sofile = new File(config.mSopath);
                resultCode |= 0x2000;
                if (config.mCrcvalue == rightcrc && sofile.exists()) {
                    resultCode |= 0x1000;
                    try {
                        System.load(sofile.getAbsolutePath());
                        return resultCode |= 2;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        // empty catch block
                    }
                }
            }
        }
        String txLibPath = String.valueOf(SoLoadCore.getAppWorkPath(context)) + PATH_TX_LIB;
        String appLibPath = String.valueOf(SoLoadCore.getAppWorkPath(context)) + PATH_LIB;
        File libSoFile = new File(String.valueOf(appLibPath) + libname);
        resultCode |= 0x800;
        if (libSoFile.exists()) {
            resultCode |= 0x400;
            long mcrc = SoLoadCore.getCRC32Value(libSoFile);
            if (mcrc == rightcrc) {
                resultCode |= 0x200;
                loadResult = SoLoadCore.loadAndSave(libSoFile, mcrc, soConfig);
                if (loadResult) {
                    return resultCode |= 2;
                }
            }
        }
        String classloader = SoLoadCore.getOsClassLoader();
        File resultFile = null;
        if (classloader.equals("equalAndAbove14")) {
            resultCode |= 0x100;
            String reallib = "lib/" + SoLoadCore.getPlatformString() + "/" + libname;
            resultFile = SoLoadCore.getSoOrDexByBaseDexClassLoader(context, reallib, String.valueOf(txLibPath) + libname);
        } else if (classloader.equals("below14")) {
            resultCode |= 0x80;
            resultFile = SoLoadCore.getSoOrDexByPathClassLoader(context, libname, txLibPath);
        }
        resultCode |= 0x40;
        if (resultFile != null) {
            long newsocrc = SoLoadCore.getCRC32Value(resultFile);
            resultCode |= 0x20;
            if (newsocrc == rightcrc) {
                resultCode |= 0x10;
                loadResult = SoLoadCore.loadAndSave(resultFile, newsocrc, soConfig);
                if (loadResult) {
                    return resultCode |= 2;
                }
            } else if (resultFile.exists()) {
                resultFile.delete();
            }
        }
        resultFile = SoLoadCore.releaseFromApk(SoLoadCore.getApkPath(context), libname, txLibPath);
        long newsocrc = SoLoadCore.getCRC32Value(resultFile);
        resultCode |= 8;
        if (newsocrc == rightcrc) {
            resultCode |= 4;
            loadResult = SoLoadCore.loadAndSave(resultFile, newsocrc, soConfig);
            if (loadResult) {
                resultCode |= 2;
            }
        }
        return resultCode;
    }

    public static File releaseSoAnyway(Context context, String libname, String dstPath) {
        File resultFile = null;
        if (SoLoadCore.hasBaseDexClassloader()) {
            String reallib = "lib/" + SoLoadCore.getPlatformString() + "/" + libname;
            if (!dstPath.endsWith(File.separator)) {
                dstPath = String.valueOf(dstPath) + File.separator;
            }
            resultFile = SoLoadCore.getSoOrDexByBaseDexClassLoader(context, reallib, String.valueOf(dstPath) + libname);
        } else {
            resultFile = SoLoadCore.getSoOrDexByPathClassLoader(context, libname, dstPath);
        }
        if (resultFile == null) {
            resultFile = SoLoadCore.releaseFromApk(SoLoadCore.getApkPath(context), libname, dstPath);
        }
        return resultFile;
    }

    private static boolean loadAndSave(File soFile, long newCrc, File soConfig) {
        boolean loadResult = false;
        try {
            System.load(soFile.getAbsolutePath());
            loadResult = true;
        }
        catch (UnsatisfiedLinkError e) {
            loadResult = false;
        }
        if (loadResult) {
            ConfigStruct config = new ConfigStruct(newCrc, soFile.getAbsolutePath());
            boolean bl = SoLoadCore.writeConfig(config, soConfig);
        }
        return loadResult;
    }

    private static synchronized void initAssestCrcConfigs(Context context) {
        block14: {
            if (assestCrcConfigs != null) {
                return;
            }
            InputStream is = null;
            try {
                try {
                    assestCrcConfigs = new HashMap();
                    String result = "";
                    is = context.getResources().getAssets().open(CONFIGPATH);
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((result = br.readLine()) != null) {
                        int index = result.indexOf(":");
                        String libname = result.substring(0, index);
                        String crcstr = result.substring(index + 1);
                        long crc = Long.parseLong(crcstr);
                        if (crc < 1L) continue;
                        Long crclong = crc;
                        assestCrcConfigs.put(libname, crclong);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (is == null) break block14;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static String getLibActualName(String libName) {
        return "lib" + libName + ".so";
    }

    private static boolean writeConfig(ConfigStruct struct, File configf) {
        boolean result;
        block13: {
            BufferedWriter bw = null;
            result = false;
            try {
                try {
                    if (configf.exists()) {
                        configf.delete();
                    }
                    configf.createNewFile();
                    FileOutputStream fos = new FileOutputStream(configf);
                    bw = new BufferedWriter(new OutputStreamWriter(fos));
                    bw.write("crcvalue=" + struct.mCrcvalue);
                    bw.newLine();
                    bw.write("path=" + struct.mSopath);
                    result = true;
                }
                catch (Exception exception) {
                    if (bw == null) break block13;
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    private static ConfigStruct readConfig(File configf) {
        FileInputStream fis = null;
        BufferedReader br = null;
        ConfigStruct config = null;
        try {
            String sopath = "";
            long mcrc = -1L;
            fis = new FileInputStream(configf);
            br = new BufferedReader(new InputStreamReader(fis));
            String str = "";
            str = br.readLine();
            if (str == null || !str.contains("crc")) {
                ConfigStruct configStruct = config;
                return configStruct;
            }
            int begin = str.indexOf("=");
            String crcstr = str.substring(begin + 1);
            mcrc = Long.parseLong(crcstr);
            try {
                str = br.readLine();
                if (str != null && str.contains("path")) {
                    begin = str.indexOf("=");
                    sopath = str.substring(begin + 1);
                }
                if (mcrc != -1L && sopath != "") {
                    config = new ConfigStruct(mcrc, sopath);
                }
            }
            catch (Exception exception) {}
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return config;
    }

    public static long getCRC32Value(InputStream in) throws Exception {
        int bytesRead = -1;
        byte[] buffer = new byte[8192];
        CRC32 crc32 = new CRC32();
        while ((bytesRead = in.read(buffer)) != -1) {
            crc32.update(buffer, 0, bytesRead);
        }
        long val = crc32.getValue();
        return val;
    }

    public static long getCRC32Value(File file) {
        if (file == null || !file.exists()) {
            return -100L;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            long l = SoLoadCore.getCRC32Value(in);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return -100L;
    }

    public static File releaseFromApk(String srcPath, String soname, String dstPath) {
        if (!dstPath.endsWith(File.separator)) {
            dstPath = String.valueOf(dstPath) + File.separator;
        }
        File tempf = new File(dstPath);
        tempf.mkdirs();
        File outFile = null;
        MyZipFile zipFile = null;
        String path = "lib/" + SoLoadCore.getPlatformString() + "/";
        String reallib = "lib/" + SoLoadCore.getPlatformString() + "/" + soname;
        try {
            zipFile = new MyZipFile(new File(srcPath), reallib);
        }
        catch (IOException e) {
            zipFile = null;
            e.printStackTrace();
        }
        if (zipFile == null) {
            return null;
        }
        MyZipEntry mz = zipFile.getDesEntry();
        if (mz != null && mz.getName().contains(path) && mz.getName().endsWith(".so")) {
            String name = mz.getName();
            int index = name.lastIndexOf(47);
            if (index != -1) {
                name = name.substring(index + 1);
            }
            if ((outFile = new File(String.valueOf(dstPath) + name)).exists()) {
                outFile.delete();
            }
            FileOutputStream fos = null;
            InputStream zipInput = null;
            byte[] buffer = new byte[4096];
            try {
                int bytesRead;
                zipInput = zipFile.getInputStream(mz);
                fos = new FileOutputStream(outFile);
                while ((bytesRead = zipInput.read(buffer)) > 0) {
                    fos.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outFile;
    }

    public static File getSoOrDexByPathClassLoader(Context context, String libname, String dstpath) {
        File outf = new File(String.valueOf(dstpath) + libname);
        ClassLoader loader = context.getClassLoader();
        Class<?> clazz = loader.getClass();
        try {
            Field fmzips = clazz.getDeclaredField("mZips");
            fmzips.setAccessible(true);
            Object mzips = fmzips.get(loader);
            Class<?> mzipsc = mzips.getClass();
            if (mzipsc.isArray()) {
                ZipEntry ze = null;
                ZipFile mzip = null;
                int length = Array.getLength(mzips);
                int i = 0;
                while (i < length) {
                    mzip = (ZipFile)Array.get(mzips, i);
                    ze = mzip.getEntry(libname);
                    if (ze != null) break;
                    ++i;
                }
                if (ze != null && mzip != null) {
                    SoLoadCore.copyZipEntry2File(ze, mzip, outf);
                } else {
                    outf = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            outf = null;
        }
        return outf;
    }

    private static File getSoOrDexByBaseDexClassLoader(Context context, String entryName, String dstpath) {
        File outf = new File(dstpath);
        if (outf.exists()) {
            outf.delete();
        }
        ClassLoader loader = context.getClassLoader();
        BaseDexClassLoader bdc = (BaseDexClassLoader)context.getClassLoader();
        Class<?> clazz = loader.getClass().getSuperclass();
        try {
            int length;
            outf.createNewFile();
            Field pathlist = clazz.getDeclaredField("pathList");
            pathlist.setAccessible(true);
            Object o = pathlist.get(bdc);
            Class<?> dexclass = pathlist.get(bdc).getClass();
            Field dexElements = dexclass.getDeclaredField("dexElements");
            dexElements.setAccessible(true);
            Object e = dexElements.get(o);
            Class<?> eclass = e.getClass();
            if (eclass.isArray() && (length = Array.getLength(e)) > 0) {
                ZipEntry ze = null;
                ZipFile zip = null;
                int i = 0;
                while (i < length) {
                    Object elem = Array.get(e, i);
                    Field zipfile = elem.getClass().getDeclaredField("zipFile");
                    zipfile.setAccessible(true);
                    Object z = zipfile.get(elem);
                    zip = (ZipFile)z;
                    ze = zip.getEntry(entryName);
                    if (ze != null) break;
                    ++i;
                }
                if (ze != null && zip != null) {
                    SoLoadCore.copyZipEntry2File(ze, zip, outf);
                } else {
                    outf = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            outf = null;
        }
        return outf;
    }

    private static boolean hasBaseDexClassloader() {
        try {
            Class.forName("dalvik.system.BaseDexClassLoader");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void copyZipEntry2File(ZipEntry ze, ZipFile zip, File outf) {
        InputStream is = null;
        FilterOutputStream fos = null;
        BufferedInputStream bis = null;
        try {
            if (ze == null || zip == null) {
                return;
            }
            try {
                is = zip.getInputStream(ze);
                bis = new BufferedInputStream(is);
                byte[] data = new byte[8192];
                fos = new BufferedOutputStream(new FileOutputStream(outf));
                int i = 0;
                while ((i = bis.read(data)) != -1) {
                    ((BufferedOutputStream)fos).write(data, 0, i);
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
            try {
                zip.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static synchronized String getPlatformString() {
        String platform = Build.CPU_ABI;
        if (platform != null && platform.contains("x86")) {
            return "x86";
        }
        if (platform != null && platform.contains("mip")) {
            return "mips";
        }
        return "armeabi";
    }

    private static synchronized String getDefaultPlatformString() {
        return "armeabi";
    }

    public static String getApkPath(Context context) {
        PackageManager pm = context.getPackageManager();
        String pkgname = context.getPackageName();
        ApplicationInfo pi = null;
        try {
            pi = pm.getApplicationInfo(pkgname, 8192);
            if (pi != null) {
                return pi.sourceDir;
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppWorkPath(Context context) {
        String path = null;
        try {
            path = context.getFilesDir().getParent();
        }
        catch (Exception e2) {
            Object e2 = null;
            try {
                Object baseContext = null;
                if (context instanceof ContextWrapper) {
                    baseContext = ((ContextWrapper)context).getBaseContext();
                } else {
                    Field baseField = ContextWrapper.class.getDeclaredField("mBase");
                    baseField.setAccessible(true);
                    baseContext = baseField.get(context);
                }
                Method m = baseContext.getClass().getDeclaredMethod("getDataDirFile", new Class[0]);
                m.setAccessible(true);
                File file = (File)m.invoke(baseContext, new Object[0]);
                path = file.getAbsolutePath();
            }
            catch (Throwable t) {
                Object var3_6 = null;
            }
        }
        return path;
    }

    public static String getOsClassLoader() {
        try {
            Class.forName("dalvik.system.LexClassLoader");
            return "lex";
        }
        catch (ClassNotFoundException classNotFoundException) {
            boolean hasBaseDexClassLoader = true;
            try {
                Class.forName("dalvik.system.BaseDexClassLoader");
            }
            catch (ClassNotFoundException e) {
                hasBaseDexClassLoader = false;
            }
            if (!hasBaseDexClassLoader) {
                return "below14";
            }
            return "equalAndAbove14";
        }
    }
}

