/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tesla.soload;

import com.tencent.tesla.soload.BufferIterator;
import com.tencent.tesla.soload.HeapBufferIterator;
import com.tencent.tesla.soload.MyZipConstants;
import com.tencent.tesla.soload.MyZipEntry;
import com.tencent.tesla.soload.Streams;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

class MyZipFile
implements MyZipConstants {
    static final int GPBF_DATA_DESCRIPTOR_FLAG = 8;
    static final int GPBF_UTF8_FLAG = 2048;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private final String fileName;
    private String libname;
    private File fileToDeleteOnClose;
    private RandomAccessFile mRaf;
    private MyZipEntry desentry = null;
    private final LinkedHashMap<String, MyZipEntry> mEntries = new LinkedHashMap();

    public MyZipFile(File file, String libname) throws ZipException, IOException {
        this(file, 1, libname);
    }

    public MyZipFile(File file, int mode, String libname) throws IOException {
        this.libname = libname;
        this.fileName = file.getPath();
        if (mode != 1 && mode != 5) {
            throw new IllegalArgumentException();
        }
        this.fileToDeleteOnClose = (mode & 4) != 0 ? file : null;
        this.mRaf = new RandomAccessFile(this.fileName, "r");
        this.readCentralDir();
    }

    public MyZipFile(String name, String libname) throws IOException {
        this(new File(name), 1, libname);
    }

    private void checkNotClosed() {
        if (this.mRaf == null) {
            throw new IllegalStateException("Zip file closed");
        }
    }

    public MyZipEntry getEntry(String entryName) {
        this.checkNotClosed();
        if (entryName == null) {
            throw new NullPointerException();
        }
        MyZipEntry ze = this.mEntries.get(entryName);
        if (ze == null) {
            ze = this.mEntries.get(String.valueOf(entryName) + "/");
        }
        return ze;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(MyZipEntry entry) throws IOException {
        RandomAccessFile raf;
        if ((entry = this.getEntry(entry.getName())) == null) {
            return null;
        }
        RandomAccessFile randomAccessFile = raf = this.mRaf;
        synchronized (randomAccessFile) {
            RAFStream rafstrm = new RAFStream(raf, entry.mLocalHeaderRelOffset + 28L);
            DataInputStream is = new DataInputStream(rafstrm);
            short localExtraLenOrWhatever = Short.reverseBytes(is.readShort());
            is.close();
            rafstrm.skip(entry.nameLength + localExtraLenOrWhatever);
            rafstrm.mLength = rafstrm.mOffset + entry.compressedSize;
            if (entry.compressionMethod == 8) {
                int bufSize = Math.max(1024, (int)Math.min(entry.getSize(), 65535L));
                return new ZipInflaterInputStream(rafstrm, new Inflater(true), bufSize, entry);
            }
            return rafstrm;
        }
    }

    public String getName() {
        return this.fileName;
    }

    public MyZipEntry getDesEntry() {
        return this.desentry;
    }

    private void readCentralDir() throws IOException {
        block6: {
            long scanOffset = this.mRaf.length() - 22L;
            if (scanOffset < 0L) {
                throw new ZipException("too short to be Zip");
            }
            long stopOffset = scanOffset - 65536L;
            if (stopOffset < 0L) {
                stopOffset = 0L;
            }
            int ENDHEADERMAGIC = 101010256;
            do {
                this.mRaf.seek(scanOffset);
                if (Integer.reverseBytes(this.mRaf.readInt()) == 101010256) break block6;
            } while (--scanOffset >= stopOffset);
            throw new ZipException("EOCD not found; not a Zip archive?");
        }
        byte[] eocd = new byte[18];
        this.mRaf.readFully(eocd);
        HeapBufferIterator it = HeapBufferIterator.iterator(eocd, 0, eocd.length, ByteOrder.LITTLE_ENDIAN);
        short diskNumber = ((BufferIterator)it).readShort();
        short diskWithCentralDir = ((BufferIterator)it).readShort();
        int numEntries = ((BufferIterator)it).readShort();
        short totalNumEntries = ((BufferIterator)it).readShort();
        ((BufferIterator)it).skip(4);
        int centralDirOffset = ((BufferIterator)it).readInt();
        if (numEntries != totalNumEntries || diskNumber != 0 || diskWithCentralDir != 0) {
            throw new ZipException("spanned archives not supported");
        }
        RAFStream rafs = new RAFStream(this.mRaf, centralDirOffset);
        BufferedInputStream bin = new BufferedInputStream(rafs, 4096);
        byte[] hdrBuf = new byte[46];
        int i = 0;
        while (i < numEntries) {
            MyZipEntry newEntry = new MyZipEntry(hdrBuf, bin);
            this.mEntries.put(newEntry.getName(), newEntry);
            if (newEntry.getName().equals(this.libname)) {
                this.desentry = newEntry;
                break;
            }
            newEntry.getName().contains("lib");
            ++i;
        }
    }

    static class RAFStream
    extends InputStream {
        RandomAccessFile mSharedRaf;
        long mOffset;
        long mLength;

        public RAFStream(RandomAccessFile raf, long pos) throws IOException {
            this.mSharedRaf = raf;
            this.mOffset = pos;
            this.mLength = raf.length();
        }

        @Override
        public int available() throws IOException {
            return this.mOffset < this.mLength ? 1 : 0;
        }

        @Override
        public int read() throws IOException {
            return Streams.readSingleByte(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            RandomAccessFile randomAccessFile = this.mSharedRaf;
            synchronized (randomAccessFile) {
                int count;
                this.mSharedRaf.seek(this.mOffset);
                if ((long)len > this.mLength - this.mOffset) {
                    len = (int)(this.mLength - this.mOffset);
                }
                if ((count = this.mSharedRaf.read(b, off, len)) > 0) {
                    this.mOffset += (long)count;
                    return count;
                }
                return -1;
            }
        }

        @Override
        public long skip(long byteCount) throws IOException {
            if (byteCount > this.mLength - this.mOffset) {
                byteCount = this.mLength - this.mOffset;
            }
            this.mOffset += byteCount;
            return byteCount;
        }
    }

    static class ZipInflaterInputStream
    extends InflaterInputStream {
        MyZipEntry entry;
        long bytesRead = 0L;

        public ZipInflaterInputStream(InputStream is, Inflater inf, int bsize, MyZipEntry entry) {
            super(is, inf, bsize);
            this.entry = entry;
        }

        @Override
        public int read(byte[] buffer, int off, int nbytes) throws IOException {
            int i = super.read(buffer, off, nbytes);
            if (i != -1) {
                this.bytesRead += (long)i;
            }
            return i;
        }

        @Override
        public int available() throws IOException {
            return super.available() == 0 ? 0 : (int)(this.entry.getSize() - this.bytesRead);
        }
    }
}

