/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tesla.soload;

import com.tencent.tesla.soload.HeapBufferIterator;
import com.tencent.tesla.soload.MyZipConstants;
import com.tencent.tesla.soload.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

class MyZipEntry
implements MyZipConstants,
Cloneable {
    String name;
    String comment;
    long compressedSize = -1L;
    long crc = -1L;
    long size = -1L;
    int compressionMethod = -1;
    int time = -1;
    int modDate = -1;
    byte[] extra;
    int nameLength = -1;
    long mLocalHeaderRelOffset = -1L;
    long mLocContentSize = -1L;
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    int version = -1;
    int versionMinimum = -1;
    int flags = -1;
    int extraLength = -1;
    int commentLength = -1;
    int diskNumbers = -1;
    int internalFileAttri = -1;
    long externalFileAttri = -1L;
    byte[] nameBytes;
    boolean hasDD = false;

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    MyZipEntry(byte[] hdrBuf, InputStream in) throws IOException {
        Streams.readFully(in, hdrBuf, 0, hdrBuf.length);
        HeapBufferIterator it = HeapBufferIterator.iterator(hdrBuf, 0, hdrBuf.length, ByteOrder.LITTLE_ENDIAN);
        int sig = it.readInt();
        this.version = it.readShort();
        this.versionMinimum = it.readShort();
        this.flags = it.readShort();
        this.compressionMethod = it.readShort();
        this.time = it.readShort();
        this.modDate = it.readShort();
        this.crc = (long)it.readInt() & 0xFFFFFFFFL;
        this.compressedSize = (long)it.readInt() & 0xFFFFFFFFL;
        this.size = (long)it.readInt() & 0xFFFFFFFFL;
        this.nameLength = it.readShort();
        this.extraLength = it.readShort();
        this.commentLength = it.readShort();
        this.diskNumbers = it.readShort();
        this.internalFileAttri = it.readShort();
        this.externalFileAttri = (long)it.readInt() & 0xFFFFFFFFL;
        this.mLocalHeaderRelOffset = (long)it.readInt() & 0xFFFFFFFFL;
        this.nameBytes = new byte[this.nameLength];
        Streams.readFully(in, this.nameBytes, 0, this.nameBytes.length);
        this.name = new String(this.nameBytes, 0, this.nameBytes.length, "UTF-8");
        if (this.commentLength > 0) {
            byte[] commentBytes = new byte[this.commentLength];
            Streams.readFully(in, commentBytes, 0, this.commentLength);
            this.comment = new String(commentBytes, 0, commentBytes.length, "UTF-8");
        }
        if (this.extraLength > 0) {
            this.extra = new byte[this.extraLength];
            Streams.readFully(in, this.extra, 0, this.extraLength);
        }
    }
}

