/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tesla.soload;

import com.tencent.tesla.soload.BufferIterator;
import com.tencent.tesla.soload.Memory;
import java.nio.ByteOrder;

public final class HeapBufferIterator
extends BufferIterator {
    private final byte[] buffer;
    private final int offset;
    private final int byteCount;
    private final ByteOrder order;
    private int position;

    HeapBufferIterator(byte[] buffer, int offset, int byteCount, ByteOrder order) {
        this.buffer = buffer;
        this.offset = offset;
        this.byteCount = byteCount;
        this.order = order;
    }

    @Override
    public void seek(int offset) {
        this.position = offset;
    }

    @Override
    public void skip(int byteCount) {
        this.position += byteCount;
    }

    @Override
    public int readInt() {
        int result = Memory.peekInt(this.buffer, this.offset + this.position, this.order);
        this.position += 4;
        return result;
    }

    @Override
    public short readShort() {
        short result = Memory.peekShort(this.buffer, this.offset + this.position, this.order);
        this.position += 2;
        return result;
    }

    public static HeapBufferIterator iterator(byte[] buffer, int offset, int byteCount, ByteOrder order) {
        return new HeapBufferIterator(buffer, offset, byteCount, order);
    }

    public final class SizeOf {
        public static final int CHAR = 2;
        public static final int DOUBLE = 8;
        public static final int FLOAT = 4;
        public static final int INT = 4;
        public static final int LONG = 8;
        public static final int SHORT = 2;

        private SizeOf() {
        }
    }
}

