/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qalsdk.util;

import com.tencent.qalsdk.util.AbsSessionInputBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.util.ByteArrayBuffer;
import qalsdk.n;

public class MsfSocketInputBuffer
extends AbsSessionInputBuffer {
    public InputStream instream;
    private int inputBufferSize = 0;
    private static final Class SOCKET_TIMEOUT_CLASS = MsfSocketInputBuffer.SocketTimeoutExceptionClass();
    private final Socket socket;

    private static Class SocketTimeoutExceptionClass() {
        try {
            return Class.forName("java.net.SocketTimeoutException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static boolean isSocketTimeoutException(InterruptedIOException interruptedIOException) {
        if (SOCKET_TIMEOUT_CLASS != null) {
            return SOCKET_TIMEOUT_CLASS.isInstance(interruptedIOException);
        }
        return true;
    }

    public MsfSocketInputBuffer(Socket socket, int n2, String string, int n3) throws IOException {
        InputStream inputStream;
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        this.socket = socket;
        if (n2 < 0) {
            n2 = socket.getReceiveBufferSize();
        }
        if (n2 < 1024) {
            n2 = 1024;
        }
        if (!n.m.contains((inputStream = socket.getInputStream()).toString())) {
            n.m.add(inputStream.toString());
        }
        this.init(inputStream, n2, string, n3);
    }

    public boolean isDataAvailable(int n2) throws IOException {
        boolean bl;
        block4: {
            bl = this.hasBufferedData();
            if (!bl) {
                try {
                    int n3 = this.fillBuffer();
                    if (n3 == -1) {
                        throw new IOException("readData return -1");
                    }
                    bl = this.hasBufferedData();
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (MsfSocketInputBuffer.isSocketTimeoutException(interruptedIOException)) break block4;
                    throw interruptedIOException;
                }
            }
        }
        return bl;
    }

    public void reset() {
        if (null != this.buffer) {
            this.buffer = new byte[this.inputBufferSize];
        }
        this.bufferpos = 0;
        this.bufferlen = 0;
        if (null != this.linebuffer) {
            this.linebuffer.clear();
        }
    }

    protected void init(InputStream inputStream, int n2, String string, int n3) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Buffer size may not be negative or zero");
        }
        this.instream = inputStream;
        this.inputBufferSize = n2;
        this.buffer = new byte[this.inputBufferSize];
        this.bufferpos = 0;
        this.bufferlen = 0;
        this.linebuffer = new ByteArrayBuffer(n2);
        this.charset = string;
        this.ascii = this.charset.equalsIgnoreCase("US-ASCII") || this.charset.equalsIgnoreCase("ASCII");
        this.maxLineLen = n3;
        this.metrics = new HttpTransportMetricsImpl();
    }

    @Override
    protected int fillBuffer() throws IOException {
        int n2;
        int n3;
        int n4;
        if (this.bufferpos > 0) {
            n4 = this.bufferlen - this.bufferpos;
            if (n4 > 0) {
                System.arraycopy(this.buffer, this.bufferpos, this.buffer, 0, n4);
            }
            this.bufferpos = 0;
            this.bufferlen = n4;
        }
        if ((n4 = this.instream.read(this.buffer, n3 = this.bufferlen, n2 = this.buffer.length - n3)) == -1) {
            return -1;
        }
        this.bufferlen = n3 + n4;
        this.metrics.incrementBytesTransferred((long)n4);
        return n4;
    }
}

