/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qalsdk.util;

import java.io.IOException;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

public abstract class AbsSessionInputBuffer
implements SessionInputBuffer {
    protected byte[] buffer;
    protected int bufferpos;
    protected int bufferlen;
    protected ByteArrayBuffer linebuffer = null;
    protected String charset = "US-ASCII";
    protected boolean ascii = true;
    protected int maxLineLen = -1;
    protected HttpTransportMetricsImpl metrics;

    public boolean hasBufferedData() {
        return this.bufferpos < this.bufferlen;
    }

    public int read() throws IOException {
        int n2 = 0;
        while (!this.hasBufferedData()) {
            n2 = this.fillBuffer();
            if (n2 != -1) continue;
            return -1;
        }
        return this.buffer[this.bufferpos++] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            return 0;
        }
        int n4 = 0;
        while (!this.hasBufferedData()) {
            n4 = this.fillBuffer();
            if (n4 != -1) continue;
            return -1;
        }
        int n5 = this.bufferlen - this.bufferpos;
        if (n5 > n3) {
            n5 = n3;
        }
        System.arraycopy(this.buffer, this.bufferpos, byArray, n2, n5);
        this.bufferpos += n5;
        return n5;
    }

    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }

    private int locateLF() {
        for (int i2 = this.bufferpos; i2 < this.bufferlen; ++i2) {
            if (this.buffer[i2] != 10) continue;
            return i2;
        }
        return -1;
    }

    public int readLine(CharArrayBuffer charArrayBuffer) throws IOException {
        if (charArrayBuffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        this.linebuffer.clear();
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            int n3;
            int n4 = this.locateLF();
            if (n4 != -1) {
                if (this.linebuffer.isEmpty()) {
                    return this.lineFromReadBuffer(charArrayBuffer, n4);
                }
                bl = false;
                n3 = n4 + 1 - this.bufferpos;
                this.linebuffer.append(this.buffer, this.bufferpos, n3);
                this.bufferpos = n4 + 1;
            } else {
                if (this.hasBufferedData()) {
                    n3 = this.bufferlen - this.bufferpos;
                    this.linebuffer.append(this.buffer, this.bufferpos, n3);
                    this.bufferpos = this.bufferlen;
                }
                if ((n2 = this.fillBuffer()) == -1) {
                    bl = false;
                }
            }
            if (this.maxLineLen <= 0 || this.linebuffer.length() < this.maxLineLen) continue;
            throw new IOException("Maximum line length limit exceeded");
        }
        if (n2 == -1 && this.linebuffer.isEmpty()) {
            return -1;
        }
        return this.lineFromLineBuffer(charArrayBuffer);
    }

    private int lineFromLineBuffer(CharArrayBuffer charArrayBuffer) throws IOException {
        int n2 = this.linebuffer.length();
        if (n2 > 0) {
            if (this.linebuffer.byteAt(n2 - 1) == 10) {
                this.linebuffer.setLength(--n2);
            }
            if (n2 > 0 && this.linebuffer.byteAt(n2 - 1) == 13) {
                this.linebuffer.setLength(--n2);
            }
        }
        n2 = this.linebuffer.length();
        if (this.ascii) {
            charArrayBuffer.append(this.linebuffer, 0, n2);
        } else {
            String string = new String(this.linebuffer.buffer(), 0, n2, this.charset);
            charArrayBuffer.append(string);
        }
        return n2;
    }

    private int lineFromReadBuffer(CharArrayBuffer charArrayBuffer, int n2) throws IOException {
        int n3 = this.bufferpos;
        this.bufferpos = n2 + 1;
        if (n2 > n3 && this.buffer[n2 - 1] == 13) {
            --n2;
        }
        int n4 = n2 - n3;
        if (this.ascii) {
            charArrayBuffer.append(this.buffer, n3, n4);
        } else {
            String string = new String(this.buffer, n3, n4, this.charset);
            charArrayBuffer.append(string);
        }
        return n4;
    }

    public String readLine() throws IOException {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        int n2 = this.readLine(charArrayBuffer);
        if (n2 != -1) {
            return charArrayBuffer.toString();
        }
        return null;
    }

    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getBufferpos() {
        return this.bufferpos;
    }

    public int getBufferlen() {
        return this.bufferlen;
    }

    protected abstract int fillBuffer() throws IOException;
}

