/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qalsdk.sdk;

import android.app.ActivityManager;
import android.content.Context;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import com.tencent.qalsdk.base.remote.FromServiceMsg;
import com.tencent.qalsdk.base.remote.ToServiceMsg;
import com.tencent.qalsdk.util.QLog;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class MsfSdkUtils {
    private static final AtomicInteger seqFactory = new AtomicInteger(new Random().nextInt(100000));
    public static final SimpleDateFormat timeFormatter = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
    private static final String[] PRIVILEGE_CMDS = new String[]{"openim.pbvideoinfo", "openim.pbvideoapp", "openim.pbtinyidtouserid", "openim.pbuseridtotinyid"};
    private static final String tag = "MsfSdkUtils";

    public static boolean isTopActivity(Context context) {
        try {
            if (context == null) {
                return false;
            }
            String string = context.getPackageName();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List list = activityManager.getRunningTasks(1);
            return ((ActivityManager.RunningTaskInfo)list.get((int)0)).topActivity.getPackageName().equals(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isScreenOn(Context context) {
        if (context == null) {
            return false;
        }
        boolean bl = false;
        try {
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            Method method = powerManager.getClass().getMethod("isScreenOn", new Class[0]);
            bl = (Boolean)method.invoke((Object)powerManager, (Object[])null);
        }
        catch (Exception exception) {
            QLog.d(tag, 1, "e = " + exception.toString());
            bl = true;
        }
        return bl;
    }

    public static String getProcessName(Context context) {
        if (context == null) {
            return "unknown";
        }
        List list = null;
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            list = activityManager.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (null == runningAppProcessInfo || runningAppProcessInfo.pid != Process.myPid()) continue;
                return runningAppProcessInfo.processName;
            }
        }
        catch (Exception exception) {
            QLog.d(tag, 1, "getProcessName error " + list);
        }
        return "unknown";
    }

    public static boolean isMainProcess(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        String string = context.getPackageName();
        int n2 = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (runningAppProcessInfo.pid != n2 || !string.equals(runningAppProcessInfo.processName)) continue;
            return true;
        }
        return false;
    }

    public static synchronized int getNextAppSeq() {
        int n2 = seqFactory.incrementAndGet();
        if (n2 > 1000000) {
            seqFactory.set(new Random().nextInt(100000));
        }
        if (n2 == 50000) {
            n2 += 10000;
        }
        return n2;
    }

    public static boolean killProcess(Context context, String string) {
        if (context == null || string == null) {
            return false;
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (!runningAppProcessInfo.processName.equals(string)) continue;
            Process.killProcess((int)runningAppProcessInfo.pid);
            return true;
        }
        return false;
    }

    public static FromServiceMsg constructResponse(String string, String string2, int n2, int n3, String string3, Object object, int n4) {
        FromServiceMsg fromServiceMsg = new FromServiceMsg(string, string2);
        fromServiceMsg.setAppId(n2);
        if (n3 != 1000) {
            fromServiceMsg.setBusinessFail(n3, string3);
        } else {
            fromServiceMsg.setMsgSuccess();
        }
        if (null != object) {
            fromServiceMsg.addAttribute(string2, object);
        }
        fromServiceMsg.setRequestSsoSeq(n4);
        return fromServiceMsg;
    }

    public static void addFromMsgProcessName(String string, FromServiceMsg fromServiceMsg) {
        if (fromServiceMsg == null) {
            return;
        }
        fromServiceMsg.getAttributes().put("to_SenderProcessName", string);
    }

    public static void addToMsgProcessName(String string, ToServiceMsg toServiceMsg) {
        if (toServiceMsg == null) {
            return;
        }
        toServiceMsg.getAttributes().put("to_SenderProcessName", string);
    }

    public static byte[] convertInt2Bytes(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return byArray;
    }

    public static int convertBytes2Int(byte[] byArray) {
        int n2 = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] << 0 & 0xFF;
        return n2;
    }

    public static int convertBytes2Int(byte[] byArray, int n2) {
        int n3 = byArray[0 + n2] << 24 & 0xFF000000 | byArray[1 + n2] << 16 & 0xFF0000 | byArray[2 + n2] << 8 & 0xFF00 | byArray[3 + n2] << 0 & 0xFF;
        return n3;
    }

    public static void saveConfig(String string, Properties properties) throws Exception {
        if (string == null || properties == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string, false);
            properties.store(fileOutputStream, "");
        }
        finally {
            if (null != fileOutputStream) {
                fileOutputStream.close();
            }
        }
    }

    public static Properties loadConfig(String string) throws Exception {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
        }
        finally {
            if (null != fileInputStream) {
                fileInputStream.close();
            }
        }
        return properties;
    }

    public static FromServiceMsg constructResponse(ToServiceMsg toServiceMsg, int n2, String string, Object object) {
        if (toServiceMsg == null) {
            return new FromServiceMsg();
        }
        FromServiceMsg fromServiceMsg = MsfSdkUtils.constructResponse(toServiceMsg.getUin(), toServiceMsg.getServiceCmd(), toServiceMsg.getAppId(), n2, string, object, toServiceMsg.getRequestSsoSeq());
        fromServiceMsg.setAppSeq(toServiceMsg.getAppSeq());
        return fromServiceMsg;
    }

    public static String getShortUin(String string) {
        if (TextUtils.isEmpty((CharSequence)string) || string.length() < 4) {
            return string;
        }
        return "*" + string.substring(string.length() - 4, string.length());
    }

    public static String insertMtype(String string, String string2) {
        if (string2.contains("mType=")) {
            return string2;
        }
        if (null != string) {
            int n2 = string2.indexOf("?");
            if (n2 > 0) {
                int n3;
                string2 = string2.length() == n2 + 1 ? string2.substring(0, n2 + 1) + "mType=" + string : ((n3 = string2.indexOf("#", n2)) > -1 ? string2.substring(0, n3) + "&mType=" + string + string2.substring(n3) : string2 + "&mType=" + string);
            } else if (string2.length() > 0) {
                string2 = string2 + "?mType=" + string;
            }
        }
        return string2;
    }

    public static boolean isPrivilegeCMD(String string) {
        if (string == null) {
            return false;
        }
        for (int i2 = 0; i2 < PRIVILEGE_CMDS.length; ++i2) {
            if (!string.equals(PRIVILEGE_CMDS[i2])) continue;
            return true;
        }
        return false;
    }
}

