/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qalsdk.base.remote;

import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.tencent.qalsdk.base.remote.IBaseActionListener;
import com.tencent.qalsdk.base.remote.c;
import com.tencent.qalsdk.sdk.MsfCommand;
import java.io.Serializable;
import java.util.HashMap;

public class ToServiceMsg
implements Parcelable {
    private static final String tag = "ToServiceMsg";
    private static final String version = "version";
    private int appId;
    private String serviceName;
    private String uin;
    private String serviceCmd = "";
    private long sendTimeout = -1L;
    private long timeout = -1L;
    private int appSeq = -1;
    private byte[] wupBuffer = new byte[0];
    private boolean needResp = true;
    private boolean httpReq = false;
    private int ssoSeq = -1;
    private HashMap<String, Object> attributes = new HashMap();
    private IBaseActionListener actionListener;
    public Bundle extraData = new Bundle();
    private byte toVersion = 1;
    private MsfCommand msfCommand = MsfCommand.unknown;
    private byte uinType = (byte)20;
    public static final Parcelable.Creator<ToServiceMsg> CREATOR = new c();

    public ToServiceMsg(String string, String string2, String string3) {
        this.serviceName = string;
        this.uin = string2;
        this.serviceCmd = string3;
        this.extraData.putByte(version, this.toVersion);
    }

    public ToServiceMsg(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public String toString() {
        return "ToServiceMsg msName:" + (Object)((Object)this.msfCommand) + " ssoSeq:" + this.getRequestSsoSeq() + " appId:" + this.appId + " appSeq:" + this.appSeq + " sName:" + this.serviceName + " uin:" + this.uin + " sCmd:" + this.serviceCmd + " t:" + this.timeout + " needResp:" + this.needResp + "httpReq:" + this.httpReq;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        try {
            parcel.writeInt(this.appId);
            parcel.writeInt(this.appSeq);
            parcel.writeString(this.serviceName);
            parcel.writeString(this.uin);
            parcel.writeByte(this.uinType);
            parcel.writeString(this.serviceCmd);
            parcel.writeLong(this.timeout);
            parcel.writeBundle(this.extraData);
            parcel.writeStrongInterface((IInterface)this.actionListener);
            if (this.toVersion > 0) {
                parcel.writeSerializable((Serializable)((Object)this.msfCommand));
                parcel.writeLong(this.sendTimeout);
                parcel.writeByte(this.needResp ? (byte)1 : 0);
                parcel.writeByte(this.httpReq ? (byte)1 : 0);
                parcel.writeInt(this.wupBuffer.length);
                parcel.writeByteArray(this.wupBuffer);
                parcel.writeInt(this.ssoSeq);
                parcel.writeMap(this.attributes);
            }
        }
        catch (RuntimeException runtimeException) {
            Log.d((String)tag, (String)"writeToParcel RuntimeException", (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    private void readFromParcel(Parcel parcel) {
        try {
            this.appId = parcel.readInt();
            this.appSeq = parcel.readInt();
            this.serviceName = parcel.readString();
            this.uin = parcel.readString();
            this.uinType = parcel.readByte();
            this.serviceCmd = parcel.readString();
            this.timeout = parcel.readLong();
            this.extraData.clear();
            this.extraData.putAll(parcel.readBundle(Thread.currentThread().getContextClassLoader()));
            IBinder iBinder = parcel.readStrongBinder();
            this.actionListener = IBaseActionListener.Stub.asInterface(iBinder);
            this.toVersion = this.extraData.getByte(version);
            if (this.toVersion > 0) {
                this.msfCommand = (MsfCommand)((Object)parcel.readSerializable());
                this.sendTimeout = parcel.readLong();
                this.needResp = parcel.readByte() != 0;
                this.httpReq = parcel.readByte() != 0;
                this.wupBuffer = new byte[parcel.readInt()];
                parcel.readByteArray(this.wupBuffer);
                this.ssoSeq = parcel.readInt();
                this.attributes.clear();
                parcel.readMap(this.attributes, ToServiceMsg.class.getClassLoader());
            }
        }
        catch (RuntimeException runtimeException) {
            Log.d((String)tag, (String)"readFromParcel RuntimeException", (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    public byte[] getWupBuffer() {
        return this.wupBuffer;
    }

    public void putWupBuffer(byte[] byArray) {
        this.wupBuffer = byArray;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l2) {
        this.timeout = l2;
    }

    public void setActionListener(IBaseActionListener iBaseActionListener) {
        this.actionListener = iBaseActionListener;
    }

    public String getDestServiceId() {
        return this.serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getUin() {
        return this.uin;
    }

    public String getServiceCmd() {
        return this.serviceCmd;
    }

    public IBaseActionListener getActionListener() {
        return this.actionListener;
    }

    public boolean isNeedCallback() {
        return this.needResp;
    }

    public void setNeedCallback(boolean bl) {
        this.needResp = bl;
    }

    public boolean isHttpReq() {
        return this.httpReq;
    }

    public void setIsHttpReq() {
        this.httpReq = true;
    }

    public int getAppId() {
        return this.appId;
    }

    public void setAppId(int n2) {
        this.appId = n2;
    }

    public int getAppSeq() {
        return this.appSeq;
    }

    public void setAppSeq(int n2) {
        this.appSeq = n2;
    }

    public int getRequestSsoSeq() {
        return this.ssoSeq;
    }

    public void setRequestSsoSeq(int n2) {
        this.ssoSeq = n2;
    }

    public Object addAttribute(String string, Object object) {
        return this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public <T> T getAttribute(String string, T t2) {
        if (!this.attributes.containsKey(string)) {
            return t2;
        }
        return (T)this.attributes.get(string);
    }

    public HashMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setUin(String string) {
        this.uin = string;
    }

    public void setServiceCmd(String string) {
        this.serviceCmd = string;
    }

    public MsfCommand getMsfCommand() {
        return this.msfCommand;
    }

    public void setMsfCommand(MsfCommand msfCommand) {
        this.msfCommand = msfCommand;
    }

    public void setAttributes(HashMap<String, Object> hashMap) {
        this.attributes = hashMap;
    }

    public void setEnableFastResend(boolean bl) {
        this.addAttribute("fastresend", bl);
    }

    public boolean isFastResendEnabled() {
        return this.getAttribute("fastresend", false);
    }

    public void setNeedRemindSlowNetwork(boolean bl) {
        this.addAttribute("remind_slown_network", bl);
    }

    public boolean isNeedRemindSlowNetwork() {
        return this.getAttribute("remind_slown_network", false);
    }

    public void setUinType(int n2) {
        this.uinType = (byte)n2;
    }

    public byte getUinType() {
        return this.uinType;
    }
}

