/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qalhttp;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.tencent.mobileqq.pb.ByteStringMicro;
import com.tencent.mobileqq.pb.InvalidProtocolBufferMicroException;
import com.tencent.mobileqq.pb.MessageMicro;
import com.tencent.qalhttp.QALHttpResponse;
import com.tencent.qalhttp.QALHttpValueCallBack;
import com.tencent.qalhttp.a;
import com.tencent.qalhttp.b;
import com.tencent.qalhttp.c;
import com.tencent.qalhttp.d;
import com.tencent.qalsdk.QALInitHelper;
import com.tencent.qalsdk.base.remote.ToServiceMsg;
import com.tencent.qalsdk.core.j;
import com.tencent.qalsdk.im_open.QalMonitor;
import com.tencent.qalsdk.im_open.http;
import com.tencent.qalsdk.sdk.MsfCommand;
import com.tencent.qalsdk.sdk.ac;
import com.tencent.qalsdk.sdk.e;
import com.tencent.qalsdk.util.QLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class QALHttpHelper {
    private static final String tag = "QALHttpHelper";
    private String uri = null;
    private int method = -1;
    private String contentType = null;
    private String accept = null;
    private String acceptLanguage = null;
    private String acceptCharset = null;
    private String user_agent = null;
    private String cookie = null;
    private String referer = null;
    private String origin = null;
    private String x_requested_with = null;
    private String if_modified_since = null;
    private String if_unmodified_since = null;
    private String if_none_match = null;
    private String if_match = null;
    private List<String> cache_control = null;
    private String pragma;
    private Map<String, String> otherHeaders;
    private Map<String, String> formData;
    private String formDataCharSet;
    private byte[] body = null;
    private long beginTime = 0L;
    private static Handler mainHandler = new Handler(Looper.getMainLooper());
    static a cacheHelper = new a();
    LinkedList<QALHttpResponse> frags = new LinkedList();
    QALHttpResponse head = new QALHttpResponse();
    int total_length = -1;
    int local_total_length = 0;

    public QALHttpHelper(String string) {
        this.uri = string;
        this.otherHeaders = new HashMap<String, String>();
    }

    public boolean setRequestMethod(int n2) {
        this.method = n2;
        return true;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setAccept(String string) {
        this.accept = string;
    }

    public void setAcceptLanguage(String string) {
        this.acceptLanguage = string;
    }

    public void setAcceptCharset(String string) {
        this.acceptCharset = string;
    }

    public void setUserAgent(String string) {
        this.user_agent = string;
    }

    public void setCookie(String string) {
        this.cookie = string;
    }

    public void setReferer(String string) {
        this.referer = string;
    }

    public void setOrigin(String string) {
        this.origin = string;
    }

    public void setXRequestedWith(String string) {
        this.x_requested_with = string;
    }

    public void setIfModifiedSince(String string) {
        this.if_modified_since = string;
    }

    public void setIfUnmodifiedSince(String string) {
        this.if_unmodified_since = string;
    }

    public void setIfNoneMatch(String string) {
        this.if_none_match = string;
    }

    public void setIfMatch(String string) {
        this.if_match = string;
    }

    public void setCacheControl(List<String> list) {
        this.cache_control = list;
    }

    public void setPragma(String string) {
        this.pragma = string;
    }

    public void setRequestOtherHeader(String string, String string2) {
        this.otherHeaders.put(string, string2);
    }

    public void setFormData(String string, Map<String, String> map) {
        this.formData = map;
        this.contentType = "application/x-www-form-urlencoded;" + string;
    }

    public void setBody(byte[] byArray) {
        this.body = byArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Content-Type:");
        stringBuilder.append(this.contentType);
        stringBuilder.append("\n");
        stringBuilder.append("Accept:");
        stringBuilder.append(this.accept);
        stringBuilder.append("\n");
        stringBuilder.append("Accept-Language:");
        stringBuilder.append(this.acceptLanguage);
        stringBuilder.append("\n");
        stringBuilder.append("Accept-Charset:");
        stringBuilder.append(this.acceptCharset);
        stringBuilder.append("\n");
        stringBuilder.append("User-Agent:");
        stringBuilder.append(this.user_agent);
        stringBuilder.append("\n");
        stringBuilder.append("Cookie:");
        stringBuilder.append(this.cookie);
        stringBuilder.append("\n");
        stringBuilder.append("Referer:");
        stringBuilder.append(this.referer);
        stringBuilder.append("\n");
        stringBuilder.append("Origin:");
        stringBuilder.append(this.origin);
        stringBuilder.append("\n");
        stringBuilder.append("X-Requested-With:");
        stringBuilder.append(this.x_requested_with);
        stringBuilder.append("\n");
        stringBuilder.append("If-Modified-Since:");
        stringBuilder.append(this.if_modified_since);
        stringBuilder.append("\n");
        stringBuilder.append("If-Unmodified-Since:");
        stringBuilder.append(this.if_unmodified_since);
        stringBuilder.append("\n");
        stringBuilder.append("If-None-Match:");
        stringBuilder.append(this.if_none_match);
        stringBuilder.append("\n");
        stringBuilder.append("If-Match:");
        stringBuilder.append(this.if_match);
        stringBuilder.append("\n");
        stringBuilder.append("Pragma:");
        stringBuilder.append(this.pragma);
        return stringBuilder.toString();
    }

    public void request(QALHttpValueCallBack qALHttpValueCallBack) {
        Object object;
        QLog.i(tag, 1, "http request:" + this.method + ":" + this.uri);
        this.beginTime = SystemClock.elapsedRealtime();
        QALHttpResponse qALHttpResponse = cacheHelper.a(this.method, this.uri);
        if (qALHttpResponse != null) {
            object = new StringBuilder();
            QLog.d(tag, 1, ((StringBuilder)object).append("cache hit|qal http sdk resp ok:").append(qALHttpResponse.getStatus()).append("|").append(qALHttpResponse.getBody().length).append("|sdk costTime|").append(QALHttpHelper.cacheHelper.d).toString());
            this.mainCallSucc(qALHttpValueCallBack, qALHttpResponse);
            this.reportHttp(QALHttpHelper.cacheHelper.d, 0L, qALHttpResponse.getStatus(), "", true);
            if (!QALHttpHelper.cacheHelper.a) {
                return;
            }
            QLog.d(tag, 4, " cache hit| but need fresh");
        }
        if (QALHttpHelper.cacheHelper.c != null) {
            this.if_modified_since = QALHttpHelper.cacheHelper.c;
        }
        if (QALHttpHelper.cacheHelper.b != null) {
            this.if_none_match = QALHttpHelper.cacheHelper.b;
        }
        if ((object = (Object)this.EncodeRequest()) == null) {
            QLog.e(tag, this.uri + " http encode err");
            return;
        }
        b b2 = new b(this, qALHttpValueCallBack);
        if (e.b().f() == null) {
            QALInitHelper.instance().addToQueue("qal.http", (byte[])object, b2);
        } else {
            e.b().a(e.b().f(), "qal.http", (byte[])object, b2, e.b().c(((Object)object).length), true);
        }
    }

    private void removeSendMsg(ToServiceMsg toServiceMsg) {
        ac.a().a(toServiceMsg);
        toServiceMsg.setMsfCommand(MsfCommand.httpreq_remove);
        toServiceMsg.setNeedCallback(false);
        ac.a().b(toServiceMsg);
    }

    private void mainCallFail(QALHttpValueCallBack qALHttpValueCallBack, int n2, String string) {
        mainHandler.post((Runnable)new c(this, qALHttpValueCallBack, n2, string));
    }

    private void mainCallSucc(QALHttpValueCallBack qALHttpValueCallBack, QALHttpResponse qALHttpResponse) {
        mainHandler.post((Runnable)new d(this, qALHttpValueCallBack, qALHttpResponse));
    }

    public void onHttpResp(byte[] byArray, ToServiceMsg toServiceMsg, QALHttpValueCallBack qALHttpValueCallBack) {
        http.Response response = new http.Response();
        try {
            response.mergeFrom(byArray);
        }
        catch (InvalidProtocolBufferMicroException invalidProtocolBufferMicroException) {
            invalidProtocolBufferMicroException.printStackTrace();
            if (qALHttpValueCallBack != null) {
                String string = "http parse rspbody failed";
                long l2 = SystemClock.elapsedRealtime() - this.beginTime;
                this.mainCallFail(qALHttpValueCallBack, -21022, string);
                this.reportHttp(QALHttpHelper.cacheHelper.d, l2, 6001, string, false);
                QLog.e(tag, 1, this.uri + "|http resp error:http parse rspbody failed");
            }
            return;
        }
        QALHttpResponse qALHttpResponse = this.DecodeResponse(response);
        this.put_frag(qALHttpResponse);
        if (!this.is_full()) {
            return;
        }
        this.merge_frag();
        this.removeSendMsg(toServiceMsg);
        if (!this.is_complete()) {
            String string = "\u6536\u5305\u9519\u8bef,\u4e0d\u5b8c\u6574";
            long l3 = SystemClock.elapsedRealtime() - this.beginTime;
            this.mainCallFail(qALHttpValueCallBack, -21017, string);
            QLog.e(tag, this.uri + " http res error:" + -21017);
            this.reportHttp(QALHttpHelper.cacheHelper.d, l3, -21017, string, false);
            return;
        }
        if (this.head.responsePrivate.body_encoding.get() == 2 && this.head.getBody().length != 0) {
            byte[] byArray2 = this.unzipBody(this.head.getBody());
            if (byArray2 != null) {
                this.head.setBody(byArray2);
            } else {
                this.head.setStatus(-21016);
            }
        }
        long l4 = SystemClock.elapsedRealtime() - this.beginTime;
        if (!QALHttpHelper.cacheHelper.a) {
            if (this.head.getStatus() == 304) {
                QLog.i(tag, 1, this.uri + " 304,return from cache");
                this.mainCallSucc(qALHttpValueCallBack, cacheHelper.a(this.uri));
                this.reportHttp(QALHttpHelper.cacheHelper.d, l4, 304, "", false);
            } else if (this.head.getStatus() == -21016) {
                String string = "body unzip error";
                QLog.e(tag, 1, "http resp error:" + string);
                this.mainCallFail(qALHttpValueCallBack, -21016, string);
                this.reportHttp(QALHttpHelper.cacheHelper.d, l4, -21016, string, false);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                QLog.i(tag, 1, stringBuilder.append(this.uri).append("|").append("http resp :").append(this.head.getStatus()).append("|").append(this.head.getBody().length).toString());
                this.mainCallSucc(qALHttpValueCallBack, this.head);
                this.reportHttp(QALHttpHelper.cacheHelper.d, l4 - QALHttpHelper.cacheHelper.d, this.head.getStatus(), "", false);
            }
        } else {
            QLog.d(tag, 4, "cache already return ,server response need no return");
        }
        cacheHelper.a(this.method, this.uri, this.head);
    }

    private byte[] EncodeRequest() {
        MessageMicro messageMicro;
        http.Request request = new http.Request();
        if (this.uri == null) {
            QLog.e(tag, 1, "param error: uri null");
            return null;
        }
        request.uri.set(this.uri);
        if (this.method < 1 || this.method > 8) {
            QLog.e(tag, 1, "param error: method wrong");
            return null;
        }
        request.method.set(this.method);
        if (this.contentType != null) {
            request.content_type.set(this.contentType);
        }
        if (this.accept != null) {
            request.accept.set(this.accept);
        }
        if (this.acceptLanguage != null) {
            request.accept_language.set(this.acceptLanguage);
        }
        if (this.acceptCharset != null) {
            request.accept_charset.set(this.acceptCharset);
        }
        if (this.user_agent != null) {
            request.user_agent.set(this.user_agent);
        }
        if (this.cookie != null) {
            request.cookie.set(this.cookie);
        }
        if (this.referer != null) {
            request.referer.set(this.referer);
        }
        if (this.origin != null) {
            request.origin.set(this.origin);
        }
        if (this.x_requested_with != null) {
            request.x_requested_with.set(this.x_requested_with);
        }
        if (this.if_modified_since != null) {
            request.if_modified_since.set(this.if_modified_since);
        }
        if (this.if_unmodified_since != null) {
            request.if_unmodified_since.set(this.if_unmodified_since);
        }
        if (this.if_none_match != null) {
            request.if_none_match.set(this.if_none_match);
        }
        if (this.if_match != null) {
            request.if_match.set(this.if_match);
        }
        if (this.cache_control != null) {
            request.cache_control.set(this.cache_control);
        }
        if (this.pragma != null) {
            request.pragma.set(this.pragma);
        }
        for (String string : this.otherHeaders.keySet()) {
            if (string.equals("Accept-Encoding") || string.equals("Connection") || string.equals("Content-Length")) continue;
            messageMicro = new http.Pair();
            messageMicro.key.set(string);
            messageMicro.value.set(this.otherHeaders.get(string));
            request.other_headers.add(messageMicro);
        }
        if (this.formData != null) {
            for (String string : this.formData.keySet()) {
                messageMicro = new http.PairBytes();
                messageMicro.key.set(ByteStringMicro.copyFrom((byte[])string.getBytes()));
                messageMicro.value.set(ByteStringMicro.copyFrom((byte[])this.formData.get(string).getBytes()));
                request.x_www_form.add(messageMicro);
            }
        }
        if (this.body != null) {
            request.body.set(ByteStringMicro.copyFrom((byte[])this.body));
            QLog.d(tag, 4, "http reqeust body len:" + this.body.length);
        }
        Object object = request.toByteArray();
        return object;
    }

    private QALHttpResponse DecodeResponse(http.Response response) {
        QALHttpResponse qALHttpResponse = new QALHttpResponse();
        qALHttpResponse.setStatus(response.status_code.get());
        qALHttpResponse.setContentType(response.content_type.get());
        qALHttpResponse.setLocation(response.location.get());
        qALHttpResponse.setDate(response.date.get());
        qALHttpResponse.setServer(response.server.get());
        qALHttpResponse.setVia(response.via.get());
        qALHttpResponse.setXCache(response.x_cache.get());
        qALHttpResponse.setXCacheLookup(response.x_cache_lookup.get());
        qALHttpResponse.setAge(response.age.get());
        qALHttpResponse.setLastModified(response.last_modified.get());
        qALHttpResponse.setEtag(response.etag.get());
        qALHttpResponse.setCacheControl(response.cache_control.get());
        qALHttpResponse.setExpires(response.expires.get());
        qALHttpResponse.setPragma(response.pragma.get());
        qALHttpResponse.setSetCookie(response.set_cookie.get());
        qALHttpResponse.responsePrivate = (http.ResponsePrivate)response.private_response.get();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < response.other_headers.size(); ++i2) {
            hashMap.put(((http.Pair)response.other_headers.get((int)i2)).key.get(), ((http.Pair)response.other_headers.get((int)i2)).value.get());
        }
        qALHttpResponse.setOtherHeaders(hashMap);
        qALHttpResponse.setBody(response.body.get().toByteArray());
        return qALHttpResponse;
    }

    public byte[] unzipBody(byte[] byArray) {
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            byte[] byArray2 = new byte[4096];
            while ((n2 = gZIPInputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    boolean is_complete() {
        long l2;
        long l3 = l2 = this.head == null ? -1L : (long)this.head.getBody().length;
        return this.total_length >= 0 && l2 == (long)this.total_length;
    }

    boolean is_full() {
        return this.total_length >= 0 && this.local_total_length == this.total_length;
    }

    void merge_frag() {
        if (this.frags.isEmpty() || this.frags.get((int)0).responsePrivate.chunk_start.get() != 0L) {
            return;
        }
        this.head = this.frags.get(0);
        this.frags.remove(0);
        for (int i2 = 0; i2 < this.frags.size(); ++i2) {
            QALHttpResponse qALHttpResponse = this.frags.get(i2);
            if ((long)this.head.getBody().length != qALHttpResponse.responsePrivate.chunk_start.get()) {
                QLog.e(tag, "respfrag order wrong!");
                break;
            }
            byte[] byArray = new byte[this.head.getBody().length + qALHttpResponse.getBody().length];
            System.arraycopy(this.head.getBody(), 0, byArray, 0, this.head.getBody().length);
            System.arraycopy(qALHttpResponse.getBody(), 0, byArray, this.head.getBody().length, qALHttpResponse.getBody().length);
            this.head.setBody(byArray);
            if (!qALHttpResponse.getSetCookie().isEmpty()) {
                this.head.setSetCookie(qALHttpResponse.getSetCookie());
            }
            if (qALHttpResponse.responsePrivate.cache_max_age.get() >= 0L) {
                this.head.responsePrivate.cache_max_age.set(qALHttpResponse.responsePrivate.cache_max_age.get());
            }
            if (qALHttpResponse.responsePrivate.cache_max_stale_age.get() < 0L) continue;
            this.head.responsePrivate.cache_max_stale_age.set(qALHttpResponse.responsePrivate.cache_max_stale_age.get());
        }
    }

    void put_frag(QALHttpResponse qALHttpResponse) {
        if (this.frags.size() > 0) {
            int n2;
            for (n2 = this.frags.size() - 1; n2 >= 0; --n2) {
                QALHttpResponse qALHttpResponse2 = this.frags.get(n2);
                if (qALHttpResponse2.responsePrivate.chunk_start.get() < qALHttpResponse.responsePrivate.chunk_start.get()) break;
            }
            if (n2 == this.frags.size() - 1) {
                this.frags.add(qALHttpResponse);
            } else {
                this.frags.add(n2 + 1, qALHttpResponse);
            }
        } else {
            this.frags.add(qALHttpResponse);
        }
        this.local_total_length += qALHttpResponse.getBody().length;
        QLog.d(tag, "recv frag|" + qALHttpResponse.responsePrivate.chunk_start.get() + "|" + qALHttpResponse.getBody().length + "|local_len:" + this.local_total_length);
        if (qALHttpResponse.responsePrivate.total_length.get() >= 0L) {
            this.total_length = (int)qALHttpResponse.responsePrivate.total_length.get();
        }
    }

    private void reportHttp(long l2, long l3, int n2, String string, boolean bl) {
        double d2 = Math.random();
        if (d2 > 0.1) {
            return;
        }
        try {
            QalMonitor.Request request = new QalMonitor.Request();
            QalMonitor.Request.Http http2 = new QalMonitor.Request.Http();
            long l4 = System.currentTimeMillis() / 1000L;
            http2.timestamp.set((int)l4);
            http2.uri.set(this.uri);
            http2.cache_cost.set((int)l2);
            http2.total_cost.set((int)l3);
            http2.code.set(n2);
            http2.hit_cache.set(bl);
            if (e.b().i() != null) {
                http2.apn.set(e.b().i());
            }
            if (e.b().j() != null) {
                http2.gateway_ip.set(e.b().j());
            }
            if (e.b().k() != null) {
                http2.server_ip.set(e.b().k());
            }
            http2.radio_access.set(e.b().l());
            http2.errmsg.set(string);
            request.http.add((MessageMicro)http2);
            byte[] byArray = null;
            byArray = request.toByteArray();
            if (byArray == null) {
                QLog.e(tag, "http report pb error");
                return;
            }
            ToServiceMsg toServiceMsg = new ToServiceMsg("", e.b().f(), "CliLogSvc.QalUpload");
            toServiceMsg.setRequestSsoSeq(j.f());
            toServiceMsg.putWupBuffer(byArray);
            toServiceMsg.setUinType(20);
            toServiceMsg.setNeedCallback(false);
            toServiceMsg.setAppId(537049204);
            toServiceMsg.setTimeout(15000L);
            ac.a().b(toServiceMsg);
            StringBuilder stringBuilder = new StringBuilder();
            QLog.d(tag, "report http:" + stringBuilder.append(http2.timestamp.get()).append("|").append(http2.uri.get()).append("|").append(http2.cache_cost.get()).append("|").append(http2.total_cost.get()).append("|").append(http2.code.get()).append("|").append(http2.hit_cache.get()).append("|").append(http2.apn.get()).append("|").append(http2.radio_access.get()).append("|").append(http2.server_ip.get()).append("|").append(http2.gateway_ip.get()).toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static /* synthetic */ void access$000(QALHttpHelper qALHttpHelper, ToServiceMsg toServiceMsg) {
        qALHttpHelper.removeSendMsg(toServiceMsg);
    }

    static /* synthetic */ long access$100(QALHttpHelper qALHttpHelper) {
        return qALHttpHelper.beginTime;
    }

    static /* synthetic */ String access$200(QALHttpHelper qALHttpHelper) {
        return qALHttpHelper.uri;
    }

    static /* synthetic */ void access$300(QALHttpHelper qALHttpHelper, QALHttpValueCallBack qALHttpValueCallBack, int n2, String string) {
        qALHttpHelper.mainCallFail(qALHttpValueCallBack, n2, string);
    }

    static /* synthetic */ void access$400(QALHttpHelper qALHttpHelper, long l2, long l3, int n2, String string, boolean bl) {
        qALHttpHelper.reportHttp(l2, l3, n2, string, bl);
    }
}

