/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.tools;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import tencent.tls.report.QLog;
import tencent.tls.request.req_global;
import tencent.tls.tools.FileTracer;
import tencent.tls.tools.MD5;

public class util {
    public static final int S_ROLL_BACK = 180;
    public static int MAX_NAME_LEN = 128;
    private static final String TAG = "tls_sdk";
    private static int LOG_LEVEL = 1;
    public static final int D = 2;
    public static final int I = 1;
    public static final int W = 0;
    public static boolean LOGCAT_OUT = true;
    public static final int SSO_VERSION = 1;
    public static final String SDK_VERSION = "1.1.1794";
    public static final long BUILD_TIME = 1460985272L;
    public static final long SVN_VER = 1532L;
    private static final String LOG_DIR = "tencent/tls";
    private static final int MAX_FILE_SIZE = 102400;
    static final int MAX_CONTENT_SIZE = 4096;
    private static SimpleDateFormat DAYFORMAT = null;
    private static boolean libwtecdh_loaded = false;
    public static String LIBWT = "wtcrypto";
    private static String SPFileName = "TLS_DEVICE_INFO";
    public static int connRetryTimes = 3;
    public static String soLoadPath = "";
    @SuppressLint(value={"NewApi"})
    private static int MODE_MULTI_PROCESS = Build.VERSION.SDK_INT > 9 ? 4 : 0;
    static final char[] base64_encode_chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    static final char base64_pad_url = '_';
    static final short[] base64_reverse_table_url = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, 63, -1, -1, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public static byte[] get_os_type() {
        return "android".getBytes();
    }

    public static byte[] get_os_version() {
        return Build.VERSION.RELEASE.getBytes();
    }

    public static void int8_to_buf(byte[] buf, int pos, int value) {
        buf[pos + 0] = (byte)(value >> 0);
    }

    public static void int16_to_buf(byte[] buf, int pos, int value) {
        buf[pos + 1] = (byte)(value >> 0);
        buf[pos + 0] = (byte)(value >> 8);
    }

    public static void int32_to_buf(byte[] buf, int pos, int value) {
        buf[pos + 3] = (byte)(value >> 0);
        buf[pos + 2] = (byte)(value >> 8);
        buf[pos + 1] = (byte)(value >> 16);
        buf[pos + 0] = (byte)(value >> 24);
    }

    public static void int64_to_buf(byte[] buf, int pos, long value) {
        buf[pos + 7] = (byte)(value >> 0);
        buf[pos + 6] = (byte)(value >> 8);
        buf[pos + 5] = (byte)(value >> 16);
        buf[pos + 4] = (byte)(value >> 24);
        buf[pos + 3] = (byte)(value >> 32);
        buf[pos + 2] = (byte)(value >> 40);
        buf[pos + 1] = (byte)(value >> 48);
        buf[pos + 0] = (byte)(value >> 56);
    }

    public static void int64_to_buf32(byte[] buf, int pos, long value) {
        buf[pos + 3] = (byte)(value >> 0);
        buf[pos + 2] = (byte)(value >> 8);
        buf[pos + 1] = (byte)(value >> 16);
        buf[pos + 0] = (byte)(value >> 24);
    }

    public static int buf_to_int8(byte[] buf, int pos) {
        return buf[pos] & 0xFF;
    }

    public static int buf_to_int16(byte[] buf, int pos) {
        return (buf[pos] << 8 & 0xFF00) + (buf[pos + 1] << 0 & 0xFF);
    }

    public static int buf_to_int32(byte[] buf, int pos) {
        return (buf[pos] << 24 & 0xFF000000) + (buf[pos + 1] << 16 & 0xFF0000) + (buf[pos + 2] << 8 & 0xFF00) + (buf[pos + 3] << 0 & 0xFF);
    }

    public static long buf_to_int64(byte[] buf, int pos) {
        long ret = 0L;
        ret += (long)buf[pos] << 56 & 0xFF00000000000000L;
        ret += (long)buf[pos + 1] << 48 & 0xFF000000000000L;
        ret += (long)buf[pos + 2] << 40 & 0xFF0000000000L;
        ret += (long)buf[pos + 3] << 32 & 0xFF00000000L;
        ret += (long)buf[pos + 4] << 24 & 0xFF000000L;
        ret += (long)buf[pos + 5] << 16 & 0xFF0000L;
        ret += (long)buf[pos + 6] << 8 & 0xFF00L;
        return ret += (long)buf[pos + 7] << 0 & 0xFFL;
    }

    public static int get_rand_32() {
        return (int)(Math.random() * 2.147483647E9);
    }

    public static byte[] get_rand_16byte(byte[] imei) {
        try {
            byte[] ret1 = SecureRandom.getSeed(16);
            byte[] ret = new byte[ret1.length + imei.length];
            System.arraycopy(ret1, 0, ret, 0, ret1.length);
            System.arraycopy(imei, 0, ret, ret1.length, imei.length);
            return MD5.toMD5Byte(ret);
        }
        catch (Throwable e) {
            return util.get_prand_16byte();
        }
    }

    public static byte[] get_prand_16byte() {
        try {
            byte[] ret = new byte[16];
            int r = (int)(Math.random() * 2.147483647E9);
            util.int32_to_buf(ret, 0, r);
            r = (int)(Math.random() * 2.147483647E9);
            util.int32_to_buf(ret, 4, r);
            r = (int)(Math.random() * 2.147483647E9);
            util.int32_to_buf(ret, 8, r);
            r = (int)(Math.random() * 2.147483647E9);
            util.int32_to_buf(ret, 12, r);
            return MD5.toMD5Byte(ret);
        }
        catch (Throwable e) {
            return new byte[16];
        }
    }

    public static String get_mpasswd() {
        try {
            byte[] r = SecureRandom.getSeed(16);
            String passwd = "";
            for (int i = 0; i < r.length; ++i) {
                boolean b = new Random().nextBoolean();
                int v = Math.abs(r[i] % 26) + (b ? 97 : 65);
                passwd = passwd + String.valueOf((char)v);
            }
            return passwd;
        }
        catch (Throwable throwable) {
            return "1234567890123456";
        }
    }

    public static byte[] getS2(byte[] md5Pwd, long msalt) {
        byte[] s2 = new byte[24];
        System.arraycopy(md5Pwd, 0, s2, 0, md5Pwd.length);
        util.int64_to_buf(s2, 16, msalt);
        s2 = MD5.toMD5Byte(s2);
        return s2;
    }

    public static long get_server_cur_time() {
        return req_global.get_server_cur_time();
    }

    public static String buf_to_string(byte[] bs) {
        if (bs == null) {
            return "";
        }
        String ret = "";
        for (int i = 0; i < bs.length; ++i) {
            ret = ret + Integer.toHexString(bs[i] >> 4 & 0xF);
            ret = ret + Integer.toHexString(bs[i] & 0xF);
        }
        return ret;
    }

    public static String buf_to_string(byte[] bs, int len) {
        if (bs == null) {
            return "";
        }
        if (len > bs.length) {
            len = bs.length;
        }
        String ret = "";
        for (int i = 0; i < len; ++i) {
            ret = ret + Integer.toHexString(bs[i] >> 4 & 0xF);
            ret = ret + Integer.toHexString(bs[i] & 0xF);
        }
        return ret;
    }

    public static long buf_len(byte[] bs) {
        if (bs == null) {
            return 0L;
        }
        return bs.length;
    }

    public static byte get_char(byte c) {
        if (c >= 48 && c <= 57) {
            return (byte)(c - 48);
        }
        if (c >= 97 && c <= 102) {
            return (byte)(c - 97 + 10);
        }
        if (c >= 65 && c <= 70) {
            return (byte)(c - 65 + 10);
        }
        return 0;
    }

    public static byte[] string_to_buf(String s) {
        if (s == null) {
            return new byte[0];
        }
        byte[] ret = new byte[s.length() / 2];
        for (int i = 0; i < s.length() / 2; ++i) {
            ret[i] = (byte)((util.get_char((byte)s.charAt(2 * i)) << 4) + util.get_char((byte)s.charAt(2 * i + 1)));
        }
        return ret;
    }

    public static byte[] get_mac_addr(Context context) {
        String smac = null;
        try {
            WifiInfo info;
            WifiManager wifi = (WifiManager)context.getSystemService("wifi");
            if (wifi != null && (info = wifi.getConnectionInfo()) != null && (smac = info.getMacAddress()) != null) {
                return smac.getBytes();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new byte[0];
    }

    public static byte[] get_imei_id(Context context) {
        String simei = null;
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null && (simei = tm.getDeviceId()) != null) {
                return simei.getBytes();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new byte[0];
    }

    @SuppressLint(value={"NewApi"})
    public static byte[] get_android_id(Context context) {
        String sandroid_id = null;
        try {
            sandroid_id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            if (sandroid_id != null) {
                return sandroid_id.getBytes();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new byte[0];
    }

    public static byte[] get_IMSI(Context context) {
        String simsi = null;
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null && (simsi = tm.getSubscriberId()) != null) {
                return simsi.getBytes();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new byte[0];
    }

    public static byte[] get_IMEI(Context context) {
        String simei = null;
        String smac = null;
        try {
            WifiInfo info;
            WifiManager wifi;
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null) {
                simei = tm.getDeviceId();
            }
            if ((wifi = (WifiManager)context.getSystemService("wifi")) != null && (info = wifi.getConnectionInfo()) != null) {
                smac = info.getMacAddress();
            }
            String rets = "";
            if (simei != null) {
                rets = rets + simei;
            }
            if (smac != null) {
                rets = rets + smac;
            }
            if (rets.length() <= 0) {
                return new byte[0];
            }
            return MD5.toMD5Byte(rets.getBytes());
        }
        catch (Throwable throwable) {
            return new byte[0];
        }
    }

    public static byte[] get_sim_operator_name(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm.getSimState() == 5) {
                return tm.getSimOperatorName().getBytes();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new byte[0];
    }

    public static int get_network_type(Context context) {
        int type;
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netinfo = cm.getActiveNetworkInfo();
            type = netinfo.getType();
        }
        catch (Throwable e) {
            type = 0;
        }
        if (type == 0) {
            return 1;
        }
        if (type == 1) {
            return 2;
        }
        return 0;
    }

    public static int get_saved_network_type(Context context) {
        try {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            return settings.getInt("network_type", 0);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public static void save_network_type(Context context, int type) {
        if (context != null) {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            SharedPreferences.Editor editor = settings.edit();
            editor.putInt("network_type", type);
            editor.commit();
        }
    }

    public static void set_server_host(Context context, byte[] host, String entry) {
        if (context != null && host != null && host.length > 0) {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            SharedPreferences.Editor editor = settings.edit();
            editor.putString(entry, new String(host));
            editor.commit();
        }
    }

    public static String get_server_host(Context context, String entry) {
        try {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            return settings.getString(entry, "");
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void set_net_retry_type(Context context, int type) {
        if (context != null) {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            SharedPreferences.Editor editor = settings.edit();
            editor.putInt("netretry_type", type);
            editor.commit();
        }
    }

    public static int get_net_retry_type(Context context) {
        try {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            return settings.getInt("netretry_type", 0);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public static boolean is_wap_retry(Context context) {
        return 0 != util.get_net_retry_type(context);
    }

    public static String get_apn_string(Context context) {
        block4: {
            try {
                ConnectivityManager connectivity_mgr = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo info = connectivity_mgr.getActiveNetworkInfo();
                if (info.getType() == 0) {
                    String current_apn = info.getExtraInfo();
                    if (current_apn != null) {
                        return current_apn;
                    }
                    break block4;
                }
                return "wifi";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "wifi";
    }

    public static boolean is_wap_proxy_retry(Context context) {
        try {
            String current_apn = util.get_apn_string(context);
            if (current_apn != null) {
                if (current_apn.equalsIgnoreCase("cmwap")) {
                    return true;
                }
                if (current_apn.equalsIgnoreCase("uniwap")) {
                    return true;
                }
                if (current_apn.equalsIgnoreCase("ctwap")) {
                    return true;
                }
                if (current_apn.equalsIgnoreCase("3gwap")) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void chg_retry_type(Context context) {
        if (0 == util.get_net_retry_type(context)) {
            util.set_net_retry_type(context, 1);
        } else {
            util.set_net_retry_type(context, 0);
        }
    }

    public static String get_proxy_ip() {
        return System.getProperty("http.proxyHost");
    }

    public static int get_proxy_port() {
        try {
            return Integer.parseInt(System.getProperty("http.proxyPort"));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void save_imei(Context context, byte[] imei) {
        if (context != null && imei != null && imei.length > 0) {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            SharedPreferences.Editor editor = settings.edit();
            editor.putString("imei", util.buf_to_string(imei));
            editor.commit();
        }
    }

    public static byte[] get_saved_imei(Context context) {
        byte[] imei = new byte[]{};
        try {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            imei = util.string_to_buf(settings.getString("imei", ""));
        }
        catch (Throwable e) {
            util.printThrowable(e, "");
        }
        return imei;
    }

    public static void save_cur_flag(Context context, int flag) {
        if (context != null) {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            SharedPreferences.Editor editor = settings.edit();
            editor.putInt("last_flag", flag);
            editor.commit();
        }
    }

    public static int get_last_flag(Context context) {
        int flag = 0;
        try {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            flag = settings.getInt("last_flag", 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return flag;
    }

    public static void save_cur_mac(Context context, byte[] mac) {
        if (context != null && mac != null && mac.length > 0) {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            SharedPreferences.Editor editor = settings.edit();
            editor.putString("last_mac", util.buf_to_string(mac));
            editor.commit();
        }
    }

    public static byte[] get_last_mac(Context context) {
        byte[] mac = new byte[]{};
        try {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            mac = util.string_to_buf(settings.getString("last_mac", ""));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (mac == null || mac.length <= 0) {
            mac = new byte[]{};
        }
        return mac;
    }

    public static void save_cur_imei(Context context, byte[] imei) {
        if (context != null && imei != null && imei.length > 0) {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            SharedPreferences.Editor editor = settings.edit();
            editor.putString("last_imei", util.buf_to_string(imei));
            editor.commit();
        }
    }

    public static byte[] get_last_imei(Context context) {
        byte[] imei = new byte[]{};
        try {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            imei = util.string_to_buf(settings.getString("last_imei", ""));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (imei == null || imei.length <= 0) {
            imei = new byte[]{};
        }
        return imei;
    }

    public static void save_cur_guid(Context context, byte[] guid) {
        if (context != null && guid != null && guid.length > 0) {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            SharedPreferences.Editor editor = settings.edit();
            editor.putString("last_guid", util.buf_to_string(guid));
            editor.commit();
        }
    }

    public static byte[] get_last_guid(Context context) {
        byte[] guid = new byte[]{};
        try {
            SharedPreferences settings = context.getSharedPreferences(SPFileName, MODE_MULTI_PROCESS);
            guid = util.string_to_buf(settings.getString("last_guid", ""));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (guid == null || guid.length <= 0) {
            guid = new byte[]{};
        }
        return guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save_file_imei(Context context, byte[] imei) {
        if (context != null && imei != null && imei.length > 0) {
            FileOutputStream fout = null;
            try {
                String fileName = context.getFilesDir().getAbsolutePath() + "/tls_device.dat";
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                if (file.exists() && file.canWrite()) {
                    fout = new FileOutputStream(file, false);
                    fout.write(imei);
                }
                util.save_imei(context, imei);
            }
            catch (Exception e) {
                util.printException(e, "");
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException e) {
                        util.printException(e, "");
                    }
                }
            }
        }
    }

    public static byte[] get_apk_id(Context context) {
        try {
            return context.getPackageName().getBytes();
        }
        catch (Throwable e) {
            return new byte[0];
        }
    }

    public static byte[] get_apk_v(Context context, String name) {
        try {
            return context.getPackageManager().getPackageInfo((String)name, (int)0).versionName.getBytes();
        }
        catch (Throwable e) {
            return new byte[0];
        }
    }

    public static String getLineInfo(int stackLayer) {
        if (stackLayer < 0) {
            return "";
        }
        try {
            StackTraceElement ste = new Throwable().getStackTrace()[stackLayer];
            return "[" + ste.getFileName() + ":" + ste.getLineNumber() + "]";
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static void LOGI(String msg) {
        try {
            if (LOG_LEVEL >= 1 && LOGCAT_OUT) {
                Log.i((String)(TAG + util.getLineInfo(2)), (String)msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void LOGI(String msg, String name) {
        try {
            if (LOG_LEVEL >= 1) {
                if (LOGCAT_OUT) {
                    Log.i((String)(TAG + util.getLineInfo(2)), (String)msg);
                }
                FileTracer.writeLog(req_global._context, name, msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void LOGW(String msg1, String msg2, String name) {
        try {
            if (LOG_LEVEL >= 0) {
                if (LOGCAT_OUT) {
                    Log.w((String)(TAG + util.getLineInfo(2)), (String)(msg1 + ":" + msg2));
                }
                FileTracer.writeLog(req_global._context, name, msg1 + ":" + msg2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String base64_encode(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int len = data.length;
        int i = 0;
        while (i < len) {
            int b1 = data[i++] & 0xFF;
            if (i == len) {
                sb.append(base64_encode_chars[b1 >>> 2]);
                sb.append(base64_encode_chars[(b1 & 3) << 4]);
                break;
            }
            int b2 = data[i++] & 0xFF;
            if (i == len) {
                sb.append(base64_encode_chars[b1 >>> 2]);
                sb.append(base64_encode_chars[(b1 & 3) << 4 | (b2 & 0xF0) >>> 4]);
                sb.append(base64_encode_chars[(b2 & 0xF) << 2]);
                break;
            }
            int b3 = data[i++] & 0xFF;
            sb.append(base64_encode_chars[b1 >>> 2]);
            sb.append(base64_encode_chars[(b1 & 3) << 4 | (b2 & 0xF0) >>> 4]);
            sb.append(base64_encode_chars[(b2 & 0xF) << 2 | (b3 & 0xC0) >>> 6]);
            sb.append(base64_encode_chars[b3 & 0x3F]);
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] base64_decode_url(byte[] in_str, int length) {
        pos = 0;
        ch = 0;
        i = 0;
        j = 0;
        result = new byte[24];
        while (length-- > 0 && (ch = in_str[pos++]) != 0 && ch != 95) {
            if (ch == 32) {
                ch = 42;
            }
            if ((ch = util.base64_reverse_table_url[ch]) < 0) continue;
            switch (i % 4) {
                case 0: {
                    result[j] = (byte)(ch << 2);
                    break;
                }
                case 1: {
                    v0 = j++;
                    result[v0] = (byte)(result[v0] | ch >> 4);
                    result[j] = (byte)((ch & 15) << 4);
                    break;
                }
                case 2: {
                    v1 = j++;
                    result[v1] = (byte)(result[v1] | ch >> 2);
                    result[j] = (byte)((ch & 3) << 6);
                    break;
                }
                case 3: {
                    v2 = j++;
                    result[v2] = (byte)(result[v2] | ch);
                }
            }
            ++i;
        }
        k = j;
        if (ch == 95) {
            switch (i % 4) {
                case 0: 
                case 1: {
                    return null;
                }
                ** case 2:
lbl35:
                // 2 sources

                case 3: {
                    v3 = ++k;
                    ++k;
                    result[v3] = 0;
                }
            }
        }
        return result;
    }

    public static void printException(Exception e, String name) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        String ss = sw.toString();
        util.LOGW("exception", ss, name);
    }

    public static void printThrowable(Throwable e, String name) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        String ss = sw.toString();
        util.LOGW("throwable", ss, name);
    }

    public static byte[] getPkgSigFromApkName(Context context, String apkName) {
        try {
            PackageInfo myPInfo = context.getPackageManager().getPackageInfo(apkName, 64);
            if (myPInfo.signatures == null || myPInfo.signatures.length <= 0 || myPInfo.signatures[0] == null) {
                return new byte[0];
            }
            return MD5.toMD5Byte(myPInfo.signatures[0].toByteArray());
        }
        catch (Throwable throwable) {
            return new byte[0];
        }
    }

    public static String get_release_time() {
        return "2015/11/09 17:10:19";
    }

    public static String getDate() {
        String date = "";
        try {
            date = "[" + System.currentTimeMillis() + "]";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static String getThreadId() {
        return "[" + Thread.currentThread().getId() + "]";
    }

    public static String getSdkVersion() {
        return "[1]";
    }

    public static String getUser(String name) {
        if (name != null) {
            return "[" + name + "]";
        }
        return "[]";
    }

    public static boolean ExistSDCard() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getCurrentDay() {
        try {
            if (DAYFORMAT == null) {
                DAYFORMAT = new SimpleDateFormat("yyyyMMdd");
            }
            return DAYFORMAT.format(new Date());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isFileExist(String fileName) {
        try {
            File file = new File(fileName);
            return file.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getFileSize(String fileName) {
        int length = 0;
        try {
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                length = (int)file.length();
            }
        }
        catch (Exception e) {
            length = 0;
        }
        return length;
    }

    public static byte[] compress(byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream deflater = new DeflaterOutputStream(out);
            deflater.write(data);
            deflater.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public static String getLogFileName(Context context, String date) {
        if (context == null || date == null || date.length() == 0) {
            return null;
        }
        String fileName = null;
        try {
            if (util.ExistSDCard()) {
                File path = Environment.getExternalStorageDirectory();
                fileName = path.getAbsolutePath() + "/" + LOG_DIR + "/" + context.getPackageName() + "/" + util.base64_encode(date.getBytes());
            } else {
                String path = context.getFilesDir().getPath();
                fileName = path + "/" + LOG_DIR + "/" + util.base64_encode(date.getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileName;
    }

    public static synchronized void writeFile(String fileName, byte[] data) {
        if (fileName == null || fileName.length() == 0) {
            return;
        }
        try {
            File parentFile;
            File file = new File(fileName);
            if (!(file.exists() || (parentFile = file.getParentFile()) != null && (parentFile.mkdirs() || parentFile.isDirectory()))) {
                return;
            }
            if (util.getFileSize(fileName) < 102400) {
                FileOutputStream fout = new FileOutputStream(file, true);
                fout.write(data);
                fout.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteExpireFile(String filePath, int expireTime) {
        if (filePath == null || filePath.length() == 0) {
            return;
        }
        util.LOGI("file path:" + filePath);
        try {
            File[] files;
            File file = new File(filePath);
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                int count = files.length;
                for (int i = 0; i < count; ++i) {
                    long modifyTime;
                    long currentTime;
                    if (files[i].isDirectory() || ((currentTime = System.currentTimeMillis()) - (modifyTime = files[i].lastModified())) / 1000L <= (long)expireTime) continue;
                    files[i].delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteExpireLog(Context context) {
        if (context == null) {
            return;
        }
        try {
            if (util.ExistSDCard()) {
                File path = Environment.getExternalStorageDirectory();
                String filePath = path.getAbsolutePath() + "/" + LOG_DIR + "/" + context.getPackageName();
                util.deleteExpireFile(filePath, 691200);
            } else {
                String path = context.getFilesDir().getPath();
                String filePath = path + "/" + LOG_DIR;
                util.deleteExpireFile(filePath, 259200);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public static boolean loadLibrary(String libName, Context context) {
        boolean bLoaded;
        block15: {
            if (Build.VERSION.SDK_INT >= 23) {
                return false;
            }
            if (libwtecdh_loaded) {
                return true;
            }
            if (context == null || libName == null || libName.length() == 0) {
                return false;
            }
            bLoaded = false;
            File soFile = null;
            try {
                soFile = new File(soLoadPath + "/lib" + libName + ".so");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (soFile != null && soFile.exists()) {
                try {
                    System.load(soFile.getAbsolutePath());
                    bLoaded = true;
                    break block15;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            try {
                soFile = new File(context.getFilesDir().getParent() + "/lib/lib" + libName + ".so");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (soFile != null && soFile.exists()) {
                try {
                    System.load(soFile.getAbsolutePath());
                    bLoaded = true;
                    break block15;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            try {
                System.loadLibrary(libName);
                bLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        libwtecdh_loaded = bLoaded;
        QLog.i("libwtcrypto loaded " + libwtecdh_loaded);
        return bLoaded;
    }

    public static boolean checkInvalid(String str) {
        return str == null || str.length() <= 0;
    }

    public static final class APNName {
        public static final String NAME_CMWAP = "cmwap";
        public static final String NAME_3GWAP = "3gwap";
        public static final String NAME_UNIWAP = "uniwap";
        public static final String NAME_CTWAP = "ctwap";
    }
}

