/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.tools;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import tencent.tls.tools.util;

public class FileTracer
implements Handler.Callback {
    private static FileTracer instance = null;
    private static final int MSG_FLUSH = 1024;
    private volatile boolean isFlushing = false;
    private static String bufferA = "";
    private static String bufferB = "";
    private Context context;
    private HandlerThread thread;
    private Handler handler;

    private FileTracer(Context context) {
        this.context = context;
        this.thread = new HandlerThread("FileTracer");
        if (this.thread != null) {
            this.thread.start();
        }
        if (this.thread.isAlive()) {
            this.handler = new Handler(this.thread.getLooper(), (Handler.Callback)this);
        }
        this.handler.sendEmptyMessage(1024);
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1024: {
                this.flushBuffer();
                this.prepareNextFlush();
                break;
            }
        }
        return true;
    }

    private void prepareNextFlush() {
        try {
            this.handler.sendEmptyMessageDelayed(1024, 1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void flush() {
        if (this.handler.hasMessages(1024)) {
            this.handler.removeMessages(1024);
        }
        this.handler.sendEmptyMessage(1024);
    }

    private void flushBuffer() {
        if (Thread.currentThread() != this.thread) {
            return;
        }
        if (this.isFlushing) {
            return;
        }
        this.isFlushing = true;
        this.writeFile();
        this.isFlushing = false;
    }

    private void writeFile() {
        if (bufferB == null || bufferB.length() <= 0) {
            return;
        }
        bufferA = bufferB;
        bufferB = "";
        byte[] bytes = util.compress(bufferA.getBytes());
        if (bytes == null || bytes.length == 0) {
            return;
        }
        byte[] data = new byte[4 + bytes.length];
        util.int32_to_buf(data, 0, bytes.length);
        System.arraycopy(bytes, 0, data, 4, bytes.length);
        String fileName = util.getLogFileName(this.context, util.getCurrentDay());
        util.writeFile(fileName, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLog(Context context, String name, String content) {
        if (context == null || content == null) {
            return;
        }
        if (instance == null) {
            instance = new FileTracer(context);
        }
        String string = bufferB;
        synchronized (string) {
            if (bufferB.length() > 4096) {
                bufferB = "";
            }
            bufferB = bufferB + util.getDate() + util.getThreadId() + util.getLineInfo(3) + util.getSdkVersion() + util.getUser(name) + content + "\n";
        }
    }
}

