/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.tools;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

class CryptorImpl {
    private byte[] plain;
    private byte[] prePlain;
    private byte[] out;
    private int crypt;
    private int preCrypt;
    private int pos;
    private int padding;
    private byte[] key;
    private boolean header = true;
    private int contextStart;
    private Random random = new Random();

    CryptorImpl() {
    }

    private static long getUnsignedInt(byte[] in, int offset, int len) {
        long ret = 0L;
        int end = 0;
        end = len > 4 ? offset + 4 : offset + len;
        for (int i = offset; i < end; ++i) {
            ret <<= 8;
            ret |= (long)(in[i] & 0xFF);
        }
        return ret & 0xFFFFFFFFL;
    }

    protected byte[] decrypt(byte[] in, int offset, int len, byte[] key) {
        int i;
        this.preCrypt = 0;
        this.crypt = 0;
        this.key = key;
        byte[] m = new byte[offset + 8];
        if (len % 8 != 0 || len < 16) {
            return null;
        }
        this.prePlain = this.decipher(in, offset);
        this.pos = this.prePlain[0] & 7;
        int count = len - this.pos - 10;
        if (count < 0) {
            return null;
        }
        for (i = offset; i < m.length; ++i) {
            m[i] = 0;
        }
        this.out = new byte[count];
        this.preCrypt = 0;
        this.crypt = 8;
        this.contextStart = 8;
        ++this.pos;
        this.padding = 1;
        while (this.padding <= 2) {
            if (this.pos < 8) {
                ++this.pos;
                ++this.padding;
            }
            if (this.pos != 8) continue;
            m = in;
            if (this.decrypt8Bytes(in, offset, len)) continue;
            return null;
        }
        i = 0;
        while (count != 0) {
            if (this.pos < 8) {
                this.out[i] = (byte)(m[offset + this.preCrypt + this.pos] ^ this.prePlain[this.pos]);
                ++i;
                --count;
                ++this.pos;
            }
            if (this.pos != 8) continue;
            m = in;
            this.preCrypt = this.crypt - 8;
            if (this.decrypt8Bytes(in, offset, len)) continue;
            return null;
        }
        this.padding = 1;
        while (this.padding < 8) {
            if (this.pos < 8) {
                if ((m[offset + this.preCrypt + this.pos] ^ this.prePlain[this.pos]) != 0) {
                    return null;
                }
                ++this.pos;
            }
            if (this.pos == 8) {
                m = in;
                this.preCrypt = this.crypt;
                if (!this.decrypt8Bytes(in, offset, len)) {
                    return null;
                }
            }
            ++this.padding;
        }
        return this.out;
    }

    protected byte[] decrypt(byte[] in, byte[] key) {
        return this.decrypt(in, 0, in.length, key);
    }

    private byte[] encrypt(byte[] in, int offset, int len, byte[] key) {
        int i;
        this.plain = new byte[8];
        this.prePlain = new byte[8];
        this.pos = 1;
        this.padding = 0;
        this.preCrypt = 0;
        this.crypt = 0;
        this.key = key;
        this.header = true;
        this.pos = (len + 10) % 8;
        if (this.pos != 0) {
            this.pos = 8 - this.pos;
        }
        this.out = new byte[len + this.pos + 10];
        this.plain[0] = (byte)(this.rand() & 0xF8 | this.pos);
        for (i = 1; i <= this.pos; ++i) {
            this.plain[i] = (byte)(this.rand() & 0xFF);
        }
        ++this.pos;
        for (i = 0; i < 8; ++i) {
            this.prePlain[i] = 0;
        }
        this.padding = 1;
        while (this.padding <= 2) {
            if (this.pos < 8) {
                this.plain[this.pos++] = (byte)(this.rand() & 0xFF);
                ++this.padding;
            }
            if (this.pos != 8) continue;
            this.encrypt8Bytes();
        }
        i = offset;
        while (len > 0) {
            if (this.pos < 8) {
                this.plain[this.pos++] = in[i++];
                --len;
            }
            if (this.pos != 8) continue;
            this.encrypt8Bytes();
        }
        this.padding = 1;
        while (this.padding <= 7) {
            if (this.pos < 8) {
                this.plain[this.pos++] = 0;
                ++this.padding;
            }
            if (this.pos != 8) continue;
            this.encrypt8Bytes();
        }
        return this.out;
    }

    protected byte[] encrypt(byte[] in, byte[] key) {
        return this.encrypt(in, 0, in.length, key);
    }

    private byte[] encipher(byte[] in) {
        try {
            int loop = 16;
            long y = CryptorImpl.getUnsignedInt(in, 0, 4);
            long z = CryptorImpl.getUnsignedInt(in, 4, 4);
            long a = CryptorImpl.getUnsignedInt(this.key, 0, 4);
            long b = CryptorImpl.getUnsignedInt(this.key, 4, 4);
            long c = CryptorImpl.getUnsignedInt(this.key, 8, 4);
            long d = CryptorImpl.getUnsignedInt(this.key, 12, 4);
            long sum = 0L;
            long delta = -1640531527L;
            delta &= 0xFFFFFFFFL;
            while (loop-- > 0) {
                sum += delta;
                y += (z << 4) + a ^ z + (sum &= 0xFFFFFFFFL) ^ (z >>> 5) + b;
                z += ((y &= 0xFFFFFFFFL) << 4) + c ^ y + sum ^ (y >>> 5) + d;
                z &= 0xFFFFFFFFL;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt((int)y);
            dos.writeInt((int)z);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private byte[] decipher(byte[] in, int offset) {
        try {
            int loop = 16;
            long y = CryptorImpl.getUnsignedInt(in, offset, 4);
            long z = CryptorImpl.getUnsignedInt(in, offset + 4, 4);
            long a = CryptorImpl.getUnsignedInt(this.key, 0, 4);
            long b = CryptorImpl.getUnsignedInt(this.key, 4, 4);
            long c = CryptorImpl.getUnsignedInt(this.key, 8, 4);
            long d = CryptorImpl.getUnsignedInt(this.key, 12, 4);
            long sum = -478700656L;
            sum &= 0xFFFFFFFFL;
            long delta = -1640531527L;
            delta &= 0xFFFFFFFFL;
            while (loop-- > 0) {
                z -= (y << 4) + c ^ y + sum ^ (y >>> 5) + d;
                y -= ((z &= 0xFFFFFFFFL) << 4) + a ^ z + sum ^ (z >>> 5) + b;
                y &= 0xFFFFFFFFL;
                sum -= delta;
                sum &= 0xFFFFFFFFL;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt((int)y);
            dos.writeInt((int)z);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private byte[] decipher(byte[] in) {
        return this.decipher(in, 0);
    }

    private void encrypt8Bytes() {
        this.pos = 0;
        while (this.pos < 8) {
            if (this.header) {
                int n = this.pos;
                this.plain[n] = (byte)(this.plain[n] ^ this.prePlain[this.pos]);
            } else {
                int n = this.pos;
                this.plain[n] = (byte)(this.plain[n] ^ this.out[this.preCrypt + this.pos]);
            }
            ++this.pos;
        }
        byte[] crypted = this.encipher(this.plain);
        System.arraycopy(crypted, 0, this.out, this.crypt, 8);
        this.pos = 0;
        while (this.pos < 8) {
            int n = this.crypt + this.pos;
            this.out[n] = (byte)(this.out[n] ^ this.prePlain[this.pos]);
            ++this.pos;
        }
        System.arraycopy(this.plain, 0, this.prePlain, 0, 8);
        this.preCrypt = this.crypt;
        this.crypt += 8;
        this.pos = 0;
        this.header = false;
    }

    private boolean decrypt8Bytes(byte[] in, int offset, int len) {
        this.pos = 0;
        while (this.pos < 8) {
            if (this.contextStart + this.pos >= len) {
                return true;
            }
            int n = this.pos;
            this.prePlain[n] = (byte)(this.prePlain[n] ^ in[offset + this.crypt + this.pos]);
            ++this.pos;
        }
        this.prePlain = this.decipher(this.prePlain);
        if (this.prePlain == null) {
            return false;
        }
        this.contextStart += 8;
        this.crypt += 8;
        this.pos = 0;
        return true;
    }

    private int rand() {
        return this.random.nextInt();
    }
}

