/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.tlvs;

import tencent.tls.tools.cryptor;
import tencent.tls.tools.util;

public class tlv_t {
    protected int _max = 128;
    protected int _pos = 0;
    protected int _head_len = 4;
    protected int _body_len = 0;
    protected byte[] _buf = new byte[this._max];
    protected int _cmd = 0;

    public tlv_t() {
    }

    public tlv_t(int type) {
        this._cmd = type;
    }

    public byte[] get_buf() {
        byte[] ret = new byte[this._pos];
        System.arraycopy(this._buf, 0, ret, 0, this._pos);
        return ret;
    }

    public int getTLVSize() {
        return this._pos;
    }

    public byte[] get_data() {
        byte[] ret = new byte[this._body_len];
        System.arraycopy(this._buf, this._head_len, ret, 0, this._body_len);
        return ret;
    }

    public int get_data_len() {
        return this._body_len;
    }

    public void set_data(byte[] in, int len) {
        if (len + this._head_len > this._max) {
            this._max = len + this._head_len + 128;
            byte[] buf1 = new byte[this._max];
            System.arraycopy(this._buf, 0, buf1, 0, this._head_len);
            this._buf = buf1;
        }
        this._pos = len + this._head_len;
        System.arraycopy(in, 0, this._buf, this._head_len, len);
        this._body_len = len;
        util.int16_to_buf(this._buf, 0, this._cmd);
        util.int16_to_buf(this._buf, 2, this._body_len);
    }

    public byte[] build_tlv(byte[] data) {
        if (data == null) {
            data = new byte[]{};
        }
        this.set_data(data, data.length);
        return this.get_buf();
    }

    public void set_buf(byte[] in, int pos, int len) {
        if (len > this._max) {
            this._max = len + 128;
            this._buf = new byte[this._max];
        }
        this._pos = len;
        System.arraycopy(in, pos, this._buf, 0, len);
        this._cmd = util.buf_to_int16(in, pos);
        this._body_len = len - this._head_len;
    }

    int search_tlv(byte[] in, int pos, int len, int type) {
        int ret = -1;
        int t = 0;
        int max = in.length;
        while (pos < max && pos + 2 <= max) {
            t = util.buf_to_int16(in, pos);
            if (t == type) {
                ret = pos;
                break;
            }
            if ((pos += 2) + 2 > max) break;
            pos += 2 + util.buf_to_int16(in, pos);
        }
        return ret;
    }

    public int get_tlv(byte[] in, int pos, int len) {
        int p = 0;
        p = this.search_tlv(in, pos, len, this._cmd);
        if (p < 0) {
            return -1;
        }
        len -= p - pos;
        pos = p;
        if (this._head_len >= len) {
            return -1;
        }
        this._body_len = util.buf_to_int16(in, pos + 2);
        if (this._head_len + this._body_len > len) {
            return -1;
        }
        this.set_buf(in, pos, this._head_len + this._body_len);
        if (!this.verify()) {
            return -1005;
        }
        return p + this._head_len + this._body_len;
    }

    int get_tlv(byte[] in, int len, byte[] key) {
        if (this._head_len >= len) {
            return -1;
        }
        this._body_len = util.buf_to_int16(in, 2);
        if (this._head_len + this._body_len > len) {
            return -1;
        }
        byte[] decrypt_body = cryptor.decrypt(in, this._head_len, this._body_len, key);
        if (decrypt_body == null) {
            return -1002;
        }
        if (this._head_len + decrypt_body.length > this._max) {
            this._max = this._head_len + decrypt_body.length;
            this._buf = new byte[this._max];
        }
        this._pos = 0;
        System.arraycopy(in, 0, this._buf, 0, this._head_len);
        this._pos += this._head_len;
        System.arraycopy(decrypt_body, 0, this._buf, this._pos, decrypt_body.length);
        this._pos += decrypt_body.length;
        this._body_len = decrypt_body.length;
        if (!this.verify()) {
            return -1005;
        }
        return 0;
    }

    public int get_tlv(byte[] in, int pos, int len, byte[] key) {
        int p = 0;
        p = this.search_tlv(in, pos, len, this._cmd);
        if (p < 0) {
            return -1;
        }
        len -= p - pos;
        pos = p;
        byte[] in1 = new byte[len];
        System.arraycopy(in, pos, in1, 0, len);
        return this.get_tlv(in1, len, key);
    }

    public boolean verify() {
        return true;
    }

    public int limit_len(byte[] data, int max_len) {
        if (data != null) {
            if (data.length > max_len) {
                return max_len;
            }
            return data.length;
        }
        return 0;
    }
}

