/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.request;

import java.net.Socket;
import tencent.tls.platform.TLSUserInfo;
import tencent.tls.report.QLog;
import tencent.tls.request.TransReqContext;
import tencent.tls.request.oicq_request;
import tencent.tls.request.req_global;
import tencent.tls.tlvs.tlv_t172;
import tencent.tls.tools.cryptor;
import tencent.tls.tools.util;

public class req_transport
extends oicq_request {
    public int _req_transport_eext_head_len = 0;
    public int _rsp_transport_eext_head_len = 5;

    public req_transport(req_global g) {
        this._cmd = 2104;
        this._sub_cmd = 1;
        this._service_cmd = "wtlogin64.trans_emp";
        this._g = g;
        this._g._encrypt_type = 0;
    }

    public int get_port(boolean is_wap_retry) {
        if (is_wap_retry) {
            return 8080;
        }
        return 8080;
    }

    public Socket get_sk() {
        if (this._g._transport_sk != null) {
            QLog.d("_transport_sk" + this._g._transport_sk.toString());
        } else {
            QLog.d("_transport_sk null");
        }
        return this._g._transport_sk;
    }

    public void set_sk(Socket sk) {
        this._g._transport_sk = sk;
    }

    public byte[] get_request_body(byte[] body, byte[] st, long appid, long role, int is_msf) {
        int pos = 0;
        byte[] bbody = null;
        int subcmd = 0;
        if (st == null) {
            st = new byte[]{};
            subcmd = is_msf == 0 ? 0 : 3;
        } else {
            subcmd = is_msf == 0 ? 1 : 2;
        }
        byte[] reserve = new byte[]{};
        if (this._g._t172_data != null && this._g._t172_data.length > 0) {
            tlv_t172 t172 = new tlv_t172();
            byte[] buf = t172.get_tlv_172(this._g._t172_data);
            reserve = new byte[2 + buf.length];
            util.int16_to_buf(reserve, 0, 1);
            System.arraycopy(buf, 0, reserve, 2, buf.length);
        }
        this._req_transport_eext_head_len = 13 + st.length + 1 + reserve.length;
        bbody = new byte[body.length + this._req_transport_eext_head_len];
        util.int8_to_buf(bbody, pos, subcmd);
        util.int16_to_buf(bbody, ++pos, body.length);
        util.int32_to_buf(bbody, pos += 2, 0);
        util.int64_to_buf32(bbody, pos += 4, role);
        util.int16_to_buf(bbody, pos += 4, st.length);
        System.arraycopy(st, 0, bbody, pos += 2, st.length);
        util.int8_to_buf(bbody, pos += st.length, reserve.length);
        System.arraycopy(reserve, 0, bbody, ++pos, reserve.length);
        System.arraycopy(body, 0, bbody, pos += reserve.length, body.length);
        pos += body.length;
        return this.encrypt_body(bbody);
    }

    protected byte[] encrypt_body(byte[] in) {
        if (this._g._encrypt_type == 0) {
            return this.ecdh_encrypt_body(in, this._g._rand_key, this._g._pub_key, this._g._share_key);
        }
        return this.kc_encrypt_body(in, this._g._rand_key, 3);
    }

    public int get_response_body(byte[] in, int pos, int len) {
        int ret = 0;
        if (len < this._rsp_transport_eext_head_len) {
            return -1009;
        }
        int type = this.get_response_ret_code(in, pos);
        this.set_err_msg(null);
        QLog.d("type=" + type);
        ret = type;
        return ret;
    }

    public synchronized int make_request(long uin, TransReqContext req_context, byte[] st, byte[] st_key, long appid, long role, TLSUserInfo userInfo) {
        int ret = 0;
        int g_client_version = req_global._app_client_version;
        int retry_num = 0;
        do {
            byte[] bbody;
            byte[] body = req_context._body;
            long server_time = System.currentTimeMillis() / 1000L + req_global._l_init_time;
            if (body == null) {
                body = new byte[]{};
            } else if (st == null) {
                bbody = new byte[4 + body.length];
                util.int64_to_buf32(bbody, 0, server_time);
                System.arraycopy(body, 0, bbody, 4, body.length);
                body = bbody;
            } else {
                bbody = new byte[4 + body.length];
                util.int64_to_buf32(bbody, 0, server_time);
                System.arraycopy(body, 0, bbody, 4, body.length);
                body = bbody;
                body = cryptor.encrypt(body, 0, body.length, st_key);
            }
            if (body == null || body.length <= 0) continue;
            bbody = this.get_request_body(body, st, appid, role, 0);
            this.get_request(this._default_client_version, this._cmd, this._default_client_seq, uin, this._default_ext_retry, this._default_ext_type, g_client_version, this._default_ext_instance, bbody);
            ret = this.snd_rcv_req();
            if (ret != 0) break;
            ret = this.get_response(req_context);
            if (ret == 0 && st != null) {
                byte[] rsp_body = req_context.get_body();
                req_context.set_body(cryptor.decrypt(rsp_body, 0, rsp_body.length, st_key));
            }
            if (ret != 180) break;
        } while (retry_num++ < 1);
        QLog.d("req_transport rsp: ret=" + ret);
        return ret;
    }

    public int get_response(TransReqContext req_context) {
        int ret = 0;
        int len = this._pos;
        if (len <= this._rsp_head_len + 2) {
            return -1009;
        }
        this._rsp_body_len = len - this._rsp_head_len - 2;
        if (this._g._encrypt_type == 0) {
            ret = this.decrypt_body(this._buf, 1 + this._rsp_head_len, this._rsp_body_len, this._g._share_key);
            if (ret < 0) {
                QLog.i("use ecdh decrypt_body failed");
                ret = this.decrypt_body(this._buf, 1 + this._rsp_head_len, this._rsp_body_len, this._g._rand_key);
                if (ret < 0) {
                    QLog.i("use kc decrypt_body failed");
                }
            }
        } else {
            ret = this.decrypt_body(this._buf, 1 + this._rsp_head_len, this._rsp_body_len, this._g._rand_key);
            if (ret < 0) {
                QLog.i("use kc decrypt_body failed");
            }
        }
        if (ret < 0) {
            return ret;
        }
        ret = this.get_response_body(this._buf, 1 + this._rsp_head_len, this._rsp_body_len, req_context);
        return ret;
    }

    public int get_response_body(byte[] in, int pos, int len, TransReqContext req_context) {
        int ret = 0;
        if (len < this._rsp_transport_eext_head_len) {
            return -1009;
        }
        int type = this.get_response_ret_code(in, pos);
        this.set_err_msg(null);
        QLog.d("type=" + type);
        ret = type;
        switch (type) {
            case 0: {
                byte[] body = new byte[len - this._rsp_transport_eext_head_len];
                System.arraycopy(in, pos += this._rsp_transport_eext_head_len, body, 0, body.length);
                req_context.set_body(body);
                break;
            }
            case 180: {
                tlv_t172 t172 = new tlv_t172();
                ret = t172.get_tlv(in, pos += this._rsp_transport_eext_head_len + 2, this._pos - pos - 1);
                if (ret <= 0) break;
                this._g._encrypt_type = 1;
                this._g._t172_data = t172.get_data();
                ret = type;
                QLog.i("get rollback sig");
                break;
            }
        }
        return ret;
    }
}

