/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.request;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Socket;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import tencent.tls.account.acc_status;
import tencent.tls.platform.TLSUserInfo;
import tencent.tls.report.QLog;
import tencent.tls.request.SigInfo;
import tencent.tls.request.Ticket;
import tencent.tls.request.TinyInfo;
import tencent.tls.request.account_sig_info_map;
import tencent.tls.request.async_context;
import tencent.tls.request.delete_expire_log;
import tencent.tls.tlvs.tlv_t150;
import tencent.tls.tools.MD5;
import tencent.tls.tools.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class req_global {
    public static SecureRandom _SR = new SecureRandom();
    public byte[] _tgt_key = null;
    public byte[] _rand_key = new byte[16];
    public tlv_t150 _t150 = null;
    public long _uin = 0L;
    public String _userid = "";
    public static int _acc_type = 0;
    public static long sdkappid;
    public int _admin = 0;
    public long _seq = 0L;
    public int _sso_seq = 0;
    public boolean _use_sso_channel = true;
    public int _time_out = 10000;
    public int _encrypt_type = 0;
    public byte[] _pub_key = new byte[16];
    public byte[] _share_key = new byte[16];
    public byte[] _t172_data = new byte[0];
    public int _cancel = 0;
    public static Context _context;
    public static int _local_id;
    public static String _last_date;
    static int _app_client_version;
    static int _img_type;
    public static int _pic_type;
    public static byte[] _IMEI;
    static byte[] _IMEI_KEY;
    static byte[] _sim_operator_name;
    public static int _network_type;
    public static byte[] _apk_id;
    public static byte[] _apn;
    static byte[] _mac;
    static byte[] _apk_v;
    static byte[] _apk_sig;
    static byte[] _device;
    static byte[] _brand;
    static int _new_install;
    static int _read_guid;
    static int _guid_chg;
    static int _guid_src;
    static int _dev_chg;
    static int _dev_report;
    static int _isroot;
    static long _time_difference;
    public static long _l_init_time;
    public static byte[] _ip_addr;
    Socket _sk = null;
    Socket _transport_sk = null;
    public static int _android_sdk;
    private static final Object data_lock;
    public static account_sig_info_map _account_sig_info_map;
    public static long _cur_sequence;
    public static TreeMap<Long, async_context> _async_data;

    public req_global(Context context) {
    }

    public req_global getClone(long seq) {
        req_global req = new req_global(null);
        req._use_sso_channel = this._use_sso_channel;
        req._time_out = this._time_out;
        if (this._rand_key != null) {
            req._rand_key = (byte[])this._rand_key.clone();
        }
        if (this._pub_key != null && this._share_key != null) {
            req._pub_key = (byte[])this._pub_key.clone();
            req._share_key = (byte[])this._share_key.clone();
        }
        req._seq = seq <= 0L ? req_global.allocSequence() : seq;
        return req;
    }

    public static synchronized long allocSequence() {
        if (_cur_sequence > 200L) {
            _cur_sequence = 0L;
        }
        return ++_cur_sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static async_context get_async_data(long sequence) {
        async_context data = null;
        Object object = data_lock;
        synchronized (object) {
            data = _async_data.get(sequence);
            if (data == null) {
                data = new async_context();
                _async_data.put(sequence, data);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove_async_data(long sequence) {
        Object object = data_lock;
        synchronized (object) {
            _async_data.remove(sequence);
        }
    }

    public static void clear_sdk_log() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            String curdate = formatter.format(new Date());
            if (curdate.compareTo(_last_date) != 0) {
                _last_date = curdate;
                new delete_expire_log(_context).start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void dev_compare() {
        byte[] current_guid;
        byte[] current_imei;
        byte[] current_mac = util.get_mac_addr(_context);
        if (current_mac != null && current_mac.length > 0) {
            current_mac = MD5.toMD5Byte(current_mac);
        }
        if ((current_imei = util.get_imei_id(_context)) != null && current_imei.length > 0) {
            current_imei = MD5.toMD5Byte(current_imei);
        }
        if ((current_guid = util.get_IMEI(_context)) != null && current_guid.length > 0) {
            current_guid = MD5.toMD5Byte(current_guid);
        }
        if (util.get_last_flag(_context) != 0) {
            byte[] last_mac = util.get_last_mac(_context);
            byte[] last_imei = util.get_last_imei(_context);
            byte[] last_guid = util.get_last_guid(_context);
            if (!Arrays.equals(current_mac, last_mac)) {
                _dev_chg |= 1;
            }
            if (!Arrays.equals(current_imei, last_imei)) {
                _dev_chg |= 2;
            }
            if (!Arrays.equals(current_guid, last_guid)) {
                _dev_chg |= 4;
            }
        }
        util.save_cur_flag(_context, 1);
        util.save_cur_mac(_context, current_mac);
        util.save_cur_imei(_context, current_imei);
        util.save_cur_guid(_context, current_guid);
    }

    @SuppressLint(value={"NewApi"})
    private static byte[] get_guid(Context context) {
        String simei = null;
        String sandroid_id = null;
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null) {
                simei = tm.getDeviceId();
            }
            sandroid_id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            String rets = "";
            String device = Build.MODEL;
            if (simei != null) {
                rets = rets + simei;
            }
            if (device != null) {
                rets = rets + device;
            }
            if (sandroid_id != null) {
                rets = rets + sandroid_id;
            }
            if (rets.length() == 0) {
                return new byte[0];
            }
            return MD5.toMD5Byte(rets.getBytes());
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] get_file_guid(Context context) {
        if (context == null) {
            return null;
        }
        byte[] imei = new byte[]{};
        FileInputStream fin = null;
        try {
            int length;
            String fileName = context.getFilesDir().getAbsolutePath() + "/tls_device.dat";
            File file = new File(fileName);
            if (file != null && file.exists() && (length = (fin = new FileInputStream(file)).available()) < 1024) {
                imei = new byte[length];
                fin.read(imei);
            }
        }
        catch (Exception e) {
            _dev_report |= 0x10000;
            QLog.e(e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    QLog.e(e);
                }
            }
        }
        return imei;
    }

    public static void init() {
        int saved_network_type = util.get_saved_network_type(_context);
        _dev_report = 0;
        byte[] save_imei = req_global.get_file_guid(_context);
        byte[] cur_imei = req_global.get_guid(_context);
        if (save_imei == null || save_imei.length <= 0) {
            if (cur_imei == null || cur_imei.length <= 0) {
                cur_imei = "%4;7t>;28<fc.5*6".getBytes();
                _read_guid = 0;
                _guid_src = 20;
            } else {
                _read_guid = 1;
                _guid_src = 17;
            }
            util.save_file_imei(_context, cur_imei);
            _guid_chg = 0;
            _new_install = 1;
        } else {
            if (cur_imei == null || cur_imei.length <= 0) {
                cur_imei = "%4;7t>;28<fc.5*6".getBytes();
            }
            _guid_chg = Arrays.equals(cur_imei, save_imei) ? 0 : 1;
            cur_imei = save_imei;
            _read_guid = 1;
            _new_install = 0;
            _guid_src = 1;
        }
        req_global.dev_compare();
        _dev_report |= _guid_src << 24 & 0xFF000000;
        _dev_report |= _dev_chg << 8 & 0xFF00;
        _IMEI = (byte[])cur_imei.clone();
        _IMEI_KEY = (byte[])cur_imei.clone();
        _android_sdk = Build.VERSION.SDK_INT;
        _sim_operator_name = util.get_sim_operator_name(_context);
        _network_type = util.get_network_type(_context);
        if (saved_network_type != _network_type) {
            util.set_net_retry_type(_context, 0);
            util.save_network_type(_context, _network_type);
        }
        _apn = util.get_apn_string(_context).getBytes();
        _apk_id = util.get_apk_id(_context);
        acc_status.apk_id = _apk_id;
        _apk_v = util.get_apk_v(_context, new String(_apk_id));
        _apk_sig = util.getPkgSigFromApkName(_context, _context.getPackageName());
        String device = Build.MODEL;
        _device = device == null ? new byte[0] : device.getBytes();
        boolean isroot = util.isFileExist("/system/bin/su") || util.isFileExist("/system/xbin/su") || util.isFileExist("/sbin/su");
        _isroot = isroot ? 1 : 0;
    }

    public static long get_cur_time() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long get_server_cur_time() {
        return System.currentTimeMillis() / 1000L + _l_init_time;
    }

    public void set_time_ip(byte[] time, byte[] ip) {
        _l_init_time = _time_difference = ((long)util.buf_to_int32(time, 0) & 0xFFFFFFFFL) - System.currentTimeMillis() / 1000L;
        _ip_addr = ip;
    }

    public void clear_time_ip() {
        _ip_addr = null;
        _time_difference = 0L;
        _l_init_time = 0L;
    }

    public void set_context(Context context) {
        _context = context;
        _account_sig_info_map = new account_sig_info_map(context);
        byte[] randkey = new byte[16];
        _SR.nextBytes(randkey);
        System.arraycopy(randkey, 0, this._rand_key, 0, randkey.length);
    }

    public void close_connect() {
        QLog.d("close_connect");
        if (this._sk != null) {
            try {
                QLog.d("close_connect" + this._sk.toString());
                this._sk.close();
            }
            catch (Exception e) {
                QLog.e(e);
            }
            this._sk = null;
        }
    }

    public void close_transport_connect() {
        QLog.d("close_transport_connect");
        if (this._transport_sk != null) {
            try {
                QLog.d("close_transport_connect" + this._transport_sk.toString());
                this._transport_sk.close();
            }
            catch (Exception e) {
                QLog.e(e);
            }
            this._transport_sk = null;
        }
    }

    public synchronized SigInfo get_siginfo(long uin, long appid) {
        QLog.i("get_siginfo", uin);
        SigInfo info = _account_sig_info_map.get_siginfo(uin, appid);
        if (info != null) {
            return info;
        }
        return info;
    }

    public synchronized void remove_account(String name) {
        _account_sig_info_map.remove_account(name);
    }

    public synchronized long getTinyId(String name) {
        if (name == null) {
            return 0L;
        }
        TinyInfo tinyInfo = _account_sig_info_map.getTinyInfo(name);
        if (tinyInfo != null) {
            return tinyInfo._tinyid;
        }
        return 0L;
    }

    public synchronized TinyInfo getTinyInfo(String name) {
        if (name == null) {
            return null;
        }
        return _account_sig_info_map.getTinyInfo(name);
    }

    public synchronized List<TLSUserInfo> get_all_logined_account() {
        try {
            return _account_sig_info_map.get_all_logined_account();
        }
        catch (NullPointerException e) {
            QLog.w("_account_sig_info_map null " + e.getMessage());
            return null;
        }
    }

    public synchronized int put_siginfo(long uin, long sappid, byte[] enA1, byte[] noPicSig, long appid, long app_pri, long create_time, ArrayList<Ticket> tickets, int login_bitmap) {
        int ret = _account_sig_info_map.put_siginfo(uin, sappid, enA1, noPicSig, appid, app_pri, create_time, tickets, login_bitmap);
        return ret;
    }

    public synchronized void clear_sig(long uin, long appid) {
        _account_sig_info_map.clear_sig(uin, appid);
    }

    public synchronized void put_account(String name, long uin) {
        _account_sig_info_map.putTinyInfo(name, name, uin, TinyInfo.UserType.USER_TYPE_NORMAL);
    }

    public synchronized void put_open_account(String openid, String identifier, long uin) {
        _account_sig_info_map.putTinyInfo(openid, identifier, uin, TinyInfo.UserType.USER_TYPE_NORMAL);
    }

    public void put_guest(String name, long uin) {
        _account_sig_info_map.putTinyInfo(name, name, uin, TinyInfo.UserType.USER_TYPE_GUEST);
    }

    public void put_sso_guest(String name, long uin) {
        _account_sig_info_map.putTinyInfo(name, name, uin, TinyInfo.UserType.USER_TYPE_SSO_GUEST);
    }

    public static String long2string(long value) {
        BigInteger big = BigInteger.valueOf(value);
        if (big.signum() < 0) {
            big = big.add(BigInteger.ONE.shiftLeft(64));
        }
        return big.toString();
    }

    public String uin2string() {
        return req_global.long2string(this._uin);
    }

    static {
        _context = null;
        _local_id = 2052;
        _last_date = "";
        _app_client_version = 0;
        _img_type = 1;
        _pic_type = 0;
        _IMEI = new byte[0];
        _IMEI_KEY = new byte[0];
        _sim_operator_name = new byte[0];
        _network_type = 0;
        _apk_id = new byte[0];
        _apn = new byte[0];
        _mac = new byte[0];
        _apk_v = new byte[0];
        _apk_sig = new byte[0];
        _device = new byte[0];
        _brand = new byte[0];
        _new_install = 0;
        _read_guid = 0;
        _guid_chg = 0;
        _guid_src = 0;
        _dev_chg = 0;
        _dev_report = 0;
        _isroot = 0;
        _time_difference = 0L;
        _l_init_time = 0L;
        _ip_addr = new byte[4];
        data_lock = new Object();
        _account_sig_info_map = null;
        _cur_sequence = 0L;
        _async_data = new TreeMap();
    }
}

