/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.request;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import tencent.tls.platform.TLSErrInfo;
import tencent.tls.report.QLog;
import tencent.tls.request.DNS_resolver;
import tencent.tls.request.SSORunner;
import tencent.tls.request.Ticket;
import tencent.tls.request.alert_thread;
import tencent.tls.request.async_context;
import tencent.tls.request.http_connect_ontime;
import tencent.tls.request.req_global;
import tencent.tls.tlvs.tlv_t;
import tencent.tls.tlvs.tlv_t104;
import tencent.tls.tlvs.tlv_t105;
import tencent.tls.tlvs.tlv_t106;
import tencent.tls.tlvs.tlv_t113;
import tencent.tls.tlvs.tlv_t11f;
import tencent.tls.tlvs.tlv_t126;
import tencent.tls.tlvs.tlv_t130;
import tencent.tls.tlvs.tlv_t138;
import tencent.tls.tlvs.tlv_t146;
import tencent.tls.tlvs.tlv_t149;
import tencent.tls.tlvs.tlv_t150;
import tencent.tls.tlvs.tlv_t16a;
import tencent.tls.tlvs.tlv_t172;
import tencent.tls.tlvs.tlv_t183;
import tencent.tls.tlvs.tlv_t505;
import tencent.tls.tools.I18nMsg;
import tencent.tls.tools.cryptor;
import tencent.tls.tools.util;

public class oicq_request {
    int _max = 4096;
    int _pos = 0;
    int _req_head_len = 31;
    int _rep_body_len = 0;
    public int _rsp_head_len = 19;
    protected int _rsp_body_len = 0;
    protected byte[] _buf = new byte[this._max];
    protected int _default_client_version = 8002;
    protected int _default_client_seq = 0;
    protected int _default_ext_version = 3;
    protected int _default_ext_version1 = 0;
    protected int _default_ext_retry = 0;
    protected int _default_ext_type = 2;
    protected int _default_ext_no = 0;
    protected int _default_ext_instance = 0;
    InetSocketAddress _server_ip = null;
    int _server_port = 0;
    byte[] _recv_ret_buf = new byte[10240];
    protected int _cmd = 0;
    protected int _sub_cmd = 0;
    protected String _service_cmd = "";
    byte _ret;
    public req_global _g;
    static String[] _static_wlogin_ip = new String[]{"183.62.104.188"};
    static String[] _static_web_wlogin_ip = new String[]{"183.62.104.188"};
    static int _test = 0;
    static String _test_host = "";
    static String _save_host = "";
    static final int ECDH_KEY = 0;
    static final int KC_KEY = 1;

    public String get_static_ip(boolean is_wap_retry) {
        if (is_wap_retry) {
            return _static_web_wlogin_ip[(int)(Math.random() * 2.147483647E9) % _static_web_wlogin_ip.length];
        }
        return _static_wlogin_ip[(int)(Math.random() * 2.147483647E9) % _static_wlogin_ip.length];
    }

    public static void set_test(int test, String host) {
        _test = test;
        _test_host = host;
    }

    public void fill_head(int version, int cmd, int seq, long uin, int retry, int type, int no, int intstance, int body_len) {
        seq = ++this._default_client_seq;
        this._pos = 0;
        util.int8_to_buf(this._buf, this._pos, 2);
        ++this._pos;
        util.int16_to_buf(this._buf, this._pos, this._req_head_len + 2 + body_len);
        this._pos += 2;
        util.int16_to_buf(this._buf, this._pos, version);
        this._pos += 2;
        util.int16_to_buf(this._buf, this._pos, cmd);
        this._pos += 2;
        util.int16_to_buf(this._buf, this._pos, seq);
        this._pos += 2;
        util.int64_to_buf(this._buf, this._pos, uin);
        this._pos += 8;
        util.int8_to_buf(this._buf, this._pos, 3);
        ++this._pos;
        util.int8_to_buf(this._buf, this._pos, 7);
        ++this._pos;
        util.int8_to_buf(this._buf, this._pos, retry);
        ++this._pos;
        util.int32_to_buf(this._buf, this._pos, type);
        this._pos += 4;
        util.int32_to_buf(this._buf, this._pos, no);
        this._pos += 4;
        util.int32_to_buf(this._buf, this._pos, intstance);
        this._pos += 4;
    }

    public void fill_end() {
        util.int8_to_buf(this._buf, this._pos, 3);
        ++this._pos;
    }

    public void fill_body(byte[] body, int len) {
        if (len + this._pos + 1 > this._max) {
            this._max = len + this._pos + 1 + 128;
            byte[] new_buf = new byte[this._max];
            System.arraycopy(this._buf, 0, new_buf, 0, this._pos);
            this._buf = new_buf;
        }
        System.arraycopy(body, 0, this._buf, this._pos, len);
        this._pos += len;
    }

    public void fill(int version, int cmd, int seq, long uin, int retry, int type, int no, int intstance, byte[] body, int body_len) {
        this.fill_head(version, cmd, seq, uin, retry, type, no, intstance, body_len);
        this.fill_body(body, body_len);
        this.fill_end();
    }

    public void get_request(int version, int cmd, int seq, long uin, int retry, int type, int no, int intstance, byte[] body) {
        this.fill(version, cmd, seq, uin, retry, type, no, intstance, body, body.length);
    }

    public int get_response() {
        int ret = 0;
        int len = this._pos;
        if (len <= this._rsp_head_len + 2) {
            return -1009;
        }
        this._rsp_body_len = len - this._rsp_head_len - 2;
        if (this._g._encrypt_type == 0) {
            ret = this.decrypt_body(this._buf, 1 + this._rsp_head_len, this._rsp_body_len, this._g._share_key);
            if (ret < 0) {
                QLog.i("use ecdh decrypt_body failed");
                ret = this.decrypt_body(this._buf, 1 + this._rsp_head_len, this._rsp_body_len, this._g._rand_key);
                if (ret < 0) {
                    QLog.i("use kc decrypt_body failed");
                }
            }
        } else {
            ret = this.decrypt_body(this._buf, 1 + this._rsp_head_len, this._rsp_body_len, this._g._rand_key);
            if (ret < 0) {
                QLog.i("use kc decrypt_body failed");
            }
        }
        if (ret < 0) {
            return ret;
        }
        ret = this.get_response_body(this._buf, 1 + this._rsp_head_len, this._rsp_body_len);
        return ret;
    }

    public void set_buf(byte[] in, int len) {
        if (len > this._max) {
            this._max = len + 128;
            this._buf = new byte[this._max];
        }
        this._pos = len;
        System.arraycopy(in, 0, this._buf, 0, len);
    }

    public byte[] get_buf() {
        byte[] ret = new byte[this._pos];
        System.arraycopy(this._buf, 0, ret, 0, this._pos);
        return ret;
    }

    public int decrypt_body(byte[] in, int pos, int len, byte[] key) {
        byte[] dbody = cryptor.decrypt(in, pos, len, key);
        if (dbody == null) {
            return -1002;
        }
        this._rsp_body_len = dbody.length;
        if (dbody.length + this._rsp_head_len + 2 > this._max) {
            this._max = dbody.length + this._rsp_head_len + 2;
            byte[] new_buf = new byte[this._max];
            System.arraycopy(this._buf, 0, new_buf, 0, this._pos);
            this._buf = new_buf;
        }
        this._pos = 0;
        System.arraycopy(dbody, 0, this._buf, pos, dbody.length);
        this._pos += this._rsp_head_len + 2 + dbody.length;
        return 0;
    }

    byte[] ecdh_encrypt_body(byte[] body, byte[] randkey, byte[] pubkey, byte[] sharekey) {
        if (body == null || randkey == null || pubkey == null || sharekey == null) {
            return new byte[0];
        }
        int pos = 0;
        byte[] en_buf = cryptor.encrypt(body, 0, body.length, sharekey);
        byte[] ret = new byte[2 + randkey.length + 2 + 2 + pubkey.length + en_buf.length];
        util.int8_to_buf(ret, pos, 1);
        util.int8_to_buf(ret, ++pos, 1);
        System.arraycopy(randkey, 0, ret, ++pos, randkey.length);
        util.int16_to_buf(ret, pos += randkey.length, 258);
        util.int16_to_buf(ret, pos += 2, pubkey.length);
        System.arraycopy(pubkey, 0, ret, pos += 2, pubkey.length);
        System.arraycopy(en_buf, 0, ret, pos += pubkey.length, en_buf.length);
        pos += en_buf.length;
        QLog.d("ecdh req body " + ret.length);
        return ret;
    }

    byte[] kc_encrypt_body(byte[] body, byte[] randkey, int cmd) {
        if (body == null || randkey == null) {
            return new byte[0];
        }
        int pos = 0;
        byte[] en_buf = cryptor.encrypt(body, 0, body.length, randkey);
        byte[] ret = new byte[2 + randkey.length + 2 + 2 + en_buf.length];
        util.int8_to_buf(ret, pos, 1);
        util.int8_to_buf(ret, ++pos, cmd);
        System.arraycopy(randkey, 0, ret, ++pos, randkey.length);
        util.int16_to_buf(ret, pos += randkey.length, 258);
        util.int16_to_buf(ret, pos += 2, 0);
        System.arraycopy(en_buf, 0, ret, pos += 2, en_buf.length);
        pos += en_buf.length;
        QLog.d("kc req body " + ret.length);
        return ret;
    }

    byte[] kc_encrypt_body(byte[] body, byte[] randkey) {
        return this.kc_encrypt_body(body, randkey, 2);
    }

    byte[] encrypt_body(byte[] in, int sub_cmd, int tlv_num) {
        QLog.i("subcmd 0x" + Integer.toHexString(sub_cmd));
        byte[] body = new byte[4 + in.length];
        util.int16_to_buf(body, 0, sub_cmd);
        util.int16_to_buf(body, 2, tlv_num);
        System.arraycopy(in, 0, body, 4, in.length);
        if (this._g._encrypt_type == 0) {
            return this.ecdh_encrypt_body(body, this._g._rand_key, this._g._pub_key, this._g._share_key);
        }
        return this.kc_encrypt_body(body, this._g._rand_key);
    }

    protected byte[] encrypt_body(byte[] in) {
        if (this._g._encrypt_type == 0) {
            return this.ecdh_encrypt_body(in, this._g._rand_key, this._g._pub_key, this._g._share_key);
        }
        return this.kc_encrypt_body(in, this._g._rand_key);
    }

    public Socket get_sk() {
        if (this._g._sk != null) {
            QLog.d("_sk" + this._g._sk.toString());
        } else {
            QLog.d("_sknull");
        }
        return this._g._sk;
    }

    public void set_sk(Socket sk) {
        this._g._sk = sk;
    }

    public String get_host(boolean is_wap_retry) {
        String[] host_array = new String[2];
        if (is_wap_retry) {
            host_array[0] = "ida1.qq.com";
            host_array[1] = "ida1.qq.com";
        } else {
            host_array[0] = "ida.qq.com";
            host_array[1] = "ida.qq.com";
        }
        Random random = new Random();
        int r = random.nextInt();
        r = Math.abs(r % host_array.length);
        return host_array[r];
    }

    public int get_port(boolean is_wap_retry) {
        if (is_wap_retry) {
            return 443;
        }
        return 443;
    }

    public String resolve_server_addr(int retry_no, boolean is_wap_retry) {
        String host = "";
        retry_no /= 2;
        if (_test != 0 && _test_host != null && _test_host.length() > 0) {
            host = _test_host;
        } else if (retry_no < 1) {
            if (is_wap_retry) {
                if (req_global._network_type == 1) {
                    host = util.get_server_host(req_global._context, "wap-host1");
                } else if (req_global._network_type == 2) {
                    host = util.get_server_host(req_global._context, "wap-host2");
                }
            } else if (req_global._network_type == 1) {
                host = util.get_server_host(req_global._context, "host1");
            } else if (req_global._network_type == 2) {
                host = util.get_server_host(req_global._context, "host2");
            }
            if (host == null || host.length() <= 0) {
                host = this.get_host(is_wap_retry);
            }
        } else {
            host = retry_no < 2 ? this.get_host(is_wap_retry) : this.get_static_ip(is_wap_retry);
        }
        _save_host = host;
        QLog.d("resolve_server_addr OK host:" + host + " tryno:" + retry_no);
        return host;
    }

    public int snd_rcv_req() {
        int ret = 0;
        ret = this._g._use_sso_channel ? this.snd_rcv_req_sso() : this.snd_rcv_req_tcp();
        if (ret == -1000) {
            TLSErrInfo errInfo = new TLSErrInfo();
            errInfo.ErrCode = ret;
            errInfo.Msg = I18nMsg.getMsg(I18nMsg.MSG_TYPE.MSG_4);
            this.set_err_msg(errInfo);
        }
        return ret;
    }

    public int snd_rcv_req_sso() {
        QLog.i(this.getClass().getName() + ":snd_rcv_req_sso ...", this._g._uin);
        int ret = 0;
        int timeout = this._g._time_out;
        byte[] reqData = this.get_buf();
        byte[] resData = null;
        for (int retryTimes = util.connRetryTimes; retryTimes > 0; --retryTimes) {
            try {
                QLog.i("SSORunner service_cmd:" + this._service_cmd + " timeout:" + timeout, this._g._uin);
                SSORunner runner = new SSORunner(this._service_cmd, reqData, timeout);
                runner.run();
                resData = runner.getResData();
                if (resData == null) {
                    QLog.i("recv data from server failed, ret=" + runner.getRet(), this._g._uin);
                    if (1014 == runner.getRet()) {
                        ret = -1023;
                        continue;
                    }
                    if (1015 == runner.getRet()) {
                        ret = -1000;
                        continue;
                    }
                    ret = -1000;
                    continue;
                }
                this.set_buf(resData, resData.length);
                ret = 0;
                break;
            }
            catch (Exception e) {
                QLog.e(e);
                ret = -1000;
            }
        }
        QLog.i(this.getClass().getName() + ":snd_rcv_req_sso ret=" + ret, this._g._uin);
        return ret;
    }

    public int get_rsp_length(byte[] head) {
        return util.buf_to_int16(head, 1);
    }

    public int snd_rcv_req_tcp() {
        QLog.i(this.getClass().getName() + ":snd_rcv_req_tcp ...", this._g._uin);
        byte[] buf = this.get_buf();
        int all_len = 0;
        int has_len = 0;
        int left_len = 0;
        int ret = 0;
        int retry = 0;
        OutputStream out = null;
        InputStream in = null;
        Socket sk = this.get_sk();
        boolean is_wap_retry = false;
        boolean is_wap_proxy_retry = false;
        int retryNum = 6;
        while (retry < retryNum) {
            block29: {
                if (retry != 0) {
                    util.chg_retry_type(req_global._context);
                }
                is_wap_retry = util.is_wap_retry(req_global._context);
                is_wap_retry = false;
                this._server_ip = null;
                if (is_wap_retry) {
                    QLog.i("try http connect " + retry + " ...", this._g._uin);
                    URL url = null;
                    HttpURLConnection hconn = null;
                    String unresolve_host = "";
                    unresolve_host = this.resolve_server_addr(retry, is_wap_retry);
                    try {
                        String proxy_ip = null;
                        int proxy_port = -1;
                        is_wap_proxy_retry = util.is_wap_proxy_retry(req_global._context);
                        if (is_wap_proxy_retry) {
                            proxy_ip = util.get_proxy_ip();
                            proxy_port = util.get_proxy_port();
                            if (proxy_ip == null || proxy_ip.length() <= 0 || proxy_port == -1) {
                                is_wap_proxy_retry = false;
                                QLog.i("proxy_ip=" + proxy_ip + ",proxy_port=" + proxy_port + ",set is_wap_proxy_retry=" + is_wap_proxy_retry, this._g._uin);
                            }
                        }
                        url = is_wap_proxy_retry ? new URL("http://" + proxy_ip + ":" + proxy_port + "/cgi-bin/wlogin_proxy_login") : new URL("http://" + unresolve_host + "/cgi-bin/wlogin_proxy_login");
                        QLog.i("try http proxy=" + is_wap_proxy_retry + " connect to " + url, this._g._uin);
                        hconn = (HttpURLConnection)url.openConnection();
                        hconn.setRequestMethod("POST");
                        if (is_wap_proxy_retry) {
                            hconn.setRequestProperty("X-Online-Host", unresolve_host);
                        }
                        hconn.setRequestProperty("Content-ErrCode", "application/octet-stream");
                        hconn.setRequestProperty("Content-Disposition", "attachment; filename=micromsgresp.dat");
                        hconn.setRequestProperty("Content-Length", String.valueOf(buf.length));
                        hconn.setConnectTimeout(this._g._time_out);
                        hconn.setReadTimeout(this._g._time_out);
                        hconn.setDoOutput(true);
                        hconn.setDoInput(true);
                        QLog.i("http request connect ...", this._g._uin);
                        if (!http_connect_ontime.connect_ontime(hconn, this._g._time_out)) {
                            QLog.i("http request connect failed", this._g._uin);
                            ret = -1000;
                            ++retry;
                            continue;
                        }
                        QLog.i("http request write ...", this._g._uin);
                        out = hconn.getOutputStream();
                        out.write(buf, 0, buf.length);
                        out.flush();
                        ret = hconn.getResponseCode();
                        QLog.i("http request response code=" + ret, this._g._uin);
                        if (200 != ret) {
                            QLog.d("use http ret=" + ret + " msg=" + hconn.getResponseMessage());
                            ret = -1000;
                            ++retry;
                            continue;
                        }
                        in = hconn.getInputStream();
                        break block29;
                    }
                    catch (Exception e) {
                        ret = -1000;
                        ++retry;
                        continue;
                    }
                }
                QLog.i("try bin connect " + retry + " ...", this._g._uin);
                if (sk == null) {
                    String unresolve_host = "";
                    if (this._server_ip == null) {
                        unresolve_host = this.resolve_server_addr(retry, is_wap_retry);
                        QLog.i("DNS for " + unresolve_host + " request ...", this._g._uin);
                        try {
                            this._server_port = this.get_port(is_wap_retry);
                            this._server_ip = DNS_resolver.get_DNS_resolver(unresolve_host, this._server_port, this._g._time_out);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this._server_ip == null) {
                        QLog.i("DNS for " + unresolve_host + " request failed", this._g._uin);
                        ++retry;
                        this._server_ip = null;
                        sk = null;
                        this.set_sk(sk);
                        continue;
                    }
                    QLog.i("DNS for " + unresolve_host + "(" + this._server_ip.toString() + ") request OK", this._g._uin);
                }
                try {
                    if (sk == null) {
                        QLog.i("tcp connect to " + this._server_ip + " request ...", this._g._uin);
                        sk = new Socket();
                        this.set_sk(sk);
                        sk.connect(this._server_ip, this._g._time_out);
                        sk.setSoTimeout(this._g._time_out);
                        sk.setReceiveBufferSize(this._recv_ret_buf.length);
                        QLog.i("tcp connect to " + this._server_ip + " OK", this._g._uin);
                    }
                    QLog.i("tcp request write ...", this._g._uin);
                    out = sk.getOutputStream();
                    out.write(buf, 0, buf.length);
                    out.flush();
                    in = sk.getInputStream();
                }
                catch (Exception e) {
                    QLog.e(e);
                    ret = -1000;
                    ++retry;
                    this._server_ip = null;
                    sk = null;
                    this.set_sk(sk);
                    continue;
                }
            }
            try {
                QLog.i("recv data from server ...", this._g._uin);
                ret = 0;
                for (has_len = 0; has_len < this._rsp_head_len + 1 && (ret = in.read(this._recv_ret_buf, has_len, this._rsp_head_len + 1 - has_len)) >= 0; has_len += ret) {
                }
                if (ret < 0) {
                    ret = -1000;
                    ++retry;
                    if (is_wap_retry) continue;
                    sk.close();
                    this._server_ip = null;
                    sk = null;
                    this.set_sk(sk);
                    continue;
                }
                all_len = this.get_rsp_length(this._recv_ret_buf);
                if (all_len <= this._rsp_head_len + 1) {
                    ret = -1000;
                    ++retry;
                    if (is_wap_retry) continue;
                    sk.close();
                    this._server_ip = null;
                    sk = null;
                    this.set_sk(sk);
                    continue;
                }
                if (all_len >= this._recv_ret_buf.length) {
                    ret = -1000;
                    ++retry;
                    if (is_wap_retry) continue;
                    sk.close();
                    this._server_ip = null;
                    sk = null;
                    this.set_sk(sk);
                    continue;
                }
                has_len = this._rsp_head_len + 1;
                for (left_len = all_len - has_len; left_len > 0 && (ret = in.read(this._recv_ret_buf, has_len, left_len)) != -1; left_len -= ret) {
                    has_len += ret;
                }
                if (ret != -1) break;
                ret = -1000;
                ++retry;
                if (is_wap_retry) continue;
                sk.close();
                this._server_ip = null;
                sk = null;
                this.set_sk(sk);
            }
            catch (Exception e) {
                QLog.e(e);
                ret = -1000;
                ++retry;
                if (is_wap_retry) continue;
                try {
                    if (sk.isConnected()) {
                        sk.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._server_ip = null;
                sk = null;
                this.set_sk(sk);
            }
        }
        if ((ret = retry >= retryNum ? -1000 : 0) == 0) {
            this.set_buf(this._recv_ret_buf, all_len);
        }
        QLog.i(this.getClass().getName() + ":snd_rcv_req_tcp ret=" + ret, this._g._uin);
        return ret;
    }

    public int get_response_ret_code(byte[] in, int pos) {
        this._ret = in[pos];
        return in[pos] & 0xFF;
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < this._pos; ++i) {
            ret = ret + Integer.toHexString(this._buf[i] >> 4 & 0xF);
            ret = ret + Integer.toHexString(this._buf[i] & 0xF);
        }
        return ret;
    }

    public void get_err_msg(byte[] in, int pos, int len) {
        tlv_t146 t146 = new tlv_t146();
        int ret = t146.get_tlv(in, pos, len);
        async_context thisContext = req_global.get_async_data(this._g._seq);
        if (ret >= 0) {
            thisContext._last_err_msg = new TLSErrInfo(t146.errType, t146.errTitle, t146.errMsg, t146.extraErrMsg);
            QLog.i("t146 errtype: " + t146.errType);
        }
    }

    public void set_err_msg(TLSErrInfo errInfo) {
        async_context thisContext = req_global.get_async_data(this._g._seq);
        thisContext._last_err_msg = errInfo != null ? errInfo : new TLSErrInfo();
    }

    public void show_alert_dialog(tlv_t149 t149) {
        try {
            if (t149 != null) {
                TLSErrInfo errInfo = new TLSErrInfo(t149.get_type(), t149.get_title(), t149.get_content(), t149.get_otherinfo());
                new alert_thread(req_global._context, errInfo).start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] encrypt_a1(byte[] a1, byte[] key_tgtgt) {
        byte[] in = new byte[a1.length + key_tgtgt.length];
        System.arraycopy(a1, 0, in, 0, a1.length);
        System.arraycopy(key_tgtgt, 0, in, a1.length, key_tgtgt.length);
        return in;
    }

    public byte[] decrypt_a1(byte[] en_a1) {
        String key = "%4;7t>;28<fc.5*6";
        byte[] ret = null;
        byte[] ret1 = null;
        int a1_len = 0;
        if (req_global._IMEI_KEY == null || req_global._IMEI_KEY.length <= 0) {
            ret = cryptor.decrypt(en_a1, 0, en_a1.length, key.getBytes());
        } else {
            byte[] key1 = new byte[16];
            if (req_global._IMEI_KEY.length > key1.length) {
                System.arraycopy(req_global._IMEI_KEY, 0, key1, 0, key1.length);
            } else {
                System.arraycopy(req_global._IMEI_KEY, 0, key1, 0, req_global._IMEI_KEY.length);
                for (int i = req_global._IMEI_KEY.length; i < key1.length; ++i) {
                    key1[i] = (byte)(i + 1);
                }
            }
            ret = cryptor.decrypt(en_a1, 0, en_a1.length, key1);
            if (ret == null || ret.length <= 0) {
                ret = cryptor.decrypt(en_a1, 0, en_a1.length, key.getBytes());
            }
        }
        if (ret == null) {
            ret = (byte[])en_a1.clone();
        }
        if (ret == null || ret.length < 16) {
            return null;
        }
        a1_len = ret.length - 16;
        ret1 = new byte[a1_len];
        System.arraycopy(ret, 0, ret1, 0, a1_len);
        byte[] tgtgt_key = new byte[16];
        System.arraycopy(ret, a1_len, tgtgt_key, 0, 16);
        async_context thisContext = req_global.get_async_data(this._g._seq);
        thisContext._tgtgt_key = tgtgt_key;
        return ret1;
    }

    void set_server_host(int type, byte[] ip, int port) {
        if (ip == null || ip.length <= 0) {
            return;
        }
        if (type == 1) {
            if (req_global._network_type == 1) {
                util.set_server_host(req_global._context, ip, "host1");
            } else if (req_global._network_type == 2) {
                util.set_server_host(req_global._context, ip, "host2");
            }
        } else if (type == 2) {
            if (req_global._network_type == 1) {
                util.set_server_host(req_global._context, ip, "wap-host1");
            } else if (req_global._network_type == 2) {
                util.set_server_host(req_global._context, ip, "wap-host2");
            }
        }
        QLog.i("net type:" + req_global._network_type + " type:" + type + " host:" + new String(ip) + " port:" + port, this._g._uin);
    }

    public int parse_t173(tlv_t t173) {
        byte[] in1 = t173.get_data();
        int pos1 = 1;
        if (in1 != null && in1.length > 2) {
            int cCnt = util.buf_to_int8(in1, pos1);
            ++pos1;
            for (int i = 0; i < cCnt && in1.length >= pos1 + 1; ++i) {
                int wIpLen;
                int cIpType = util.buf_to_int8(in1, pos1);
                if (in1.length < ++pos1 + 2 || in1.length < (pos1 += 2) + (wIpLen = util.buf_to_int16(in1, pos1))) break;
                byte[] ip = new byte[wIpLen];
                System.arraycopy(in1, pos1, ip, 0, wIpLen);
                if (in1.length < (pos1 += wIpLen) + 2) break;
                int wPort = util.buf_to_int16(in1, pos1);
                pos1 += 2;
                this.set_server_host(cIpType, ip, wPort);
            }
        }
        return 0;
    }

    public int parse_t161(tlv_t t161) {
        int tl;
        int pos1;
        int ret = 0;
        tlv_t t173 = new tlv_t(371);
        tlv_t172 t172 = new tlv_t172();
        byte[] in1 = t161.get_data();
        ret = t173.get_tlv(in1, pos1 = 2, tl = in1.length);
        if (ret > 0) {
            this.parse_t173(t173);
        }
        if ((ret = t172.get_tlv(in1, pos1, tl)) > 0) {
            this._g._encrypt_type = 1;
            this._g._t172_data = t172.get_data();
            QLog.i("get rollback sig");
        }
        return 0;
    }

    public int get_response_body(byte[] in, int pos, int len) {
        long tk_valid = 2160000L;
        long a2_valid = 2160000L;
        long d2_valid = 1728000L;
        long app_pri = 0xFFFFFFFFL;
        tlv_t104 t104 = new tlv_t104();
        tlv_t105 t105 = new tlv_t105();
        tlv_t113 t113 = new tlv_t113();
        tlv_t t119 = new tlv_t(281);
        tlv_t t10d = new tlv_t(269);
        tlv_t t10a = new tlv_t(266);
        tlv_t130 t130 = new tlv_t130();
        tlv_t106 t106 = new tlv_t106();
        tlv_t t10c = new tlv_t(268);
        tlv_t11f t11f = new tlv_t11f();
        tlv_t138 t138 = new tlv_t138();
        tlv_t149 t149 = new tlv_t149();
        tlv_t150 t150 = new tlv_t150();
        tlv_t t143 = new tlv_t(323);
        tlv_t t305 = new tlv_t(773);
        tlv_t16a t16a = new tlv_t16a();
        tlv_t t161 = new tlv_t(353);
        tlv_t t174 = new tlv_t(372);
        tlv_t126 t126 = new tlv_t126();
        tlv_t505 t505 = new tlv_t505();
        tlv_t183 t183 = new tlv_t183();
        int ret = 0;
        int flowid = 0;
        async_context thisContext = req_global.get_async_data(this._g._seq);
        long srcAppid = thisContext._src_appid;
        long dstAppid = thisContext._appid;
        switch (this._sub_cmd) {
            case 9: {
                flowid = 0;
                break;
            }
            case 15: {
                flowid = 5;
                break;
            }
            case 7: {
                flowid = 6;
                break;
            }
            case 18: {
                flowid = 7;
                break;
            }
            case 17: 
            case 19: {
                break;
            }
            case 25: {
                flowid = 8;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 26: {
                flowid = 9;
                break;
            }
            default: {
                return -1012;
            }
        }
        if (len < 5) {
            return -1009;
        }
        int type = this.get_response_ret_code(in, pos + 2);
        QLog.i("get_response_body type=" + type);
        pos += 5;
        this._g._t150 = null;
        switch (type) {
            case 0: {
                int len119;
                int bufPos;
                if (flowid == 7 || flowid == 8) {
                    if (flowid == 8) {
                        ret = t183.get_tlv(in, pos, this._pos - pos);
                        if (ret < 0) break;
                        thisContext._msalt = t183.getMsalt();
                        this._g.put_account(this._g._userid, this._g._uin);
                    }
                    if ((ret = t104.get_tlv(in, pos, this._pos - pos)) < 0) break;
                    thisContext._t104 = t104;
                    ret = 0;
                    break;
                }
                if (flowid == 9) {
                    ret = t113.get_tlv(in, pos, this._pos - pos);
                    if (ret < 0) {
                        ret = -1003;
                        break;
                    }
                    this._g._uin = t113.get_uin();
                    tlv_t t506 = new tlv_t(1286);
                    ret = t506.get_tlv(in, pos, this._pos - pos);
                    if (ret >= 0) {
                        this._g._admin = util.buf_to_int32(t506.get_data(), 0);
                    }
                    tlv_t t112 = new tlv_t(274);
                    ret = t112.get_tlv(in, pos, this._pos - pos);
                    String innerID = this._g._userid;
                    if (ret >= 0) {
                        innerID = new String(t112.get_data());
                    }
                    this._g.put_open_account(this._g._userid, innerID, this._g._uin);
                    this._g._userid = innerID;
                    ret = t10a.get_tlv(in, pos, this._pos - pos);
                    ret = t143.get_tlv(in, pos, this._pos - pos);
                    ret = t305.get_tlv(in, pos, this._pos - pos);
                    long create_time = req_global.get_cur_time();
                    ArrayList<Ticket> tickets = new ArrayList<Ticket>();
                    tickets.add(new Ticket(64, t10a.get_data(), t10d.get_data(), create_time, create_time + a2_valid));
                    tickets.add(new Ticket(262144, t143.get_data(), t305.get_data(), create_time, create_time + d2_valid));
                    ret = this._g.put_siginfo(this._g._uin, srcAppid, new byte[0], new byte[0], dstAppid, app_pri, create_time, tickets, thisContext._login_bitmap);
                    ret = 0;
                    break;
                }
                if (flowid == 0) {
                    ret = t113.get_tlv(in, pos, this._pos - pos);
                    if (ret < 0) {
                        ret = -1003;
                        break;
                    }
                    this._g._uin = t113.get_uin();
                    this._g.put_account(this._g._userid, this._g._uin);
                }
                if ((ret = t150.get_tlv(in, pos, this._pos - pos - 1)) >= 0) {
                    this._g._t150 = t150;
                }
                if ((ret = t161.get_tlv(in, pos, this._pos - pos - 1)) >= 0) {
                    this.parse_t161(t161);
                    QLog.d("parse t161 called");
                }
                if ((ret = t119.get_tlv(in, pos, this._pos - pos - 1, thisContext._tgtgt_key)) < 0) {
                    QLog.d("119 can not decrypt");
                    break;
                }
                byte[] buf119 = t119.get_data();
                ret = t149.get_tlv(buf119, bufPos = 2, len119 = buf119.length);
                if (ret > 0) {
                    this.show_alert_dialog(t149);
                }
                if ((ret = t130.get_tlv(buf119, bufPos, len119)) > 0) {
                    this._g.set_time_ip(t130.get_time(), t130.get_ipaddr());
                }
                t10a.get_tlv(buf119, bufPos, len119);
                t10d.get_tlv(buf119, bufPos, len119);
                t143.get_tlv(buf119, bufPos, len119);
                t305.get_tlv(buf119, bufPos, len119);
                tlv_t t503 = new tlv_t(1283);
                t503.get_tlv(buf119, bufPos, len119);
                ret = t11f.get_tlv(buf119, bufPos, len119);
                if (ret >= 0) {
                    app_pri = (long)t11f.get_tk_pri() & 0xFFFFFFFFL;
                }
                QLog.i("sdkAppid:" + thisContext._appid + " tk_valid:" + tk_valid + " a2_valid:" + a2_valid, this._g._uin);
                byte[] enA1 = new byte[]{};
                byte[] noPicSig = new byte[]{};
                int ret1 = t10c.get_tlv(buf119, bufPos, len119);
                ret = t106.get_tlv(buf119, bufPos, len119);
                if (ret >= 0 && ret1 >= 0) {
                    byte[] _key_tgtgt = t10c.get_data();
                    enA1 = oicq_request.encrypt_a1(t106.get_data(), _key_tgtgt);
                }
                if ((ret = t16a.get_tlv(buf119, bufPos, len119)) >= 0) {
                    noPicSig = t16a.get_data();
                }
                long create_time = req_global.get_cur_time();
                ArrayList<Ticket> tickets = new ArrayList<Ticket>();
                tickets.add(new Ticket(64, t10a.get_data(), t10d.get_data(), create_time, create_time + a2_valid));
                tickets.add(new Ticket(262144, t143.get_data(), t305.get_data(), create_time, create_time + d2_valid));
                tickets.add(new Ticket(0x10000000, t503.get_data(), null, create_time, create_time + tk_valid));
                ret = this._g.put_siginfo(this._g._uin, srcAppid, enA1, noPicSig, dstAppid, app_pri, create_time, tickets, thisContext._login_bitmap);
                if (ret != 0) {
                    TLSErrInfo errInfo = new TLSErrInfo();
                    errInfo.ErrCode = ret;
                    errInfo.Msg = I18nMsg.getMsg(I18nMsg.MSG_TYPE.MSG_2);
                    this.set_err_msg(errInfo);
                    QLog.i("put_siginfo fail,ret=", this._g._uin);
                    break;
                }
                ret = 0;
                break;
            }
            case 1: 
            case 15: {
                this._g.clear_sig(this._g._uin, srcAppid);
                this.get_err_msg(in, pos, this._pos - pos - 1);
                ret = type;
                break;
            }
            case 2: {
                ret = t104.get_tlv(in, pos, this._pos - pos - 1);
                if (ret < 0) break;
                thisContext._t104 = t104;
                ret = t105.get_tlv(in, pos, this._pos - pos - 1);
                if (ret < 0) break;
                thisContext._t105 = t105;
                tlv_t t504 = new tlv_t(1284);
                ret = t504.get_tlv(in, pos, this._pos - pos - 1);
                if (ret >= 0) {
                    QLog.i("got t504");
                }
                TLSErrInfo errInfo = new TLSErrInfo(type, null, new String(t504.get_data()));
                this.set_err_msg(errInfo);
                ret = type;
                break;
            }
            case 16: {
                ret = t130.get_tlv(in, pos, this._pos - pos - 1);
                if (ret < 0) break;
                this._g.set_time_ip(t130.get_time(), t130.get_ipaddr());
                this.get_err_msg(in, pos, this._pos - pos - 1);
                ret = type;
                break;
            }
            case 160: {
                ret = t104.get_tlv(in, pos, this._pos - pos - 1);
                if (ret < 0) break;
                thisContext._t104 = t104;
                ret = t174.get_tlv(in, pos, this._pos - pos - 1);
                if (ret < 0) break;
                thisContext._t174 = t174;
                this.get_err_msg(in, pos, this._pos - pos - 1);
                ret = type;
                break;
            }
            case 176: {
                this.get_err_msg(in, pos, this._pos - pos - 1);
                ret = type;
                this._g.remove_account(this._g._userid);
                this._g.clear_sig(this._g._uin, 0L);
                break;
            }
            case 180: {
                ret = t161.get_tlv(in, pos, this._pos - pos - 1);
                if (ret < 0) break;
                this.parse_t161(t161);
                QLog.d("0xb4 parse t161 called");
                this.get_err_msg(in, pos, this._pos - pos - 1);
                ret = type;
                break;
            }
            case 208: {
                ret = t104.get_tlv(in, pos, this._pos - pos - 1);
                if (ret < 0) break;
                thisContext._t104 = t104;
                ret = t126.get_tlv(in, pos, this._pos - pos - 1);
                if (ret < 0) break;
                thisContext._t126 = t126;
                ret = t505.get_tlv(in, pos, this._pos - pos - 1);
                if (ret < 0) break;
                thisContext._smslogin_reask = t505.getReask();
                thisContext._smslogin_expire = t505.getExpire();
                QLog.i("reask: " + thisContext._smslogin_reask + ", expire: " + thisContext._smslogin_expire);
                ret = t183.get_tlv(in, pos, this._pos - pos - 1);
                if (ret < 0) break;
                thisContext._msalt = t183.getMsalt();
                ret = 0;
                break;
            }
            case 255: {
                this.get_err_msg(in, pos, this._pos - pos - 1);
                ret = thisContext._last_err_msg.ErrCode;
                break;
            }
            default: {
                this.get_err_msg(in, pos, this._pos - pos - 1);
                ret = type;
            }
        }
        QLog.i("ret:" + (ret > 0 ? "0x" + Integer.toHexString(ret) : Integer.valueOf(ret)), this._g._uin);
        thisContext._last_err_msg.ErrCode = ret;
        if (ret == 0) {
            this.set_err_msg(null);
            thisContext._last_err_msg.ErrCode = 0;
        }
        if (ret == 10 || ret == 162 || ret == 164 || ret == 165 || ret == 166 || ret == 154 || ret >= 128 && ret <= 143) {
            ret = -1000;
        }
        return ret;
    }
}

