/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.request;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import tencent.tls.platform.TLSUserInfo;
import tencent.tls.report.QLog;
import tencent.tls.request.AllSigInfo;
import tencent.tls.request.SigInfo;
import tencent.tls.request.Ticket;
import tencent.tls.request.TinyInfo;
import tencent.tls.request.TkDBHelper;
import tencent.tls.request.req_global;
import tencent.tls.tools.cryptor;
import tencent.tls.tools.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class account_sig_info_map {
    Context _context;
    public static final String TLS_TICKET_TABLE = "tk_tree";
    public static final String TLS_ACCOUNT_TABLE = "name_tree";
    public static final String tls_sdk_DBNAME = "tls_sdk.db";
    private static final Object db_lock = new Object();
    private static TkDBHelper tlsDBHelper = null;
    TreeMap<Long, AllSigInfo> _uin_map = new TreeMap();
    TreeMap<String, TinyInfo> _name_map = new TreeMap();

    public account_sig_info_map(Context context) {
        this._context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int put_siginfo(long uin, long sappid, byte[] enA1, byte[] noPicSig, long appid, long app_pri, long create_time, ArrayList<Ticket> tickets, int login_bitmap) {
        int ret = 0;
        if (this._context != null) {
            Object object = db_lock;
            synchronized (object) {
                AllSigInfo info;
                QLog.i("before put_siginfo", uin);
                TreeMap<Object, Object> t_uin_map = account_sig_info_map.loadTKTreeMap(this._context, TLS_TICKET_TABLE);
                if (t_uin_map == null) {
                    t_uin_map = new TreeMap();
                }
                if ((info = this._uin_map.get(uin)) == null && (info = (AllSigInfo)t_uin_map.get(uin)) == null) {
                    info = new AllSigInfo();
                }
                byte[] sappid_enA1 = new byte[]{};
                byte[] sappid_noPicSig = new byte[]{};
                SigInfo sigInfo = null;
                sigInfo = info._tk_map.get(sappid);
                if (sigInfo != null && sigInfo._en_A1 != null) {
                    sappid_enA1 = (byte[])sigInfo._en_A1.clone();
                    if (sigInfo._noPicSig != null) {
                        sappid_noPicSig = (byte[])sigInfo._noPicSig.clone();
                    }
                }
                info.put_siginfo(appid, app_pri, create_time, tickets, login_bitmap);
                if (enA1 != null && enA1.length > 0) {
                    info.put_siginfo(sappid, enA1, noPicSig, create_time);
                }
                t_uin_map.put(uin, info);
                ret = this.refreshTKTreeMap(t_uin_map, TLS_TICKET_TABLE);
                if (ret != 0 && (sigInfo = info._tk_map.get(sappid)) != null) {
                    sigInfo._en_A1 = sappid_enA1;
                    sigInfo._noPicSig = sappid_noPicSig;
                }
                this._uin_map.put(uin, info);
                QLog.i("after put_siginfo", uin);
            }
        }
        return ret;
    }

    public synchronized AllSigInfo get_all_siginfo(long uin) {
        QLog.i("get_all_siginfo", uin);
        AllSigInfo info = null;
        info = this._uin_map.get(uin);
        if (info != null) {
            return info;
        }
        TreeMap<?, ?> t_uin_map = account_sig_info_map.loadTKTreeMap(this._context, TLS_TICKET_TABLE);
        if (t_uin_map == null) {
            return null;
        }
        info = (AllSigInfo)t_uin_map.get(uin);
        if (info == null) {
            return null;
        }
        this._uin_map.put(uin, info);
        return info.clone();
    }

    public synchronized void refresh_all_siginfo() {
        QLog.i("refresh_all_siginfo...");
        this._uin_map = account_sig_info_map.loadTKTreeMap(this._context, TLS_ACCOUNT_TABLE);
        if (this._uin_map == null) {
            this._uin_map = new TreeMap();
        }
    }

    public synchronized SigInfo get_siginfo(long uin, long appid) {
        QLog.i("get_siginfo", uin);
        AllSigInfo info = null;
        SigInfo ret = null;
        info = this.get_all_siginfo(uin);
        if (info == null) {
            return null;
        }
        ret = info._tk_map.get(appid);
        if (ret == null) {
            return null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear_sig(long uin, long appid) {
        QLog.i("clear_sig sdkAppid=" + appid, uin);
        Object info = null;
        this._uin_map.remove(uin);
        if (this._context != null) {
            Object object = db_lock;
            synchronized (object) {
                TreeMap<?, ?> t_uin_map = account_sig_info_map.loadTKTreeMap(this._context, TLS_TICKET_TABLE);
                if (t_uin_map == null) {
                    return;
                }
                t_uin_map.remove(uin);
                this.refreshTKTreeMap(t_uin_map, TLS_TICKET_TABLE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove_account(String name) {
        QLog.i("remove_account " + name);
        TinyInfo tinyInfo = this.getTinyInfo(name);
        if (tinyInfo == null) {
            return;
        }
        Set<String> keys = this._name_map.keySet();
        ArrayList<String> rmList = new ArrayList<String>();
        for (String key : keys) {
            TinyInfo tmp = this._name_map.get(key);
            if (tmp == null || tmp._tinyid != tinyInfo._tinyid) continue;
            rmList.add(key);
        }
        for (String key : rmList) {
            this._name_map.remove(key);
        }
        rmList.clear();
        if (this._context != null) {
            Object object = db_lock;
            synchronized (object) {
                TreeMap<Object, Object> t_name_map = account_sig_info_map.loadTKTreeMap(this._context, TLS_ACCOUNT_TABLE);
                if (t_name_map == null) {
                    t_name_map = new TreeMap();
                }
                keys = t_name_map.keySet();
                for (String key : keys) {
                    TinyInfo tmp = (TinyInfo)t_name_map.get(key);
                    if (tmp == null || tmp._tinyid != tinyInfo._tinyid) continue;
                    rmList.add(key);
                }
                for (String key : rmList) {
                    t_name_map.remove(key);
                }
                this.refreshTKTreeMap(t_name_map, TLS_ACCOUNT_TABLE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putTinyInfo(String name, String realIdentifier, long tinyId, TinyInfo.UserType userType) {
        QLog.i("putTinyInfo " + name + " userType " + (Object)((Object)userType) + " tinyid " + tinyId);
        TinyInfo tinyInfo = this.getTinyInfo(name);
        if (tinyInfo != null) {
            tinyInfo._tinyid = tinyId;
        } else {
            QLog.i("new tinyInfo");
            tinyInfo = new TinyInfo(req_global._acc_type, realIdentifier, tinyId, userType);
        }
        tinyInfo.userType = userType;
        if (userType == TinyInfo.UserType.USER_TYPE_GUEST) {
            // empty if block
        }
        tinyInfo._userid = realIdentifier;
        this._name_map.put(name, tinyInfo);
        if (!name.equals(realIdentifier)) {
            this._name_map.put(realIdentifier, tinyInfo);
        }
        if (this._context != null) {
            Object object = db_lock;
            synchronized (object) {
                TreeMap<Object, Object> t_name_map = account_sig_info_map.loadTKTreeMap(this._context, TLS_ACCOUNT_TABLE);
                if (t_name_map == null) {
                    t_name_map = new TreeMap();
                }
                t_name_map.put(name, tinyInfo);
                this.refreshTKTreeMap(t_name_map, TLS_ACCOUNT_TABLE);
            }
        }
    }

    public synchronized TinyInfo getTinyInfo(String name) {
        QLog.i("getTinyInfo " + util.getLineInfo(3) + util.getLineInfo(4));
        TinyInfo ti = this._name_map.get(name);
        if (ti != null) {
            return ti;
        }
        if (this._context == null) {
            return null;
        }
        TreeMap<?, ?> t_name_map = account_sig_info_map.loadTKTreeMap(this._context, TLS_ACCOUNT_TABLE);
        if (t_name_map == null) {
            return null;
        }
        ti = (TinyInfo)t_name_map.get(name);
        if (ti == null) {
            return null;
        }
        this._name_map.put(name, ti);
        return ti;
    }

    private synchronized TinyInfo getTinyInfo(long tinyid) {
        for (TinyInfo tmp : this._name_map.values()) {
            if (tmp._tinyid != tinyid) continue;
            return tmp;
        }
        if (this._context == null) {
            return null;
        }
        TreeMap<?, ?> t_name_map = account_sig_info_map.loadTKTreeMap(this._context, TLS_ACCOUNT_TABLE);
        if (t_name_map == null) {
            return null;
        }
        for (TinyInfo tmp : t_name_map.values()) {
            if (tmp._tinyid != tinyid) continue;
            this._name_map.put(tmp._userid, tmp);
            return tmp;
        }
        return null;
    }

    public synchronized List<TLSUserInfo> get_all_logined_account() {
        ArrayList<TLSUserInfo> ret = new ArrayList<TLSUserInfo>();
        if (this._context != null) {
            TreeMap<?, ?> t_uin_map = account_sig_info_map.loadTKTreeMap(this._context, TLS_TICKET_TABLE);
            if (t_uin_map == null) {
                return ret;
            }
            Iterator<?> iterator = t_uin_map.keySet().iterator();
            while (iterator.hasNext()) {
                long tinyId = (Long)iterator.next();
                AllSigInfo all_info = this._uin_map.get(tinyId);
                if (all_info == null) {
                    all_info = (AllSigInfo)t_uin_map.get(tinyId);
                    if (all_info == null) continue;
                    this._uin_map.put(tinyId, all_info);
                }
                TinyInfo tinyInfo = this.getTinyInfo(tinyId);
                String identifier = null;
                if (tinyInfo != null) {
                    identifier = tinyInfo._userid;
                }
                for (long appid : all_info._tk_map.keySet()) {
                    SigInfo info;
                    if (appid != req_global.sdkappid || (info = all_info._tk_map.get(appid)) == null) continue;
                    if (identifier == null) {
                        this.clear_sig(tinyId, appid);
                        continue;
                    }
                    long createTime = info._A1_create_time;
                    if (createTime <= 0L) {
                        createTime = info._TLS_create_time;
                    }
                    ret.add(new TLSUserInfo(tinyInfo._acc_type, identifier, tinyId, createTime, tinyInfo.userType));
                }
            }
        }
        return ret;
    }

    public synchronized int refreshTKTreeMap(TreeMap<?, ?> m, String fileName) {
        int ret = 0;
        if (TLS_TICKET_TABLE.equals(fileName) || TLS_ACCOUNT_TABLE.equals(fileName)) {
            ret = this.saveTKTreeMap(m, fileName);
        }
        return ret;
    }

    public synchronized int saveTKTreeMap(TreeMap<?, ?> tree, String fileName) {
        int ret = 0;
        ObjectOutputStream objectOut = null;
        try {
            ByteArrayOutputStream of = new ByteArrayOutputStream();
            objectOut = new ObjectOutputStream(of);
            objectOut.writeObject(tree);
            objectOut.flush();
            byte[] plain = of.toByteArray();
            byte[] cipher = cryptor.encrypt(plain, 0, plain.length, req_global._IMEI_KEY);
            ret = account_sig_info_map.write_to_db(this._context, fileName, cipher);
            objectOut.close();
            of.close();
        }
        catch (Throwable e) {
            QLog.e(e);
            ret = -1022;
        }
        return ret;
    }

    public static TreeMap<?, ?> loadTKTreeMap(Context context, String fileName) {
        ObjectInputStream objectIn = null;
        TreeMap tree = null;
        byte[] dbdata = account_sig_info_map.get_from_db(context, fileName);
        if (dbdata != null) {
            QLog.i("get_from_db len:" + dbdata.length);
            try {
                byte[] plain = cryptor.decrypt(dbdata, 0, dbdata.length, req_global._IMEI_KEY);
                if (plain != null) {
                    ByteArrayInputStream inf = new ByteArrayInputStream(plain);
                    objectIn = new ObjectInputStream(inf);
                    tree = (TreeMap)objectIn.readObject();
                    if (tree != null) {
                        objectIn.close();
                        return tree;
                    }
                    return null;
                }
            }
            catch (Throwable e) {
                QLog.e(e);
            }
        }
        return tree;
    }

    public static int write_to_db(Context context, String table_name, byte[] filedata) {
        Object[] args;
        String TKFILE_TABLE_NAME = table_name;
        String TKFILE_FIELD_NAME = table_name;
        String sql = "";
        SQLiteDatabase db = null;
        Cursor cur = null;
        try {
            if (tlsDBHelper == null) {
                tlsDBHelper = new TkDBHelper(context, tls_sdk_DBNAME, null, 1);
            }
            db = tlsDBHelper.getWritableDatabase();
        }
        catch (Exception e) {
            tlsDBHelper = null;
            QLog.e(e);
            return -1022;
        }
        try {
            sql = "CREATE TABLE IF NOT EXISTS " + TKFILE_TABLE_NAME + " (ID INTEGER PRIMARY KEY, " + TKFILE_FIELD_NAME + " BLOB);";
            db.execSQL(sql);
        }
        catch (Exception e) {
            tlsDBHelper = null;
            QLog.e(e);
            return -1022;
        }
        try {
            String[] cols = new String[]{"ID"};
            cur = db.query(TKFILE_TABLE_NAME, cols, "ID=0", null, null, null, null);
        }
        catch (SQLException e) {
            QLog.e(e);
            if (cur != null && !cur.isClosed()) {
                cur.close();
            }
            return -1022;
        }
        if (cur == null || !cur.moveToFirst()) {
            try {
                sql = "insert into " + TKFILE_TABLE_NAME + " (ID, " + TKFILE_FIELD_NAME + ") values (?,?);";
                args = new Object[]{0, new byte[1]};
                db.execSQL(sql, args);
            }
            catch (SQLException e) {
                QLog.e(e);
                if (cur != null && !cur.isClosed()) {
                    cur.close();
                }
                return -1022;
            }
        }
        try {
            sql = "update " + TKFILE_TABLE_NAME + " set " + TKFILE_FIELD_NAME + " =? where ID=0";
            args = new Object[]{filedata};
            db.execSQL(sql, args);
        }
        catch (SQLException e) {
            tlsDBHelper = null;
            QLog.e(e);
            if (cur != null && !cur.isClosed()) {
                cur.close();
            }
            return -1022;
        }
        if (cur != null && !cur.isClosed()) {
            cur.close();
        }
        return 0;
    }

    public static byte[] get_from_db(Context context, String table_name) {
        String TKFILE_TABLE_NAME = table_name;
        String TKFILE_FIELD_NAME = table_name;
        String sql = "";
        SQLiteDatabase db = null;
        Cursor cur = null;
        Boolean tableExist = false;
        try {
            if (tlsDBHelper == null) {
                tlsDBHelper = new TkDBHelper(context, tls_sdk_DBNAME, null, 1);
            }
            db = tlsDBHelper.getWritableDatabase();
        }
        catch (Exception e) {
            tlsDBHelper = null;
            QLog.e(e);
            return null;
        }
        try {
            int count;
            sql = "select count(*) from sqlite_master where type ='table' and name ='" + TKFILE_TABLE_NAME + "' ";
            cur = db.rawQuery(sql, null);
            if (cur.moveToNext() && (count = cur.getInt(0)) > 0) {
                tableExist = true;
            }
            if (cur != null && !cur.isClosed()) {
                cur.close();
            }
            if (!tableExist.booleanValue()) {
                return null;
            }
            String[] cols = new String[]{TKFILE_FIELD_NAME};
            cur = db.query(TKFILE_TABLE_NAME, cols, "ID=0", null, null, null, null);
        }
        catch (SQLException e) {
            tlsDBHelper = null;
            QLog.e(e);
            if (cur != null && !cur.isClosed()) {
                cur.close();
            }
            return null;
        }
        if (cur != null && cur.moveToFirst()) {
            byte[] ret = cur.getBlob(0);
            cur.close();
            return ret;
        }
        return null;
    }
}

