/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.request;

import android.os.Handler;
import android.os.Looper;
import tencent.tls.report.QLog;

public class WorkThread
extends Thread {
    private Worker worker;
    private When when;
    private Handler handler;
    private int ret;
    private static Thread loopThread;
    private static Looper selfLooper;

    public WorkThread(Looper looper, Worker worker, When when) {
        this.worker = worker;
        this.when = when;
        if (looper == null) {
            if (loopThread != null && loopThread.isAlive()) {
                this.handler = new Handler(selfLooper);
                return;
            }
            loopThread = new Thread(new Runnable(){

                public void run() {
                    Looper.prepare();
                    selfLooper = Looper.myLooper();
                    WorkThread.this.handler = new Handler();
                    Looper.loop();
                }
            });
            loopThread.setName("TLSLoopThread-" + loopThread.getId());
            loopThread.setDaemon(true);
            loopThread.start();
        } else {
            this.handler = new Handler(looper);
        }
    }

    public void run() {
        try {
            QLog.i("run at " + Thread.currentThread().getName());
            this.ret = this.worker.work();
            this.handler.post(new Runnable(){

                public void run() {
                    QLog.i("receive at " + Thread.currentThread().getName());
                    try {
                        WorkThread.this.when.done(WorkThread.this.ret);
                    }
                    catch (Exception e) {
                        QLog.e(e);
                    }
                }
            });
        }
        catch (Exception e) {
            QLog.e(e);
        }
    }

    public static interface When {
        public void done(int var1);
    }

    public static interface Worker {
        public int work();
    }
}

