/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.request;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;
import java.util.Map;
import tencent.tls.tools.util;

public class Ticket
implements Parcelable {
    public int Type;
    public int accountType;
    public String appidAt3rd;
    public byte[] Sig;
    public byte[] SigKey;
    public long CreateTime;
    public long ExpireTime;
    protected Map<String, byte[]> _pskey_map = new HashMap<String, byte[]>();
    public static final Parcelable.Creator<Ticket> CREATOR = new Parcelable.Creator<Ticket>(){

        public Ticket createFromParcel(Parcel source) {
            return new Ticket(source);
        }

        public Ticket[] newArray(int size) {
            return new Ticket[size];
        }
    };

    public Ticket() {
    }

    public Ticket(int type, byte[] sig, byte[] sig_key, long create_time, long expire_time) {
        this.Type = type;
        this.Sig = sig == null ? new byte[]{} : (byte[])sig.clone();
        this.SigKey = sig_key == null ? new byte[]{} : (byte[])sig_key.clone();
        this.CreateTime = create_time;
        this.ExpireTime = expire_time;
    }

    public Ticket(int type, int accountType, String appidAt3rd, byte[] sig, byte[] sig_key, long create_time, long expire_time) {
        this(type, sig, sig_key, create_time, expire_time);
        this.accountType = accountType;
        this.appidAt3rd = appidAt3rd;
    }

    protected Ticket(int type, byte[] sig, byte[] sig_key, long create_time, long expire_time, byte[] ps_buf) {
        this.Type = type;
        this.Sig = sig == null ? new byte[]{} : (byte[])sig.clone();
        this.SigKey = sig_key == null ? new byte[]{} : (byte[])sig_key.clone();
        this.CreateTime = create_time;
        this.ExpireTime = expire_time;
        this.parsePsBuf(ps_buf);
    }

    private void parsePsBuf(byte[] ps_buf) {
        if (ps_buf != null && ps_buf.length > 2) {
            int wDomainLen;
            int pos = 0;
            int wDomainCnt = util.buf_to_int16(ps_buf, pos);
            pos += 2;
            for (int i = 0; i < wDomainCnt && ps_buf.length >= pos + 2 && ps_buf.length >= (pos += 2) + (wDomainLen = util.buf_to_int16(ps_buf, pos)); ++i) {
                int wPsKeyLen;
                String strDomain = new String(ps_buf, pos, wDomainLen);
                if (ps_buf.length < (pos += wDomainLen) + 2 || ps_buf.length < (pos += 2) + (wPsKeyLen = util.buf_to_int16(ps_buf, pos))) break;
                byte[] ps_key = new byte[wPsKeyLen];
                System.arraycopy(ps_buf, pos, ps_key, 0, wPsKeyLen);
                pos += wPsKeyLen;
                this._pskey_map.put(strDomain, ps_key);
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.Type);
        dest.writeInt(this.accountType);
        dest.writeString(this.appidAt3rd);
        dest.writeByteArray(this.Sig);
        dest.writeByteArray(this.SigKey);
        dest.writeLong(this.CreateTime);
        dest.writeLong(this.ExpireTime);
        dest.writeMap(this._pskey_map);
    }

    public void readFromParcel(Parcel in) {
        this.Type = in.readInt();
        this.accountType = in.readInt();
        this.appidAt3rd = in.readString();
        this.Sig = in.createByteArray();
        this.SigKey = in.createByteArray();
        this.CreateTime = in.readLong();
        this.ExpireTime = in.readLong();
        this._pskey_map = in.readHashMap(Map.class.getClassLoader());
    }

    private Ticket(Parcel in) {
        this.readFromParcel(in);
    }
}

