/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.request;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.ArrayList;
import tencent.tls.report.QLog;
import tencent.tls.request.Ticket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigInfo
implements Serializable,
Parcelable {
    public byte[] _TGT = new byte[0];
    public byte[] _TGTKey = new byte[0];
    public byte[] _D2 = new byte[0];
    public byte[] _D2Key = new byte[0];
    public byte[] _TLS = new byte[0];
    public byte[] _en_A1 = new byte[0];
    public byte[] _noPicSig = new byte[0];
    public byte[] openid = new byte[0];
    public byte[] _access_token = new byte[0];
    public int accountType = 0;
    public String appidAt3rd;
    public long _app_pri = 0L;
    public int _login_bitmap = 0;
    public long _A1_create_time = 0L;
    public long _A2_create_time = 0L;
    public long _D2_create_time = 0L;
    public long _TLS_create_time = 0L;
    public long _A2_expire_time = 0L;
    public long _D2_expire_time = 0L;
    public long _TLS_expire_time = 0L;
    private static final long serialVersionUID = 1L;
    protected static final Parcelable.Creator<SigInfo> CREATOR = new Parcelable.Creator<SigInfo>(){

        public SigInfo createFromParcel(Parcel source) {
            return new SigInfo(source);
        }

        public SigInfo[] newArray(int size) {
            return new SigInfo[size];
        }
    };

    public SigInfo(long app_pri, long create_time, ArrayList<Ticket> tickets, int login_bitmap) {
        this.SetSigInfo(app_pri, create_time, tickets, login_bitmap);
    }

    public void SetSigInfo(long app_pri, long create_time, ArrayList<Ticket> tickets, int login_bitmap) {
        this._app_pri = app_pri;
        this._login_bitmap |= login_bitmap;
        for (Ticket ticket : tickets) {
            if (ticket.Sig == null || ticket.Sig.length == 0) continue;
            switch (ticket.Type) {
                case 64: {
                    this._A2_create_time = ticket.CreateTime;
                    this._A2_expire_time = ticket.ExpireTime;
                    this._TGT = ticket.Sig;
                    this._TGTKey = ticket.SigKey;
                    break;
                }
                case 262144: {
                    this._D2_create_time = ticket.CreateTime;
                    this._D2_expire_time = ticket.ExpireTime;
                    this._D2 = ticket.Sig;
                    this._D2Key = ticket.SigKey;
                    break;
                }
                case 0x10000000: {
                    this._TLS_create_time = ticket.CreateTime;
                    this._TLS_expire_time = ticket.ExpireTime;
                    this._TLS = ticket.Sig;
                    break;
                }
                case 305419896: {
                    this._access_token = ticket.Sig;
                    this.openid = ticket.SigKey;
                    this.accountType = ticket.accountType;
                    this.appidAt3rd = ticket.appidAt3rd;
                }
            }
        }
    }

    public SigInfo Set(long app_pri, long create_time, ArrayList<Ticket> tickets, int login_bitmap) {
        this.SetSigInfo(app_pri, create_time, tickets, login_bitmap);
        return this;
    }

    public SigInfo Set(byte[][] srcTickets, long create_time) {
        try {
            this._en_A1 = (byte[])srcTickets[0].clone();
            this._A1_create_time = create_time;
            this._noPicSig = (byte[])srcTickets[1].clone();
        }
        catch (Exception e) {
            QLog.e(e);
        }
        return this;
    }

    private SigInfo(Parcel in) {
        this.readFromParcel(in);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this._en_A1);
        dest.writeByteArray(this._noPicSig);
        dest.writeByteArray(this._TGT);
        dest.writeByteArray(this._TGTKey);
        dest.writeByteArray(this._D2);
        dest.writeByteArray(this._D2Key);
        dest.writeByteArray(this._TLS);
        dest.writeByteArray(this.openid);
        dest.writeByteArray(this._access_token);
        dest.writeInt(this.accountType);
        dest.writeString(this.appidAt3rd);
        dest.writeLong(this._A1_create_time);
        dest.writeLong(this._A2_create_time);
        dest.writeLong(this._D2_create_time);
        dest.writeLong(this._TLS_create_time);
        dest.writeLong(this._A2_expire_time);
        dest.writeLong(this._D2_expire_time);
        dest.writeLong(this._TLS_expire_time);
        dest.writeInt(this._login_bitmap);
        dest.writeLong(this._app_pri);
    }

    public void readFromParcel(Parcel in) {
        this._en_A1 = in.createByteArray();
        this._noPicSig = in.createByteArray();
        this._TGT = in.createByteArray();
        this._TGTKey = in.createByteArray();
        this._D2 = in.createByteArray();
        this._D2Key = in.createByteArray();
        this._TLS = in.createByteArray();
        this.openid = in.createByteArray();
        this._access_token = in.createByteArray();
        this.accountType = in.readInt();
        this.appidAt3rd = in.readString();
        this._A1_create_time = in.readLong();
        this._A2_create_time = in.readLong();
        this._D2_create_time = in.readLong();
        this._TLS_create_time = in.readLong();
        this._A2_expire_time = in.readLong();
        this._D2_expire_time = in.readLong();
        this._TLS_expire_time = in.readLong();
        this._login_bitmap = in.readInt();
        this._app_pri = in.readLong();
    }
}

