/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.request;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import tencent.tls.report.QLog;

public class SSORunner
implements Runnable {
    private String serviceCmd;
    private byte[] reqData;
    private int timeout;
    private int ret;
    private byte[] resData = null;
    private final Object __sync = new Object();

    public SSORunner(String serviceCmd, byte[] reqBuf, int timeout) {
        this.serviceCmd = serviceCmd == null ? "" : serviceCmd;
        this.reqData = reqBuf == null ? new byte[]{} : reqBuf;
        this.timeout = timeout > 0 ? timeout : 10000;
    }

    public int getRet() {
        return this.ret;
    }

    public byte[] getResData() {
        return this.resData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.ret = 0;
        try {
            Class<?> QALSDKManager = Class.forName("com.tencent.qalsdk.QALSDKManager");
            Method getInstance = QALSDKManager.getMethod("getInstance", new Class[0]);
            Object manager = getInstance.invoke(null, new Object[0]);
            Class<?> QALValueCallBack = Class.forName("com.tencent.qalsdk.QALValueCallBack");
            Object intf = Proxy.newProxyInstance(QALValueCallBack.getClassLoader(), new Class[]{QALValueCallBack}, (InvocationHandler)new ProxyListener());
            Method sendMsg = QALSDKManager.getMethod("sendMsg", String.class, String.class, byte[].class, Long.TYPE, QALValueCallBack);
            QLog.i("SSORunner serviceCmd=" + this.serviceCmd + " reqData.length=" + this.reqData.length + " timeout=" + this.timeout);
            String identifier = "0";
            sendMsg.invoke(manager, identifier, this.serviceCmd, this.reqData, this.timeout, intf);
            Object object = this.__sync;
            synchronized (object) {
                this.__sync.wait(this.timeout + 500);
            }
        }
        catch (Exception e1) {
            try {
                Class<?> TIMIntManager = Class.forName("com.tencent.timint.TIMIntManager");
                Method getInstance = TIMIntManager.getMethod("getInstance", new Class[0]);
                Object tim = getInstance.invoke(null, new Object[0]);
                Class<?> TIMValueCallBack = Class.forName("com.tencent.TIMValueCallBack");
                Object intf = Proxy.newProxyInstance(TIMValueCallBack.getClassLoader(), new Class[]{TIMValueCallBack}, (InvocationHandler)new ProxyListener());
                Method request = TIMIntManager.getMethod("request", String.class, byte[].class, TIMValueCallBack, Long.TYPE);
                request.invoke(tim, this.serviceCmd, this.reqData, intf, this.timeout);
                Object object = this.__sync;
                synchronized (object) {
                    this.__sync.wait(this.timeout + 500);
                }
            }
            catch (Exception e2) {
                QLog.e(e2);
                this.ret = -1000;
            }
        }
    }

    static /* synthetic */ byte[] access$002(SSORunner x0, byte[] x1) {
        x0.resData = x1;
        return x1;
    }

    class ProxyListener
    implements InvocationHandler {
        ProxyListener() {
        }

        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            String method = m.getName();
            QLog.i("proxy " + method);
            if (method.equals("onSuccess")) {
                this.onSuccess((byte[])args[0]);
            } else if (method.equals("onError")) {
                this.onError((Integer)args[0], (String)args[1]);
            } else {
                if ("equals".equals(method)) {
                    return proxy == args[0];
                }
                if ("hashCode".equals(method)) {
                    return System.identityHashCode(proxy);
                }
                if ("toString".equals(method)) {
                    return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy)) + ", with InvocationHandler " + this;
                }
            }
            return proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onSuccess(byte[] data) {
            SSORunner.access$002(SSORunner.this, data);
            Object object = SSORunner.this.__sync;
            synchronized (object) {
                SSORunner.this.__sync.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onError(int errno, String errmsg) {
            QLog.i("sso err " + errno + " errmsg " + errmsg);
            SSORunner.access$002(SSORunner.this, null);
            SSORunner.this.ret = errno;
            Object object = SSORunner.this.__sync;
            synchronized (object) {
                SSORunner.this.__sync.notify();
            }
        }
    }
}

