/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.platform;

import android.content.Context;
import android.os.Build;
import android.os.Looper;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.KeyAgreement;
import tencent.tls.account.TLSOpenAccountInfo;
import tencent.tls.account.acc_ask_code;
import tencent.tls.account.acc_commit;
import tencent.tls.account.acc_guest;
import tencent.tls.account.acc_reask_code;
import tencent.tls.account.acc_request;
import tencent.tls.account.acc_status;
import tencent.tls.account.acc_verify_code;
import tencent.tls.oidb.Oidb0x483_request;
import tencent.tls.oidb.Oidb0x483_response;
import tencent.tls.oidb.Oidb0x601_request;
import tencent.tls.oidb.Oidb0x601_response;
import tencent.tls.oidb.Oidb0x602_request;
import tencent.tls.oidb.Oidb0x602_response;
import tencent.tls.oidb.Oidb0xa0b_request;
import tencent.tls.oidb.Oidb0xa0b_response;
import tencent.tls.platform.TLSAccessTokenInfo;
import tencent.tls.platform.TLSErrInfo;
import tencent.tls.platform.TLSExchangeTicketListener;
import tencent.tls.platform.TLSGuestLoginListener;
import tencent.tls.platform.TLSGuestRegListener;
import tencent.tls.platform.TLSOpenAccessTokenListener;
import tencent.tls.platform.TLSOpenAccountBindListener;
import tencent.tls.platform.TLSOpenAccountQueryListener;
import tencent.tls.platform.TLSPwdLoginListener;
import tencent.tls.platform.TLSPwdRegListener;
import tencent.tls.platform.TLSPwdResetListener;
import tencent.tls.platform.TLSRefreshUserSigListener;
import tencent.tls.platform.TLSSSOGuestLoginListener;
import tencent.tls.platform.TLSSSORegListener;
import tencent.tls.platform.TLSSmsLoginListener;
import tencent.tls.platform.TLSSmsRegListener;
import tencent.tls.platform.TLSStrAccRegListener;
import tencent.tls.platform.TLSUserInfo;
import tencent.tls.report.QLog;
import tencent.tls.request.SigInfo;
import tencent.tls.request.Ticket;
import tencent.tls.request.TinyInfo;
import tencent.tls.request.TransReqContext;
import tencent.tls.request.WorkThread;
import tencent.tls.request.async_context;
import tencent.tls.request.oicq_request;
import tencent.tls.request.req_TGTGT;
import tencent.tls.request.req_getsalt;
import tencent.tls.request.req_global;
import tencent.tls.request.req_imgcode_reask;
import tencent.tls.request.req_imgcode_verify;
import tencent.tls.request.req_smslogin_ask;
import tencent.tls.request.req_smslogin_reask;
import tencent.tls.request.req_smslogin_verify;
import tencent.tls.request.req_tgtgt_nopicsig;
import tencent.tls.request.req_transport;
import tencent.tls.tlvs.tlv_t;
import tencent.tls.tools.EcdhCrypt;
import tencent.tls.tools.I18nMsg;
import tencent.tls.tools.MD5;
import tencent.tls.tools.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLSHelper {
    private req_global mG = new req_global(null);
    private Context mContext;
    private long mSdkAppid;
    private long mSubAppid = 1L;
    private int mAccType = 0;
    private int mCountry = 86;
    private String mAppVer = "";
    private acc_status mRegStatus = new acc_status();
    private int DummyGetSig = -1;
    private int mMainSigMap = 262208;
    private int mSubSigMap = 66560;
    private int mMiscBitmap = 16252;
    private long mAsyncSeq = 0L;
    private static String guest = null;
    private static String ssoGuest = null;
    private TLSOpenAccountInfo openAccountInfo;
    private static TLSHelper __helper = null;

    private TLSHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TLSHelper getInstance() {
        Class<TLSHelper> clazz = TLSHelper.class;
        synchronized (TLSHelper.class) {
            if (__helper == null) {
                __helper = new TLSHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return __helper;
        }
    }

    public TLSHelper init(Context context, long sdkAppid) {
        QLog.initQAL();
        this.mContext = context;
        this.mSdkAppid = sdkAppid;
        this.mAccType = 0;
        this.mAppVer = "";
        req_global._acc_type = 0;
        req_global.sdkappid = sdkAppid;
        acc_status.apk_id = util.get_apk_id(this.mContext);
        acc_status.apk_sig = util.getPkgSigFromApkName(this.mContext, this.mContext.getPackageName());
        this.mG.set_context(this.mContext);
        this.shareKeyInit();
        this.requestInit();
        return this;
    }

    private int ShareKeyInitDefault() {
        this.mG._pub_key = util.string_to_buf("020b03cf3d99541f29ffec281bebbd4ea211292ac1f53d7128");
        this.mG._share_key = util.string_to_buf("4da0f614fc9f29c2054c77048a6566d7");
        QLog.w("android sdk " + req_global._android_sdk + " using DEFAULT key");
        return 0;
    }

    private int ShareKeyInitOpenSSL() {
        if (Build.VERSION.SDK_INT >= 23) {
            return -1;
        }
        EcdhCrypt crypt = new EcdhCrypt(this.mContext);
        if (0 != crypt.GenereateKey()) {
            return -1;
        }
        byte[] temp_pub = crypt.get_c_pub_key();
        byte[] temp_share = crypt.get_g_share_key();
        if (temp_pub == null || temp_pub.length <= 0 || temp_share == null || temp_share.length <= 0) {
            QLog.w("get client public key or shared key FAILED");
            return -2;
        }
        this.mG._pub_key = (byte[])temp_pub.clone();
        this.mG._share_key = (byte[])temp_share.clone();
        QLog.i("create key pair and shared key with OpenSSL OK");
        return 0;
    }

    private int ShareKeyInitBC() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", "BC");
            ECGenParameterSpec ecsp = new ECGenParameterSpec("secp192k1");
            keyGen.initialize(ecsp);
            KeyPair keyPair = keyGen.genKeyPair();
            PrivateKey clientPrivateKey = keyPair.getPrivate();
            byte[] clientPublicKeyBytes = keyPair.getPublic().getEncoded();
            KeyFactory senderKeyFactory = KeyFactory.getInstance("EC", "BC");
            byte[] serverPublicKeyBytes = util.string_to_buf("3046301006072A8648CE3D020106052B8104001F03320004928D8850673088B343264E0C6BACB8496D697799F37211DEB25BB73906CB089FEA9639B4E0260498B51A992D50813DA8");
            X509EncodedKeySpec x509ks = new X509EncodedKeySpec(serverPublicKeyBytes);
            PublicKey serverPublicKey = senderKeyFactory.generatePublic(x509ks);
            KeyAgreement senderKeyAgreement = KeyAgreement.getInstance("ECDH", "BC");
            senderKeyAgreement.init(clientPrivateKey);
            senderKeyAgreement.doPhase(serverPublicKey, true);
            byte[] sharedKey = senderKeyAgreement.generateSecret();
            byte[] rawClientPublicKeyBytes = new byte[49];
            System.arraycopy(clientPublicKeyBytes, 23, rawClientPublicKeyBytes, 0, 49);
            byte[] sharedKeyMd5 = MD5.toMD5Byte(sharedKey);
            this.mG._pub_key = rawClientPublicKeyBytes;
            this.mG._share_key = sharedKeyMd5;
        }
        catch (InvalidAlgorithmParameterException e) {
            QLog.w("create key pair and shared key failed, " + e.getMessage());
            return -1;
        }
        catch (NoSuchAlgorithmException e) {
            QLog.w("create key pair and shared key failed, " + e.getMessage());
            return -2;
        }
        catch (NoSuchProviderException e) {
            QLog.w("create key pair and shared key failed, " + e.getMessage());
            return -3;
        }
        catch (InvalidKeySpecException e) {
            QLog.w("create key pair and shared key failed, " + e.getMessage());
            return -4;
        }
        catch (InvalidKeyException e) {
            QLog.w("create key pair and shared key failed, " + e.getMessage());
            return -5;
        }
        QLog.i("create key pair and shared key with bouncycastle OK");
        return 0;
    }

    private int shareKeyInit() {
        QLog.i("Generate Shared Key Begin ...");
        if (0 == this.ShareKeyInitOpenSSL()) {
            return 0;
        }
        if (0 == this.ShareKeyInitBC()) {
            return 0;
        }
        return this.ShareKeyInitDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int requestInit() {
        int ret = 0;
        TLSHelper tLSHelper = this;
        synchronized (tLSHelper) {
            int saved_network_type = util.get_saved_network_type(this.mContext);
            String android_ver = Build.VERSION.RELEASE;
            if (android_ver == null) {
                android_ver = "";
            }
            req_global.init();
            QLog.i("android version:" + android_ver + " saved_network_type:" + saved_network_type + " network_type:" + req_global._network_type + " release time:" + util.get_release_time() + " svn ver:" + 1532L);
        }
        return ret;
    }

    public void setTestHost(String host, boolean useSSO) {
        oicq_request.set_test(1, host);
        this.mG._use_sso_channel = useSSO;
    }

    public void setLocalId(int localid) {
        acc_status.lang = localid;
        req_global._local_id = localid;
    }

    public void setTimeOut(int timeout) {
        this.mG._time_out = timeout;
    }

    public static void setLogcat(boolean show) {
        util.LOGCAT_OUT = show;
    }

    public String getSDKVersion() {
        return "1.1.1794";
    }

    public void setCountry(int country) {
        this.mCountry = country;
    }

    public List<TLSUserInfo> getAllUserInfo() {
        return this.mG.get_all_logined_account();
    }

    public TLSUserInfo getLastUserInfo() {
        List<TLSUserInfo> loginList = this.mG.get_all_logined_account();
        if (loginList == null) {
            return null;
        }
        TLSUserInfo info = null;
        for (TLSUserInfo userInfo : loginList) {
            if (info != null && userInfo.createTime <= info.createTime) continue;
            info = userInfo;
        }
        return info;
    }

    public boolean needSmsVerify(String identifier) {
        return acc_status.mpasswd.length() == 0;
    }

    public boolean needLogin(String identifier) {
        SigInfo info;
        if (identifier == null) {
            return true;
        }
        long uin = this.mG.getTinyId(identifier);
        if (uin == 0L) {
            info = null;
        } else {
            info = this.mG.get_siginfo(uin, this.mSdkAppid);
            if (info == null) {
                // empty if block
            }
        }
        if (info == null || info._en_A1 == null || info._en_A1.length <= 0) {
            QLog.i("userAccount:" + identifier + " dwAppid:" + this.mSdkAppid + " IsUserHaveA1 false");
            return true;
        }
        QLog.i("userAccount:" + identifier + " dwAppid:" + this.mSdkAppid + " IsUserHaveA1 true");
        return false;
    }

    public Map<String, Object> getSSOTicket(String identifier) {
        HashMap<String, Object> tickets = new HashMap<String, Object>();
        TLSUserInfo userInfo = this.GetLocalSig(identifier, this.mSdkAppid);
        Ticket a2 = TLSHelper.getUserTicket(userInfo, 64);
        if (a2 == null) {
            tickets.put("A2", new byte[0]);
            tickets.put("A2Key", new byte[0]);
        } else {
            tickets.put("A2", a2.Sig);
            tickets.put("A2Key", a2.SigKey);
        }
        Ticket d2 = TLSHelper.getUserTicket(userInfo, 262144);
        if (d2 == null) {
            tickets.put("D2", new byte[0]);
            tickets.put("D2Key", new byte[0]);
        } else {
            tickets.put("D2", d2.Sig);
            tickets.put("D2Key", d2.SigKey);
        }
        long tinyid = 0L;
        if (userInfo != null) {
            tinyid = userInfo.tinyid;
            identifier = userInfo.identifier;
        }
        tickets.put("tinyID", tinyid);
        tickets.put("identifier", identifier);
        return tickets;
    }

    public String getUserSig(String identifier) {
        Ticket ticket = this.getLocalTicket(identifier, 0x10000000);
        String userSig = "";
        if (ticket != null && ticket.Sig != null && ticket.Sig.length > 0) {
            userSig = new String(ticket.Sig);
            QLog.i("ticket not null " + userSig.length());
        }
        return userSig;
    }

    public String getGuestIdentifier() {
        if (guest != null) {
            return guest;
        }
        List<TLSUserInfo> loginList = this.mG.get_all_logined_account();
        if (loginList == null) {
            return null;
        }
        for (TLSUserInfo userInfo : loginList) {
            if (userInfo.userType != TinyInfo.UserType.USER_TYPE_GUEST) continue;
            guest = userInfo.identifier;
            return guest;
        }
        return null;
    }

    public String getSSOGuestIdentifier() {
        if (ssoGuest != null) {
            return ssoGuest;
        }
        List<TLSUserInfo> loginList = this.mG.get_all_logined_account();
        if (loginList == null) {
            return null;
        }
        for (TLSUserInfo userInfo : loginList) {
            if (userInfo.userType != TinyInfo.UserType.USER_TYPE_SSO_GUEST) continue;
            ssoGuest = userInfo.identifier;
            return ssoGuest;
        }
        return null;
    }

    public int TLSPwdResetAskCode(String mobile, TLSPwdResetListener listener) {
        QLog.i("TLSPwdResetAskCode ..." + mobile);
        return this.askCode(mobile, 64, false, listener);
    }

    public int TLSPwdRegAskCode(String mobile, TLSPwdRegListener listener) {
        QLog.i("TLSPwdRegAskCode ..." + mobile);
        return this.askCode(mobile, 49, false, listener);
    }

    public int TLSSmsRegAskCode(String mobile, TLSSmsRegListener listener) {
        QLog.i("TLSSmsRegAskCode ..." + mobile);
        return this.askCode(mobile, 33, false, listener);
    }

    private int askCode(String mobile, int cmd, boolean withOA, Object listener) {
        if (mobile == null || mobile.length() == 0) {
            return -1017;
        }
        if (withOA && (this.openAccountInfo.checkInvalid() || this.openAccountInfo.status == TLSOpenAccountInfo.OpenAccountStatus.UNKNOWN || this.openAccountInfo.status == TLSOpenAccountInfo.OpenAccountStatus.USED_BINDED)) {
            QLog.i("openAccountInfo invalid or status == UNKNOW or status == LOGINED_BINDED");
            return -1017;
        }
        this.mRegStatus.userID = mobile;
        acc_ask_code rreq = new acc_ask_code(cmd);
        TransReqContext req_con = new TransReqContext(listener);
        this.mRegStatus.sdkAppid = this.mSdkAppid;
        req_con.set_register_req();
        req_con.set_subcmd(rreq.get_cmd());
        req_con._body = withOA ? rreq.get_request(this.mAccType, mobile, req_global._apk_id, this.mAppVer, this.mCountry, this.mSdkAppid, req_global._IMEI, this.openAccountInfo) : rreq.get_request(this.mAccType, mobile, req_global._apk_id, this.mAppVer, this.mCountry, this.mSdkAppid, req_global._IMEI);
        return this.RequestTransport(null, 0, mobile, null, this.mRegStatus.role, req_con);
    }

    public int TLSPwdResetReaskCode(TLSPwdResetListener listener) {
        QLog.i("TLSPwdResetReaskCode ...");
        return this.reaskCode(65, listener);
    }

    public int TLSPwdRegReaskCode(TLSPwdRegListener listener) {
        QLog.i("TLSPwdRegReaskCode ...");
        return this.reaskCode(52, listener);
    }

    public int TLSSmsRegReaskCode(TLSSmsRegListener listener) {
        QLog.i("TLSSmsRegReaskCode ...");
        return this.reaskCode(36, listener);
    }

    private int reaskCode(int cmd, Object listener) {
        acc_reask_code rreq = new acc_reask_code(cmd);
        TransReqContext req_con = new TransReqContext(listener);
        req_con.set_register_req();
        req_con.set_subcmd(rreq.get_cmd());
        req_con._body = rreq.get_request(this.mRegStatus.token);
        return this.RequestTransport(null, 0, this.mRegStatus.userID, null, this.mRegStatus.role, req_con);
    }

    public int TLSPwdResetVerifyCode(String code, TLSPwdResetListener listener) {
        QLog.i("TLSPwdResetVerifyCode ...");
        return this.verifyCode(code, 66, listener);
    }

    public int TLSPwdRegVerifyCode(String code, TLSPwdRegListener listener) {
        QLog.i("TLSPwdRegVerifyCode ...");
        return this.verifyCode(code, 53, listener);
    }

    public int TLSSmsRegVerifyCode(String code, TLSSmsRegListener listener) {
        QLog.i("TLSSmsRegVerifyCode ...");
        return this.verifyCode(code, 37, listener);
    }

    private int verifyCode(String code, int cmd, Object listener) {
        if (code == null || code.length() == 0) {
            return -1017;
        }
        acc_verify_code rreq = new acc_verify_code(cmd);
        TransReqContext req_con = new TransReqContext(listener);
        this.mRegStatus.msgcode = code.getBytes();
        req_con.set_register_req();
        req_con.set_subcmd(rreq.get_cmd());
        req_con._body = rreq.get_request(this.mRegStatus.token, code.getBytes());
        return this.RequestTransport(null, 0, this.mRegStatus.userID, null, this.mRegStatus.role, req_con);
    }

    public int TLSPwdResetCommit(String password, TLSPwdResetListener listener) {
        QLog.i("TLSPwdResetCommit ...");
        return this.commit(password, 67, listener);
    }

    public int TLSPwdRegCommit(String password, TLSPwdRegListener listener) {
        QLog.i("TLSPwdRegCommit ...");
        return this.commit(password, 54, listener);
    }

    public int TLSSmsRegCommit(TLSSmsRegListener listener) {
        QLog.i("TLSSmsRegCommit No Password...");
        acc_status.mpasswd = util.get_mpasswd();
        return this.commit(acc_status.mpasswd, 38, listener);
    }

    private int commit(String password, int cmd, Object listener) {
        acc_commit rreq = new acc_commit(cmd);
        TransReqContext req_con = new TransReqContext(listener);
        req_con.set_register_req();
        req_con.set_subcmd(rreq.get_cmd());
        req_con._body = rreq.get_request(this.mRegStatus.token, password, this.mRegStatus.msgcode);
        return this.RequestTransport(null, 0, this.mRegStatus.userID, null, this.mRegStatus.role, req_con);
    }

    public int TLSStrAccReg(String account, String password, TLSStrAccRegListener listener) {
        if (account.length() == 0 || account.getBytes().length > 24) {
            return -1017;
        }
        if (password.length() == 0 || password.getBytes().length > 16 || password.getBytes().length < 8) {
            return -1017;
        }
        boolean allNumber = true;
        for (int i = 0; i < account.length(); ++i) {
            char c = account.charAt(i);
            if (c != '.' && c != '_' && !Character.isLetterOrDigit(c)) {
                return -1017;
            }
            if (Character.isDigit(c)) continue;
            allNumber = false;
        }
        if (allNumber) {
            return -1017;
        }
        acc_ask_code acc_query = new acc_ask_code(97);
        TransReqContext req_con = new TransReqContext(listener);
        this.mRegStatus.userID = account;
        this.mRegStatus.password = password;
        req_con.set_register_req();
        req_con.set_subcmd(acc_query.get_cmd());
        req_con._body = acc_query.get_request(this.mAccType, account, req_global._apk_id, this.mAppVer, this.mCountry, this.mSdkAppid, req_global._IMEI);
        return this.RequestTransport(null, 0, account, null, this.mRegStatus.role, req_con);
    }

    private int TLSStrAccRegCommit(TLSStrAccRegListener listener) {
        acc_commit rreq = new acc_commit(102);
        TransReqContext req_con = new TransReqContext(listener);
        req_con.set_register_req();
        req_con.set_subcmd(rreq.get_cmd());
        req_con._body = rreq.get_request(this.mRegStatus.token, this.mRegStatus.password, null);
        return this.RequestTransport(null, 0, this.mRegStatus.userID, null, this.mRegStatus.role, req_con);
    }

    private int TLSGuestReg(TLSGuestRegListener listener) {
        acc_guest rreq = new acc_guest();
        TransReqContext req_con = new TransReqContext(listener);
        req_con.set_register_req();
        req_con.set_subcmd(rreq.get_cmd());
        req_con._body = rreq.get_request(this.mAccType, req_global._apk_id, this.mAppVer, this.mCountry, this.mSdkAppid, req_global._IMEI);
        return this.RequestTransport(null, 0, null, null, this.mRegStatus.role, req_con);
    }

    private int TLSSSOGuestReg(TLSSSORegListener listener) {
        acc_guest rreq = new acc_guest();
        TransReqContext req_con = new TransReqContext(listener);
        req_con.set_register_req();
        req_con.set_subcmd(rreq.get_cmd());
        req_con._body = rreq.get_request(this.mAccType, req_global._apk_id, this.mAppVer, this.mCountry, this.mSdkAppid, req_global._IMEI);
        return this.RequestTransport(null, 0, null, null, this.mRegStatus.role, req_con);
    }

    public int TLSRefreshUserSig(String identifier, final TLSRefreshUserSigListener listener) {
        TLSOpenAccountInfo localOpenAccountInfo = this.GetLocalOpenAccountInfo(identifier, this.mSdkAppid);
        if (localOpenAccountInfo == null || !localOpenAccountInfo.openid.equals(identifier)) {
            QLog.i("Account RefreshUserSig");
            return this.GetStWithoutPasswd(identifier, this.mSdkAppid, listener);
        }
        QLog.i("OpenAccount RefreshUserSig");
        final TLSOpenAccountInfo savedOpenAccountInfo = this.openAccountInfo;
        this.openAccountInfo = localOpenAccountInfo;
        this.TLSOpenAccountLogin(new TLSExchangeTicketListener(){

            public void OnExchangeTicketSuccess(TLSUserInfo userInfo) {
                listener.OnRefreshUserSigSuccess(userInfo);
                TLSHelper.this.openAccountInfo = savedOpenAccountInfo;
            }

            public void OnExchangeTicketFail(TLSErrInfo errInfo) {
                listener.OnRefreshUserSigFail(errInfo);
                TLSHelper.this.openAccountInfo = savedOpenAccountInfo;
            }

            public void OnExchangeTicketTimeout(TLSErrInfo errInfo) {
                listener.OnRefreshUserSigTimeout(errInfo);
                TLSHelper.this.openAccountInfo = savedOpenAccountInfo;
            }
        });
        return -1001;
    }

    private int GetStWithoutPasswd(final String userAccount, final long dstAppid, final Object listener) {
        if (userAccount == null) {
            return -1017;
        }
        final TLSUserInfo userInfo = new TLSUserInfo();
        final req_global thisG = this.mG.getClone(0L);
        new WorkThread(Looper.myLooper(), new WorkThread.Worker(){

            public int work() {
                int ret = 0;
                async_context thisContext = req_global.get_async_data(thisG._seq);
                QLog.i("wtlogin login with GetStWithoutPasswd:user:" + userAccount + " dwSrcAppid:" + TLSHelper.this.mSdkAppid + " dwDstAppid:" + dstAppid + " dwMainSigMap:" + TLSHelper.this.mMainSigMap + " dwSubDstAppid:" + TLSHelper.this.mSubAppid + " Seq:" + thisG._seq + " ...");
                int saved_network_type = util.get_saved_network_type(TLSHelper.this.mContext);
                req_global._network_type = util.get_network_type(TLSHelper.this.mContext);
                if (saved_network_type != req_global._network_type) {
                    util.set_net_retry_type(TLSHelper.this.mContext, 0);
                    util.save_network_type(TLSHelper.this.mContext, req_global._network_type);
                }
                req_global._apn = util.get_apn_string(TLSHelper.this.mContext).getBytes();
                userInfo.identifier = userAccount;
                thisContext._userid = thisG._userid = userAccount;
                thisG._uin = 0L;
                thisContext._tinyid = 0L;
                thisContext._src_appid = TLSHelper.this.mSdkAppid;
                thisContext._appid = dstAppid;
                thisContext._sub_appid = TLSHelper.this.mSubAppid;
                thisContext._main_sigmap = TLSHelper.this.mMainSigMap;
                thisContext._last_err_msg = new TLSErrInfo();
                long uin = thisG.getTinyId(userAccount);
                if (uin == 0L) {
                    QLog.i("user:" + userAccount + " have not found uin record.");
                    ret = -1003;
                } else {
                    thisG._uin = uin;
                    byte[] tmp_pwd = TLSHelper.this.GetA1ByAccount(userAccount, TLSHelper.this.mSdkAppid);
                    byte[] no_pic_sig = TLSHelper.this.GetNoPicSigByAccount(userAccount, TLSHelper.this.mSdkAppid);
                    if (tmp_pwd != null && tmp_pwd.length > 0 && no_pic_sig != null && no_pic_sig.length > 0) {
                        QLog.i("user:" + userAccount + " exchange A2 from A1.", thisG._uin);
                        thisContext._tmp_pwd = tmp_pwd;
                        thisContext._tmp_no_pic_sig = no_pic_sig;
                        ret = new req_tgtgt_nopicsig(thisG).make_request(dstAppid, 1, thisG._uin, 0, req_global._ip_addr, tmp_pwd, no_pic_sig, TLSHelper.this.mMiscBitmap, TLSHelper.this.mSubSigMap, null, TLSHelper.this.mMainSigMap, TLSHelper.this.mSubAppid, 1, req_global._pic_type, 0, 0, 1, TLSHelper.this.mSdkAppid, userInfo);
                    } else {
                        ret = -1004;
                    }
                    if (ret == 0) {
                        SigInfo info = thisG.get_siginfo(uin, dstAppid);
                        if (info == null) {
                            ret = -1004;
                        } else {
                            userInfo.get_clone(info);
                        }
                    }
                }
                thisG.close_connect();
                QLog.i("wtlogin login with GetStWithoutPasswd:user:" + userAccount + " dwSrcAppid:" + TLSHelper.this.mSdkAppid + " dwDstAppid:" + dstAppid + " dwMainSigMap:0x" + Integer.toHexString(TLSHelper.this.mMainSigMap) + " dwSubDstAppid:" + TLSHelper.this.mSubAppid + " Seq:" + thisG._seq + " ret=" + ret, thisG._uin);
                return ret;
            }
        }, new WorkThread.When(){

            public void done(int ret) {
                async_context thisContext = req_global.get_async_data(thisG._seq);
                TLSErrInfo errInfo = thisContext._last_err_msg;
                req_global.remove_async_data(thisG._seq);
                TLSRefreshUserSigListener tmp = (TLSRefreshUserSigListener)listener;
                if (ret == 0) {
                    tmp.OnRefreshUserSigSuccess(userInfo);
                } else if (ret == -1000) {
                    tmp.OnRefreshUserSigTimeout(errInfo);
                } else {
                    errInfo.ErrCode = ret;
                    tmp.OnRefreshUserSigFail(errInfo);
                }
            }
        }).start();
        return -1001;
    }

    private int GetStWithPasswd(final String userAccount, final byte[] userPasswd, final boolean smslogin, final Object listener) {
        if (userAccount == null) {
            return -1017;
        }
        final req_global thisG = this.mG.getClone(this.mAsyncSeq);
        final TLSUserInfo userInfo = new TLSUserInfo();
        new WorkThread(Looper.myLooper(), new WorkThread.Worker(){

            public int work() {
                int ret;
                int saved_network_type;
                byte[] password = userPasswd;
                async_context thisContext = req_global.get_async_data(thisG._seq);
                QLog.i("wtlogin login with GetStWithPasswd:user:" + userAccount + " accType: " + TLSHelper.this.mAccType + " dwAppid:" + TLSHelper.this.mSdkAppid + " dwMainSigMap:0x" + Integer.toHexString(TLSHelper.this.mMainSigMap) + " dwSubAppid:" + TLSHelper.this.mSubAppid + " Seq:" + thisG._seq + " ...");
                if (password == null || password.length == 0) {
                    password = thisContext._mpasswd.getBytes();
                }
                acc_status.mpasswd = "";
                if (acc_status.msalt != 0L) {
                    thisContext._msalt = acc_status.msalt;
                    acc_status.msalt = 0L;
                }
                if (password.length > 16) {
                    System.arraycopy(password, 0, password, 0, 16);
                }
                if ((saved_network_type = util.get_saved_network_type(TLSHelper.this.mContext)) != (req_global._network_type = util.get_network_type(TLSHelper.this.mContext))) {
                    util.set_net_retry_type(TLSHelper.this.mContext, 0);
                    util.save_network_type(TLSHelper.this.mContext, req_global._network_type);
                }
                req_global._apn = util.get_apn_string(TLSHelper.this.mContext).getBytes();
                userInfo.identifier = userAccount;
                thisContext._userid = thisG._userid = userAccount;
                thisG._uin = 0L;
                thisContext._tinyid = 0L;
                thisContext._src_appid = TLSHelper.this.mSdkAppid;
                thisContext._appid = TLSHelper.this.mSdkAppid;
                thisContext._sub_appid = TLSHelper.this.mSubAppid;
                thisContext._main_sigmap = TLSHelper.this.mMainSigMap;
                thisContext._last_err_msg = new TLSErrInfo();
                if (password.length > 0) {
                    thisContext._tmp_pwd = MD5.toMD5Byte(password);
                    thisContext._tmp_pwd_type = 0;
                }
                if (userAccount.length() > util.MAX_NAME_LEN) {
                    ret = -1008;
                } else if (thisContext._msalt != 0L || (ret = new req_getsalt(thisG).make_request(TLSHelper.this.mSdkAppid, TLSHelper.this.mSubAppid, TLSHelper.this.mMainSigMap, userAccount, req_global._pic_type, 0, 0, 1, userInfo)) == 0) {
                    QLog.i("get salt: " + (thisContext._msalt != 0L));
                    if (thisContext._tmp_pwd_type != 0) {
                        QLog.i("user:" + userAccount + " login with saved A1.", thisG._uin);
                        ret = new req_TGTGT(thisG).make_request(TLSHelper.this.mSdkAppid, TLSHelper.this.mSubAppid, 1, thisG._uin, 0, req_global._ip_addr, thisContext._tmp_pwd, thisContext._tmp_no_pic_sig, TLSHelper.this.mMiscBitmap, TLSHelper.this.mSubSigMap, null, TLSHelper.this.mMainSigMap, TLSHelper.this.mSubAppid, 1, req_global._pic_type, 0, 0, 1, userInfo);
                    } else {
                        QLog.i("user:" + userAccount + " login with input password.", thisG._uin);
                        byte[] init_time = new byte[4];
                        long current = System.currentTimeMillis() / 1000L + req_global._l_init_time;
                        util.int64_to_buf32(init_time, 0, acc_status.regtime == 0L ? current : acc_status.regtime);
                        acc_status.regtime = 0L;
                        ret = new req_TGTGT(thisG).make_request(TLSHelper.this.mSdkAppid, TLSHelper.this.mSubAppid, 1, thisG._uin, 0, req_global._ip_addr, init_time, 0, thisContext._tmp_pwd, smslogin, TLSHelper.this.mMiscBitmap, TLSHelper.this.mSubSigMap, null, TLSHelper.this.mMainSigMap, TLSHelper.this.mSubAppid, 1, req_global._pic_type, 0, 0, 1, userInfo);
                    }
                    if (ret == 0) {
                        SigInfo info = thisG.get_siginfo(thisG._uin, TLSHelper.this.mSdkAppid);
                        if (info == null) {
                            ret = -1004;
                        } else {
                            userInfo.get_clone(info);
                        }
                    }
                }
                thisG.close_connect();
                QLog.i("wtlogin login with GetStWithPasswd:user:" + userAccount + " dwAppid:" + TLSHelper.this.mSdkAppid + " dwMainSigMap:" + TLSHelper.this.mMainSigMap + " dwSubAppid:" + TLSHelper.this.mSubAppid + " Seq:" + thisG._seq + " ret=" + ret, thisG._uin);
                return ret;
            }
        }, new WorkThread.When(){

            public void done(int ret) {
                async_context thisContext = req_global.get_async_data(thisG._seq);
                TLSErrInfo errInfo = thisContext._last_err_msg;
                if (listener instanceof TLSSmsLoginListener) {
                    TLSSmsLoginListener loginListener = (TLSSmsLoginListener)listener;
                    if (ret == 0) {
                        loginListener.OnSmsLoginSuccess(userInfo);
                    } else if (ret == -1000) {
                        loginListener.OnSmsLoginTimeout(errInfo);
                    } else {
                        errInfo.ErrCode = ret;
                        loginListener.OnSmsLoginFail(errInfo);
                    }
                } else if (listener instanceof TLSPwdLoginListener) {
                    TLSPwdLoginListener loginListener = (TLSPwdLoginListener)listener;
                    if (ret == 0) {
                        loginListener.OnPwdLoginSuccess(userInfo);
                    } else if (ret == 2) {
                        TLSHelper.this.mAsyncSeq = thisG._seq;
                        byte[] picData = thisContext._t105.get_pic();
                        loginListener.OnPwdLoginNeedImgcode(picData, errInfo);
                    } else if (ret == -1000) {
                        loginListener.OnPwdLoginTimeout(errInfo);
                    } else {
                        errInfo.ErrCode = ret;
                        loginListener.OnPwdLoginFail(errInfo);
                    }
                } else if (listener instanceof TLSGuestLoginListener) {
                    TLSGuestLoginListener loginListener = (TLSGuestLoginListener)listener;
                    if (ret == 0) {
                        thisG.put_guest(thisG._userid, thisG._uin);
                        guest = thisG._userid;
                        loginListener.OnGuestLoginSuccess(userInfo);
                    } else if (ret == -1000) {
                        loginListener.OnGuestLoginTimeout(errInfo);
                    } else {
                        loginListener.OnGuestLoginFail(errInfo);
                    }
                } else if (listener instanceof TLSSSOGuestLoginListener) {
                    TLSSSOGuestLoginListener loginListener = (TLSSSOGuestLoginListener)listener;
                    if (ret == 0) {
                        thisG.put_sso_guest(thisG._userid, thisG._uin);
                        ssoGuest = thisG._userid;
                        loginListener.OnGuestLoginSuccess(userInfo);
                    } else if (ret == -1000) {
                        loginListener.OnGuestLoginTimeout(errInfo);
                    } else {
                        loginListener.OnGuestLoginFail(errInfo);
                    }
                }
            }
        }).start();
        return -1001;
    }

    public int TLSSmsLogin(String mobile, TLSSmsLoginListener listener) {
        QLog.i("user:" + mobile + " TLSSmsLogin ..." + this.mSubAppid);
        String passwd = acc_status.mpasswd;
        if (passwd.length() > 0) {
            this.mAsyncSeq = 0L;
        }
        QLog.i("has mpasswd? " + passwd.length());
        return this.GetStWithPasswd(mobile, passwd.getBytes(), true, listener);
    }

    public int TLSPwdLogin(String identifier, byte[] password, TLSPwdLoginListener listener) {
        QLog.i("user:" + identifier + " TLSPwdLogin ..." + this.mSdkAppid);
        this.mAsyncSeq = 0L;
        return this.GetStWithPasswd(identifier, password, false, listener);
    }

    public int TLSGuestLogin(final TLSGuestLoginListener listener) {
        this.TLSGuestReg(new TLSGuestRegListener(){

            public void OnGuestRegSuccess(TLSUserInfo userInfo) {
                TLSHelper.this.clearUserInfo(TLSHelper.this.getGuestIdentifier());
                QLog.i("user:" + userInfo.identifier + " TLSGuestLogin ..." + TLSHelper.this.mSdkAppid);
                TLSHelper.this.mAsyncSeq = 0L;
                TLSHelper.this.GetStWithPasswd(userInfo.identifier, acc_status.mpasswd.getBytes(), false, listener);
            }

            public void OnGuestRegFail(TLSErrInfo errInfo) {
                listener.OnGuestLoginFail(errInfo);
            }

            public void OnGuestRegTimeout(TLSErrInfo errInfo) {
                listener.OnGuestLoginTimeout(errInfo);
            }
        });
        return -1001;
    }

    public int TLSSSOGuestLogin(final TLSSSOGuestLoginListener listener) {
        this.TLSSSOGuestReg(new TLSSSORegListener(){

            public void OnGuestRegSuccess(TLSUserInfo userInfo) {
                TLSHelper.this.clearUserInfo(TLSHelper.this.getSSOGuestIdentifier());
                QLog.i("user:" + userInfo.identifier + " TLSGuestLogin ..." + TLSHelper.this.mSdkAppid);
                TLSHelper.this.mAsyncSeq = 0L;
                TLSHelper.this.GetStWithPasswd(userInfo.identifier, acc_status.mpasswd.getBytes(), false, listener);
            }

            public void OnGuestRegFail(TLSErrInfo errInfo) {
                listener.OnGuestLoginFail(errInfo);
            }

            public void OnGuestRegTimeout(TLSErrInfo errInfo) {
                listener.OnGuestLoginTimeout(errInfo);
            }
        });
        return -1001;
    }

    public int TLSSmsLoginAskCode(final String mobile, final TLSSmsLoginListener listener) {
        acc_status.msalt = 0L;
        acc_status.mpasswd = "";
        if (mobile == null) {
            return -1017;
        }
        final TLSUserInfo userInfo = new TLSUserInfo();
        final req_global thisG = this.mG.getClone(0L);
        this.mAsyncSeq = thisG._seq;
        new WorkThread(Looper.myLooper(), new WorkThread.Worker(){

            public int work() {
                int ret = 0;
                async_context thisContext = req_global.get_async_data(thisG._seq);
                thisG._userid = mobile;
                QLog.i("user:" + mobile + " Seq:" + thisG._seq + " TLSSmsLoginAskCode ...");
                thisContext._last_err_msg = new TLSErrInfo();
                ret = new req_smslogin_ask(thisG).make_request(TLSHelper.this.mSdkAppid, TLSHelper.this.mSubAppid, TLSHelper.this.DummyGetSig, mobile, TLSHelper.this.mMiscBitmap, TLSHelper.this.mSubSigMap, userInfo);
                QLog.i("user:" + thisG._userid + " Seq:" + thisG._seq + " TLSSmsLoginAskCode ret=" + (ret > 0 ? Integer.toHexString(ret) : Integer.valueOf(ret)), thisG._uin);
                return ret;
            }
        }, new WorkThread.When(){

            public void done(int ret) {
                async_context thisContext = req_global.get_async_data(thisG._seq);
                TLSErrInfo errInfo = thisContext._last_err_msg;
                if (ret == 0) {
                    listener.OnSmsLoginAskCodeSuccess(thisContext._smslogin_reask, thisContext._smslogin_expire);
                } else if (ret == -1000) {
                    listener.OnSmsLoginTimeout(errInfo);
                } else {
                    listener.OnSmsLoginFail(errInfo);
                }
            }
        }).start();
        return -1001;
    }

    public int TLSSmsLoginReaskCode(final String mobile, final TLSSmsLoginListener listener) {
        if (mobile == null || mobile.length() == 0) {
            return -1017;
        }
        final TLSUserInfo userInfo = new TLSUserInfo();
        final req_global thisG = this.mG.getClone(this.mAsyncSeq);
        new WorkThread(Looper.myLooper(), new WorkThread.Worker(){

            public int work() {
                int ret = 0;
                async_context thisContext = req_global.get_async_data(thisG._seq);
                QLog.i("user:" + mobile + " Seq:" + thisG._seq + " TLSSmsLoginReaskCode ...");
                thisG._userid = mobile;
                thisContext._last_err_msg = new TLSErrInfo();
                ret = new req_smslogin_reask(thisG).make_request(TLSHelper.this.mMiscBitmap, TLSHelper.this.mSubSigMap, null, userInfo);
                QLog.i("user:" + thisG._userid + " Seq:" + thisG._seq + " TLSSmsLoginReaskCode ret=" + (ret > 0 ? Integer.toHexString(ret) : Integer.valueOf(ret)));
                return ret;
            }
        }, new WorkThread.When(){

            public void done(int ret) {
                async_context thisContext = req_global.get_async_data(thisG._seq);
                TLSErrInfo errInfo = thisContext._last_err_msg;
                if (ret == 0) {
                    listener.OnSmsLoginReaskCodeSuccess(thisContext._smslogin_reask, thisContext._smslogin_expire);
                } else if (ret == -1000) {
                    listener.OnSmsLoginTimeout(errInfo);
                } else {
                    listener.OnSmsLoginFail(errInfo);
                }
            }
        }).start();
        return -1001;
    }

    public int TLSPwdLoginReaskImgcode(final TLSPwdLoginListener listener) {
        TLSUserInfo userInfo = new TLSUserInfo();
        final req_global thisG = this.mG.getClone(this.mAsyncSeq);
        new WorkThread(Looper.myLooper(), new WorkThread.Worker(){

            public int work() {
                int ret = 0;
                async_context thisContext = req_global.get_async_data(thisG._seq);
                QLog.i("user:" + thisG._userid + " Seq:" + thisG._seq + " TLSPwdLoginReaskImgcode ...");
                thisG._userid = thisContext._userid;
                thisG._uin = thisContext._tinyid;
                thisContext._last_err_msg = new TLSErrInfo();
                ret = new req_imgcode_reask(thisG).make_request();
                QLog.i("user:" + thisG._userid + " Seq:" + thisG._seq + " TLSPwdLoginReaskImgcode ret=" + (ret > 0 ? Integer.toHexString(ret) : Integer.valueOf(ret)));
                return ret;
            }
        }, new WorkThread.When(){

            public void done(int ret) {
                async_context thisContext = req_global.get_async_data(thisG._seq);
                TLSErrInfo errInfo = thisContext._last_err_msg;
                if (ret == 2) {
                    TLSHelper.this.mAsyncSeq = thisG._seq;
                    byte[] picData = thisContext._t105.get_pic();
                    listener.OnPwdLoginReaskImgcodeSuccess(picData);
                } else if (ret == -1000) {
                    listener.OnPwdLoginTimeout(errInfo);
                } else {
                    listener.OnPwdLoginFail(errInfo);
                }
            }
        }).start();
        return -1001;
    }

    public int TLSSmsLoginVerifyCode(final String code, final TLSSmsLoginListener listener) {
        if (code == null || code.length() == 0) {
            return -1017;
        }
        final TLSUserInfo userInfo = new TLSUserInfo();
        final req_global thisG = this.mG.getClone(this.mAsyncSeq);
        new WorkThread(Looper.myLooper(), new WorkThread.Worker(){

            public int work() {
                int ret = 0;
                async_context thisContext = req_global.get_async_data(thisG._seq);
                QLog.i("user:" + thisG._userid + " code:" + code + " Seq:" + thisG._seq + " TLSSmsLoginVerifyCode ...");
                thisContext._last_err_msg = new TLSErrInfo();
                thisContext._mpasswd = util.get_mpasswd();
                ret = new req_smslogin_verify(thisG).make_request(code, TLSHelper.this.mMiscBitmap, TLSHelper.this.mSubSigMap, null, userInfo);
                QLog.i("user:" + thisG._userid + " code:" + code + " Seq:" + thisG._seq + " TLSSmsLoginVerifyCode ret=" + Integer.toHexString(ret));
                return ret;
            }
        }, new WorkThread.When(){

            public void done(int ret) {
                async_context thisContext = req_global.get_async_data(thisG._seq);
                TLSErrInfo errInfo = thisContext._last_err_msg;
                if (ret == 0) {
                    listener.OnSmsLoginVerifyCodeSuccess();
                } else if (ret == -1000) {
                    listener.OnSmsLoginTimeout(errInfo);
                } else {
                    listener.OnSmsLoginFail(errInfo);
                }
            }
        }).start();
        return -1001;
    }

    public int TLSPwdLoginVerifyImgcode(final String imgCode, final TLSPwdLoginListener listener) {
        final TLSUserInfo userInfo = new TLSUserInfo();
        final req_global thisG = this.mG.getClone(this.mAsyncSeq);
        new WorkThread(Looper.myLooper(), new WorkThread.Worker(){

            public int work() {
                int ret = 0;
                async_context thisContext = req_global.get_async_data(thisG._seq);
                QLog.i("user:" + thisG._userid + " Seq:" + thisG._seq + " TLSPwdLoginVerifyImgcode ...");
                userInfo.identifier = thisG._userid = thisContext._userid;
                thisG._uin = thisContext._tinyid;
                thisContext._last_err_msg = new TLSErrInfo();
                ret = new req_imgcode_verify(thisG).make_request(imgCode);
                QLog.i("user:" + thisG._userid + " Seq:" + thisG._seq + " TLSPwdLoginVerifyImgcode ret=" + (ret > 0 ? Integer.toHexString(ret) : Integer.valueOf(ret)));
                return ret;
            }
        }, new WorkThread.When(){

            public void done(int ret) {
                async_context thisContext = req_global.get_async_data(thisG._seq);
                TLSErrInfo errInfo = thisContext._last_err_msg;
                if (ret == 0) {
                    listener.OnPwdLoginSuccess(userInfo);
                } else if (ret == 2) {
                    TLSHelper.this.mAsyncSeq = thisG._seq;
                    byte[] picData = thisContext._t105.get_pic();
                    listener.OnPwdLoginNeedImgcode(picData, errInfo);
                } else if (ret == -1000) {
                    listener.OnPwdLoginTimeout(errInfo);
                } else {
                    listener.OnPwdLoginFail(errInfo);
                }
            }
        }).start();
        return -1001;
    }

    public void clearUserInfo(String identifier) {
        long uin;
        QLog.i("user:" + identifier + " sdkAppid:" + this.mSdkAppid + " clearUserInfo");
        if (identifier == null || identifier.length() <= 0) {
            return;
        }
        if (identifier.equals(guest)) {
            guest = null;
        }
        if ((uin = this.mG.getTinyId(identifier)) != 0L) {
            this.mG.clear_sig(uin, this.mSdkAppid);
        }
        this.mG.remove_account(identifier);
    }

    public byte[] getGUID() {
        byte[] guid = null;
        if (req_global._IMEI != null && req_global._IMEI.length > 0) {
            guid = new byte[req_global._IMEI.length];
            System.arraycopy(req_global._IMEI, 0, guid, 0, req_global._IMEI.length);
        }
        return guid;
    }

    public int TLSExchangeTicket(String identifier, String usersig, TLSExchangeTicketListener listener) {
        return this.TLSExchangeTicket(this.mSdkAppid, identifier, usersig, listener);
    }

    public int TLSExchangeTicket(long sdkappid, String identifier, String usersig, TLSExchangeTicketListener listener) {
        if (util.checkInvalid(identifier) || util.checkInvalid(usersig)) {
            return -1017;
        }
        this.mSdkAppid = sdkappid;
        Oidb0xa0b_request oidb0xa0b_request = new Oidb0xa0b_request(2);
        TransReqContext req_con = new TransReqContext(listener);
        req_con.set_subcmd(oidb0xa0b_request.getCmd());
        req_con._body = oidb0xa0b_request.get_request(this.mSdkAppid, 0, identifier, null, usersig);
        return this.RequestTransport(null, 0, identifier, usersig, 6269L, req_con);
    }

    public void setOpenAccountInfo(int openAccountType, String openappid, String openid, String access_token) {
        this.openAccountInfo = new TLSOpenAccountInfo(openAccountType, openappid, openid, access_token);
        this.openAccountInfo.sdkAppid = this.mSdkAppid;
        this.openAccountInfo.userAccountType = this.mAccType;
    }

    public void setOpenAccountInfo(TLSOpenAccountInfo openAccountInfo) {
        this.openAccountInfo = openAccountInfo;
        this.openAccountInfo.sdkAppid = this.mSdkAppid;
        this.openAccountInfo.userAccountType = this.mAccType;
    }

    public TLSOpenAccountInfo getOpenAccountInfo() {
        return this.openAccountInfo;
    }

    public int TLSOpenAccountQuery(TLSOpenAccountQueryListener listener) {
        int openAccountType = this.openAccountInfo.openAccountType;
        String openid = this.openAccountInfo.openid;
        String accessToken = this.openAccountInfo.access_token;
        String openappid = this.openAccountInfo.openappid;
        if (openAccountType <= 0 || util.checkInvalid(openid) || util.checkInvalid(accessToken)) {
            return -1017;
        }
        Oidb0x602_request oidb0x602_request = new Oidb0x602_request();
        TransReqContext req_con = new TransReqContext(listener);
        req_con.set_subcmd(oidb0x602_request.getCmd());
        req_con._body = oidb0x602_request.get_request((int)this.mSdkAppid, openAccountType, openappid, openid, accessToken);
        return this.RequestTransport(openappid, openAccountType, openid, accessToken, 6161L, req_con);
    }

    public int TLSOpenAccountBind(String identifier, String userSig, TLSOpenAccountBindListener listener) {
        int openAccountType = this.openAccountInfo.openAccountType;
        String openid = this.openAccountInfo.openid;
        String accessToken = this.openAccountInfo.access_token;
        String openappid = this.openAccountInfo.openappid;
        this.openAccountInfo.identifer = identifier;
        this.openAccountInfo.usersig = userSig;
        if (openAccountType <= 0 || util.checkInvalid(identifier) || util.checkInvalid(userSig) || util.checkInvalid(openid) || util.checkInvalid(accessToken)) {
            return -1017;
        }
        Oidb0x601_request oidb0x601_request = new Oidb0x601_request();
        TransReqContext req_con = new TransReqContext(listener);
        req_con.set_subcmd(oidb0x601_request.getCmd());
        req_con._body = oidb0x601_request.get_request((int)this.openAccountInfo.sdkAppid, this.openAccountInfo.userAccountType, identifier, userSig, openAccountType, this.openAccountInfo.openappid, openid, accessToken);
        return this.RequestTransport(openappid, openAccountType, openid, accessToken, 6161L, req_con);
    }

    public int TLSOpenAccessToken(int openAccountType, String code, TLSOpenAccessTokenListener listener) {
        if (openAccountType <= 0 || util.checkInvalid(code)) {
            return -1017;
        }
        Oidb0x483_request oidb0x483_request = new Oidb0x483_request();
        TransReqContext reqContext = new TransReqContext(listener);
        reqContext.set_subcmd(oidb0x483_request.getCmd());
        reqContext._body = oidb0x483_request.get_request(this.mSdkAppid, openAccountType, code);
        return this.RequestTransport(null, openAccountType, null, null, 5970L, reqContext);
    }

    public int TLSSmsRegAskCodeWithOA(String mobile, TLSSmsRegListener listener) {
        QLog.i("TLSSmsRegAskCodeWithOA ..." + mobile);
        return this.askCode(mobile, 33, true, listener);
    }

    public int TLSPwdRegAskCodeWithOA(String mobile, TLSPwdRegListener listener) {
        QLog.i("TLSPwdRegAskCodeWithOA ..." + mobile);
        return this.askCode(mobile, 49, true, listener);
    }

    public int TLSStrAccRegWithOA(String account, String password, TLSStrAccRegListener listener) {
        if (account.length() == 0 || account.getBytes().length > 24) {
            return -1017;
        }
        if (password.length() == 0 || password.getBytes().length > 16 || password.getBytes().length < 8) {
            return -1017;
        }
        if (this.openAccountInfo.checkInvalid()) {
            return -1017;
        }
        boolean allNumber = true;
        for (int i = 0; i < account.length(); ++i) {
            char c = account.charAt(i);
            if (c != '.' && c != '_' && !Character.isLetterOrDigit(c)) {
                return -1017;
            }
            if (Character.isDigit(c)) continue;
            allNumber = false;
        }
        if (allNumber) {
            return -1017;
        }
        acc_ask_code acc_query = new acc_ask_code(97);
        TransReqContext req_con = new TransReqContext(listener);
        this.mRegStatus.userID = account;
        this.mRegStatus.password = password;
        req_con.set_register_req();
        req_con.set_subcmd(acc_query.get_cmd());
        req_con._body = acc_query.get_request(this.mAccType, account, req_global._apk_id, this.mAppVer, this.mCountry, this.mSdkAppid, req_global._IMEI, this.openAccountInfo);
        return this.RequestTransport(null, 0, account, null, this.mRegStatus.role, req_con);
    }

    public int TLSOpenAccountLogin(TLSExchangeTicketListener listener) {
        if (this.openAccountInfo.checkInvalid()) {
            return -1017;
        }
        int accountType = this.openAccountInfo.openAccountType;
        String identifier = this.openAccountInfo.openid;
        String appidAt3rd = this.openAccountInfo.openappid;
        String usersig = this.openAccountInfo.access_token;
        Oidb0xa0b_request oidb0xa0b_request = new Oidb0xa0b_request(1);
        TransReqContext req_con = new TransReqContext(listener);
        req_con.set_subcmd(oidb0xa0b_request.getCmd());
        req_con._body = oidb0xa0b_request.get_request(this.mSdkAppid, accountType, identifier, appidAt3rd, usersig);
        return this.RequestTransport(appidAt3rd, accountType, identifier, usersig, 6269L, req_con);
    }

    private int RequestTransport(final String appidAt3rd, final int accountType, final String identifier, final String usersig, final long role, final TransReqContext req_context) {
        final TLSUserInfo userInfo = new TLSUserInfo();
        userInfo.identifier = identifier;
        final req_global thisG = this.mG.getClone(0L);
        new WorkThread(Looper.myLooper(), new WorkThread.Worker(){

            public int work() {
                QLog.i("user:" + identifier + " sdkAppid:" + TLSHelper.this.mSdkAppid + " role:" + role + " Seq:" + thisG._seq + " RequestTransport...");
                thisG._userid = identifier;
                int ret = new req_transport(thisG).make_request(0L, req_context, null, null, TLSHelper.this.mSdkAppid, role, userInfo);
                thisG.close_transport_connect();
                QLog.i("user:" + identifier + " sdkAppid:" + TLSHelper.this.mSdkAppid + " role:" + role + " Seq:" + thisG._seq + " RequestTransport ret=" + ret);
                return ret;
            }
        }, new WorkThread.When(){

            public void done(int ret) {
                int subcmd = req_context.get_subcmd();
                if (req_context.is_register_req()) {
                    TLSHelper.this.OnTLSRequestRegister(req_context, userInfo, ret);
                } else if (subcmd == 1538) {
                    TLSHelper.this.OnTLSOpenAccountQuery(req_context, ret);
                } else if (subcmd == 1537) {
                    TLSHelper.this.OnTLSOpenAccountBind(req_context, ret);
                } else if (subcmd == 2571) {
                    TLSHelper.this.OnTLSExchangeTicket(req_context, thisG, appidAt3rd, accountType, usersig, ret);
                } else if (subcmd == 1155) {
                    TLSHelper.this.OnTLSOpenAccessToken(req_context, ret);
                } else {
                    QLog.i("\u547d\u4ee4\u5b57\u4e0d\u4e00\u81f4!");
                }
            }
        }).start();
        return -1001;
    }

    private void OnTLSOpenAccessToken(TransReqContext reqContext, int ret) {
        TLSOpenAccessTokenListener listener = (TLSOpenAccessTokenListener)reqContext.listener;
        TLSErrInfo errInfo = new TLSErrInfo(ret, "", I18nMsg.getMsg(I18nMsg.MSG_TYPE.MSG_3));
        if (ret != 0) {
            this.whenError(errInfo, listener);
            return;
        }
        Oidb0x483_response rsp = new Oidb0x483_response(reqContext.get_body());
        if (rsp.getResult() == 0) {
            if (rsp.getHeadResult() == 0) {
                TLSAccessTokenInfo accessTokenInfo = new TLSAccessTokenInfo();
                accessTokenInfo.access_token = rsp.getAccessToken();
                accessTokenInfo.expireTime = rsp.getExpireTime();
                accessTokenInfo.refresh_token = rsp.getRefreshToken();
                accessTokenInfo.openid = rsp.getOpenid();
                accessTokenInfo.scope = rsp.getScope();
                accessTokenInfo.unionid = rsp.getUnionid();
                listener.OnOpenAccessTokenSuccess(accessTokenInfo);
            } else {
                QLog.i("rsp.getHeadResult() = " + rsp.getHeadResult());
                errInfo.ErrCode = rsp.getHeadResult();
                errInfo.Msg = rsp.getErrHint();
                listener.OnOpenAccessTokenFail(errInfo);
            }
            return;
        }
        errInfo.ErrCode = rsp.getResult();
        errInfo.Msg = "\u89e3\u6790\u5305\u51fa\u9519";
        this.whenError(errInfo, listener);
    }

    private void OnTLSRequestRegister(TransReqContext req_context, TLSUserInfo userInfo, int ret) {
        int subcmd = req_context.get_subcmd();
        Object listener = req_context.listener;
        TLSErrInfo errInfo = new TLSErrInfo(ret, "", I18nMsg.getMsg(I18nMsg.MSG_TYPE.MSG_3));
        if (ret != 0) {
            this.whenError(errInfo, listener);
            return;
        }
        ret = acc_request.parse_checkvalid_rsp(subcmd, req_context.get_body(), this.mRegStatus);
        if (ret != 0) {
            errInfo.ErrCode = ret;
            this.whenError(errInfo, listener);
            return;
        }
        QLog.i("reg cmd:" + subcmd + " ret:" + this.mRegStatus.sec_ctrl_code);
        errInfo.ErrCode = this.mRegStatus.sec_ctrl_code;
        errInfo.Msg = new String(this.mRegStatus.promptinfo);
        if (errInfo.ErrCode != 0) {
            this.whenError(errInfo, listener);
            return;
        }
        QLog.i("Reg Success " + errInfo.ErrCode + ", msg: " + errInfo.Msg);
        switch (subcmd) {
            case 49: {
                QLog.i("OnPwdRegAskCodeSuccess ");
                ((TLSPwdRegListener)listener).OnPwdRegAskCodeSuccess(this.mRegStatus.next_resend_time, this.mRegStatus.total_time_over);
                break;
            }
            case 33: {
                QLog.i("OnSmsRegAskCodeSuccess ");
                ((TLSSmsRegListener)listener).OnSmsRegAskCodeSuccess(this.mRegStatus.next_resend_time, this.mRegStatus.total_time_over);
                break;
            }
            case 64: {
                QLog.i("OnPwdResetAskCodeSuccess ");
                ((TLSPwdResetListener)listener).OnPwdResetAskCodeSuccess(this.mRegStatus.next_resend_time, this.mRegStatus.total_time_over);
                break;
            }
            case 52: {
                QLog.i("OnPwdRegReaskCodeSuccess ");
                ((TLSPwdRegListener)listener).OnPwdRegReaskCodeSuccess(this.mRegStatus.next_resend_time, this.mRegStatus.total_time_over);
                break;
            }
            case 36: {
                QLog.i("OnSmsRegReaskCodeSuccess ");
                ((TLSSmsRegListener)listener).OnSmsRegReaskCodeSuccess(this.mRegStatus.next_resend_time, this.mRegStatus.total_time_over);
                break;
            }
            case 65: {
                QLog.i("OnPwdResetReaskCodeSuccess ");
                ((TLSPwdResetListener)listener).OnPwdResetReaskCodeSuccess(this.mRegStatus.next_resend_time, this.mRegStatus.total_time_over);
                break;
            }
            case 53: {
                QLog.i("OnPwdRegVerifyCodeSuccess ");
                ((TLSPwdRegListener)listener).OnPwdRegVerifyCodeSuccess();
                break;
            }
            case 37: {
                QLog.i("OnSmsRegVerifyCodeSuccess ");
                ((TLSSmsRegListener)listener).OnSmsRegVerifyCodeSuccess();
                break;
            }
            case 66: {
                QLog.i("OnPwdResetVerifyCodeSuccess ");
                ((TLSPwdResetListener)listener).OnPwdResetVerifyCodeSuccess();
                break;
            }
            case 54: {
                QLog.i("OnPwdRegCommitSuccess ");
                ((TLSPwdRegListener)listener).OnPwdRegCommitSuccess(userInfo);
                break;
            }
            case 38: {
                QLog.i("OnSmsRegCommitSuccess ");
                ((TLSSmsRegListener)listener).OnSmsRegCommitSuccess(userInfo);
                break;
            }
            case 67: {
                QLog.i("OnPwdResetCommitSuccess ");
                ((TLSPwdResetListener)listener).OnPwdResetCommitSuccess(userInfo);
                break;
            }
            case 97: {
                QLog.i("OnStrAccRegQuerySuccess ");
                this.TLSStrAccRegCommit((TLSStrAccRegListener)listener);
                break;
            }
            case 102: {
                QLog.i("OnStrAccRegCommitSuccess ");
                ((TLSStrAccRegListener)listener).OnStrAccRegSuccess(userInfo);
                break;
            }
            case 118: {
                QLog.i("OnGuestRegSuccess ");
                userInfo.identifier = this.mRegStatus.userID;
                if (listener instanceof TLSGuestRegListener) {
                    ((TLSGuestRegListener)listener).OnGuestRegSuccess(userInfo);
                    break;
                }
                if (!(listener instanceof TLSSSORegListener)) break;
                ((TLSSSORegListener)listener).OnGuestRegSuccess(userInfo);
                break;
            }
            default: {
                QLog.w("OnTLSRequestRegister unhandle cmd:" + subcmd);
            }
        }
    }

    private void OnTLSExchangeTicket(TransReqContext reqContext, req_global thisG, String appidAt3rd, int accountType, String token, int ret) {
        TLSExchangeTicketListener listener = (TLSExchangeTicketListener)reqContext.listener;
        TLSErrInfo errInfo = new TLSErrInfo(ret, "", I18nMsg.getMsg(I18nMsg.MSG_TYPE.MSG_3));
        if (ret != 0) {
            this.whenError(errInfo, listener);
            return;
        }
        Oidb0xa0b_response rsp = new Oidb0xa0b_response(reqContext.get_body());
        if (rsp.getResult() == 0) {
            if (rsp.getHeadResult() == 0) {
                long tk_valid = 2160000L;
                long a2_valid = 2160000L;
                long d2_valid = 1728000L;
                long app_pri = 0xFFFFFFFFL;
                long tinyID = rsp.getTinyID();
                byte[] A2 = rsp.getA2();
                byte[] D2 = rsp.getD2();
                byte[] D2Key = rsp.getD2Key();
                int adminFlag = rsp.getAdminFlag();
                String innerID = rsp.getIdentifier();
                if (accountType <= 0) {
                    innerID = thisG._userid;
                }
                String usersig = rsp.getUserSig();
                String openid = thisG._userid;
                if (util.checkInvalid(innerID)) {
                    innerID = thisG._userid;
                }
                thisG._uin = tinyID;
                thisG._admin = adminFlag;
                thisG.put_open_account(thisG._userid, innerID, thisG._uin);
                thisG._userid = innerID;
                long create_time = req_global.get_cur_time();
                ArrayList<Ticket> tickets = new ArrayList<Ticket>();
                tlv_t t10d = new tlv_t(269);
                tickets.add(new Ticket(64, A2, t10d.get_data(), create_time, create_time + a2_valid));
                tickets.add(new Ticket(262144, D2, D2Key, create_time, create_time + d2_valid));
                tickets.add(new Ticket(0x10000000, usersig.getBytes(), null, create_time, create_time + tk_valid));
                if (accountType > 0) {
                    tickets.add(new Ticket(305419896, accountType, appidAt3rd, token.getBytes(), openid.getBytes(), create_time, 0L));
                }
                thisG.put_siginfo(thisG._uin, this.mSdkAppid, new byte[0], new byte[0], this.mSdkAppid, app_pri, create_time, tickets, 0);
                TLSUserInfo userInfo = new TLSUserInfo(accountType, thisG._userid, thisG._uin, create_time, TinyInfo.UserType.USER_TYPE_NORMAL);
                listener.OnExchangeTicketSuccess(userInfo);
            } else {
                QLog.i("rsp.getHeadResult() = " + rsp.getHeadResult());
                errInfo.ErrCode = rsp.getHeadResult();
                errInfo.Msg = rsp.getErrMsg();
                if (errInfo.Msg.length() == 0) {
                    errInfo.Msg = "\u5185\u90e8\u9519\u8bef\uff0c\u8bf7\u8bbf\u95ee http://bbs.qcloud.com/thread-8309-1-1.html \u6216\u8005\u8054\u7cfb QQ 3268519604";
                }
                this.whenError(errInfo, listener);
            }
            return;
        }
        errInfo.ErrCode = rsp.getResult();
        errInfo.Msg = "\u89e3\u6790\u5305\u51fa\u9519";
        this.whenError(errInfo, listener);
    }

    private void OnTLSOpenAccountQuery(TransReqContext req_context, int ret) {
        TLSOpenAccountQueryListener listener = (TLSOpenAccountQueryListener)req_context.listener;
        TLSErrInfo errInfo = new TLSErrInfo(ret, "", I18nMsg.getMsg(I18nMsg.MSG_TYPE.MSG_3));
        if (ret != 0) {
            this.whenError(errInfo, listener);
            return;
        }
        Oidb0x602_response rsp = new Oidb0x602_response(req_context.get_body());
        if (rsp.getResult() == 0) {
            if (rsp.getHeadResult() == 0) {
                TLSOpenAccountInfo.OpenAccountStatus status = rsp.getOpenAccountStatus();
                switch (status) {
                    case UNUSED: {
                        this.openAccountInfo.status = TLSOpenAccountInfo.OpenAccountStatus.UNUSED;
                        listener.onUnlogined(this.openAccountInfo);
                        break;
                    }
                    case USED_UNBINDED: {
                        this.openAccountInfo.status = TLSOpenAccountInfo.OpenAccountStatus.USED_UNBINDED;
                        listener.onLoginedButUnbinded(this.openAccountInfo);
                        break;
                    }
                    case USED_BINDED: {
                        this.openAccountInfo.status = TLSOpenAccountInfo.OpenAccountStatus.USED_BINDED;
                        listener.onLoginedAndBinded(this.openAccountInfo);
                        break;
                    }
                    default: {
                        QLog.i("\u540e\u53f0\u8fd4\u56de\u5f02\u5e38");
                    }
                }
                return;
            }
            QLog.i("rsp.getHeadResult() = " + rsp.getHeadResult());
            errInfo.ErrCode = rsp.getHeadResult();
            errInfo.Msg = "\u51fa\u9519\u5566";
            this.whenError(errInfo, listener);
            return;
        }
        errInfo.ErrCode = rsp.getResult();
        errInfo.Msg = "\u89e3\u6790\u5305\u51fa\u9519";
        this.whenError(errInfo, listener);
    }

    private void OnTLSOpenAccountBind(TransReqContext req_context, int ret) {
        TLSOpenAccountBindListener listener = (TLSOpenAccountBindListener)req_context.listener;
        TLSErrInfo errInfo = new TLSErrInfo(ret, "", I18nMsg.getMsg(I18nMsg.MSG_TYPE.MSG_3));
        if (ret != 0) {
            this.whenError(errInfo, listener);
            return;
        }
        Oidb0x601_response rsp = new Oidb0x601_response(req_context.get_body());
        if (rsp.getResult() == 0) {
            if (rsp.getHeadResult() == 0) {
                listener.onBindSuccess(this.openAccountInfo);
            } else {
                QLog.i("rsp.getHeadResult() = " + rsp.getHeadResult());
                listener.onBindFailure(this.openAccountInfo);
            }
            return;
        }
        errInfo.ErrCode = rsp.getResult();
        errInfo.Msg = "\u89e3\u6790\u5305\u51fa\u9519";
        this.whenError(errInfo, listener);
    }

    private void whenError(TLSErrInfo errInfo, Object listener) {
        if (errInfo.ErrCode == -1000) {
            if (listener instanceof TLSPwdRegListener) {
                ((TLSPwdRegListener)listener).OnPwdRegTimeout(errInfo);
            } else if (listener instanceof TLSPwdResetListener) {
                ((TLSPwdResetListener)listener).OnPwdResetTimeout(errInfo);
            } else if (listener instanceof TLSSmsRegListener) {
                ((TLSSmsRegListener)listener).OnSmsRegTimeout(errInfo);
            } else if (listener instanceof TLSStrAccRegListener) {
                ((TLSStrAccRegListener)listener).OnStrAccRegTimeout(errInfo);
            } else if (listener instanceof TLSGuestRegListener) {
                ((TLSGuestRegListener)listener).OnGuestRegTimeout(errInfo);
            } else if (listener instanceof TLSOpenAccountQueryListener) {
                ((TLSOpenAccountQueryListener)listener).onTimeOut(errInfo);
            } else if (listener instanceof TLSOpenAccountBindListener) {
                ((TLSOpenAccountBindListener)listener).onTimeOut(errInfo);
            } else if (listener instanceof TLSExchangeTicketListener) {
                ((TLSExchangeTicketListener)listener).OnExchangeTicketTimeout(errInfo);
            } else if (listener instanceof TLSOpenAccessTokenListener) {
                ((TLSOpenAccessTokenListener)listener).OnOpenAccessTokenTimeout(errInfo);
            }
        } else if (listener instanceof TLSPwdRegListener) {
            ((TLSPwdRegListener)listener).OnPwdRegFail(errInfo);
        } else if (listener instanceof TLSPwdResetListener) {
            ((TLSPwdResetListener)listener).OnPwdResetFail(errInfo);
        } else if (listener instanceof TLSSmsRegListener) {
            ((TLSSmsRegListener)listener).OnSmsRegFail(errInfo);
        } else if (listener instanceof TLSStrAccRegListener) {
            ((TLSStrAccRegListener)listener).OnStrAccRegFail(errInfo);
        } else if (listener instanceof TLSGuestRegListener) {
            ((TLSGuestRegListener)listener).OnGuestRegFail(errInfo);
        } else if (listener instanceof TLSOpenAccountQueryListener) {
            ((TLSOpenAccountQueryListener)listener).onFailure(errInfo);
        } else if (listener instanceof TLSOpenAccountBindListener) {
            ((TLSOpenAccountBindListener)listener).onFailure(errInfo);
        } else if (listener instanceof TLSExchangeTicketListener) {
            ((TLSExchangeTicketListener)listener).OnExchangeTicketFail(errInfo);
        } else if (listener instanceof TLSOpenAccessTokenListener) {
            ((TLSOpenAccessTokenListener)listener).OnOpenAccessTokenFail(errInfo);
        }
        QLog.i("whenError " + errInfo.ErrCode + ", msg: " + errInfo.Msg);
    }

    private TLSOpenAccountInfo GetLocalOpenAccountInfo(String userID, long sdkAppid) {
        SigInfo info;
        long uin = this.mG.getTinyId(userID);
        if (uin == 0L) {
            info = null;
        } else {
            info = this.mG.get_siginfo(uin, sdkAppid);
            if (info == null) {
                // empty if block
            }
        }
        if (info == null || info._access_token == null || info._access_token.length <= 0) {
            QLog.i("userAccount:" + userID + " dwAppid:" + sdkAppid + " GetLocalOpenAccountInfo return: null");
            return null;
        }
        QLog.i("userAccount:" + userID + " dwAppid:" + sdkAppid + " GetLocalOpenAccountInfo return: not null");
        return new TLSOpenAccountInfo(info.accountType, new String(info.appidAt3rd), new String((byte[])info.openid.clone()), new String((byte[])info._access_token.clone()));
    }

    private byte[] GetA1ByAccount(String userID, long sdkAppid) {
        SigInfo info;
        long uin = this.mG.getTinyId(userID);
        if (uin == 0L) {
            info = null;
        } else {
            info = this.mG.get_siginfo(uin, sdkAppid);
            if (info == null) {
                // empty if block
            }
        }
        if (info == null || info._en_A1 == null || info._en_A1.length <= 0) {
            QLog.i("userAccount:" + userID + " dwAppid:" + sdkAppid + " GetA1ByAccount return: null");
            return null;
        }
        QLog.i("userAccount:" + userID + " dwAppid:" + sdkAppid + " GetA1ByAccount return: not null");
        return (byte[])info._en_A1.clone();
    }

    private byte[] GetNoPicSigByAccount(String userID, long sdkAppid) {
        SigInfo info;
        long uin = this.mG.getTinyId(userID);
        if (uin == 0L) {
            info = null;
        } else {
            info = this.mG.get_siginfo(uin, sdkAppid);
            if (info == null) {
                // empty if block
            }
        }
        if (info == null || info._noPicSig == null || info._noPicSig.length <= 0) {
            QLog.i("userAccount:" + userID + " dwAppid:" + sdkAppid + " GetNoPicSigByAccount return: null");
            return null;
        }
        QLog.i("userAccount:" + userID + " dwAppid:" + sdkAppid + " GetNoPicSigByAccount return: not null");
        return (byte[])info._noPicSig.clone();
    }

    private TLSUserInfo GetLocalSig(String userID, long sdkAppid) {
        TLSUserInfo userInfo = null;
        QLog.i("GetLocalSig name:" + userID);
        TinyInfo tinyInfo = this.mG.getTinyInfo(userID);
        if (tinyInfo != null) {
            this.mG._uin = tinyInfo._tinyid;
            SigInfo sigInfo = this.mG.get_siginfo(tinyInfo._tinyid, sdkAppid);
            if (sigInfo != null) {
                long createTime = sigInfo._A1_create_time;
                if (createTime <= 0L) {
                    createTime = sigInfo._TLS_create_time;
                }
                userInfo = new TLSUserInfo(tinyInfo._acc_type, tinyInfo._userid, tinyInfo._tinyid, createTime, tinyInfo.userType);
                userInfo.get_clone(sigInfo);
            }
        }
        return userInfo;
    }

    private Ticket getLocalTicket(String userID, int type) {
        TLSUserInfo userInfo = this.GetLocalSig(userID, this.mSdkAppid);
        Ticket ticket = TLSHelper.getUserTicket(userInfo, type);
        return ticket;
    }

    private static Ticket getUserTicket(TLSUserInfo userInfo, int type) {
        if (userInfo != null && userInfo._tickets != null) {
            for (int i = 0; i < userInfo._tickets.size(); ++i) {
                Ticket ticket = userInfo._tickets.get(i);
                if (ticket.Type != type) continue;
                QLog.i(" type:" + Integer.toHexString(type) + " sig:" + util.buf_len(ticket.Sig) + " key:" + util.buf_len(ticket.SigKey) + " create time:" + ticket.CreateTime + " expire time:" + ticket.ExpireTime);
                return ticket;
            }
        }
        return null;
    }

    public long TLSGetLastRefreshTime(String identifier) {
        SigInfo sigInfo;
        if (util.checkInvalid(identifier)) {
            return 0L;
        }
        QLog.i("TLSGetLastRefreshTime identifier:" + identifier);
        TinyInfo tinyInfo = this.mG.getTinyInfo(identifier);
        if (tinyInfo != null && (sigInfo = this.mG.get_siginfo(tinyInfo._tinyid, this.mSdkAppid)) != null) {
            return sigInfo._A2_create_time;
        }
        return 0L;
    }

    public static void setSoLoadPath(String path) {
        util.soLoadPath = path;
    }
}

