/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.oidb;

import java.nio.ByteBuffer;
import tencent.tls.oidb.OidbHead;
import tencent.tls.oidb.cmd0xa0b.Oidb0Xa0b;
import tencent.tls.report.QLog;

public class Oidb0xa0b_response {
    private int dwHeadLen;
    private int dwBodyLen;
    private OidbHead.OIDBHead oidbHead;
    private Oidb0Xa0b.RspBody rspBody;
    private int result = 0;

    public Oidb0xa0b_response(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf);
        try {
            buffer.get();
            this.dwHeadLen = buffer.getInt();
            this.dwBodyLen = buffer.getInt();
            byte[] tmp = new byte[this.dwHeadLen];
            buffer.get(tmp);
            this.oidbHead = new OidbHead.OIDBHead();
            this.oidbHead.mergeFrom(tmp);
            tmp = new byte[this.dwBodyLen];
            buffer.get(tmp);
            this.rspBody = new Oidb0Xa0b.RspBody();
            this.rspBody.mergeFrom(tmp);
            buffer.get();
        }
        catch (Exception e) {
            QLog.e(e);
            this.result = -1009;
        }
    }

    public int getResult() {
        return this.result;
    }

    public long getTinyID() {
        return this.rspBody.uint64_tinyid.get();
    }

    public byte[] getA2() {
        return this.rspBody.bytes_a2.get().toByteArray();
    }

    public byte[] getD2() {
        return this.rspBody.bytes_d2.get().toByteArray();
    }

    public byte[] getD2Key() {
        return this.rspBody.bytes_d2key.get().toByteArray();
    }

    public String getErrMsg() {
        return this.oidbHead.str_error_msg.get();
    }

    public int getAdminFlag() {
        return this.rspBody.uint32_adminflag.get();
    }

    public String getIdentifier() {
        return this.rspBody.str_identifier.get();
    }

    public String getUserSig() {
        return this.rspBody.str_tlssig.get();
    }

    public int getHeadResult() {
        if (this.oidbHead != null) {
            return this.oidbHead.uint32_result.get();
        }
        return -1;
    }
}

