/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.oidb;

import com.tencent.mobileqq.pb.ByteStringMicro;
import java.nio.ByteBuffer;
import tencent.tls.oidb.OidbHead;
import tencent.tls.oidb.cmd0xa0b.Oidb0Xa0b;

public class Oidb0xa0b_request {
    public static final byte STX_C = 40;
    public static final byte ETX_C = 41;
    public static final int ROLE = 6269;
    public static final int OPENACCOUNT = 1;
    public static final int SELFACCOUNT = 2;
    public static final int CMD = 2571;
    protected int service_type;
    protected int dwHeadLen;
    protected int dwBodyLen;

    public Oidb0xa0b_request(int service_type) {
        this.service_type = service_type;
    }

    public int getCmd() {
        return 2571;
    }

    public byte[] get_request(long sdkAppid, int accountType, String identifier, String appidAt3rd, String usersig) {
        if (identifier == null) {
            identifier = "";
        }
        if (appidAt3rd == null) {
            appidAt3rd = "";
        }
        if (usersig == null) {
            usersig = "";
        }
        OidbHead.OIDBHead oidbHead = new OidbHead.OIDBHead();
        oidbHead.uint32_command.set(2571);
        oidbHead.uint32_service_type.set(this.service_type);
        Oidb0Xa0b.ReqBody reqBody = new Oidb0Xa0b.ReqBody();
        reqBody.uint32_sdkappid.set((int)sdkAppid);
        reqBody.str_appidat3rd.set(appidAt3rd);
        reqBody.str_identifier.set(identifier);
        reqBody.bytes_usersig.set(ByteStringMicro.copyFrom((byte[])usersig.getBytes()));
        reqBody.uint32_accounttype.set(accountType);
        this.dwHeadLen = oidbHead.getSerializedSize();
        this.dwBodyLen = reqBody.getSerializedSize();
        int len = 9 + this.dwHeadLen + this.dwBodyLen + 1;
        ByteBuffer buffer = ByteBuffer.allocate(len);
        buffer.put((byte)40);
        buffer.putInt(this.dwHeadLen);
        buffer.putInt(this.dwBodyLen);
        buffer.put(oidbHead.toByteArray());
        buffer.put(reqBody.toByteArray());
        buffer.put((byte)41);
        return buffer.array();
    }
}

