/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.oidb;

import java.nio.ByteBuffer;
import tencent.tls.account.TLSOpenAccountInfo;
import tencent.tls.oidb.OidbHead;
import tencent.tls.oidb.cmd0x602.Oidb0X602;
import tencent.tls.report.QLog;

public class Oidb0x602_response {
    private int dwHeadLen;
    private int dwBodyLen;
    private OidbHead.OIDBHead oidbHead;
    private Oidb0X602.RspBody rspBody;
    private int result = 0;

    public Oidb0x602_response(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf);
        try {
            buffer.get();
            this.dwHeadLen = buffer.getInt();
            this.dwBodyLen = buffer.getInt();
            byte[] tmp = new byte[this.dwHeadLen];
            buffer.get(tmp);
            this.oidbHead = new OidbHead.OIDBHead();
            this.oidbHead.mergeFrom(tmp);
            tmp = new byte[this.dwBodyLen];
            buffer.get(tmp);
            this.rspBody = new Oidb0X602.RspBody();
            this.rspBody.mergeFrom(tmp);
            buffer.get();
        }
        catch (Exception e) {
            QLog.e(e);
            this.result = -1009;
        }
    }

    public int getResult() {
        return this.result;
    }

    public int getHeadResult() {
        if (this.oidbHead != null) {
            return this.oidbHead.uint32_result.get();
        }
        return -1;
    }

    public TLSOpenAccountInfo.OpenAccountStatus getOpenAccountStatus() {
        int k = this.rspBody.rpt_open2userinfos.size();
        if (k > 0) {
            int ret = ((Oidb0X602.Open2UserInfo)this.rspBody.rpt_open2userinfos.get((int)0)).uint32_result_flg.get();
            switch (ret) {
                case 1: {
                    return TLSOpenAccountInfo.OpenAccountStatus.USED_BINDED;
                }
                case 2: {
                    return TLSOpenAccountInfo.OpenAccountStatus.USED_UNBINDED;
                }
                case 3: {
                    return TLSOpenAccountInfo.OpenAccountStatus.UNUSED;
                }
            }
        }
        return TLSOpenAccountInfo.OpenAccountStatus.UNKNOWN;
    }
}

