/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.oidb;

import java.nio.ByteBuffer;
import tencent.tls.oidb.OidbHead;
import tencent.tls.oidb.cmd0x483.Oidb0X483;
import tencent.tls.report.QLog;

public class Oidb0x483_response {
    private int dwHeadLen;
    private int dwBodyLen;
    private OidbHead.OIDBHead oidbHead;
    private Oidb0X483.RspBody rspBody;
    private int result = 0;

    public Oidb0x483_response(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf);
        try {
            buffer.get();
            this.dwHeadLen = buffer.getInt();
            this.dwBodyLen = buffer.getInt();
            byte[] tmp = new byte[this.dwHeadLen];
            buffer.get(tmp);
            this.oidbHead = new OidbHead.OIDBHead();
            this.oidbHead.mergeFrom(tmp);
            tmp = new byte[this.dwBodyLen];
            buffer.get(tmp);
            this.rspBody = new Oidb0X483.RspBody();
            this.rspBody.mergeFrom(tmp);
            buffer.get();
        }
        catch (Exception e) {
            QLog.e(e);
            this.result = -1009;
        }
    }

    public int getResult() {
        return this.result;
    }

    public int getHeadResult() {
        if (this.oidbHead != null) {
            return this.oidbHead.uint32_result.get();
        }
        return -1;
    }

    public String getErrHint() {
        return this.rspBody.str_errhint.get();
    }

    public String getAccessToken() {
        return this.rspBody.st_token.str_access_token.get();
    }

    public long getExpireTime() {
        return this.rspBody.st_token.uint32_expires_in.get();
    }

    public String getRefreshToken() {
        return this.rspBody.st_token.str_refresh_token.get();
    }

    public String getOpenid() {
        return this.rspBody.st_token.str_openid.get();
    }

    public String getScope() {
        return this.rspBody.st_token.str_scope.get();
    }

    public String getUnionid() {
        return this.rspBody.st_token.str_unionid.get();
    }
}

