/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.oidb;

import java.nio.ByteBuffer;
import tencent.tls.oidb.OidbHead;
import tencent.tls.oidb.cmd0x483.Oidb0X483;

public class Oidb0x483_request {
    public static final byte STX_C = 40;
    public static final byte ETX_C = 41;
    public static final int ROLE = 5970;
    public static final int CMD = 1155;
    protected int service_type = 0;
    protected int dwHeadLen;
    protected int dwBodyLen;

    public int getCmd() {
        return 1155;
    }

    public byte[] get_request(long appid, int accType, String code) {
        if (code == null) {
            code = "";
        }
        OidbHead.OIDBHead oidbHead = new OidbHead.OIDBHead();
        oidbHead.uint32_command.set(1155);
        oidbHead.uint32_service_type.set(this.service_type);
        Oidb0X483.ReqBody reqBody = new Oidb0X483.ReqBody();
        reqBody.uint32_appid.set((int)appid);
        reqBody.uint32_account_type.set(accType);
        reqBody.str_code.set(code);
        this.dwHeadLen = oidbHead.getSerializedSize();
        this.dwBodyLen = reqBody.getSerializedSize();
        int len = 9 + this.dwHeadLen + this.dwBodyLen + 1;
        ByteBuffer buffer = ByteBuffer.allocate(len);
        buffer.put((byte)40);
        buffer.putInt(this.dwHeadLen);
        buffer.putInt(this.dwBodyLen);
        buffer.put(oidbHead.toByteArray());
        buffer.put(reqBody.toByteArray());
        buffer.put((byte)41);
        return buffer.array();
    }
}

