/*
 * Decompiled with CFR 0.152.
 */
package tencent.tls.account;

import java.nio.ByteBuffer;
import java.util.Arrays;
import tencent.tls.account.acc_status;
import tencent.tls.report.QLog;
import tencent.tls.tools.MD5;
import tencent.tls.tools.cryptor;
import tencent.tls.tools.util;

public class acc_request {
    protected int _head_len = 11;
    protected int _cmd = 0;
    protected int _os_type = 5;
    protected int _body_len = 0;
    protected int _version = 1;
    public static final int CMD_REG_AC = 49;
    public static final int CMD_REG_RA = 52;
    public static final int CMD_REG_VC = 53;
    public static final int CMD_REG_CM = 54;
    public static final int CMD_SMS_AC = 33;
    public static final int CMD_SMS_RA = 36;
    public static final int CMD_SMS_VC = 37;
    public static final int CMD_SMS_CM = 38;
    public static final int CMD_RST_AC = 64;
    public static final int CMD_RST_RA = 65;
    public static final int CMD_RST_VC = 66;
    public static final int CMD_RST_CM = 67;
    public static final int CMD_STR_QRY = 97;
    public static final int CMD_STR_CM = 102;
    public static final int CMD_GUEST = 118;

    public int get_cmd() {
        return this._cmd;
    }

    protected byte[] get_request(byte[] body) {
        ByteBuffer buffer = ByteBuffer.allocate(2 + this._head_len + body.length);
        buffer.put((byte)2);
        buffer.putShort((short)(1 + this._head_len + body.length + 1));
        buffer.putShort((short)this._version);
        buffer.putShort((short)this._cmd);
        buffer.put((byte)4);
        buffer.putInt(0);
        buffer.put(body);
        buffer.put((byte)3);
        return buffer.array();
    }

    private static int check_header(byte[] body) {
        ByteBuffer buffer = ByteBuffer.wrap(body);
        try {
            buffer.get();
            short len = buffer.getShort();
            if (len != body.length) {
                return -1009;
            }
            buffer.getInt();
            len = buffer.get();
            return buffer.position() + len;
        }
        catch (Exception e) {
            QLog.e(e);
            return -1009;
        }
    }

    public static int parse_checkvalid_rsp(int cmd, byte[] body, acc_status regs) {
        int pos = 0;
        short len = 0;
        ByteBuffer buffer = ByteBuffer.wrap(body);
        pos = acc_request.check_header(body);
        if (pos == -1009) {
            return -1009;
        }
        buffer.position(pos);
        regs.sec_ctrl_code = buffer.get();
        byte[] tmpToken = null;
        switch (cmd) {
            case 33: 
            case 36: 
            case 49: 
            case 52: 
            case 64: 
            case 65: {
                len = buffer.getShort();
                regs.next_resend_time = buffer.getShort();
                regs.total_time_over = buffer.getShort();
                break;
            }
            case 38: 
            case 54: 
            case 67: {
                len = buffer.getShort();
                byte[] encrypted = new byte[len];
                buffer.get(encrypted);
                byte[] key = regs.msgcode == null || regs.msgcode.length == 0 ? acc_status.STATIC_KEY.getBytes() : MD5.toMD5Byte(regs.msgcode);
                byte[] decrypted = cryptor.decrypt(encrypted, 0, encrypted.length, key);
                if (decrypted == null) {
                    return -1002;
                }
                ByteBuffer deBuf = ByteBuffer.wrap(decrypted);
                len = deBuf.get();
                tmpToken = new byte[len];
                deBuf.get(tmpToken);
                len = deBuf.getShort();
                regs.nopicsig = new byte[len];
                deBuf.get(regs.nopicsig);
                break;
            }
            case 102: {
                acc_request.resolveTLV(cmd, buffer);
                break;
            }
            case 37: 
            case 53: 
            case 66: {
                acc_status.msalt = buffer.getLong();
                break;
            }
            case 97: {
                acc_status.msalt = buffer.getLong();
                len = buffer.getShort();
                if (len <= 0) break;
                buffer.position(buffer.position() + len);
                break;
            }
            case 118: {
                acc_status.msalt = buffer.getLong();
                acc_status.regtime = buffer.getLong();
                len = buffer.get();
                byte[] guest = new byte[len];
                buffer.get(guest);
                regs.userID = new String(guest);
                acc_request.resolveTLV(cmd, buffer);
                len = buffer.getShort();
                regs.promptinfo = new byte[len];
                buffer.get(regs.promptinfo);
                return 0;
            }
        }
        len = buffer.get();
        regs.token = new byte[len];
        buffer.get(regs.token);
        if (tmpToken != null && !Arrays.equals(regs.token, tmpToken)) {
            return -1002;
        }
        len = buffer.getShort();
        regs.promptinfo = new byte[len];
        buffer.get(regs.promptinfo);
        return 0;
    }

    private static void resolveTLV(int cmd, ByteBuffer buffer) {
        byte cnt = buffer.get();
        if (cnt == 0) {
            return;
        }
    }

    protected byte[] get_encrypt_token(byte[] token, byte[] msgcode) {
        byte[] body = new byte[token.length + 1];
        util.int8_to_buf(body, 0, token.length);
        System.arraycopy(token, 0, body, 1, token.length);
        byte[] key = MD5.toMD5Byte(msgcode);
        body = cryptor.encrypt(body, 0, body.length, key);
        return body;
    }
}

