/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mobileqq.pb;

import com.tencent.mobileqq.pb.CodedInputStreamMicro;
import com.tencent.mobileqq.pb.CodedOutputStreamMicro;
import com.tencent.mobileqq.pb.PBField;
import com.tencent.mobileqq.pb.PBPrimitiveField;
import java.io.IOException;

public final class PBFloatField
extends PBPrimitiveField<Float> {
    public static final PBFloatField __repeatHelper__ = new PBFloatField(0.0f, false);
    private float value = 0.0f;

    public PBFloatField(float f, boolean bl) {
        this.set(f, bl);
    }

    public float get() {
        return this.value;
    }

    public void set(float f, boolean bl) {
        this.value = f;
        this.setHasFlag(bl);
    }

    public void set(float f) {
        this.set(f, true);
    }

    @Override
    public int computeSize(int n) {
        if (this.has()) {
            return CodedOutputStreamMicro.computeFloatSize(n, this.value);
        }
        return 0;
    }

    @Override
    protected int computeSizeDirectly(int n, Float f) {
        return CodedOutputStreamMicro.computeFloatSize(n, f.floatValue());
    }

    @Override
    public void writeTo(CodedOutputStreamMicro codedOutputStreamMicro, int n) throws IOException {
        if (this.has()) {
            codedOutputStreamMicro.writeFloat(n, this.value);
        }
    }

    @Override
    protected void writeToDirectly(CodedOutputStreamMicro codedOutputStreamMicro, int n, Float f) throws IOException {
        codedOutputStreamMicro.writeFloat(n, f.floatValue());
    }

    @Override
    public void readFrom(CodedInputStreamMicro codedInputStreamMicro) throws IOException {
        this.value = codedInputStreamMicro.readFloat();
        this.setHasFlag(true);
    }

    @Override
    protected Float readFromDirectly(CodedInputStreamMicro codedInputStreamMicro) throws IOException {
        return Float.valueOf(codedInputStreamMicro.readFloat());
    }

    @Override
    public void clear(Object object) {
        this.value = object instanceof Float ? ((Float)object).floatValue() : 0.0f;
        this.setHasFlag(false);
    }

    @Override
    protected void copyFrom(PBField<Float> pBField) {
        PBFloatField pBFloatField = (PBFloatField)pBField;
        this.set(pBFloatField.value, pBFloatField.has());
    }
}

