/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mobileqq.pb;

import com.tencent.mobileqq.pb.ByteStringMicro;
import com.tencent.mobileqq.pb.CodedInputStreamMicro;
import com.tencent.mobileqq.pb.CodedOutputStreamMicro;
import com.tencent.mobileqq.pb.MessageMicro;
import com.tencent.mobileqq.pb.PBBoolField;
import com.tencent.mobileqq.pb.PBBytesField;
import com.tencent.mobileqq.pb.PBDoubleField;
import com.tencent.mobileqq.pb.PBEnumField;
import com.tencent.mobileqq.pb.PBFixed32Field;
import com.tencent.mobileqq.pb.PBFixed64Field;
import com.tencent.mobileqq.pb.PBFloatField;
import com.tencent.mobileqq.pb.PBInt32Field;
import com.tencent.mobileqq.pb.PBInt64Field;
import com.tencent.mobileqq.pb.PBRepeatField;
import com.tencent.mobileqq.pb.PBRepeatMessageField;
import com.tencent.mobileqq.pb.PBSFixed32Field;
import com.tencent.mobileqq.pb.PBSFixed64Field;
import com.tencent.mobileqq.pb.PBSInt32Field;
import com.tencent.mobileqq.pb.PBSInt64Field;
import com.tencent.mobileqq.pb.PBStringField;
import com.tencent.mobileqq.pb.PBUInt32Field;
import com.tencent.mobileqq.pb.PBUInt64Field;
import java.io.IOException;

public abstract class PBField<T> {
    public abstract int computeSize(int var1);

    protected abstract int computeSizeDirectly(int var1, T var2);

    public abstract void writeTo(CodedOutputStreamMicro var1, int var2) throws IOException;

    protected abstract void writeToDirectly(CodedOutputStreamMicro var1, int var2, T var3) throws IOException;

    public abstract void readFrom(CodedInputStreamMicro var1) throws IOException;

    protected abstract T readFromDirectly(CodedInputStreamMicro var1) throws IOException;

    protected abstract void copyFrom(PBField<T> var1);

    public abstract void clear(Object var1);

    public final void clear() {
        this.clear(null);
    }

    public static PBBoolField initBool(boolean bl) {
        return new PBBoolField(bl, false);
    }

    public static PBBytesField initBytes(ByteStringMicro byteStringMicro) {
        return new PBBytesField(byteStringMicro, false);
    }

    public static PBBytesField initBytes(byte[] byArray) {
        return new PBBytesField(ByteStringMicro.copyFrom(byArray), false);
    }

    public static PBDoubleField initDouble(double d) {
        return new PBDoubleField(d, false);
    }

    public static PBEnumField initEnum(int n) {
        return new PBEnumField(n, false);
    }

    public static PBFixed32Field initFixed32(int n) {
        return new PBFixed32Field(n, false);
    }

    public static PBFixed64Field initFixed64(long l) {
        return new PBFixed64Field(l, false);
    }

    public static PBFloatField initFloat(float f) {
        return new PBFloatField(f, false);
    }

    public static PBInt32Field initInt32(int n) {
        return new PBInt32Field(n, false);
    }

    public static PBInt64Field initInt64(long l) {
        return new PBInt64Field(l, false);
    }

    public static <T> PBRepeatField<T> initRepeat(PBField<T> pBField) {
        return new PBRepeatField<T>(pBField);
    }

    public static <T extends MessageMicro<T>> PBRepeatMessageField<T> initRepeatMessage(Class<T> clazz) {
        return new PBRepeatMessageField<T>(clazz);
    }

    public static PBSFixed32Field initSFixed32(int n) {
        return new PBSFixed32Field(n, false);
    }

    public static PBSFixed64Field initSFixed64(long l) {
        return new PBSFixed64Field(l, false);
    }

    public static PBSInt32Field initSInt32(int n) {
        return new PBSInt32Field(n, false);
    }

    public static PBSInt64Field initSInt64(long l) {
        return new PBSInt64Field(l, false);
    }

    public static PBStringField initString(String string) {
        return new PBStringField(string, false);
    }

    public static PBUInt32Field initUInt32(int n) {
        return new PBUInt32Field(n, false);
    }

    public static PBUInt64Field initUInt64(long l) {
        return new PBUInt64Field(l, false);
    }
}

