/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mobileqq.pb;

import com.tencent.mobileqq.pb.ByteStringMicro;
import com.tencent.mobileqq.pb.MessageMicro;
import com.tencent.mobileqq.pb.WireFormatMicro;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class CodedOutputStreamMicro {
    private final byte[] buffer;
    private final int limit;
    private int position;
    private final OutputStream output;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;

    private CodedOutputStreamMicro(byte[] byArray, int n, int n2) {
        this.output = null;
        this.buffer = byArray;
        this.position = n;
        this.limit = n + n2;
    }

    private CodedOutputStreamMicro(OutputStream outputStream, byte[] byArray) {
        this.output = outputStream;
        this.buffer = byArray;
        this.position = 0;
        this.limit = byArray.length;
    }

    public static CodedOutputStreamMicro newInstance(OutputStream outputStream) {
        return CodedOutputStreamMicro.newInstance(outputStream, 4096);
    }

    public static CodedOutputStreamMicro newInstance(OutputStream outputStream, int n) {
        return new CodedOutputStreamMicro(outputStream, new byte[n]);
    }

    public static CodedOutputStreamMicro newInstance(byte[] byArray) {
        return CodedOutputStreamMicro.newInstance(byArray, 0, byArray.length);
    }

    public static CodedOutputStreamMicro newInstance(byte[] byArray, int n, int n2) {
        return new CodedOutputStreamMicro(byArray, n, n2);
    }

    public void writeDouble(int n, double d) throws IOException {
        this.writeTag(n, 1);
        this.writeDoubleNoTag(d);
    }

    public void writeFloat(int n, float f) throws IOException {
        this.writeTag(n, 5);
        this.writeFloatNoTag(f);
    }

    public void writeUInt64(int n, long l) throws IOException {
        this.writeTag(n, 0);
        this.writeUInt64NoTag(l);
    }

    public void writeInt64(int n, long l) throws IOException {
        this.writeTag(n, 0);
        this.writeInt64NoTag(l);
    }

    public void writeInt32(int n, int n2) throws IOException {
        this.writeTag(n, 0);
        this.writeInt32NoTag(n2);
    }

    public void writeFixed64(int n, long l) throws IOException {
        this.writeTag(n, 1);
        this.writeFixed64NoTag(l);
    }

    public void writeFixed32(int n, int n2) throws IOException {
        this.writeTag(n, 5);
        this.writeFixed32NoTag(n2);
    }

    public void writeBool(int n, boolean bl) throws IOException {
        this.writeTag(n, 0);
        this.writeBoolNoTag(bl);
    }

    public void writeString(int n, String string) throws IOException {
        this.writeTag(n, 2);
        this.writeStringNoTag(string);
    }

    public void writeGroup(int n, MessageMicro<?> messageMicro) throws IOException {
        this.writeTag(n, 3);
        this.writeGroupNoTag(messageMicro);
        this.writeTag(n, 4);
    }

    public void writeMessage(int n, MessageMicro<?> messageMicro) throws IOException {
        this.writeTag(n, 2);
        this.writeMessageNoTag(messageMicro);
    }

    public void writeBytes(int n, ByteStringMicro byteStringMicro) throws IOException {
        this.writeTag(n, 2);
        this.writeBytesNoTag(byteStringMicro);
    }

    public void writeByteArray(int n, byte[] byArray) throws IOException {
        this.writeTag(n, 2);
        this.writeByteArrayNoTag(byArray);
    }

    public void writeUInt32(int n, int n2) throws IOException {
        this.writeTag(n, 0);
        this.writeUInt32NoTag(n2);
    }

    public void writeEnum(int n, int n2) throws IOException {
        this.writeTag(n, 0);
        this.writeEnumNoTag(n2);
    }

    public void writeSFixed32(int n, int n2) throws IOException {
        this.writeTag(n, 5);
        this.writeSFixed32NoTag(n2);
    }

    public void writeSFixed64(int n, long l) throws IOException {
        this.writeTag(n, 1);
        this.writeSFixed64NoTag(l);
    }

    public void writeSInt32(int n, int n2) throws IOException {
        this.writeTag(n, 0);
        this.writeSInt32NoTag(n2);
    }

    public void writeSInt64(int n, long l) throws IOException {
        this.writeTag(n, 0);
        this.writeSInt64NoTag(l);
    }

    public void writeDoubleNoTag(double d) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToLongBits(d));
    }

    public void writeFloatNoTag(float f) throws IOException {
        this.writeRawLittleEndian32(Float.floatToIntBits(f));
    }

    public void writeUInt64NoTag(long l) throws IOException {
        this.writeRawVarint64(l);
    }

    public void writeInt64NoTag(long l) throws IOException {
        this.writeRawVarint64(l);
    }

    public void writeInt32NoTag(int n) throws IOException {
        if (n >= 0) {
            this.writeRawVarint32(n);
        } else {
            this.writeRawVarint64(n);
        }
    }

    public void writeFixed64NoTag(long l) throws IOException {
        this.writeRawLittleEndian64(l);
    }

    public void writeFixed32NoTag(int n) throws IOException {
        this.writeRawLittleEndian32(n);
    }

    public void writeBoolNoTag(boolean bl) throws IOException {
        this.writeRawByte(bl ? 1 : 0);
    }

    public void writeStringNoTag(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        this.writeRawVarint32(byArray.length);
        this.writeRawBytes(byArray);
    }

    public void writeGroupNoTag(MessageMicro<?> messageMicro) throws IOException {
        messageMicro.writeTo(this);
    }

    public void writeMessageNoTag(MessageMicro<?> messageMicro) throws IOException {
        this.writeRawVarint32(messageMicro.getCachedSize());
        messageMicro.writeTo(this);
    }

    public void writeBytesNoTag(ByteStringMicro byteStringMicro) throws IOException {
        byte[] byArray = byteStringMicro.toByteArray();
        this.writeRawVarint32(byArray.length);
        this.writeRawBytes(byArray);
    }

    public void writeByteArrayNoTag(byte[] byArray) throws IOException {
        this.writeRawVarint32(byArray.length);
        this.writeRawBytes(byArray);
    }

    public void writeUInt32NoTag(int n) throws IOException {
        this.writeRawVarint32(n);
    }

    public void writeEnumNoTag(int n) throws IOException {
        this.writeRawVarint32(n);
    }

    public void writeSFixed32NoTag(int n) throws IOException {
        this.writeRawLittleEndian32(n);
    }

    public void writeSFixed64NoTag(long l) throws IOException {
        this.writeRawLittleEndian64(l);
    }

    public void writeSInt32NoTag(int n) throws IOException {
        this.writeRawVarint32(CodedOutputStreamMicro.encodeZigZag32(n));
    }

    public void writeSInt64NoTag(long l) throws IOException {
        this.writeRawVarint64(CodedOutputStreamMicro.encodeZigZag64(l));
    }

    public static int computeDoubleSize(int n, double d) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeDoubleSizeNoTag(d);
    }

    public static int computeFloatSize(int n, float f) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeFloatSizeNoTag(f);
    }

    public static int computeUInt64Size(int n, long l) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeUInt64SizeNoTag(l);
    }

    public static int computeInt64Size(int n, long l) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeInt64SizeNoTag(l);
    }

    public static int computeInt32Size(int n, int n2) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeInt32SizeNoTag(n2);
    }

    public static int computeFixed64Size(int n, long l) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeFixed64SizeNoTag(l);
    }

    public static int computeFixed32Size(int n, int n2) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeFixed32SizeNoTag(n2);
    }

    public static int computeBoolSize(int n, boolean bl) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeBoolSizeNoTag(bl);
    }

    public static int computeStringSize(int n, String string) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeStringSizeNoTag(string);
    }

    public static int computeGroupSize(int n, MessageMicro<?> messageMicro) {
        return CodedOutputStreamMicro.computeTagSize(n) * 2 + CodedOutputStreamMicro.computeGroupSizeNoTag(messageMicro);
    }

    public static int computeMessageSize(int n, MessageMicro<?> messageMicro) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeMessageSizeNoTag(messageMicro);
    }

    public static int computeBytesSize(int n, ByteStringMicro byteStringMicro) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeBytesSizeNoTag(byteStringMicro);
    }

    public static int computeByteArraySize(int n, byte[] byArray) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeByteArraySizeNoTag(byArray);
    }

    public static int computeUInt32Size(int n, int n2) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeUInt32SizeNoTag(n2);
    }

    public static int computeEnumSize(int n, int n2) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeEnumSizeNoTag(n2);
    }

    public static int computeSFixed32Size(int n, int n2) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeSFixed32SizeNoTag(n2);
    }

    public static int computeSFixed64Size(int n, long l) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeSFixed64SizeNoTag(l);
    }

    public static int computeSInt32Size(int n, int n2) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeSInt32SizeNoTag(n2);
    }

    public static int computeSInt64Size(int n, long l) {
        return CodedOutputStreamMicro.computeTagSize(n) + CodedOutputStreamMicro.computeSInt64SizeNoTag(l);
    }

    public static int computeDoubleSizeNoTag(double d) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float f) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long l) {
        return CodedOutputStreamMicro.computeRawVarint64Size(l);
    }

    public static int computeInt64SizeNoTag(long l) {
        return CodedOutputStreamMicro.computeRawVarint64Size(l);
    }

    public static int computeInt32SizeNoTag(int n) {
        if (n >= 0) {
            return CodedOutputStreamMicro.computeRawVarint32Size(n);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean bl) {
        return 1;
    }

    public static int computeStringSizeNoTag(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            return CodedOutputStreamMicro.computeRawVarint32Size(byArray.length) + byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported.");
        }
    }

    public static int computeGroupSizeNoTag(MessageMicro<?> messageMicro) {
        return messageMicro.getCachedSize();
    }

    public static int computeMessageSizeNoTag(MessageMicro<?> messageMicro) {
        int n = messageMicro.getCachedSize();
        return CodedOutputStreamMicro.computeRawVarint32Size(n) + n;
    }

    public static int computeBytesSizeNoTag(ByteStringMicro byteStringMicro) {
        return CodedOutputStreamMicro.computeRawVarint32Size(byteStringMicro.size()) + byteStringMicro.size();
    }

    public static int computeByteArraySizeNoTag(byte[] byArray) {
        return CodedOutputStreamMicro.computeRawVarint32Size(byArray.length) + byArray.length;
    }

    public static int computeUInt32SizeNoTag(int n) {
        return CodedOutputStreamMicro.computeRawVarint32Size(n);
    }

    public static int computeEnumSizeNoTag(int n) {
        return CodedOutputStreamMicro.computeRawVarint32Size(n);
    }

    public static int computeSFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int n) {
        return CodedOutputStreamMicro.computeRawVarint32Size(CodedOutputStreamMicro.encodeZigZag32(n));
    }

    public static int computeSInt64SizeNoTag(long l) {
        return CodedOutputStreamMicro.computeRawVarint64Size(CodedOutputStreamMicro.encodeZigZag64(l));
    }

    private void refreshBuffer() throws IOException {
        if (this.output == null) {
            throw new OutOfSpaceException();
        }
        this.output.write(this.buffer, 0, this.position);
        this.position = 0;
    }

    public void flush() throws IOException {
        if (this.output != null) {
            this.refreshBuffer();
        }
    }

    public int spaceLeft() {
        if (this.output == null) {
            return this.limit - this.position;
        }
        throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array.");
    }

    public void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void writeRawByte(byte by) throws IOException {
        if (this.position == this.limit) {
            this.refreshBuffer();
        }
        this.buffer[this.position++] = by;
    }

    public void writeRawByte(int n) throws IOException {
        this.writeRawByte((byte)n);
    }

    public void writeRawBytes(byte[] byArray) throws IOException {
        this.writeRawBytes(byArray, 0, byArray.length);
    }

    public void writeRawBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.limit - this.position >= n2) {
            System.arraycopy(byArray, n, this.buffer, this.position, n2);
            this.position += n2;
        } else {
            int n3 = this.limit - this.position;
            System.arraycopy(byArray, n, this.buffer, this.position, n3);
            n += n3;
            this.position = this.limit;
            this.refreshBuffer();
            if ((n2 -= n3) <= this.limit) {
                System.arraycopy(byArray, n, this.buffer, 0, n2);
                this.position = n2;
            } else {
                this.output.write(byArray, n, n2);
            }
        }
    }

    public void writeTag(int n, int n2) throws IOException {
        this.writeRawVarint32(WireFormatMicro.makeTag(n, n2));
    }

    public static int computeTagSize(int n) {
        return CodedOutputStreamMicro.computeRawVarint32Size(WireFormatMicro.makeTag(n, 0));
    }

    public void writeRawVarint32(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.writeRawByte(n);
                return;
            }
            this.writeRawByte(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeRawVarint64(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)l);
                return;
            }
            this.writeRawByte((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void writeRawLittleEndian32(int n) throws IOException {
        this.writeRawByte(n & 0xFF);
        this.writeRawByte(n >> 8 & 0xFF);
        this.writeRawByte(n >> 16 & 0xFF);
        this.writeRawByte(n >> 24 & 0xFF);
    }

    public void writeRawLittleEndian64(long l) throws IOException {
        this.writeRawByte((int)l & 0xFF);
        this.writeRawByte((int)(l >> 8) & 0xFF);
        this.writeRawByte((int)(l >> 16) & 0xFF);
        this.writeRawByte((int)(l >> 24) & 0xFF);
        this.writeRawByte((int)(l >> 32) & 0xFF);
        this.writeRawByte((int)(l >> 40) & 0xFF);
        this.writeRawByte((int)(l >> 48) & 0xFF);
        this.writeRawByte((int)(l >> 56) & 0xFF);
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;

        OutOfSpaceException() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }
    }
}

