/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mobileqq.pb;

import java.io.UnsupportedEncodingException;

public final class ByteStringMicro {
    private final byte[] bytes;
    public static final ByteStringMicro EMPTY = new ByteStringMicro(new byte[0]);
    private volatile int hash = 0;

    private ByteStringMicro(byte[] byArray) {
        this.bytes = byArray;
    }

    public byte byteAt(int n) {
        return this.bytes[n];
    }

    public int size() {
        return this.bytes.length;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public static ByteStringMicro copyFrom(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new ByteStringMicro(byArray2);
    }

    public static ByteStringMicro copyFrom(byte[] byArray) {
        return ByteStringMicro.copyFrom(byArray, 0, byArray.length);
    }

    public static ByteStringMicro copyFrom(String string, String string2) throws UnsupportedEncodingException {
        return new ByteStringMicro(string.getBytes(string2));
    }

    public static ByteStringMicro copyFromUtf8(String string) {
        try {
            return new ByteStringMicro(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported?");
        }
    }

    public void copyTo(byte[] byArray, int n) {
        System.arraycopy(this.bytes, 0, byArray, n, this.bytes.length);
    }

    public void copyTo(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.bytes, n, byArray, n2, n3);
    }

    public byte[] toByteArray() {
        int n = this.bytes.length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.bytes, 0, byArray, 0, n);
        return byArray;
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.bytes, string);
    }

    public String toStringUtf8() {
        try {
            return new String(this.bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported?");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteStringMicro)) {
            return false;
        }
        ByteStringMicro byteStringMicro = (ByteStringMicro)object;
        int n = this.bytes.length;
        if (n != byteStringMicro.bytes.length) {
            return false;
        }
        byte[] byArray = this.bytes;
        byte[] byArray2 = byteStringMicro.bytes;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            int n2;
            byte[] byArray = this.bytes;
            n = n2 = this.bytes.length;
            for (int i = 0; i < n2; ++i) {
                n = n * 31 + byArray[i];
            }
            if (n == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }
}

