/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.timint;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Proxy;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.tencent.TIMCallBack;
import com.tencent.TIMConnListener;
import com.tencent.TIMLogLevel;
import com.tencent.TIMManager;
import com.tencent.TIMNetworkStatus;
import com.tencent.TIMUser;
import com.tencent.TIMValueCallBack;
import com.tencent.imsdk.IMMsfCoreProxy;
import com.tencent.imsdk.IMMsfUserInfo;
import com.tencent.imsdk.QLog;
import com.tencent.imsdk.av.MultiVideoTinyId;
import com.tencent.imsdk.av.SharpTinyId;
import com.tencent.imsdk.userid.TIMTinyIdToUserId;
import com.tencent.imsdk.userid.TIMUserIdToTinyId;
import com.tencent.mobileqq.pb.ByteStringMicro;
import com.tencent.openqq.protocol.imsdk.quality_report;
import com.tencent.timint.DBHelper;
import com.tencent.timint.aa;
import com.tencent.timint.ab;
import com.tencent.timint.ad;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TIMIntManager {
    private static final String tag = "MSF.C.TIMIntManager";
    private static IMMsfCoreProxy msfCoreProxy = IMMsfCoreProxy.get();
    private TIMConnListener connListener = null;
    DBHelper dbhelper = new DBHelper(msfCoreProxy.getContext(), "QualityReport.db");
    private ExecutorService pool = Executors.newFixedThreadPool(1);
    static TIMIntManager inst = new TIMIntManager();

    private TIMIntManager() {
    }

    public void setBuglyDebugMode(boolean bl2) {
        IMMsfCoreProxy.get().enableBuglyDebugMode(bl2);
    }

    public void setAvSDKVersionToBugly(String string, String string2) {
        IMMsfCoreProxy.get().setAvSDKVersionToBugly(string, string2);
    }

    public static TIMIntManager getInstance() {
        return inst;
    }

    public TIMNetworkStatus getNetworkStatus() {
        return IMMsfCoreProxy.get().getNetworkStatus();
    }

    public void setConnectionListener(TIMConnListener tIMConnListener) {
        this.connListener = tIMConnListener;
    }

    public TIMConnListener getConnectionListener() {
        return this.connListener;
    }

    public void setReqTimeout(long l) {
        msfCoreProxy.setReqTimeout(l);
    }

    public void request(String string, byte[] byArray, TIMValueCallBack<byte[]> tIMValueCallBack) {
        IMMsfUserInfo iMMsfUserInfo = IMMsfCoreProxy.get().getAnyOnLineMsfUserInfo();
        if (iMMsfUserInfo == null || !iMMsfUserInfo.isLoggedIn()) {
            QLog.e(tag, 1, "TIMIntManager|request no user online");
            iMMsfUserInfo = new IMMsfUserInfo();
        }
        msfCoreProxy.request(iMMsfUserInfo.getUserId(), string, byArray, tIMValueCallBack);
    }

    public void request(String string, byte[] byArray, TIMValueCallBack<byte[]> tIMValueCallBack, long l) {
        IMMsfUserInfo iMMsfUserInfo = IMMsfCoreProxy.get().getAnyOnLineMsfUserInfo();
        if (iMMsfUserInfo == null || !iMMsfUserInfo.isLoggedIn()) {
            QLog.e(tag, 1, "TIMIntManager|request no user online");
            iMMsfUserInfo = new IMMsfUserInfo();
        }
        msfCoreProxy.request(iMMsfUserInfo.getUserId(), string, byArray, tIMValueCallBack, l);
    }

    public void userIdToTinyId(List<String> list, TIMValueCallBack<List<TIMUser>> tIMValueCallBack) {
        this.userIdToTinyId(list, tIMValueCallBack, 0L);
    }

    public void userIdToTinyId(List<String> object, TIMValueCallBack<List<TIMUser>> tIMValueCallBack, long l) {
        ArrayList<TIMUser> arrayList = new ArrayList<TIMUser>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            TIMUser tIMUser = new TIMUser();
            tIMUser.setAccountType(IMMsfCoreProxy.get().getUidType());
            tIMUser.setAppIdAt3rd(String.valueOf(IMMsfCoreProxy.get().getSdkAppId()));
            tIMUser.setIdentifier(string);
            arrayList.add(tIMUser);
        }
        TIMUserIdToTinyId.get().userIdToTinyId(arrayList, tIMValueCallBack, l);
    }

    public void tinyIdToUserId(List<Long> list, TIMValueCallBack<List<TIMUser>> tIMValueCallBack) {
        this.tinyIdToUserId(list, tIMValueCallBack, 0L);
    }

    public void tinyIdToUserId(List<Long> list, TIMValueCallBack<List<TIMUser>> tIMValueCallBack, long l) {
        TIMTinyIdToUserId.get().tinyIdToUserId(list, tIMValueCallBack, l);
    }

    public void requestMultiVideoApp(byte[] byArray, TIMValueCallBack<byte[]> tIMValueCallBack) {
        MultiVideoTinyId.get().requestMultiVideoApp(byArray, tIMValueCallBack, 0L);
    }

    public void requestMultiVideoApp(byte[] byArray, TIMValueCallBack<byte[]> tIMValueCallBack, long l) {
        MultiVideoTinyId.get().requestMultiVideoApp(byArray, tIMValueCallBack, l);
    }

    public void requestMultiVideoInfo(byte[] byArray, TIMValueCallBack<byte[]> tIMValueCallBack) {
        MultiVideoTinyId.get().requestMultiVideoInfo(byArray, tIMValueCallBack, 0L);
    }

    public void requestMultiVideoInfo(byte[] byArray, TIMValueCallBack<byte[]> tIMValueCallBack, long l) {
        MultiVideoTinyId.get().requestMultiVideoInfo(byArray, tIMValueCallBack, l);
    }

    public void setSharpSvrPushCallBack(TIMValueCallBack<byte[]> tIMValueCallBack) {
        SharpTinyId.get().setSharpSvrPushCallBack(tIMValueCallBack);
    }

    public void setSharpSvrRspCallBack(TIMValueCallBack<byte[]> tIMValueCallBack) {
        SharpTinyId.get().setSharpSvrRspCallBack(tIMValueCallBack);
    }

    public void requestSharpSvr(long l, byte[] byArray, TIMCallBack tIMCallBack) {
        SharpTinyId.get().requestSharpSvr(l, byArray, tIMCallBack, 0L);
    }

    public void requestSharpSvr(long l, byte[] byArray, TIMCallBack tIMCallBack, long l2) {
        SharpTinyId.get().requestSharpSvr(l, byArray, tIMCallBack, l2);
    }

    public void responseSharpSvr(long l, byte[] byArray, TIMCallBack tIMCallBack) {
        SharpTinyId.get().requestSharpSvr(l, byArray, tIMCallBack, 0L);
    }

    public void responseSharpSvr(long l, byte[] byArray, TIMCallBack tIMCallBack, long l2) {
        SharpTinyId.get().requestSharpSvr(l, byArray, tIMCallBack, l2);
    }

    public long getTinyId() {
        Object object = TIMManager.getInstance().getLoginUser();
        QLog.i(tag, 1, "getTinyId, identifier: " + (String)object);
        if (TextUtils.isEmpty((CharSequence)object)) {
            return 0L;
        }
        object = IMMsfCoreProxy.get().getMsfUserInfo((String)object);
        if (object == null || !((IMMsfUserInfo)object).isLoggedIn()) {
            QLog.e(tag, 1, "getTinyId, user not online");
            return 0L;
        }
        return ((IMMsfUserInfo)object).getTinyid();
    }

    int getDeviceType() {
        Context context = msfCoreProxy.getContext();
        if (context == null) {
            return 2;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        int n = telephonyManager.getPhoneType() != 0 && (context.getResources().getConfiguration().screenLayout & 0xF) < 3 ? 2 : 3;
        return n;
    }

    int getNetworkType() {
        int n;
        block8: {
            block6: {
                Context context;
                block9: {
                    int n2;
                    block7: {
                        n = 6;
                        context = msfCoreProxy.getContext();
                        if (context == null) {
                            return 0;
                        }
                        context = (ConnectivityManager)context.getSystemService("connectivity");
                        if ((context = context.getActiveNetworkInfo()) == null || !context.isConnected()) break block6;
                        n2 = context.getType();
                        if (n2 != 1) break block7;
                        n = 5;
                        break block8;
                    }
                    if (n2 != 0) break block8;
                    String string = Proxy.getDefaultHost();
                    if (TextUtils.isEmpty((CharSequence)string)) break block9;
                    n = 1;
                    break block8;
                }
                n = context.getSubtype();
                switch (n) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        n = 2;
                        break block8;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        n = 3;
                        break block8;
                    }
                    case 13: {
                        n = 4;
                        break block8;
                    }
                    default: {
                        n = 6;
                    }
                }
                break block8;
            }
            n = 0;
        }
        return n;
    }

    private void storeQualityReportToLocal(quality_report.ReqBody reqBody) {
        QLog.d(tag, 1, "store quality report to local");
        this.pool.execute(new aa(this, reqBody));
    }

    private void resendLocalQualityReport(String string) {
        QLog.d(tag, 1, "start to resend local quality report");
        this.pool.execute(new ab(this, string));
    }

    public void requestQualityReport(int n, byte[] byArray, TIMCallBack tIMCallBack) {
        QLog.d(tag, 1, "quality report, type: " + n + ", data: " + byArray);
        if (tIMCallBack == null) {
            return;
        }
        if (byArray == null) {
            QLog.e(tag, 1, "invalid param");
            tIMCallBack.onError(6017, "invalid param");
            return;
        }
        if (!TIMIntManager.msfCoreProxy.inited) {
            QLog.e(tag, 1, "sdk not initialized");
            tIMCallBack.onError(6013, "sdk not initialized");
            return;
        }
        quality_report.ReqBody reqBody = new quality_report.ReqBody();
        reqBody.uint32_sdkappid.set(msfCoreProxy.getSdkAppId());
        reqBody.uint64_from_uin.set(this.getTinyId());
        reqBody.uint32_timestamp.set((int)System.currentTimeMillis() / 1000);
        reqBody.uint32_seq.set(TIMIntManager.msfCoreProxy.random.nextInt());
        reqBody.msg_common_info.setHasFlag(true);
        reqBody.msg_common_info.msg_device_info.setHasFlag(true);
        reqBody.msg_common_info.msg_device_info.enum_device_type.set(this.getDeviceType());
        reqBody.msg_common_info.msg_device_info.str_device_board.set(Build.BOARD);
        reqBody.msg_common_info.msg_device_info.str_device_brand.set(Build.BRAND);
        reqBody.msg_common_info.msg_device_info.str_device_model.set(Build.MODEL);
        reqBody.msg_common_info.msg_device_info.str_device_cpu_abi.set(Build.CPU_ABI);
        reqBody.msg_common_info.msg_system_info.setHasFlag(true);
        reqBody.msg_common_info.msg_system_info.enum_os_type.set(1);
        reqBody.msg_common_info.msg_system_info.str_os_version.set(Build.VERSION.RELEASE);
        reqBody.msg_common_info.msg_network_info.setHasFlag(true);
        reqBody.msg_common_info.msg_network_info.enum_network_type.set(this.getNetworkType());
        reqBody.msg_report_content.setHasFlag(true);
        reqBody.msg_report_content.uint32_type.set(n);
        reqBody.msg_report_content.bytes_report_data.set(ByteStringMicro.copyFrom((byte[])byArray));
        this.request("AVQualityReportSvc.C2S", reqBody.toByteArray(), new ad(this, tIMCallBack, reqBody));
    }

    public void logBugly(TIMLogLevel tIMLogLevel, String string, String string2) {
        IMMsfCoreProxy.get().logBugly(tIMLogLevel, string, string2);
    }

    static /* synthetic */ void access$000(TIMIntManager tIMIntManager, quality_report.ReqBody reqBody) {
        tIMIntManager.storeQualityReportToLocal(reqBody);
    }

    static /* synthetic */ void access$100(TIMIntManager tIMIntManager, String string) {
        tIMIntManager.resendLocalQualityReport(string);
    }
}

