/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.util;

import android.text.TextUtils;
import com.tencent.imcore.IMCore;
import com.tencent.imcore.SdkReportItem;
import com.tencent.imsdk.IMMsfCoreProxy;
import com.tencent.imsdk.QLog;
import java.io.UnsupportedEncodingException;

public class QualityReportHelper {
    private static final String tag = "imsdk.QualityReportHelper";
    private int eventId;
    private int code = 0;
    private String descr = "";
    private long startTime = 0L;

    public QualityReportHelper() {
        this.startTime = System.currentTimeMillis();
    }

    public QualityReportHelper(int n) {
        this.eventId = n;
        this.startTime = System.currentTimeMillis();
    }

    public int getEventId() {
        return this.eventId;
    }

    public void setEventId(int n) {
        this.eventId = n;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n) {
        this.code = n;
    }

    public String getDescr() {
        return this.descr;
    }

    public void setDescr(String string) {
        this.descr = string;
    }

    public void init(int n, int n2, String string) {
        this.eventId = n;
        this.code = n2;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.descr = string;
        }
    }

    public void init(int n, String string) {
        this.code = n;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.descr = string;
        }
    }

    public void report() {
        try {
            SdkReportItem sdkReportItem;
            if (IMMsfCoreProxy.get().getMode() == 1) {
                sdkReportItem = new SdkReportItem();
                sdkReportItem.setEvent(this.eventId);
                sdkReportItem.setCode(this.code);
                try {
                    sdkReportItem.setDesc(this.descr.getBytes("utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
            } else {
                QLog.w(tag, 1, "ignore reportQrEvent event:" + this.eventId + "|code:" + this.code + "|descr:" + this.descr);
                return;
            }
            sdkReportItem.setStart_time_ms(this.startTime);
            sdkReportItem.setEnd_time_ms(System.currentTimeMillis());
            IMCore.get().qrReportEvent(sdkReportItem);
        }
        catch (Throwable throwable) {
            QLog.e(tag, 1, throwable.toString());
        }
    }
}

