/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.tencent.TIMLogListener;
import com.tencent.TIMManager;
import com.tencent.imsdk.IMMsfCoreProxy;
import com.tencent.imsdk.MyLinkedBlockingDeque;
import com.tencent.imsdk.QLog;
import com.tencent.imsdk.bp;
import com.tencent.imsdk.br;
import com.tencent.qalsdk.sdk.MsfSdkUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class QLogImpl {
    private static final String MEMTag = "appMemory";
    protected static int _DEFAULT_REPORTLOG_LEVEL = 4;
    private static int UIN_REPORTLOG_LEVEL = 4;
    protected static boolean isLogToFile = true;
    protected static Object formatterLock = new Object();
    private static String logPath = "";
    private static long nextHourTime;
    private static long nextSecondMinuteTime;
    private static String processName;
    private static String packageName;
    private static FileWriter writer;
    static MyLinkedBlockingDeque<String> logDeque;
    static final ReentrantLock lock;
    private static AtomicBoolean isInitLogFileDone;
    private static int myProcessId;
    private static long lastPrintMemeoryTime;
    private static AtomicBoolean isPreExceptionEnospc;
    private static TIMLogListener sdkLogLister;
    private static final int[] INTERVAL_RETRY_INIT;
    private static AtomicInteger retryInitTimes;
    private static Handler retryInitHandler;
    private static volatile Context sContext;
    public static Runnable acutualInitRunnable;
    private static String logTime;
    static String nowUsedFile;
    static long lastWriterErrorTime;
    static Thread t;
    public static final String TAG_REPORTLEVEL_DEVELOPER = "D";
    public static final String TAG_REPORTLEVEL_COLORUSER = "W";
    public static final String TAG_REPORTLEVEL_USER = "E";
    private static final String tag = "MSF.D.QLogImpl";
    static HashSet<String> colorTags;
    static long colorLogTime;

    public static void setSdkLogListener(TIMLogListener tIMLogListener) {
        sdkLogLister = tIMLogListener;
    }

    public static void init(Context context) {
        sContext = context.getApplicationContext();
        acutualInitRunnable.run();
    }

    private static String getThisHour(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy.MM.dd.HH");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        logTime = simpleDateFormat2.format(l);
        String string = simpleDateFormat.format(calendar.getTime());
        QLogImpl.setNextSecond(calendar);
        QLogImpl.setNextHour(calendar);
        return string;
    }

    private static void setNextHour(Calendar calendar) {
        calendar.add(11, 1);
        calendar.set(12, 0);
        calendar.set(13, 0);
        nextHourTime = calendar.getTimeInMillis();
    }

    private static void setNextSecond(Calendar calendar) {
        calendar.set(14, 0);
        nextSecondMinuteTime = calendar.getTimeInMillis() + 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void checkNextMinuteTime(long l) {
        if (l > nextSecondMinuteTime) {
            Object object = formatterLock;
            synchronized (object) {
                logTime = MsfSdkUtils.timeFormatter.format(l);
                nextSecondMinuteTime += 1000L;
                return;
            }
        }
    }

    public static String getLogFileName(String string) {
        return processName.replace(":", "_") + "." + string + ".log";
    }

    static synchronized void initLogFile(long l) throws IOException {
        logPath = Environment.getExternalStorageDirectory().getPath() + "/tencent/imsdklogs/" + packageName.replace(".", "/") + "/";
        File file = new File(logPath);
        if (!file.exists() && !file.mkdirs()) {
            QLog.d(tag, 1, "create imsdklogs folder failed");
        }
        nowUsedFile = logPath + QLogImpl.getLogFileName(QLogImpl.getThisHour(l));
        try {
            file = new File(nowUsedFile);
            if (!file.exists()) {
                boolean bl2 = file.createNewFile();
                QLogImpl.writeAppVersion();
                if (writer != null) {
                    writer.write(logTime + "|" + processName + "|D|MSF.D.QLogImpl" + "|" + Build.MODEL + " " + Build.VERSION.RELEASE + " create newLogFile " + file.getName() + " " + bl2 + "\n");
                    writer.flush();
                }
            } else {
                QLogImpl.writeAppVersion();
                if (writer != null) {
                    writer.write(logTime + "|" + processName + "|E|MSF.D.QLogImpl" + "|" + Build.MODEL + " " + Build.VERSION.RELEASE + "|newLogFile " + file.getName() + " is existed.\n");
                    writer.flush();
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
        }
        writer = new FileWriter(file, true);
        QLogImpl.writeAppVersion();
    }

    private static void writeAppVersion() throws IOException {
        if (writer != null && !"".equals(QLog.sBuildNumber)) {
            writer.write(logTime + "|" + processName + "|D||QQ_Version: " + QLog.sBuildNumber + "\r\n");
            writer.flush();
        }
    }

    private static void addLogItem(String string, int n, String string2, Throwable throwable) {
        if (IMMsfCoreProxy.get().getMode() == 1) {
            return;
        }
        if (!isLogToFile) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l >= nextSecondMinuteTime) {
            QLogImpl.checkNextMinuteTime(l);
        }
        if (colorLogTime != 0L && l - colorLogTime > 1800000L) {
            colorLogTime = 0L;
            colorTags.clear();
        }
        String string3 = QLogImpl.getReportLevel(n);
        long l2 = Thread.currentThread().getId();
        string = logTime + "|" + processName + "[" + myProcessId + "]|" + String.valueOf(l2) + "|" + string3 + "|" + string + "|" + string2 + "\n";
        if (throwable != null) {
            string = string + "\n" + Log.getStackTraceString((Throwable)throwable) + "\n";
        }
        if (!QLogImpl.addLogToCache(string)) {
            return;
        }
        if (null != IMMsfCoreProxy.get().getContext() && System.currentTimeMillis() - lastPrintMemeoryTime > 180000L) {
            lastPrintMemeoryTime = System.currentTimeMillis();
            QLogImpl.printMemStatus();
        }
    }

    private static void printMemStatus() {
        try {
            ActivityManager activityManager = (ActivityManager)IMMsfCoreProxy.get().getContext().getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            if (QLog.isColorLevel()) {
                QLogImpl.d(MEMTag, 2, "availMem:" + memoryInfo.availMem / 1024L / 1024L + "M lowThreshold:" + memoryInfo.threshold / 1024L / 1024L + "M");
            }
            return;
        }
        catch (Exception exception) {
            if (QLog.isColorLevel()) {
                QLogImpl.d(MEMTag, 2, "printMemError " + exception, exception);
            }
            return;
        }
    }

    private static boolean addLogToCache(String string) {
        try {
            logDeque.add(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean insertLogToCacheHead(String string) {
        try {
            logDeque.addFirst(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void writeLogToFile(String object) {
        try {
            if (!isLogToFile || !"mounted".equals(Environment.getExternalStorageState())) {
                return;
            }
            if (writer == null) {
                System.out.println("can not write log.");
                long l = System.currentTimeMillis();
                if (lastWriterErrorTime == 0L) {
                    lastWriterErrorTime = l;
                } else if (l - lastWriterErrorTime > 60000L) {
                    try {
                        QLogImpl.initLogFile(System.currentTimeMillis());
                    }
                    catch (IOException iOException) {
                        object = iOException;
                        iOException.printStackTrace();
                    }
                    lastWriterErrorTime = l;
                }
            } else {
                long l = System.currentTimeMillis();
                if (l > nextHourTime) {
                    QLogImpl.initLogFile(l);
                }
                if (lock.tryLock()) {
                    try {
                        writer.write((String)object);
                        writer.flush();
                    }
                    finally {
                        lock.unlock();
                    }
                } else if (!QLogImpl.insertLogToCacheHead((String)object)) {
                    Log.d((String)"QLogImpl", (String)"insertLogToCacheHead failed!");
                }
            }
            isPreExceptionEnospc.compareAndSet(true, false);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof IOException && throwable2.getMessage().contains("ENOSPC")) {
                if (isPreExceptionEnospc.compareAndSet(false, true)) {
                    throwable2.printStackTrace();
                    return;
                }
            } else {
                isPreExceptionEnospc.compareAndSet(true, false);
                throwable2.printStackTrace();
                try {
                    QLogImpl.initLogFile(System.currentTimeMillis());
                    return;
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    throwable3.printStackTrace();
                }
            }
            return;
        }
    }

    public static void e(String string, int n, String string2) {
        QLogImpl.e(string, n, string2, null);
    }

    public static void e(String string, int n, String string2, Throwable throwable) {
        if (UIN_REPORTLOG_LEVEL >= n || colorTags.contains(string)) {
            if (TIMManager.getInstance().getIsLogPrintEnabled()) {
                if (throwable == null) {
                    Log.e((String)string, (String)("[" + QLogImpl.getReportLevel(n) + "]" + string2));
                } else {
                    Log.e((String)string, (String)("[" + QLogImpl.getReportLevel(n) + "]" + string2), (Throwable)throwable);
                }
            }
            QLogImpl.addLogItem(string, n, string2, throwable);
            if (sdkLogLister != null) {
                sdkLogLister.log(1, string, string2);
            }
        }
    }

    public static void efile(String string, int n, String string2) {
        if (UIN_REPORTLOG_LEVEL >= n || colorTags.contains(string)) {
            QLogImpl.addLogItem(string, n, string2, null);
            if (sdkLogLister != null) {
                sdkLogLister.log(1, string, string2);
            }
        }
    }

    public static void w(String string, int n, String string2) {
        QLogImpl.w(string, n, string2, null);
    }

    public static void w(String string, int n, String string2, Throwable throwable) {
        if (UIN_REPORTLOG_LEVEL >= n || colorTags.contains(string)) {
            if (TIMManager.getInstance().getIsLogPrintEnabled()) {
                if (throwable == null) {
                    Log.w((String)string, (String)("[" + QLogImpl.getReportLevel(n) + "]" + string2));
                } else {
                    Log.w((String)string, (String)("[" + QLogImpl.getReportLevel(n) + "]" + string2), (Throwable)throwable);
                }
            }
            QLogImpl.addLogItem(string, n, string2, throwable);
            if (sdkLogLister != null) {
                sdkLogLister.log(2, string, string2);
            }
        }
    }

    public static void wfile(String string, int n, String string2) {
        if (UIN_REPORTLOG_LEVEL >= n || colorTags.contains(string)) {
            QLogImpl.addLogItem(string, n, string2, null);
            if (sdkLogLister != null) {
                sdkLogLister.log(2, string, string2);
            }
        }
    }

    public static void p(String string, String string2) {
        if (TIMManager.getInstance().getIsLogPrintEnabled()) {
            Log.d((String)tag, (String)("[s]" + string2));
        }
    }

    public static void i(String string, int n, String string2) {
        QLogImpl.i(string, n, string2, null);
    }

    public static void i(String string, int n, String string2, Throwable throwable) {
        if (UIN_REPORTLOG_LEVEL >= n || colorTags.contains(string)) {
            if (TIMManager.getInstance().getIsLogPrintEnabled()) {
                if (throwable == null) {
                    Log.i((String)string, (String)("[" + QLogImpl.getReportLevel(n) + "]" + string2));
                } else {
                    Log.i((String)string, (String)("[" + QLogImpl.getReportLevel(n) + "]" + string2), (Throwable)throwable);
                }
            }
            QLogImpl.addLogItem(string, n, string2, throwable);
            if (sdkLogLister != null) {
                sdkLogLister.log(3, string, string2);
            }
        }
    }

    public static void ifile(String string, int n, String string2) {
        if (UIN_REPORTLOG_LEVEL >= n || colorTags.contains(string)) {
            QLogImpl.addLogItem(string, n, string2, null);
            if (sdkLogLister != null) {
                sdkLogLister.log(3, string, string2);
            }
        }
    }

    public static void d(String string, int n, String string2) {
        QLogImpl.d(string, n, string2, null);
    }

    public static void d(String string, int n, String string2, Throwable throwable) {
        if (UIN_REPORTLOG_LEVEL >= n || colorTags.contains(string)) {
            if (TIMManager.getInstance().getIsLogPrintEnabled()) {
                if (throwable == null) {
                    Log.d((String)string, (String)("[" + QLogImpl.getReportLevel(n) + "]" + string2));
                } else {
                    Log.d((String)string, (String)("[" + QLogImpl.getReportLevel(n) + "]" + string2), (Throwable)throwable);
                }
            }
            QLogImpl.addLogItem(string, n, string2, throwable);
            if (sdkLogLister != null) {
                sdkLogLister.log(4, string, string2);
            }
        }
    }

    public static void dfile(String string, int n, String string2) {
        if (UIN_REPORTLOG_LEVEL >= n || colorTags.contains(string)) {
            QLogImpl.addLogItem(string, n, string2, null);
            if (sdkLogLister != null) {
                sdkLogLister.log(4, string, string2);
            }
        }
    }

    public static String getReportLevel(int n) {
        switch (n) {
            case 2: {
                return TAG_REPORTLEVEL_COLORUSER;
            }
            case 4: {
                return TAG_REPORTLEVEL_DEVELOPER;
            }
            case 1: {
                return TAG_REPORTLEVEL_USER;
            }
        }
        return TAG_REPORTLEVEL_USER;
    }

    public static String getLogPath() {
        return logPath;
    }

    public static boolean isColorUser() {
        return UIN_REPORTLOG_LEVEL > 1;
    }

    public static boolean isDEVELOPER() {
        return UIN_REPORTLOG_LEVEL >= 4;
    }

    static /* synthetic */ Context access$000() {
        return sContext;
    }

    static /* synthetic */ AtomicBoolean access$100() {
        return isInitLogFileDone;
    }

    static /* synthetic */ String access$202(String string) {
        processName = string;
        return processName;
    }

    static /* synthetic */ String access$302(String string) {
        packageName = string;
        return packageName;
    }

    static /* synthetic */ int access$402(int n) {
        myProcessId = n;
        return myProcessId;
    }

    static /* synthetic */ Handler access$500() {
        return retryInitHandler;
    }

    static /* synthetic */ AtomicInteger access$600() {
        return retryInitTimes;
    }

    static /* synthetic */ int[] access$700() {
        return INTERVAL_RETRY_INIT;
    }

    static /* synthetic */ void access$800(String string) {
        QLogImpl.writeLogToFile(string);
    }

    static {
        processName = "";
        packageName = "";
        logDeque = new MyLinkedBlockingDeque(15000);
        lock = new ReentrantLock();
        isInitLogFileDone = new AtomicBoolean(false);
        lastPrintMemeoryTime = 0L;
        isPreExceptionEnospc = new AtomicBoolean(false);
        INTERVAL_RETRY_INIT = new int[]{1, 2, 4, 8, 16, 29};
        retryInitTimes = new AtomicInteger(0);
        retryInitHandler = new Handler(Looper.getMainLooper());
        sContext = null;
        acutualInitRunnable = new bp();
        logTime = "";
        nowUsedFile = "";
        lastWriterErrorTime = 0L;
        t = new br();
        colorTags = new HashSet();
        colorLogTime = 0L;
    }

    protected static class QLogItem {
        String tag;
        String level;
        String msg;
        Throwable tr;

        public QLogItem(String string, String string2, String string3, Throwable throwable) {
            this.tag = string;
            this.level = string2;
            this.msg = string3;
            this.tr = throwable;
        }
    }

    public static class LogFile
    extends File {
        public LogFile(File file, String string) {
            super(file, string);
        }

        public LogFile(String string) {
            super(string);
        }
    }
}

