/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class MyLinkedBlockingDeque<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    transient Node<E> first;
    transient Node<E> last;
    private transient int count;
    private final int capacity;
    final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();

    public MyLinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public MyLinkedBlockingDeque(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
    }

    public MyLinkedBlockingDeque(Collection<? extends E> object) {
        this(Integer.MAX_VALUE);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (e == null) {
                    throw new NullPointerException();
                }
                if (super.linkLast(new Node(e))) continue;
                throw new IllegalStateException("Deque full");
            }
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private boolean linkFirst(Node<E> node) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.first;
        node.c = node2;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        } else {
            node2.b = node;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private boolean linkLast(Node<E> node) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.last;
        node.b = node2;
        this.last = node;
        if (this.first == null) {
            this.first = node;
        } else {
            node2.c = node;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private E unlinkFirst() {
        Node<E> node = this.first;
        if (node == null) {
            return null;
        }
        Node node2 = node.c;
        Object e = node.a;
        node.a = null;
        node.c = node;
        this.first = node2;
        if (node2 == null) {
            this.last = null;
        } else {
            node2.b = null;
        }
        --this.count;
        this.notFull.signal();
        return e;
    }

    private E unlinkLast() {
        Node<E> node = this.last;
        if (node == null) {
            return null;
        }
        Node node2 = node.b;
        Object e = node.a;
        node.a = null;
        node.b = node;
        this.last = node2;
        if (node2 == null) {
            this.first = null;
        } else {
            node2.c = null;
        }
        --this.count;
        this.notFull.signal();
        return e;
    }

    void unlink(Node<E> node) {
        Node node2 = node.b;
        Node node3 = node.c;
        if (node2 == null) {
            this.unlinkFirst();
            return;
        }
        if (node3 == null) {
            this.unlinkLast();
            return;
        }
        node2.c = node3;
        node3.b = node2;
        node.a = null;
        --this.count;
        this.notFull.signal();
    }

    public void addFirst(E e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    public void addLast(E e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    public boolean offerFirst(E object) {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = this.linkFirst((Node<E>)object);
            return bl2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean offerLast(E object) {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = this.linkLast((Node<E>)object);
            return bl2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public void putFirst(E object) throws InterruptedException {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            while (!this.linkFirst((Node<E>)object)) {
                this.notFull.await();
            }
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public void putLast(E object) throws InterruptedException {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            while (!this.linkLast((Node<E>)object)) {
                this.notFull.await();
            }
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean offerFirst(E object, long l, TimeUnit timeUnit) throws InterruptedException {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (!this.linkFirst((Node<E>)object)) {
                if (l2 <= 0L) {
                    return false;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
            return true;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean offerLast(E object, long l, TimeUnit timeUnit) throws InterruptedException {
        if (object == null) {
            throw new NullPointerException();
        }
        object = new Node<E>(object);
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (!this.linkLast((Node<E>)object)) {
                if (l2 <= 0L) {
                    return false;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
            return true;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public E removeFirst() {
        E e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    public E pollFirst() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.unlinkFirst();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public E pollLast() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.unlinkLast();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public E takeFirst() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e;
            while ((e = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public E takeLast() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e;
            while ((e = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public E pollFirst(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            E e;
            while ((e = this.unlinkFirst()) == null) {
                if (l2 <= 0L) {
                    return null;
                }
                l2 = this.notEmpty.awaitNanos(l2);
            }
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public E pollLast(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            E e;
            while ((e = this.unlinkLast()) == null) {
                if (l2 <= 0L) {
                    return null;
                }
                l2 = this.notEmpty.awaitNanos(l2);
            }
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public E getFirst() {
        E e = this.peekFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    public E getLast() {
        E e = this.peekLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    public E peekFirst() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.first == null ? null : (E)this.first.a;
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public E peekLast() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.last == null ? null : (E)this.last.a;
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean removeFirstOccurrence(Object object) {
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.a)) {
                    this.unlink(node);
                    return true;
                }
                node = node.c;
            }
            return false;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean removeLastOccurrence(Object object) {
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.last;
            while (node != null) {
                if (object.equals(node.a)) {
                    this.unlink(node);
                    return true;
                }
                node = node.b;
            }
            return false;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.offerLast(e, l, timeUnit);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.pollFirst(l, timeUnit);
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    public int remainingCapacity() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.capacity - this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            n = Math.min(n, this.count);
            for (int i = 0; i < n; ++i) {
                collection.add(this.first.a);
                this.unlinkFirst();
            }
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public void push(E e) {
        this.addFirst(e);
    }

    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.a)) {
                    return true;
                }
                node = node.c;
            }
            return false;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = new Object[this.count];
            int n = 0;
            Object object = this.first;
            while (object != null) {
                objectArray[n++] = object.a;
                object = object.c;
            }
            object = objectArray;
            return object;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (objectArray.length < this.count) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
            }
            int n = 0;
            Object object = this.first;
            while (object != null) {
                objectArray[n++] = object.a;
                object = object.c;
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            object = objectArray;
            return object;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public String toString() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object object = this.first;
            if (object == null) {
                String string = "[]";
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            while (true) {
                Object e;
                stringBuilder.append((Object)((e = ((Node)object).a) == this ? "(this Collection)" : e));
                object = ((Node)object).c;
                if (object == null) {
                    object = stringBuilder.append(']').toString();
                    return object;
                }
                stringBuilder.append(',').append(' ');
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                node.a = null;
                Node node2 = node.c;
                node.b = null;
                node.c = null;
                node = node2;
            }
            this.last = null;
            this.first = null;
            this.count = 0;
            this.notFull.signalAll();
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ac(this, 0);
    }

    public Iterator<E> descendingIterator() {
        return new ab(this, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            objectOutputStream.defaultWriteObject();
            Node<E> node = this.first;
            while (node != null) {
                objectOutputStream.writeObject(node.a);
                node = node.c;
            }
            objectOutputStream.writeObject(null);
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
    }

    private final class ab
    extends aa {
        private /* synthetic */ MyLinkedBlockingDeque a;

        private ab(MyLinkedBlockingDeque myLinkedBlockingDeque) {
            this.a = myLinkedBlockingDeque;
            super(myLinkedBlockingDeque);
        }

        @Override
        final Node<E> a() {
            return this.a.last;
        }

        @Override
        final Node<E> a(Node<E> node) {
            return node.b;
        }

        /* synthetic */ ab(MyLinkedBlockingDeque myLinkedBlockingDeque, byte by2) {
            this(myLinkedBlockingDeque);
        }
    }

    private final class ac
    extends aa {
        private /* synthetic */ MyLinkedBlockingDeque a;

        private ac(MyLinkedBlockingDeque myLinkedBlockingDeque) {
            this.a = myLinkedBlockingDeque;
            super(myLinkedBlockingDeque);
        }

        @Override
        final Node<E> a() {
            return this.a.first;
        }

        @Override
        final Node<E> a(Node<E> node) {
            return node.c;
        }

        /* synthetic */ ac(MyLinkedBlockingDeque myLinkedBlockingDeque, byte by2) {
            this(myLinkedBlockingDeque);
        }
    }

    private abstract class aa
    implements Iterator<E> {
        private Node<E> a;
        private E b;
        private Node<E> c;
        private /* synthetic */ MyLinkedBlockingDeque d;

        abstract Node<E> a();

        abstract Node<E> a(Node<E> var1);

        aa(MyLinkedBlockingDeque serializable) {
            this.d = serializable;
            serializable = ((MyLinkedBlockingDeque)serializable).lock;
            ((ReentrantLock)serializable).lock();
            try {
                this.a = this.a();
                this.b = this.a == null ? null : this.a.a;
                return;
            }
            finally {
                ((ReentrantLock)serializable).unlock();
            }
        }

        private void b() {
            ReentrantLock reentrantLock = this.d.lock;
            reentrantLock.lock();
            try {
                Node node;
                Node node2 = this.a;
                aa aa2 = this;
                while (true) {
                    Node node3;
                    if ((node3 = aa2.a(node2)) == null) {
                        node = null;
                        break;
                    }
                    if (node3.a != null) {
                        node = node3;
                        break;
                    }
                    if (node3 == node2) {
                        node = aa2.a();
                        break;
                    }
                    node2 = node3;
                }
                this.a = node;
                this.b = this.a == null ? null : this.a.a;
                return;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.a != null;
        }

        @Override
        public E next() {
            if (this.a == null) {
                throw new NoSuchElementException();
            }
            this.c = this.a;
            Object e = this.b;
            this.b();
            return e;
        }

        @Override
        public void remove() {
            Node node = this.c;
            if (node == null) {
                throw new IllegalStateException();
            }
            this.c = null;
            ReentrantLock reentrantLock = this.d.lock;
            reentrantLock.lock();
            try {
                if (node.a != null) {
                    this.d.unlink(node);
                }
                return;
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    static final class Node<E> {
        E a;
        Node<E> b;
        Node<E> c;

        Node(E e) {
            this.a = e;
        }
    }
}

