/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.IMCoreUploadLogFileOpt;
import com.tencent.IMCoreWrapper;
import com.tencent.IMErrInfo;
import com.tencent.IMFunc;
import com.tencent.TIMCallBack;
import com.tencent.TIMLogLevel;
import com.tencent.TIMLogListener;
import com.tencent.TIMManager;
import com.tencent.TIMNetworkStatus;
import com.tencent.TIMOfflinePushSettings;
import com.tencent.TIMOfflinePushToken;
import com.tencent.TIMUser;
import com.tencent.TIMValueCallBack;
import com.tencent.imcore.IMCore;
import com.tencent.imcore.IMCoreUser;
import com.tencent.imcore.QrEventType;
import com.tencent.imsdk.IMMsfUserInfo;
import com.tencent.imsdk.LogManager;
import com.tencent.imsdk.QLog;
import com.tencent.imsdk.ab;
import com.tencent.imsdk.ac;
import com.tencent.imsdk.ad;
import com.tencent.imsdk.ae;
import com.tencent.imsdk.af;
import com.tencent.imsdk.ag;
import com.tencent.imsdk.ah;
import com.tencent.imsdk.ai;
import com.tencent.imsdk.an;
import com.tencent.imsdk.as;
import com.tencent.imsdk.at;
import com.tencent.imsdk.ay;
import com.tencent.imsdk.ba;
import com.tencent.imsdk.bf;
import com.tencent.imsdk.bh;
import com.tencent.imsdk.bi;
import com.tencent.imsdk.bk;
import com.tencent.imsdk.util.QualityReportHelper;
import com.tencent.mobileqq.pb.ByteStringMicro;
import com.tencent.openqq.IMCmdListener;
import com.tencent.openqq.IMPushListener;
import com.tencent.openqq.protocol.imsdk.log_report;
import com.tencent.openqq.protocol.imsdk.stat_get_pushsound;
import com.tencent.openqq.protocol.imsdk.stat_set_pushsound;
import com.tencent.openqq.protocol.imsdk.stat_settoken;
import com.tencent.qalsdk.QALCallBack;
import com.tencent.qalsdk.QALConnListener;
import com.tencent.qalsdk.QALLogListener;
import com.tencent.qalsdk.QALPushListener;
import com.tencent.qalsdk.QALSDKManager;
import com.tencent.qalsdk.QALUserStatusListener;
import com.tencent.qalsdk.QALValueCallBack;
import com.tencent.statistics.BeaconUtil;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import tencent.tls.platform.TLSExchangeTicketListener;
import tencent.tls.platform.TLSHelper;
import tencent.tls.platform.TLSLoginHelper;

public class IMMsfCoreProxy {
    private static final String tag = "imsdk.IMMsfCoreProxy";
    public volatile boolean inited = false;
    private boolean noCrashReport = false;
    private boolean buglyInited = false;
    private boolean buglyDebugMode = true;
    private int sdkAppId = 0;
    private String sdkType = "openim";
    private int env = 0;
    private int mode = 1;
    private String accountType = "0";
    private IMMsfUserInfo onlineMsfUser = null;
    private Context context = null;
    private ConcurrentHashMap<String, IMMsfUserInfo> mutiUserMap = new ConcurrentHashMap();
    private TIMNetworkStatus networkStatus = TIMNetworkStatus.TIM_NETWORK_STATUS_DISCONNECTED;
    public Random random = new Random();
    public AtomicInteger msgSeq = new AtomicInteger(1000);
    private static String backupStorePath = Environment.getExternalStorageDirectory().getPath() + "/imsdk/files";
    private TIMLogListener logListener = null;
    private TIMLogLevel logCbLevel = TIMLogLevel.WARN;
    private ExecutorService pool = Executors.newFixedThreadPool(10);
    private long reqTimeout = 0L;
    static IMMsfCoreProxy coreProxy = new IMMsfCoreProxy();
    public static Handler mainHandler = new Handler(Looper.getMainLooper());
    private long count = 0L;
    private long ttotal = 0L;

    public Context getContext() {
        return this.context;
    }

    public boolean isLoggedIn(String string) {
        if (this.mutiUserMap.containsKey(string)) {
            return this.mutiUserMap.get(string).isLoggedIn();
        }
        return false;
    }

    public void disableCrashReport() {
        this.noCrashReport = true;
    }

    public TIMNetworkStatus getNetworkStatus() {
        return this.networkStatus;
    }

    private IMMsfCoreProxy() {
    }

    public synchronized String getSaveRootPath() {
        try {
            String string = null;
            File file = this.context.getFilesDir();
            if (file == null) {
                file = this.context.getCacheDir();
                if (file == null) {
                    QLog.d(tag, 1, "load cache dir is null");
                } else {
                    string = file.getAbsolutePath();
                    int n = string.lastIndexOf(47);
                    if (n != -1) {
                        string = string.substring(0, n);
                        string = string + "/files/";
                    }
                }
            } else {
                string = file.getAbsolutePath();
            }
            if (string == null) {
                string = backupStorePath;
                File file2 = new File(string);
                if (!file2.exists() && !file2.mkdirs()) {
                    QLog.d(tag, 1, "create backupStore folder failed");
                }
            } else {
                File file3 = new File(string);
                if (!file3.exists() && !file3.mkdirs()) {
                    QLog.d(tag, 1, "create backupStore folder failed");
                }
                if (!(file3.exists() && file3.canWrite() || (file3 = new File(string = backupStorePath)).mkdirs())) {
                    QLog.d(tag, 1, "create backupStore folder failed");
                }
            }
            QLog.d(tag, 1, "load save root dir is " + string);
            return string;
        }
        catch (Throwable throwable) {
            QLog.d(tag, 1, "getSaveRootPath error ", throwable);
            return null;
        }
    }

    public static IMMsfCoreProxy get() {
        return coreProxy;
    }

    public void setReqTimeout(long l) {
        this.reqTimeout = l;
    }

    public long getReqTimeout() {
        return this.reqTimeout;
    }

    public void setEnv(int n) {
        this.env = n;
        QALSDKManager.getInstance().setEnv(n);
    }

    public int getEnv() {
        return QALSDKManager.getInstance().getServerEnv();
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setSdkType(String string) {
        this.sdkType = string;
    }

    public String getSdkType() {
        return this.sdkType;
    }

    public static void errorOnMainThread(TIMCallBack tIMCallBack, int n, String string) {
        mainHandler.post((Runnable)new ab(tIMCallBack, n, string));
    }

    public void performanceTest(String string) {
        int n;
        byte[] byArray = new byte[]{10, -99, 1, 10, -113, 1, 10, 30, 8, -76, 4, 16, 6, 24, -16, 80, 32, -87, -58, -100, 42, 40, -4, -121, -25, -72, 5, 48, -4, -121, -25, -72, 5, 64, -58, -59, -47, 2, 18, 99, 10, 19, 26, 17, 16, -79, -49, -118, -128, 2, 40, -3, -89, -55, -101, 5, 90, 3, 87, 101, 98, 34, 74, 8, -86, -62, -50, -84, -90, -128, -128, -128, 2, 16, -11, -72, -102, -97, -90, -128, -128, -128, 2, 24, 5, 32, 5, 42, 6, -25, -117, -105, -27, -72, -90, 56, -4, -55, -36, -120, 16, 66, 3, 66, 66, 67, 98, 14, 64, 84, 71, 83, 35, 50, 52, 72, 74, 79, 82, 65, 69, 77, 104, 0, 114, 11, 16, -56, 1, 50, 6, 120, 107, 97, 122, 101, 114, 58, 0, 34, 8, 34, 2, 8, 0, 40, 0, 80, 2, 18, 9, 10, 7, 18, 5, 10, 3, 10, 1, 51, 18, 21, 13, 10, -21, 8, 25, 21, 52, -127, 0, 0, 24, -44, -1, -53, -43, -90, -95, -4, -71, -88, 1};
        long l = System.currentTimeMillis();
        ++this.count;
        for (n = 0; n < 100; ++n) {
            IMCore.get().getUser(string).manualPush(byArray);
        }
        long l2 = System.currentTimeMillis() - l;
        Log.e((String)"XIAO", (String)("totoal cost: " + l2 + "ms/" + n));
        Log.e((String)"XIAO", (String)("level: " + l2 / (long)n + "mpm"));
        this.ttotal += l2 / (long)n;
        Log.e((String)"XIAO", (String)("ave: " + this.ttotal / this.count + "mpm/" + this.count));
    }

    public void initQalSdk() {
        QALSDKManager.getInstance().setTIMLogListener((QALLogListener)new as(this));
        QALSDKManager.getInstance().setConnectionListener((QALConnListener)new at(this));
        QALSDKManager.getInstance().setUserStatusListener((QALUserStatusListener)new ay(this));
        QALSDKManager.getInstance().addPushListener("im_open_push.msg_push", (QALPushListener)new ba(this));
        QALSDKManager.getInstance().setNoGuestMode();
        QALSDKManager.getInstance().init(this.context, this.sdkAppId);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean init(Context var1_1) {
        IMCoreWrapper.get().initLogPath(var1_1);
        QLog.i("imsdk.IMMsfCoreProxy", 1, "try initIMCore msfCoreProxy|appid: " + QALSDKManager.getInstance().getQalAppId());
        if (!this.inited) {
            QLog.i("imsdk.IMMsfCoreProxy", 1, "initIMCore msfCoreProxy...");
            this.context = var1_1.getApplicationContext();
            if (IMMsfCoreProxy.get().getMode() == 1) {
                try {
                    if (!IMCoreWrapper.get().loadLib()) ** GOTO lbl23
                    if (Build.VERSION.SDK_INT >= 23 && 0 != var1_1.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE")) {
                        QLog.d("imsdk.IMMsfCoreProxy", 1, "no WRITE_EXTERNAL_STORAGE permission granted, won't log to file");
                        IMCoreWrapper.get().setLogLevel(TIMLogLevel.OFF);
                    }
                    IMCoreWrapper.get().initLog(var1_1, this.logCbLevel, this.logListener);
                    IMCoreWrapper.get().initPicCachePath(var1_1);
                    IMCoreWrapper.get().initVideoCachePath(var1_1);
                    IMCoreWrapper.get().initFileCachePath(var1_1);
                }
                catch (Throwable var1_2) {
                    this.setMode(0);
                    QLog.e("imsdk.IMMsfCoreProxy", 1, "setMode 0\n" + var1_2.getLocalizedMessage());
                    return false;
                }
            } else {
                LogManager.init();
                QLog.init(var1_1);
            }
lbl23:
            // 3 sources

            this.initQalSdk();
            this.inited = true;
            BeaconUtil.Init(var1_1);
            QLog.i("imsdk.IMMsfCoreProxy", 1, "initIMCore msfCoreProxy done: " + this);
            return true;
        }
        return false;
    }

    public synchronized boolean init(Context context, int n, String string) {
        this.sdkAppId = n;
        this.accountType = string;
        return this.init(context);
    }

    public synchronized boolean init(Context context, int n) {
        this.sdkAppId = n;
        return this.init(context);
    }

    public String getUidType() {
        return this.accountType;
    }

    public IMMsfUserInfo getAnyOnLineMsfUserInfo() {
        if (this.onlineMsfUser != null && this.onlineMsfUser.isLoggedIn()) {
            return this.onlineMsfUser;
        }
        for (Map.Entry<String, IMMsfUserInfo> entry : this.mutiUserMap.entrySet()) {
            IMMsfUserInfo object = entry.getValue();
            if (!object.isLoggedIn()) continue;
            this.onlineMsfUser = object;
            return this.onlineMsfUser;
        }
        return this.onlineMsfUser;
    }

    public int getSdkAppId() {
        return this.sdkAppId;
    }

    public IMMsfUserInfo getMsfUserInfo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = TIMManager.getInstance().getIdentification();
            QLog.w(tag, 1, "IMMsfCoreProxy|getMsfUserInfo empty, take identifer id:" + string);
        }
        if (this.mutiUserMap.containsKey(string)) {
            return this.mutiUserMap.get(string);
        }
        return null;
    }

    public ConcurrentHashMap<String, IMPushListener> getUserPushListener(String string) {
        if (this.mutiUserMap.containsKey(string)) {
            return this.mutiUserMap.get(string).getCmd2PushListener();
        }
        return null;
    }

    public ConcurrentHashMap<String, TIMValueCallBack<byte[]>> getUserPushCallBack(String string) {
        if (this.mutiUserMap.containsKey(string)) {
            return this.mutiUserMap.get(string).getCmd2PushCallBack();
        }
        return null;
    }

    public void request(String string, String string2, byte[] byArray, TIMValueCallBack<byte[]> object, long l) {
        bf bf2 = null;
        if (object != null) {
            bf2 = new bf(this, (TIMValueCallBack)object, string2);
        }
        object = TextUtils.isEmpty((CharSequence)string) ? TIMManager.getInstance().getIdentification() : string;
        QLog.d(tag, 1, "request user: " + string + "|cmd:" + string2 + "|req:" + IMFunc.byte2hex(byArray));
        QALSDKManager.getInstance().sendMsg((String)object, string2, byArray, l, (QALValueCallBack)bf2);
    }

    public void request(String string, String string2, byte[] byArray, TIMValueCallBack<byte[]> tIMValueCallBack) {
        this.request(string, string2, byArray, tIMValueCallBack, this.reqTimeout);
    }

    public void request(String string, String string2, byte[] byArray, IMCmdListener iMCmdListener) {
        bh bh2 = null;
        if (iMCmdListener != null) {
            bh2 = new bh(this, iMCmdListener);
        }
        this.request(string, string2, byArray, bh2);
    }

    private void initBugly(TIMUser tIMUser) {
        if (!this.buglyInited && !this.noCrashReport) {
            try {
                Class<?> clazz = Class.forName("com.tencent.bugly.imsdk.crashreport.CrashReport");
                Method method = clazz.getMethod("setSdkExtraData", Context.class, String.class, String.class);
                if (method != null) {
                    method.invoke(null, this.context, "900011355", TIMManager.getInstance().getVersion());
                }
                if ((method = clazz.getMethod("initCrashReport", Context.class, String.class, Boolean.TYPE)) != null) {
                    method.invoke(null, this.context, String.valueOf(this.sdkAppId), this.buglyDebugMode);
                    this.buglyInited = true;
                    QLog.i(tag, 1, "initIMCore imsdk bugly succ");
                }
                if ((method = clazz.getMethod("setUserId", String.class)) != null) {
                    method.invoke(null, String.valueOf(this.sdkAppId) + "_" + tIMUser.getAccountType() + "_" + tIMUser.getIdentifier());
                }
                return;
            }
            catch (Throwable throwable) {
                QLog.e(tag, 1, "enable crashreport failed|" + throwable.getLocalizedMessage());
            }
        }
    }

    public void setAvSDKVersionToBugly(String string, String string2) {
        if (this.noCrashReport) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            QLog.e(tag, 1, "setAvSDKVersionToBugly failed| invalid param");
            return;
        }
        try {
            GenericDeclaration genericDeclaration = Class.forName("com.tencent.bugly.imsdk.crashreport.CrashReport");
            genericDeclaration = ((Class)genericDeclaration).getMethod("setSdkExtraData", Context.class, String.class, String.class);
            if (genericDeclaration != null) {
                ((Method)genericDeclaration).invoke(null, this.context, string, string2);
            }
            return;
        }
        catch (Throwable throwable) {
            QLog.e(tag, 1, "setAvSDKVersionToBugly failed|" + throwable.getLocalizedMessage());
            return;
        }
    }

    public void enableBuglyDebugMode(boolean bl2) {
        this.buglyDebugMode = bl2;
    }

    public void logBugly(TIMLogLevel object, String string, String string2) {
        if (this.noCrashReport) {
            return;
        }
        try {
            if (object == TIMLogLevel.DEBUG) {
                object = "d";
            } else if (object == TIMLogLevel.INFO) {
                object = "i";
            } else if (object == TIMLogLevel.WARN) {
                object = "w";
            } else if (object == TIMLogLevel.ERROR) {
                object = "e";
            } else {
                return;
            }
            Class<?> clazz = Class.forName("com.tencent.bugly.imsdk.crashreport.BuglyLog");
            if (clazz != null) {
                object = clazz.getMethod((String)object, String.class, String.class);
                ((Method)object).invoke(null, string, string2);
            }
            return;
        }
        catch (Throwable throwable) {
            QLog.e(string, 1, "logBugly failed|" + throwable.getLocalizedMessage());
            return;
        }
    }

    public void login(String string, String string2, TIMCallBack tIMCallBack) {
        if (this.sdkAppId == 0) {
            IMMsfCoreProxy.errorOnMainThread(tIMCallBack, 6013, "please initIMCore SDK with sdkAppId!!!");
            return;
        }
        TIMUser tIMUser = new TIMUser();
        tIMUser.setIdentifier(string);
        tIMUser.setAccountType("0");
        tIMUser.setAppIdAt3rd("0");
        this.login(this.sdkAppId, tIMUser, string2, tIMCallBack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void login(int n, TIMUser tIMUser, String string, @NonNull TIMCallBack object) {
        if (tIMUser == null) {
            IMMsfCoreProxy.errorOnMainThread((TIMCallBack)object, 6017, "invalid TIMUser");
            return;
        }
        if (tIMUser.getIdentifier() == null || tIMUser.getIdentifier().length() <= 0) {
            IMMsfCoreProxy.errorOnMainThread((TIMCallBack)object, 6017, "invalid Identifier");
            return;
        }
        if (string == null || string.length() <= 0) {
            IMMsfCoreProxy.errorOnMainThread((TIMCallBack)object, 6017, "invalid userKey");
            return;
        }
        QualityReportHelper qualityReportHelper = new QualityReportHelper();
        QLog.i(tag, 1, "Login|1-Begin|Succ|identifer=" + tIMUser + ", sdkappid=" + n);
        QLog.i(tag, 1, "user sig: " + string);
        Object object2 = tIMUser.getIdentifier();
        object2 = this.getMsfUserInfo((String)object2);
        if (object2 == null) {
            object2 = new IMMsfUserInfo();
            ((IMMsfUserInfo)object2).setUser(tIMUser);
            this.mutiUserMap.put(tIMUser.getIdentifier(), (IMMsfUserInfo)object2);
        }
        this.sdkAppId = n;
        this.accountType = tIMUser.getAccountType();
        QALSDKManager.getInstance().setSDKAppID(n);
        this.initBugly(tIMUser);
        if (!QALSDKManager.getInstance().inited) {
            IMErrInfo iMErrInfo = new IMErrInfo(6013, "qalsdk not initialized.");
            IMMsfCoreProxy.errorOnMainThread((TIMCallBack)object, iMErrInfo.getCode(), iMErrInfo.getMsg());
            qualityReportHelper.init(QrEventType.kEventLogin.swigValue(), iMErrInfo.getCode(), iMErrInfo.getMsg());
            qualityReportHelper.report();
            return;
        }
        bi bi2 = new bi(this, tIMUser, (TIMCallBack)object, qualityReportHelper, (IMMsfUserInfo)object2);
        boolean bl2 = TLSLoginHelper.getInstance().needLogin(tIMUser.getIdentifier());
        QLog.e(tag, 1, "needLogin: " + bl2);
        if (bl2) {
            object = new bk(this, tIMUser, (IMMsfUserInfo)object2, bi2, (TIMCallBack)object, qualityReportHelper);
            int n2 = 0;
            try {
                n2 = Integer.valueOf(this.accountType);
            }
            catch (Exception exception) {
                QLog.e(tag, 1, "invalid accountType: " + this.accountType);
            }
            if (n2 > 0 && n2 < 100) {
                QLog.i(tag, 1, "3rd login:" + this.accountType + ":" + tIMUser.getAppIdAt3rd() + ":" + tIMUser.getIdentifier() + ":" + string);
                TLSHelper.getInstance().setOpenAccountInfo(n2, tIMUser.getAppIdAt3rd(), tIMUser.getIdentifier(), string);
                TLSHelper.getInstance().TLSOpenAccountLogin((TLSExchangeTicketListener)object);
                return;
            }
            TLSLoginHelper.getInstance().TLSExchangeTicket((long)n, tIMUser.getIdentifier(), string, (TLSExchangeTicketListener)object);
            return;
        }
        QLog.e(tag, 1, "tkt exist");
        try {
            object = TLSLoginHelper.getInstance().getSSOTicket(tIMUser.getIdentifier());
            ((IMMsfUserInfo)object2).setTinyid((Long)object.get("tinyID"));
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        QALSDKManager.getInstance().bindID(tIMUser.getIdentifier(), (QALCallBack)bi2);
    }

    public void logout(String string) {
        this.logout(string, null);
    }

    public void logout(String string, TIMCallBack tIMCallBack) {
        IMMsfUserInfo iMMsfUserInfo;
        QLog.i(tag, 1, "Logout|1-Begin|Succ, identifier: " + string);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            QALSDKManager.getInstance().unBindID(string, (QALCallBack)new ac(this, tIMCallBack));
        }
        if ((iMMsfUserInfo = this.getMsfUserInfo(string)) == null) {
            QLog.e(tag, 1, "user logout error user not found: " + string);
            if (tIMCallBack != null) {
                tIMCallBack.onError(6014, "current user not login. id: " + string);
                QLog.e(tag, 1, "Logout|2-Callback|Succ|user not found");
            }
            return;
        }
        TIMUser tIMUser = iMMsfUserInfo.getUser();
        QLog.i(tag, 1, "user logout: " + tIMUser);
        if (tIMUser != null && IMCoreWrapper.get().isReady()) {
            IMCoreUser iMCoreUser = TIMManager.getInstanceById(tIMUser.getIdentifier()).getCoreUser();
            iMCoreUser.cancelAllPicupTask();
            iMCoreUser.getFriendShipMgr().clearAllData();
            if (this.mode == 1) {
                IMCore.get().unInitUser(tIMUser.getIdentifier());
            }
            if (null == this.getAnyOnLineMsfUserInfo()) {
                IMCoreWrapper.get().setReady(false);
            }
        }
        iMMsfUserInfo.setTinyid(0L);
        iMMsfUserInfo.setIsLoggedIn(false);
        if (tIMCallBack != null) {
            if (string == null) {
                tIMCallBack.onSuccess();
                QLog.i(tag, 1, "Logout|2-Callback|Succ|logout succ");
                return;
            }
        } else if (string == null) {
            QLog.e(tag, 1, "Logout|2-Callback|Fail|user not set logout callback");
        }
    }

    public void setTIMLogListener(TIMLogListener tIMLogListener) {
        this.logListener = tIMLogListener;
        QLog.setSdkLogListener(tIMLogListener);
    }

    public void setTIMLogCbLevel(TIMLogLevel tIMLogLevel) {
        this.logCbLevel = tIMLogLevel;
    }

    public void setOfflinePushToken(String object, TIMOfflinePushToken tIMOfflinePushToken, TIMCallBack tIMCallBack) {
        QualityReportHelper qualityReportHelper = new QualityReportHelper(QrEventType.kEventSetToken.swigValue());
        if (!this.isLoggedIn((String)object)) {
            IMErrInfo iMErrInfo = new IMErrInfo(6014, "current user not login. id: " + (String)object);
            QLog.e(tag, 1, iMErrInfo.getMsg());
            qualityReportHelper.init(iMErrInfo.getCode(), iMErrInfo.getMsg());
            qualityReportHelper.report();
            if (tIMCallBack != null) {
                tIMCallBack.onError(iMErrInfo.getCode(), iMErrInfo.getMsg());
            }
            return;
        }
        if (tIMOfflinePushToken == null || TextUtils.isEmpty((CharSequence)tIMOfflinePushToken.getToken()) || tIMOfflinePushToken.getBussid() == 0L) {
            IMErrInfo iMErrInfo = new IMErrInfo(6017, "setToken failed, busisid=0 or token is empty");
            QLog.e(tag, 1, iMErrInfo.getMsg());
            qualityReportHelper.init(iMErrInfo.getCode(), iMErrInfo.getMsg());
            qualityReportHelper.report();
            if (tIMCallBack != null) {
                tIMCallBack.onError(iMErrInfo.getCode(), iMErrInfo.getMsg());
            }
            return;
        }
        QLog.i(tag, 1, "setToken, token: " + tIMOfflinePushToken.getToken() + "|bussid: " + tIMOfflinePushToken.getBussid() + "|vendor: " + Build.MANUFACTURER);
        String string = Build.MANUFACTURER;
        int n = string.toLowerCase(Locale.ENGLISH).contains("xiaomi") ? 2000 : (string.toLowerCase(Locale.ENGLISH).contains("huawei") ? 2001 : 2002);
        stat_settoken.ReqBody reqBody = new stat_settoken.ReqBody();
        reqBody.uint32_busiid.set((int)tIMOfflinePushToken.getBussid());
        try {
            reqBody.bytes_token_id.set(ByteStringMicro.copyFrom((byte[])tIMOfflinePushToken.getToken().getBytes("utf-8")));
        }
        catch (Throwable throwable) {
            object = new IMErrInfo(6002, "setToken failed, req serialize failed");
            QLog.e(tag, 1, ((IMErrInfo)object).getMsg());
            qualityReportHelper.init(((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.report();
            QLog.e(tag, 1, ((IMErrInfo)object).getMsg());
            if (tIMCallBack != null) {
                tIMCallBack.onError(((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            }
            return;
        }
        reqBody.uint32_inst_type.set(n);
        reqBody.uint32_enter_version.set(this.getSdkAppId());
        reqBody.uint32_push_msg.set(1);
        this.request((String)object, "im_open_status.stat_settoken", reqBody.toByteArray(), new ad(this, tIMCallBack, qualityReportHelper));
    }

    private void saveOfflinePushSettingsToLocal(String string, TIMOfflinePushSettings tIMOfflinePushSettings) {
        if (this.context == null || tIMOfflinePushSettings == null) {
            QLog.e(tag, 1, "save offlinePushSettings failed");
            return;
        }
        SharedPreferences sharedPreferences = this.context.getSharedPreferences("OfflinePushSettings", 0);
        sharedPreferences = sharedPreferences.edit();
        sharedPreferences.putBoolean(string + "_IS_ENABLED", tIMOfflinePushSettings.isEnabled());
        sharedPreferences.putString(string + "_C2C_SOUND", tIMOfflinePushSettings.getC2cMsgRemindSound() != null ? tIMOfflinePushSettings.getC2cMsgRemindSound().toString() : "");
        sharedPreferences.putString(string + "_GRP_SOUND", tIMOfflinePushSettings.getGroupMsgRemindSound() != null ? tIMOfflinePushSettings.getGroupMsgRemindSound().toString() : "");
        sharedPreferences.apply();
    }

    public boolean getOfflinePushSettingsFromLocal(Context object, String string, TIMOfflinePushSettings tIMOfflinePushSettings) {
        if (tIMOfflinePushSettings == null || object == null) {
            return false;
        }
        if (!(object = object.getSharedPreferences("OfflinePushSettings", 0)).contains(string + "_IS_ENABLED")) {
            return false;
        }
        tIMOfflinePushSettings.setEnabled(object.getBoolean(string + "_IS_ENABLED", false));
        String string2 = object.getString(string + "_C2C_SOUND", "");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            tIMOfflinePushSettings.setC2cMsgRemindSound(Uri.parse((String)string2));
        }
        if (!TextUtils.isEmpty((CharSequence)(object = object.getString(string + "_GRP_SOUND", "")))) {
            tIMOfflinePushSettings.setGroupMsgRemindSound(Uri.parse((String)object));
        }
        return true;
    }

    public boolean isOfflinePushEnabled(Context context, String string) {
        if (context == null) {
            return false;
        }
        if ((context = context.getSharedPreferences("OfflinePushSettings", 0)).contains(string + "_IS_ENABLED")) {
            return context.getBoolean(string + "_IS_ENABLED", false);
        }
        return true;
    }

    public void initOfflinePushSettings(String string, TIMOfflinePushSettings tIMOfflinePushSettings) {
        if (!this.isLoggedIn(string)) {
            QLog.e(tag, 1, "initOfflinePushSettings failed, user not online");
            return;
        }
        if (tIMOfflinePushSettings == null) {
            QLog.e(tag, 1, "initOfflinePushSettings failed, invalid param");
            return;
        }
        stat_set_pushsound.ReqBody reqBody = new stat_set_pushsound.ReqBody();
        reqBody.uint32_platform.set(2);
        reqBody.msg_config.setHasFlag(true);
        reqBody.msg_config.uint32_openpush.set(tIMOfflinePushSettings.isEnabled() ? 1 : 2);
        try {
            String string2 = "";
            if (tIMOfflinePushSettings.getC2cMsgRemindSound() != null) {
                string2 = tIMOfflinePushSettings.getC2cMsgRemindSound().toString();
            }
            reqBody.msg_config.bytes_c2c_sound.set(ByteStringMicro.copyFrom((byte[])string2.getBytes("utf-8")));
            string2 = "";
            if (tIMOfflinePushSettings.getGroupMsgRemindSound() != null) {
                string2 = tIMOfflinePushSettings.getGroupMsgRemindSound().toString();
            }
            reqBody.msg_config.bytes_grp_sound.set(ByteStringMicro.copyFrom((byte[])string2.getBytes("utf-8")));
        }
        catch (Throwable throwable) {
            QLog.e(tag, 1, "initOfflinePushSettings failed, form req failed: " + throwable.getLocalizedMessage());
            return;
        }
        this.request(string, "im_open_status.stat_set_pushsound", reqBody.toByteArray(), new ae(this, string, tIMOfflinePushSettings));
    }

    public void getOfflinePushSettings(String string, TIMValueCallBack<TIMOfflinePushSettings> tIMValueCallBack) {
        if (tIMValueCallBack == null) {
            return;
        }
        if (!this.isLoggedIn(string)) {
            QLog.e(tag, 1, "getOfflinePushSettings failed, user not online: " + string);
            tIMValueCallBack.onError(6014, "current user not login. id: " + string);
            return;
        }
        stat_get_pushsound.ReqBody reqBody = new stat_get_pushsound.ReqBody();
        reqBody.uint32_platform.set(2);
        reqBody.uint64_tinyid.set(IMMsfCoreProxy.get().getMsfUserInfo(string).getTinyid());
        IMMsfCoreProxy.get().request(string, "im_open_status.stat_get_pushsound", reqBody.toByteArray(), new af(this, tIMValueCallBack, string));
    }

    private void logReport(String string, String string2, int n, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        log_report.ReqBody reqBody = new log_report.ReqBody();
        reqBody.bytes_log_id.set(ByteStringMicro.copyFromUtf8((String)string2));
        if (n != 0) {
            reqBody.uint32_err_code.set(n);
            reqBody.bytes_err_msg.set(ByteStringMicro.copyFromUtf8((String)string3));
        }
        this.request(string, "open_logs.report", reqBody.toByteArray(), new ag(this));
    }

    public void stopQALService() {
        QALSDKManager.getInstance().stopQALService();
    }

    public boolean uploadLogFile(String string, IMCoreUploadLogFileOpt object) {
        Object object2 = IMMsfCoreProxy.get().getMsfUserInfo(string);
        if (object2 == null) {
            QLog.e(tag, 1, "uploadLogFile->find user failed: " + string);
            return false;
        }
        String string2 = ((IMCoreUploadLogFileOpt)object).getLogId();
        HashMap<String, String> hashMap = ((IMCoreUploadLogFileOpt)object).getFilePath();
        Object object3 = ((IMCoreUploadLogFileOpt)object).getTag();
        Object object4 = ((IMCoreUploadLogFileOpt)object).getRelativePath();
        long l = ((IMCoreUploadLogFileOpt)object).getLogSize() * 0x100000L;
        if (l == 0L) {
            QLog.e(tag, 1, "uploadLogFile->failed: invalid parameters, request size 0");
            IMMsfCoreProxy.get().logReport(string, string2, 6017, "invalid parameters, request size 0");
            return false;
        }
        try {
            long l2;
            String string3;
            object = "sdklog";
            String string4 = "8whnoADaf5USGpmmio7JATVQWrj5BaSz";
            String string5 = "AKIDIsvZoS8DRMqxDPh0wQ5B3sF6SlCINL0G";
            Object object5 = "web.file.myqcloud.com/files/v1";
            String string6 = "imsdk";
            String string7 = UUID.randomUUID().toString();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                object2 = string2 + ".lz4";
            } else {
                int n = ((String)((Object)hashMap)).lastIndexOf(46);
                string3 = ((String)((Object)hashMap)).substring(n - 8, n);
                object2 = (String)object3 + "_" + string3 + "_" + ((IMMsfUserInfo)object2).getTinyid() + ".lz4";
            }
            Object object6 = object2;
            string3 = "/" + 10002868 + "/" + (String)object + "/" + string6 + "/" + (String)object6;
            object2 = "http://" + (String)object5 + string3;
            if (TextUtils.isEmpty((CharSequence)object4)) {
                hashMap = new RandomAccessFile((String)((Object)hashMap), "r");
            } else {
                String string8 = Environment.getExternalStorageDirectory().getPath();
                hashMap = new RandomAccessFile(string8 + "/" + (String)object4, "r");
            }
            long l3 = ((RandomAccessFile)((Object)hashMap)).length();
            if (l3 > l) {
                ((RandomAccessFile)((Object)hashMap)).seek(l3 - l);
                l2 = l;
            } else {
                l2 = (int)l3;
            }
            object3 = new byte[(int)l2];
            ((RandomAccessFile)((Object)hashMap)).read((byte[])object3);
            ((RandomAccessFile)((Object)hashMap)).close();
            hashMap = new String((byte[])object3);
            hashMap = (HashMap<String, String>)IMFunc.gzCompress((String)((Object)hashMap));
            object3 = IMFunc.getParamBytes(string7, "sha", "sha", IMFunc.calcSHA((byte[])hashMap));
            object4 = IMFunc.getParamBytes(string7, "biz_attr", "biz_attr", "");
            hashMap = (HashMap<String, String>)IMFunc.getParamBytes(string7, "filecontent", (String)object6, (byte[])hashMap);
            byte[] byArray = IMFunc.getParamBytes(string7, "op", "op", "upload");
            byte[] byArray2 = ("--" + string7 + "--\r\n").getBytes();
            object5 = new byte[((Object)object3).length + ((Object)object4).length + ((Object)hashMap).length + byArray.length + byArray2.length];
            System.arraycopy(object3, 0, object5, 0, ((Object)object3).length);
            System.arraycopy(object4, 0, object5, ((Object)object3).length, ((Object)object4).length);
            System.arraycopy(hashMap, 0, object5, ((Object)object3).length + ((Object)object4).length, ((Object)hashMap).length);
            System.arraycopy(byArray, 0, object5, ((Object)object3).length + ((Object)object4).length + ((Object)hashMap).length, byArray.length);
            System.arraycopy(byArray2, 0, object5, ((Object)object3).length + ((Object)object4).length + ((Object)hashMap).length + byArray.length, byArray2.length);
            hashMap = new HashMap<String, String>();
            hashMap.put("Authorization", IMFunc.appSignature(10002868, string5, string4, 60L, string3, (String)object));
            hashMap.put("Content-Type", "multipart/form-data; boundary=" + string7);
            QLog.i(tag, 1, "uploadLogFile->request: " + (String)object2);
            IMFunc.httpPostReq((String)object2, (byte[])object5, hashMap, new ah(this, (String)object6, string, string2));
            return true;
        }
        catch (Throwable throwable) {
            QLog.e(tag, 1, "uploadLogFile->error: " + IMFunc.getExceptionInfo(throwable));
            IMMsfCoreProxy.get().logReport(string, string2, 6022, IMFunc.getExceptionInfo(throwable));
            return false;
        }
    }

    public void downloadToFile(List<String> object, String string, TIMCallBack tIMCallBack, QualityReportHelper qualityReportHelper) {
        if (object == null || object.isEmpty()) {
            object = new IMErrInfo(6021, "urls is empty");
            tIMCallBack.onError(((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.init(((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.report();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            object = new IMErrInfo(6017, "invalid path");
            tIMCallBack.onError(((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.init(((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.report();
            return;
        }
        if (!IMCoreWrapper.get().isReady()) {
            object = new IMErrInfo(6013, "sdk not initialized or not logged in.");
            tIMCallBack.onError(((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.init(((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.report();
            return;
        }
        new Thread(new ai(this, (List)object, tIMCallBack, qualityReportHelper, string)).start();
    }

    public void downloadToBuff(List<String> list, TIMValueCallBack<byte[]> tIMValueCallBack, QualityReportHelper qualityReportHelper) {
        if (list == null || list.isEmpty()) {
            IMErrInfo iMErrInfo = new IMErrInfo(6021, "urls is empty");
            tIMValueCallBack.onError(iMErrInfo.getCode(), iMErrInfo.getMsg());
            qualityReportHelper.init(iMErrInfo.getCode(), iMErrInfo.getMsg());
            qualityReportHelper.report();
            return;
        }
        if (!IMCoreWrapper.get().isReady()) {
            IMErrInfo iMErrInfo = new IMErrInfo(6013, "sdk not initialized or not logged in.");
            tIMValueCallBack.onError(iMErrInfo.getCode(), iMErrInfo.getMsg());
            qualityReportHelper.init(iMErrInfo.getCode(), iMErrInfo.getMsg());
            qualityReportHelper.report();
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        new Thread(new an(this, list, handler, tIMValueCallBack, qualityReportHelper)).start();
    }

    static /* synthetic */ TIMNetworkStatus access$002(IMMsfCoreProxy iMMsfCoreProxy, TIMNetworkStatus tIMNetworkStatus) {
        iMMsfCoreProxy.networkStatus = tIMNetworkStatus;
        return iMMsfCoreProxy.networkStatus;
    }

    static /* synthetic */ int access$100(IMMsfCoreProxy iMMsfCoreProxy) {
        return iMMsfCoreProxy.mode;
    }

    static /* synthetic */ Context access$200(IMMsfCoreProxy iMMsfCoreProxy) {
        return iMMsfCoreProxy.context;
    }

    static /* synthetic */ ExecutorService access$300(IMMsfCoreProxy iMMsfCoreProxy) {
        return iMMsfCoreProxy.pool;
    }

    static /* synthetic */ ConcurrentHashMap access$400(IMMsfCoreProxy iMMsfCoreProxy) {
        return iMMsfCoreProxy.mutiUserMap;
    }

    static /* synthetic */ void access$500(IMMsfCoreProxy iMMsfCoreProxy, String string, TIMOfflinePushSettings tIMOfflinePushSettings) {
        iMMsfCoreProxy.saveOfflinePushSettingsToLocal(string, tIMOfflinePushSettings);
    }

    static /* synthetic */ void access$600(IMMsfCoreProxy iMMsfCoreProxy, String string, String string2, int n, String string3) {
        iMMsfCoreProxy.logReport(string, string2, n, string3);
    }
}

