/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.av;

import android.util.Log;
import com.tencent.av.NetworkUtil;
import com.tencent.av.PingResult;
import com.tencent.av.ServerInfo;
import com.tencent.av.TIMPingCallBack;
import com.tencent.av.aa;
import com.tencent.av.ab;
import com.tencent.imsdk.IMMsfCoreProxy;
import com.tencent.imsdk.IMMsfUserInfo;
import com.tencent.imsdk.QLog;
import com.tencent.imsdk.av.MultiVideoTinyId;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PingUtil
implements Runnable {
    private static final String tag = "av.PingUtil";
    private static final PingUtil instance = new PingUtil();
    private volatile boolean running;
    Map<Integer, Calendar> timeRecord = new HashMap<Integer, Calendar>();
    List<ServerInfo> server = new ArrayList<ServerInfo>();
    List<PingResult> pingResults = new ArrayList<PingResult>();
    byte[] data;
    DatagramChannel channel;
    int interval;
    int pkgNum;
    int timeout;
    InetAddress client;
    TIMPingCallBack callback;
    private String identifer = "";

    private PingUtil() {
    }

    public static PingUtil getInstance() {
        return instance;
    }

    public void setIdentifer(String string) {
        this.identifer = string;
    }

    public void init(byte[] byArray, TIMPingCallBack tIMPingCallBack) {
        try {
            byte[] byArray2 = new byte[4];
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.position(0);
            short s = byteBuffer.getShort();
            int n = byteBuffer.getInt();
            byteBuffer.getShort();
            byteBuffer.position(18);
            byteBuffer.get();
            byteBuffer.get(byArray2);
            InetAddress inetAddress = InetAddress.getByAddress(byArray2);
            byteBuffer.get();
            byteBuffer.getShort();
            byteBuffer.getShort();
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            if (n5 > byteBuffer.remaining()) {
                return;
            }
            byte[] byArray3 = new byte[n5];
            byteBuffer.get(byArray3);
            byteBuffer.get();
            int n6 = byteBuffer.get();
            ArrayList<ServerInfo> arrayList = new ArrayList<ServerInfo>();
            for (int i = 0; i < n6; ++i) {
                ServerInfo serverInfo = new ServerInfo();
                for (int j = 3; j >= 0; --j) {
                    byArray2[j] = byteBuffer.get();
                }
                serverInfo.ip = InetAddress.getByAddress(byArray2);
                serverInfo.port = byteBuffer.getShort();
                serverInfo.setIDC(byteBuffer.get());
                serverInfo.setISP(byteBuffer.get());
                arrayList.add(serverInfo);
            }
            Log.d((String)tag, (String)("subcmd:" + s + "|retcode:" + n + "|servers:" + arrayList.size()));
            byteBuffer.clear();
            this.server = arrayList;
            this.data = byArray3;
            this.interval = n2;
            this.pkgNum = n4;
            this.timeout = n3;
            this.callback = tIMPingCallBack;
            this.client = inetAddress;
            if (this.callback != null) {
                this.callback.onStart(arrayList);
            }
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    private void send(ServerInfo serverInfo) throws IOException, InterruptedException {
        for (int i = 0; i < this.pkgNum; ++i) {
            if (!this.running) {
                return;
            }
            byte[] byArray = this.GetPingPackage(this.data);
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.flip();
            try {
                this.channel.write(byteBuffer);
            }
            catch (Exception exception) {}
            byteBuffer.clear();
            if (this.callback != null) {
                this.callback.onProgress(serverInfo, this.pkgNum, i);
            }
            Thread.sleep(this.interval);
        }
    }

    public void stop() {
        this.server.clear();
        this.pingResults.clear();
        this.timeRecord.clear();
        this.running = false;
    }

    public void start() {
        new Thread(instance).start();
        this.running = true;
    }

    @Override
    public void run() {
        try {
            if (this.server == null || this.server.size() == 0) {
                return;
            }
            for (ServerInfo serverInfo : this.server) {
                if (!this.running) {
                    return;
                }
                Object object = new ArrayList();
                Object object2 = Selector.open();
                this.channel = DatagramChannel.open();
                this.channel.connect(new InetSocketAddress(serverInfo.ip, (int)serverInfo.port));
                this.channel.configureBlocking(false);
                this.channel.register((Selector)object2, 1);
                Thread thread = new Thread(new aa(this, (Selector)object2, (List)object));
                thread.start();
                this.send(serverInfo);
                if (!this.running) {
                    return;
                }
                for (int i = 0; i < this.timeout / 100 && object.size() != this.pkgNum; ++i) {
                    Thread.sleep(100L);
                }
                ((Selector)object2).close();
                long l = 0L;
                long l2 = 0L;
                object = object.iterator();
                while (object.hasNext()) {
                    object2 = (Long)object.next();
                    if ((Long)object2 >= (long)this.timeout) continue;
                    ++l;
                    l2 += ((Long)object2).longValue();
                }
                object = new PingResult();
                new PingResult().server = serverInfo;
                ((PingResult)object).receivePkg = (int)l;
                ((PingResult)object).totalPkg = this.pkgNum;
                ((PingResult)object).useTime = l == 0L ? Integer.MAX_VALUE : (int)(l2 / l);
                this.pingResults.add((PingResult)object);
                if (this.callback == null) continue;
                this.callback.onSuccess((PingResult)object);
            }
            this.logResult();
            this.reportToServer();
            if (this.callback != null) {
                this.callback.onFinish();
            }
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
    }

    public void logResult() {
        for (PingResult pingResult : this.pingResults) {
            QLog.e(tag, 1, "serverIp:" + pingResult.server.ip.toString() + " useTime:" + pingResult.useTime + " totalPkg:" + pingResult.totalPkg + " receivePkg:" + pingResult.receivePkg);
        }
    }

    public byte[] GetPingPackage(byte[] byArray) {
        int n = 46 + byArray.length + 1;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.put((byte)2);
        byteBuffer.put(this.getLongConnUdtDataHeadV2((short)n, (short)469));
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)3);
        return byteBuffer.array();
    }

    private byte[] getLongConnUdtDataHeadV2(short s, short s2) {
        Object object = IMMsfCoreProxy.get().getMsfUserInfo(this.identifer);
        long l = 0L;
        if (object != null) {
            l = ((IMMsfUserInfo)object).getTinyid();
        }
        object = ByteBuffer.allocate(41);
        int n = IMMsfCoreProxy.get().random.nextInt();
        ((ByteBuffer)object).putShort(s);
        ((ByteBuffer)object).putInt(n);
        ((ByteBuffer)object).putShort(s2);
        ((ByteBuffer)object).putLong(l);
        ((ByteBuffer)object).putInt(0);
        ((ByteBuffer)object).putInt(0);
        ((ByteBuffer)object).putShort((short)0);
        ((ByteBuffer)object).putLong(0L);
        ((ByteBuffer)object).put((byte)0);
        ((ByteBuffer)object).putInt(n);
        ((ByteBuffer)object).putShort((short)0);
        Calendar calendar = Calendar.getInstance();
        this.timeRecord.put(n, calendar);
        QLog.e(tag, 1, "send seq " + n + " time " + calendar.getTimeInMillis());
        return ((ByteBuffer)object).array();
    }

    private void reportToServer() {
        int n = 19 + this.pingResults.size() * 30 + 2 + 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        int n2 = IMMsfCoreProxy.get().getSdkAppId();
        int n3 = this.interval;
        byte by2 = (byte)this.pingResults.size();
        byteBuffer.clear();
        byteBuffer.put((byte)2).put((byte)1).putShort((short)7).putShort((short)6).putInt(n2).putInt(23678484).putInt(n3).put(by2);
        for (PingResult pingResult : this.pingResults) {
            byteBuffer.put(pingResult.server.ip.getAddress());
            byteBuffer.putShort(pingResult.server.port);
            byteBuffer.put(pingResult.server.getIdcNo());
            byteBuffer.put(pingResult.server.getIspNo());
            byteBuffer.put(this.client.getAddress());
            byteBuffer.putInt(this.pkgNum);
            byteBuffer.putInt(pingResult.receivePkg);
            byteBuffer.putInt(pingResult.useTime);
            byteBuffer.putInt(0);
            byteBuffer.putShort((short)0);
        }
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)0);
        Object object = NetworkUtil.formReq(this.identifer, 210, 0, "", byteBuffer.array());
        MultiVideoTinyId.get().requestMultiVideoInfo((byte[])object, new ab(this));
        this.running = false;
    }
}

