/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import android.text.TextUtils;
import com.tencent.TIMFriendAllowType;
import com.tencent.TIMFriendGenderType;
import com.tencent.imcore.BytesMap;
import com.tencent.imcore.BytesVecFetcher;
import com.tencent.imcore.FriendProfile;
import com.tencent.imcore.MapKeyFetcher;
import com.tencent.imsdk.QLog;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TIMUserProfile {
    private String identifier = "";
    private String nickName = "";
    private String allowType = "";
    private String remark = "";
    private String faceUrl = "";
    private String selfSignature = "";
    private List<String> groupNames = new ArrayList<String>();
    private Map<String, byte[]> customInfo = new HashMap<String, byte[]>();
    private long gender = 0L;
    private long birthday = 0L;
    private long language = 0L;
    private String location = "";

    public TIMUserProfile(FriendProfile object) {
        if (object == null) {
            return;
        }
        this.identifier = ((FriendProfile)object).getSIdentifier();
        this.allowType = ((FriendProfile)object).getSAllowType();
        try {
            this.nickName = new String(((FriendProfile)object).getSNickname(), "utf-8");
            this.remark = new String(((FriendProfile)object).getSRemark(), "utf-8");
            this.faceUrl = new String(((FriendProfile)object).getSFaceURL(), "utf-8");
            this.selfSignature = new String(((FriendProfile)object).getSSelfSignature(), "utf-8");
            this.gender = ((FriendProfile)object).getEGender().swigValue();
            this.birthday = ((FriendProfile)object).getUBirthDay();
            this.language = ((FriendProfile)object).getULanguage();
            this.location = new String(((FriendProfile)object).getSLocation(), "utf-8");
            int n = (int)((FriendProfile)object).getSGroupNames().size();
            Object object2 = new BytesVecFetcher(((FriendProfile)object).getSGroupNames());
            this.groupNames.clear();
            for (int i = 0; i < n; ++i) {
                this.groupNames.add(new String(((BytesVecFetcher)object2).getBytesByIndex(i), "utf-8"));
            }
            BytesMap bytesMap = ((FriendProfile)object).getCustom_info();
            object = new MapKeyFetcher();
            ((MapKeyFetcher)object).fetchMapKeys(bytesMap);
            n = 0;
            while ((long)n < bytesMap.size()) {
                try {
                    this.getCustomInfo().put(new String(((MapKeyFetcher)object).getKey(n), "utf-8"), ((MapKeyFetcher)object).getValue(bytesMap, n));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object2 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                ++n;
            }
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            return;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getFaceUrl() {
        return this.faceUrl;
    }

    public String getSelfSignature() {
        return this.selfSignature;
    }

    public TIMFriendAllowType getAllowType() {
        QLog.e("TIMUserProfile", 1, "allowType " + this.allowType);
        if (this.allowType.equals(TIMFriendAllowType.TIM_FRIEND_ALLOW_ANY.getType())) {
            return TIMFriendAllowType.TIM_FRIEND_ALLOW_ANY;
        }
        if (this.allowType.equals(TIMFriendAllowType.TIM_FRIEND_DENY_ANY.getType())) {
            return TIMFriendAllowType.TIM_FRIEND_DENY_ANY;
        }
        if (this.allowType.equals(TIMFriendAllowType.TIM_FRIEND_NEED_CONFIRM.getType())) {
            return TIMFriendAllowType.TIM_FRIEND_NEED_CONFIRM;
        }
        return TIMFriendAllowType.TIM_FRIEND_INVALID;
    }

    public String getRemark() {
        return this.remark;
    }

    public List<String> getFriendGroups() {
        return this.groupNames;
    }

    public Map<String, byte[]> getCustomInfo() {
        return this.customInfo;
    }

    public TIMFriendGenderType getGender() {
        for (TIMFriendGenderType tIMFriendGenderType : TIMFriendGenderType.values()) {
            if (tIMFriendGenderType.getValue() != this.gender) continue;
            return tIMFriendGenderType;
        }
        return TIMFriendGenderType.Unknow;
    }

    void setGender(long l) {
        this.gender = l;
    }

    public long getBirthday() {
        return this.birthday;
    }

    void setBirthday(long l) {
        this.birthday = l;
    }

    public long getLanguage() {
        return this.language;
    }

    void setLanguage(long l) {
        this.language = l;
    }

    public String getLocation() {
        return this.location;
    }

    void setLocation(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.location = string;
        }
    }
}

