/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.tencent.TIMConversationType;
import com.tencent.TIMCustomElem;
import com.tencent.TIMElem;
import com.tencent.TIMElemType;
import com.tencent.TIMGroupReceiveMessageOpt;
import com.tencent.TIMLocationElem;
import com.tencent.TIMMessage;
import com.tencent.TIMMessageOfflinePushSettings;
import com.tencent.TIMOfflinePushSettings;
import com.tencent.TIMTextElem;
import com.tencent.imsdk.IMMsfCoreProxy;

public class TIMOfflinePushNotification {
    private String title;
    private String content;
    private TIMConversationType conversationType;
    private String conversationId;
    private String senderIdentifier;
    private String senderNickName;
    private String groupName;
    private byte[] ext;
    private Uri sound;
    private long opt = 0L;
    private String tag;
    private boolean isValid = false;
    private String identifier = "";

    protected TIMOfflinePushNotification() {
    }

    protected TIMOfflinePushNotification(Context context, TIMMessage tIMMessage) {
        Object object;
        String string = "";
        Object object2 = tIMMessage.getConversation().getType();
        if (object2 != TIMConversationType.C2C && object2 != TIMConversationType.Group) {
            this.isValid = false;
            return;
        }
        if (tIMMessage.getMsg().lifetime() == 0L) {
            this.isValid = false;
            return;
        }
        object2 = "";
        Object object3 = tIMMessage.getOfflinePushSettings();
        if (object3 != null) {
            if (!((TIMMessageOfflinePushSettings)object3).isEnabled()) {
                this.isValid = false;
                return;
            }
            this.setSound(((TIMMessageOfflinePushSettings)object3).getAndroidSettings().getSound());
            this.setExt(((TIMMessageOfflinePushSettings)object3).getExt());
            object2 = ((TIMMessageOfflinePushSettings)object3).getDescr();
            this.title = ((TIMMessageOfflinePushSettings)object3).getAndroidSettings().getTitle();
        }
        this.opt = tIMMessage.getRecvFlag().getValue();
        this.setTag(tIMMessage.getConversation().getPeer());
        this.setConversationType(tIMMessage.getConversation().getType());
        this.setConversationId(tIMMessage.getConversation().getPeer());
        if (tIMMessage.getSenderProfile() != null) {
            object3 = tIMMessage.getSenderProfile().getIdentifier();
            if (!TextUtils.isEmpty((CharSequence)object3)) {
                this.setSenderIdentifier((String)object3);
            }
            if (!TextUtils.isEmpty((CharSequence)(object = tIMMessage.getSenderProfile().getNickName()))) {
                this.setSenderNickName((String)object);
            }
        }
        if (tIMMessage.getSenderGroupMemberProfile() != null && !TextUtils.isEmpty((CharSequence)(object3 = tIMMessage.getSenderGroupMemberProfile().getNameCard()))) {
            this.setSenderNickName((String)object3);
        }
        this.setGroupName(tIMMessage.getGroupName());
        if (this.conversationType == TIMConversationType.C2C) {
            if (TextUtils.isEmpty((CharSequence)this.title)) {
                this.setTitle(this.senderNickName);
            }
        } else {
            if (TextUtils.isEmpty((CharSequence)this.title)) {
                this.setTitle(this.groupName);
            }
            if (TextUtils.isEmpty((CharSequence)(object3 = this.senderNickName))) {
                object3 = this.senderIdentifier;
            }
            string = string + (String)object3 + ": ";
        }
        if (TextUtils.isEmpty((CharSequence)this.title)) {
            this.setTitle(this.conversationId);
        }
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            string = string + (String)object2;
        } else {
            int n = 0;
            while ((long)n < tIMMessage.getElementCount()) {
                object = tIMMessage.getElement(n);
                if (((TIMElem)object).getType() == TIMElemType.Sound) {
                    string = string + "[\u8bed\u97f3]";
                } else if (((TIMElem)object).getType() == TIMElemType.File) {
                    string = string + "[\u6587\u4ef6]";
                } else if (((TIMElem)object).getType() == TIMElemType.Text) {
                    object2 = (TIMTextElem)object;
                    string = string + ((TIMTextElem)object2).getText();
                } else if (((TIMElem)object).getType() == TIMElemType.Image) {
                    string = string + "[\u56fe\u7247]";
                } else if (((TIMElem)object).getType() == TIMElemType.Face) {
                    string = string + "[\u8868\u60c5]";
                } else if (((TIMElem)object).getType() == TIMElemType.Custom) {
                    object2 = (TIMCustomElem)object;
                    if (!TextUtils.isEmpty((CharSequence)((TIMCustomElem)object2).getDesc())) {
                        string = string + "[" + ((TIMCustomElem)object2).getDesc() + "]";
                    }
                    if (this.ext == null) {
                        this.setExt(((TIMCustomElem)object2).getExt());
                    }
                } else if (((TIMElem)object).getType() == TIMElemType.Location) {
                    object2 = (TIMLocationElem)object;
                    string = string + "[\u4f4d\u7f6e\u4fe1\u606f]" + ((TIMLocationElem)object2).getDesc();
                } else if (((TIMElem)object).getType() == TIMElemType.Video) {
                    string = string + "[\u89c6\u9891]";
                }
                ++n;
            }
        }
        this.setContent(string);
        if (this.getSound() == null) {
            TIMOfflinePushSettings tIMOfflinePushSettings = new TIMOfflinePushSettings();
            if (IMMsfCoreProxy.get().getOfflinePushSettingsFromLocal(context, this.identifier, tIMOfflinePushSettings)) {
                if (this.conversationType == TIMConversationType.C2C && tIMOfflinePushSettings.getC2cMsgRemindSound() != null) {
                    this.setSound(tIMOfflinePushSettings.getC2cMsgRemindSound());
                } else if (this.conversationType == TIMConversationType.Group && tIMOfflinePushSettings.getGroupMsgRemindSound() != null) {
                    this.setSound(tIMOfflinePushSettings.getGroupMsgRemindSound());
                }
            }
        }
        this.setIsValid(true);
    }

    public Uri getSound() {
        return this.sound;
    }

    public void setSound(Uri uri) {
        if (uri != null) {
            this.sound = uri;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    void setIsValid(boolean bl2) {
        this.isValid = bl2;
    }

    void setTag(String string) {
        this.tag = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public String getContent() {
        if (this.content == null) {
            return "";
        }
        return this.content;
    }

    public void setExt(byte[] byArray) {
        if (byArray != null) {
            this.ext = byArray;
        }
    }

    public byte[] getExt() {
        if (this.ext == null) {
            return "".getBytes();
        }
        return this.ext;
    }

    public TIMConversationType getConversationType() {
        return this.conversationType;
    }

    void setConversationType(TIMConversationType tIMConversationType) {
        this.conversationType = tIMConversationType;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    void setConversationId(String string) {
        this.conversationId = string;
    }

    public String getSenderIdentifier() {
        return this.senderIdentifier;
    }

    void setSenderIdentifier(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.senderIdentifier = string;
    }

    public String getSenderNickName() {
        return this.senderNickName;
    }

    void setSenderNickName(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.senderNickName = string;
    }

    public TIMGroupReceiveMessageOpt getGroupReceiveMsgOpt() {
        for (TIMGroupReceiveMessageOpt tIMGroupReceiveMessageOpt : TIMGroupReceiveMessageOpt.values()) {
            if (tIMGroupReceiveMessageOpt.getValue() != this.opt) continue;
            return tIMGroupReceiveMessageOpt;
        }
        return TIMGroupReceiveMessageOpt.ReceiveAndNotify;
    }

    void setGroupReceiveMsgOpt(long l) {
        this.opt = l;
    }

    public String getGroupName() {
        return this.groupName;
    }

    void setGroupName(String string) {
        this.groupName = string;
    }

    public void doNotify(Context context, int n) {
        String string = "\u6536\u5230\u4e00\u6761\u65b0\u6d88\u606f";
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context.getApplicationContext());
        builder.setContentTitle((CharSequence)this.getTitle());
        builder.setContentText((CharSequence)this.getContent());
        builder.setSmallIcon(n);
        builder.setTicker((CharSequence)string);
        builder.setAutoCancel(true);
        builder.setDefaults(-1);
        if (this.sound != null) {
            builder.setDefaults(6);
            builder.setSound(this.sound);
        }
        Intent intent = context.getApplicationContext().getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        builder.setContentIntent(PendingIntent.getActivity((Context)context, (int)((int)SystemClock.uptimeMillis()), (Intent)intent, (int)0x8000000));
        context = (NotificationManager)context.getApplicationContext().getSystemService("notification");
        context.notify(this.tag, 520, builder.build());
    }

    protected void setIdentifier(String string) {
        if (string != null) {
            this.identifier = string;
        }
    }
}

