/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import android.net.Uri;
import android.text.TextUtils;
import com.tencent.imcore.APNsInfo;
import com.tencent.imcore.AndroidOfflinePushInfo;
import com.tencent.imcore.OfflinePushInfo;

public class TIMMessageOfflinePushSettings {
    private String descr;
    private byte[] ext;
    private boolean isEnabled = true;
    private AndroidSettings androidSettings;
    private IOSSettings iosSettings;

    public void setDescr(String string) {
        this.descr = string;
    }

    public String getDescr() {
        return this.descr;
    }

    public void setExt(byte[] byArray) {
        this.ext = byArray;
    }

    public byte[] getExt() {
        return this.ext;
    }

    public void setEnabled(boolean bl2) {
        this.isEnabled = bl2;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public AndroidSettings getAndroidSettings() {
        return this.androidSettings;
    }

    public void setAndroidSettings(AndroidSettings androidSettings) {
        this.androidSettings = androidSettings;
    }

    public IOSSettings getIosSettings() {
        return this.iosSettings;
    }

    public void setIosSettings(IOSSettings iOSSettings) {
        this.iosSettings = iOSSettings;
    }

    protected static TIMMessageOfflinePushSettings convertFrom(OfflinePushInfo object) {
        TIMMessageOfflinePushSettings tIMMessageOfflinePushSettings = new TIMMessageOfflinePushSettings();
        if (object != null && ((OfflinePushInfo)object).getIsValid()) {
            try {
                tIMMessageOfflinePushSettings.setEnabled(((OfflinePushInfo)object).getFlag() == 0L);
                tIMMessageOfflinePushSettings.setDescr(new String(((OfflinePushInfo)object).getDesc(), "utf-8"));
                tIMMessageOfflinePushSettings.setExt(((OfflinePushInfo)object).getExt());
                tIMMessageOfflinePushSettings.androidSettings.setTitle(new String(((OfflinePushInfo)object).getAndroidInfo().getTitle(), "utf-8"));
                tIMMessageOfflinePushSettings.androidSettings.setSound(Uri.parse((String)new String(((OfflinePushInfo)object).getAndroidInfo().getSound(), "utf-8")));
                tIMMessageOfflinePushSettings.androidSettings.setNotifyMode(NotifyMode.convertFrom(((OfflinePushInfo)object).getAndroidInfo().getNotifyMode()));
                tIMMessageOfflinePushSettings.iosSettings.setSound(new String(((OfflinePushInfo)object).getApns().getSound(), "utf-8"));
                tIMMessageOfflinePushSettings.iosSettings.setBadgeEnabled(((OfflinePushInfo)object).getApns().getBadgeMode() == 0L);
            }
            catch (Throwable throwable) {
                object = throwable;
                throwable.printStackTrace();
            }
        }
        return tIMMessageOfflinePushSettings;
    }

    protected OfflinePushInfo convertTo() {
        Throwable throwable;
        Object object;
        OfflinePushInfo offlinePushInfo = new OfflinePushInfo();
        offlinePushInfo.setIsValid(true);
        offlinePushInfo.setFlag(this.isEnabled ? 0L : 1L);
        if (!TextUtils.isEmpty((CharSequence)this.descr)) {
            try {
                offlinePushInfo.setDesc(this.descr.getBytes("utf-8"));
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throwable2.printStackTrace();
            }
        }
        if (this.ext != null) {
            offlinePushInfo.setExt(this.ext);
        }
        if (this.androidSettings != null) {
            object = new AndroidOfflinePushInfo();
            try {
                if (!TextUtils.isEmpty((CharSequence)this.androidSettings.getTitle())) {
                    ((AndroidOfflinePushInfo)object).setTitle(this.androidSettings.getTitle().getBytes("utf-8"));
                }
                if (this.androidSettings.getSound() != null) {
                    ((AndroidOfflinePushInfo)object).setSound(this.androidSettings.getSound().toString().getBytes("utf-8"));
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throwable3.printStackTrace();
            }
            ((AndroidOfflinePushInfo)object).setNotifyMode(this.androidSettings.getNotifyMode().getValue());
            offlinePushInfo.setAndroidInfo((AndroidOfflinePushInfo)object);
        }
        if (this.iosSettings != null) {
            object = new APNsInfo();
            if (this.iosSettings.getSound() != null) {
                try {
                    ((APNsInfo)object).setSound(this.iosSettings.getSound().getBytes("utf-8"));
                    ((APNsInfo)object).setBadgeMode(this.iosSettings.isBadgeEnabled ? 0L : 1L);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throwable4.printStackTrace();
                }
            }
            offlinePushInfo.setApns((APNsInfo)object);
        }
        return offlinePushInfo;
    }

    public class IOSSettings {
        private String sound = "";
        private boolean isBadgeEnabled = true;

        public String getSound() {
            return this.sound;
        }

        public void setSound(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return;
            }
            this.sound = string;
        }

        public boolean isBadgeEnabled() {
            return this.isBadgeEnabled;
        }

        public void setBadgeEnabled(boolean bl2) {
            this.isBadgeEnabled = bl2;
        }
    }

    public class AndroidSettings {
        private String title = "";
        private Uri sound;
        private NotifyMode notifyMode = NotifyMode.Normal;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return;
            }
            this.title = string;
        }

        public Uri getSound() {
            return this.sound;
        }

        public void setSound(Uri uri) {
            this.sound = uri;
        }

        public NotifyMode getNotifyMode() {
            return this.notifyMode;
        }

        public void setNotifyMode(NotifyMode notifyMode) {
            if (notifyMode == null) {
                return;
            }
            this.notifyMode = notifyMode;
        }
    }

    public static enum NotifyMode {
        Normal(0),
        Custom(1);

        private int value = 0;

        private NotifyMode(int n2) {
            this.value = n2;
        }

        final int getValue() {
            return this.value;
        }

        static NotifyMode convertFrom(long l) {
            for (NotifyMode notifyMode : NotifyMode.values()) {
                if ((long)notifyMode.getValue() != l) continue;
                return notifyMode;
            }
            return Normal;
        }
    }
}

