/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tencent.IMFunc;
import com.tencent.TIMConversation;
import com.tencent.TIMConversationType;
import com.tencent.TIMElem;
import com.tencent.TIMExceptionListener;
import com.tencent.TIMGroupMemberInfo;
import com.tencent.TIMGroupReceiveMessageOpt;
import com.tencent.TIMManager;
import com.tencent.TIMMessageOfflinePushSettings;
import com.tencent.TIMMessagePriority;
import com.tencent.TIMMessageStatus;
import com.tencent.TIMUserProfile;
import com.tencent.hg;
import com.tencent.imcore.Elem;
import com.tencent.imcore.Msg;
import com.tencent.imcore.MsgPriority;
import com.tencent.imcore.OfflinePushInfo;
import com.tencent.imsdk.QLog;
import java.io.UnsupportedEncodingException;

public class TIMMessage {
    private static final String tag = "imsdk.TIMMessage";
    private static final TIMElem defaultElem = new hg();
    private TIMConversation conversation;
    public Msg msg;

    Msg getMsg() {
        return this.msg;
    }

    public TIMMessage() {
        try {
            this.msg = Msg.newMsg();
        }
        catch (UnknownError unknownError) {
            Object object = unknownError;
            object = IMFunc.getExceptionInfo(unknownError);
            QLog.e(tag, 1, (String)object);
            throw new OutOfMemoryError();
        }
        this.conversation = new TIMConversation();
    }

    TIMMessage(Msg object) {
        try {
            this.msg = Msg.newMsg((Msg)object);
        }
        catch (UnknownError unknownError) {
            object = unknownError;
            object = IMFunc.getExceptionInfo(unknownError);
            QLog.e(tag, 1, (String)object);
            throw new OutOfMemoryError();
        }
        this.conversation = new TIMConversation();
        this.conversation.fromSession(this.msg.session());
    }

    public boolean isSelf() {
        if (this.msg != null) {
            return this.msg.isSelf();
        }
        return true;
    }

    public long timestamp() {
        if (this.msg != null) {
            return this.msg.time();
        }
        return 0L;
    }

    public boolean isRead() {
        if (this.msg != null) {
            return this.msg.isRead();
        }
        return true;
    }

    public TIMMessageStatus status() {
        if (this.msg == null) {
            return TIMMessageStatus.SendSucc;
        }
        switch (this.msg.status()) {
            case 1: {
                return TIMMessageStatus.Sending;
            }
            case 2: {
                return TIMMessageStatus.SendSucc;
            }
            case 3: {
                return TIMMessageStatus.SendFail;
            }
            case 4: {
                return TIMMessageStatus.HasDeleted;
            }
        }
        return TIMMessageStatus.SendSucc;
    }

    public TIMMessagePriority getPriority() {
        if (this.msg == null) {
            return TIMMessagePriority.Normal;
        }
        for (TIMMessagePriority tIMMessagePriority : TIMMessagePriority.values()) {
            if (tIMMessagePriority.getValue() != this.msg.priority().swigValue()) continue;
            return tIMMessagePriority;
        }
        return TIMMessagePriority.Normal;
    }

    public void setPriority(TIMMessagePriority tIMMessagePriority) {
        if (this.msg != null) {
            this.msg.setPriority(MsgPriority.swigToEnum(tIMMessagePriority.getValue()));
        }
    }

    public TIMGroupReceiveMessageOpt getRecvFlag() {
        if (this.msg != null) {
            return TIMGroupReceiveMessageOpt.values()[this.msg.getRecvFlag()];
        }
        return null;
    }

    public String getSender() {
        if (this.msg != null) {
            return this.msg.getSender();
        }
        QLog.i(tag, 1, "msg is null");
        return null;
    }

    public String getMsgId() {
        String string;
        if (this.msg == null) {
            QLog.i(tag, 1, "msg is null");
            string = "";
        } else {
            try {
                string = new String(this.msg.msgid(), "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
                unsupportedEncodingException.printStackTrace();
                return "";
            }
        }
        QLog.i(tag, 1, "msgid " + string);
        return string;
    }

    public boolean DeleteFromStorage() {
        if (this.msg != null) {
            return this.msg.deleteFromStorage();
        }
        QLog.i(tag, 1, "msg is null");
        return false;
    }

    public long getMsgUniqueId() {
        if (this.msg != null) {
            return this.msg.uniqueid();
        }
        return 0L;
    }

    public int addElement(TIMElem object) {
        if (object == null) {
            return 1;
        }
        if ((object = ((TIMElem)object).convertTo()) == null) {
            return 1;
        }
        this.msg.addElem((Elem)object);
        return 0;
    }

    public long getElementCount() {
        if (this.msg == null) {
            return 0L;
        }
        return this.msg.elemSize();
    }

    public TIMElem getElement(int n) {
        if (this.msg == null || n < 0) {
            return defaultElem;
        }
        try {
            this.msg.elemType(n);
            Elem elem = this.msg.getElem(n);
            return TIMElem.convertFrom(elem);
        }
        catch (Throwable throwable) {
            Object object = throwable;
            object = IMFunc.getExceptionInfo(throwable);
            QLog.e(tag, 1, (String)object);
            TIMExceptionListener tIMExceptionListener = TIMManager.getInstance().getExceptionListener();
            if (tIMExceptionListener != null) {
                tIMExceptionListener.onException((String)object);
            }
            return defaultElem;
        }
    }

    public TIMConversation getConversation() {
        return this.conversation;
    }

    void setConversation(TIMConversation tIMConversation) {
        this.conversation = tIMConversation;
    }

    public boolean remove() {
        if (this.msg == null) {
            return false;
        }
        return this.msg.remove();
    }

    public boolean hasGap() {
        if (this.msg == null) {
            return false;
        }
        return this.msg.hasGap();
    }

    public TIMUserProfile getSenderProfile() {
        if (this.msg == null) {
            return null;
        }
        TIMUserProfile tIMUserProfile = new TIMUserProfile(this.msg.getSenderProfile());
        if (tIMUserProfile.getIdentifier().length() == 0) {
            return null;
        }
        return tIMUserProfile;
    }

    public TIMGroupMemberInfo getSenderGroupMemberProfile() {
        if (this.msg == null || this.getConversation().getType() != TIMConversationType.Group) {
            return null;
        }
        TIMGroupMemberInfo tIMGroupMemberInfo = new TIMGroupMemberInfo(this.msg.getSenderGroupMemberProfile());
        if (tIMGroupMemberInfo.getUser().length() == 0) {
            return null;
        }
        return tIMGroupMemberInfo;
    }

    public void setCustomInt(int n) {
        if (this.msg == null) {
            return;
        }
        this.msg.setCustomInt(n);
    }

    public int getCustomInt() {
        if (this.msg == null) {
            return 0;
        }
        return this.msg.customInt();
    }

    public void setCustomStr(String string) {
        if (this.msg == null) {
            return;
        }
        this.msg.setCustomStr(string == null ? "" : string);
    }

    public String getCustomStr() {
        if (this.msg == null) {
            return "";
        }
        return this.msg.customStr();
    }

    public boolean convertToImportedMsg() {
        if (this.msg == null) {
            return false;
        }
        return this.msg.convertToImportedmsg();
    }

    public boolean setSender(String string) {
        if (this.msg == null) {
            return false;
        }
        return this.msg.setSender(string == null ? "" : string);
    }

    public boolean setTimestamp(long l) {
        if (this.msg == null) {
            return false;
        }
        return this.msg.setTime(l);
    }

    public boolean isPeerReaded() {
        if (this.msg == null) {
            return false;
        }
        return this.msg.isPeerRead();
    }

    public void setOfflinePushSettings(TIMMessageOfflinePushSettings object) {
        if (this.msg == null) {
            return;
        }
        if (object == null) {
            return;
        }
        object = ((TIMMessageOfflinePushSettings)object).convertTo();
        this.msg.setOfflinePushInfo((OfflinePushInfo)object);
    }

    public TIMMessageOfflinePushSettings getOfflinePushSettings() {
        if (this.msg == null || !this.msg.getOfflinePushInfo().getIsValid()) {
            return null;
        }
        return TIMMessageOfflinePushSettings.convertFrom(this.msg.getOfflinePushInfo());
    }

    public boolean copyFrom(@NonNull TIMMessage tIMMessage) {
        if (this.msg == null || tIMMessage == null) {
            return false;
        }
        return this.msg.copyFrom(tIMMessage.getMsg());
    }

    String getGroupName() {
        String string;
        block4: {
            string = null;
            try {
                string = new String(this.msg.getGroupName(), "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
                unsupportedEncodingException.printStackTrace();
            }
            catch (Throwable throwable) {
                Object object = throwable;
                object = IMFunc.getExceptionInfo(throwable);
                QLog.e(tag, 1, (String)object);
                TIMExceptionListener tIMExceptionListener = TIMManager.getInstance().getExceptionListener();
                if (tIMExceptionListener == null) break block4;
                tIMExceptionListener.onException((String)object);
            }
        }
        if (TextUtils.isEmpty(string)) {
            return "";
        }
        return string;
    }
}

