/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.tencent.IMCoreNotify;
import com.tencent.IMCoreUploadLogFileOpt;
import com.tencent.IMCoreUserConfig;
import com.tencent.IMCoreWrapper;
import com.tencent.TIMBatchOprDetailInfo;
import com.tencent.TIMCallBack;
import com.tencent.TIMConnListener;
import com.tencent.TIMConversation;
import com.tencent.TIMConversationType;
import com.tencent.TIMExceptionListener;
import com.tencent.TIMFriendshipProxyListener;
import com.tencent.TIMFriendshipSettings;
import com.tencent.TIMGroupAssistantListener;
import com.tencent.TIMGroupEventListener;
import com.tencent.TIMGroupMemberUpdateListener;
import com.tencent.TIMGroupSettings;
import com.tencent.TIMLogLevel;
import com.tencent.TIMLogListener;
import com.tencent.TIMMessage;
import com.tencent.TIMMessageListener;
import com.tencent.TIMMessageReceiptListener;
import com.tencent.TIMMessageUpdateListener;
import com.tencent.TIMNetworkStatus;
import com.tencent.TIMOfflinePushListener;
import com.tencent.TIMOfflinePushSettings;
import com.tencent.TIMOfflinePushToken;
import com.tencent.TIMRefreshListener;
import com.tencent.TIMSendMsgToMultiUserCallback;
import com.tencent.TIMUploadProgressListener;
import com.tencent.TIMUser;
import com.tencent.TIMUserDefinedStatus;
import com.tencent.TIMUserDefinedStatusListener;
import com.tencent.TIMUserStatusListener;
import com.tencent.TIMValueCallBack;
import com.tencent.aa;
import com.tencent.gx;
import com.tencent.gy;
import com.tencent.hb;
import com.tencent.he;
import com.tencent.hf;
import com.tencent.imcore.IMCore;
import com.tencent.imcore.IMCoreUser;
import com.tencent.imcore.IStatusCallback;
import com.tencent.imcore.IStatusSetUserDefCallback;
import com.tencent.imcore.PairSession;
import com.tencent.imcore.PairVectorSession;
import com.tencent.imcore.Session;
import com.tencent.imcore.SessionType;
import com.tencent.imcore.StrVec;
import com.tencent.imsdk.IMMsfCoreProxy;
import com.tencent.imsdk.IMMsfUserInfo;
import com.tencent.imsdk.QLog;
import com.tencent.qalsdk.QALOfflinePushListener;
import com.tencent.qalsdk.QALSDKManager;
import com.tencent.statistics.BeaconUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TIMManager {
    private static final String tag = "imsdk.TIMManager";
    private TIMMessageListener msgListener = null;
    private TIMConnListener connListener = null;
    private TIMUserStatusListener userStatusListener = null;
    private TIMUploadProgressListener uploadProgressListener = null;
    private TIMConversation defaultConversation = new TIMConversation("");
    private HashSet<TIMMessageListener> msgListeners = new HashSet();
    private HashSet<TIMMessageUpdateListener> msgUpListeners = new HashSet();
    private TIMGroupMemberUpdateListener memberUpdateListener;
    private TIMRefreshListener refreshListener;
    private TIMGroupEventListener groupEventListener;
    private TIMMessageReceiptListener receiptListener;
    private TIMUserDefinedStatusListener userDefinedStatusListener;
    private TIMOfflinePushListener offlinePushListener;
    private TIMExceptionListener exceptionListener;
    private String identification = "";
    private IMCoreUser coreUser;
    private IMCoreUserConfig userConfig = new IMCoreUserConfig();
    private TIMGroupAssistantListener groupAssistantListener;
    private TIMFriendshipProxyListener friendshipProxyListener;
    static String defaultId = "";
    static ConcurrentHashMap<String, TIMManager> mutiMap = new ConcurrentHashMap();
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;

    private TIMManager(String string) {
        this.identification = string;
    }

    public TIMNetworkStatus getNetworkStatus() {
        return IMMsfCoreProxy.get().getNetworkStatus();
    }

    public int getSdkAppId() {
        return IMMsfCoreProxy.get().getSdkAppId();
    }

    public String getAccountType() {
        return IMMsfCoreProxy.get().getUidType();
    }

    public static TIMManager getInstance() {
        return TIMManager.getInstanceById(defaultId);
    }

    public static TIMManager getInstanceById(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = defaultId;
        } else if (TextUtils.isEmpty((CharSequence)defaultId)) {
            if (mutiMap.containsKey(defaultId)) {
                TIMManager tIMManager = mutiMap.get(defaultId);
                defaultId = string;
                tIMManager.setIdentification(string, false);
                return tIMManager;
            }
            defaultId = string;
        }
        if (mutiMap.containsKey(string)) {
            return mutiMap.get(string);
        }
        if (string.equals(defaultId) && mutiMap.containsKey("")) {
            TIMManager tIMManager = mutiMap.get("");
            mutiMap.put(defaultId, tIMManager);
            return tIMManager;
        }
        TIMManager tIMManager = new TIMManager(string);
        mutiMap.put(string, tIMManager);
        return tIMManager;
    }

    public static ConcurrentHashMap<String, TIMManager> getMutiTIMMangerMap() {
        return mutiMap;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String string, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            QLog.w(tag, 1, "setIdentification->enter with empty id");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.identification) && string.equals(this.identification)) {
            return;
        }
        QLog.d(tag, 1, "setIdentification->update id:" + this.identification + "=>" + string + ", " + bl2);
        if (!TextUtils.isEmpty((CharSequence)this.identification)) {
            if (TextUtils.isEmpty((CharSequence)defaultId) || this.identification.equals(defaultId)) {
                defaultId = string;
            }
            if (bl2 && !TextUtils.isEmpty((CharSequence)this.identification) && mutiMap.containsKey(this.identification) && mutiMap.get(this.identification) == this) {
                mutiMap.remove(this.identification);
            }
        }
        this.identification = string;
        mutiMap.put(string, this);
    }

    public IMCoreUser getCoreUser() {
        if (this.coreUser == null && IMMsfCoreProxy.get().getMode() == 1) {
            QLog.w(tag, 1, "TIMManager|getCoreUser reload user from: " + this.identification);
            this.coreUser = IMCore.get().getUser(this.identification);
        }
        return this.coreUser;
    }

    public void setCoreUser(IMCoreUser iMCoreUser) {
        this.coreUser = iMCoreUser;
    }

    public void setMode(int n) {
        IMMsfCoreProxy.get().setMode(n);
    }

    public int getMode() {
        return IMMsfCoreProxy.get().getMode();
    }

    @Deprecated
    public void setEnv(int n) {
        QLog.w(tag, 1, "setEnv " + n);
        IMMsfCoreProxy.get().setEnv(n);
    }

    @Deprecated
    public int getEnv() {
        return IMMsfCoreProxy.get().getEnv();
    }

    public void init(Context context) {
        if (IMMsfCoreProxy.get().init(context) && IMMsfCoreProxy.get().getMode() == 1) {
            IMCore.get().initOpenIM(IMCoreWrapper.get().getGateWayIp(), context.getFilesDir().toString(), aa.a(), "2.5.0", "8568.8571");
            QLog.d(tag, 1, "init finished with imcore");
            return;
        }
        QLog.d(tag, 1, "init finished without imcore");
    }

    public void init(Context context, int n, String string) {
        if (IMMsfCoreProxy.get().init(context, n, string) && IMMsfCoreProxy.get().getMode() == 1) {
            IMCore.get().initOpenIM("", context.getFilesDir().toString(), aa.a(), "2.5.0", "8568.8571");
            QLog.d(tag, 1, "init finished with imcore");
            return;
        }
        QLog.d(tag, 1, "init finished without imcore");
    }

    public void init(Context context, int n) {
        if (IMMsfCoreProxy.get().init(context, n) && IMMsfCoreProxy.get().getMode() == 1) {
            IMCore.get().initOpenIM("", context.getFilesDir().toString(), aa.a(), "2.5.0", "8568.8571");
            QLog.d(tag, 1, "init finished with imcore");
            return;
        }
        QLog.d(tag, 1, "init finished without imcore");
    }

    private void ensureId(String string) {
        if (string == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.identification) && !string.equals(this.identification)) {
            IMMsfCoreProxy.get().logout(this.identification);
        }
        this.setIdentification(string, true);
        this.coreUser = null;
        if (TextUtils.isEmpty((CharSequence)this.defaultConversation.getIdentifer())) {
            this.defaultConversation.setIdentifer(string);
        }
    }

    public void login(int n, @NonNull TIMUser tIMUser, @NonNull String string, @NonNull TIMCallBack tIMCallBack) {
        this.ensureId(tIMUser.getIdentifier());
        IMMsfCoreProxy.get().login(n, tIMUser, string, tIMCallBack);
    }

    public void login(@NonNull String string, @NonNull String string2, @NonNull TIMCallBack tIMCallBack) {
        this.ensureId(string);
        IMMsfCoreProxy.get().login(string, string2, tIMCallBack);
    }

    public void logout() {
        this.logout(null);
    }

    public void logout(TIMCallBack tIMCallBack) {
        if (TextUtils.isEmpty((CharSequence)this.identification)) {
            return;
        }
        QLog.i(tag, 1, "Logout|0-CallByUser| identifier: " + this.identification);
        IMMsfCoreProxy.get().logout(this.identification, tIMCallBack);
        mutiMap.remove(this.identification);
        if (defaultId.equals(this.identification)) {
            QLog.d(tag, 1, "reset default id");
            defaultId = "";
        }
        this.identification = "";
    }

    public long getConversationCount() {
        if (!IMCoreWrapper.get().isReady()) {
            return 0L;
        }
        long l = this.getCoreUser().sessionCount();
        QLog.i(tag, 1, "getConversationCount: " + l);
        return l;
    }

    public TIMConversation getConversationByIndex(long l) {
        if (!IMCoreWrapper.get().isReady()) {
            return this.defaultConversation;
        }
        Session session = this.getCoreUser().getSession(l);
        TIMConversation tIMConversation = new TIMConversation(this.identification);
        tIMConversation.fromSession(session);
        QLog.i(tag, 1, "getConversationByIndex: " + l + " type: " + (Object)((Object)tIMConversation.getType()) + " peer: " + tIMConversation.getPeer());
        return tIMConversation;
    }

    public List<TIMConversation> getConversionList() {
        ArrayList<TIMConversation> arrayList = new ArrayList<TIMConversation>();
        if (!IMCoreWrapper.get().isReady()) {
            return arrayList;
        }
        PairVectorSession pairVectorSession = this.getCoreUser().getSessionList();
        int n = 0;
        while ((long)n < pairVectorSession.size()) {
            PairSession pairSession = pairVectorSession.get(n);
            TIMConversation tIMConversation = new TIMConversation(this.identification);
            tIMConversation.setPeer(new String(pairSession.getFirst()));
            tIMConversation.setType(TIMConversationType.getType(pairSession.getSecond()));
            arrayList.add(tIMConversation);
            ++n;
        }
        return arrayList;
    }

    public TIMConversation getConversation(TIMConversationType tIMConversationType, String string) {
        if (!IMCoreWrapper.get().isReady()) {
            return this.defaultConversation;
        }
        if (string == null) {
            QLog.e(tag, 1, "get conversation with null peer");
            return this.defaultConversation;
        }
        TIMConversation tIMConversation = new TIMConversation(this.identification);
        tIMConversation.setPeer(string);
        tIMConversation.setType(tIMConversationType);
        return tIMConversation;
    }

    public boolean deleteConversation(TIMConversationType tIMConversationType, String string) {
        if (!IMCoreWrapper.get().isReady()) {
            return false;
        }
        if (string == null) {
            QLog.e(tag, 1, "delete conversation with null peer");
            return false;
        }
        QLog.i(tag, 1, "before deleteConversation");
        int n = (int)this.getConversationCount();
        for (int i = 0; i < n; ++i) {
            this.getConversationByIndex(i);
        }
        SessionType sessionType = TIMConversationType.getType(tIMConversationType);
        boolean bl2 = this.getCoreUser().deleteSession(sessionType, string);
        QLog.i(tag, 1, "after deleteConversation");
        n = (int)this.getConversationCount();
        for (int i = 0; i < n; ++i) {
            this.getConversationByIndex(i);
        }
        return bl2;
    }

    public boolean deleteConversationAndLocalMsgs(TIMConversationType tIMConversationType, String string) {
        if (!IMCoreWrapper.get().isReady()) {
            return false;
        }
        if (string == null) {
            QLog.e(tag, 1, "delete conversation with null peer");
            return false;
        }
        QLog.i(tag, 1, "before deleteConversation");
        int n = (int)this.getConversationCount();
        for (int i = 0; i < n; ++i) {
            this.getConversationByIndex(i);
        }
        SessionType sessionType = TIMConversationType.getType(tIMConversationType);
        boolean bl2 = this.getCoreUser().deleteSessionAndMsgs(sessionType, string);
        QLog.i(tag, 1, "after deleteConversation");
        n = (int)this.getConversationCount();
        for (int i = 0; i < n; ++i) {
            this.getConversationByIndex(i);
        }
        return bl2;
    }

    public void setGroupEventListener(TIMGroupEventListener tIMGroupEventListener) {
        this.groupEventListener = tIMGroupEventListener;
    }

    TIMGroupEventListener getGroupEventListener() {
        return this.groupEventListener;
    }

    @Deprecated
    public void setGroupMemberUpdateListener(TIMGroupMemberUpdateListener tIMGroupMemberUpdateListener) {
        this.memberUpdateListener = tIMGroupMemberUpdateListener;
    }

    TIMGroupMemberUpdateListener getGroupMemberUpdateListener() {
        return this.memberUpdateListener;
    }

    public void addMessageListener(TIMMessageListener tIMMessageListener) {
        this.msgListeners.add(tIMMessageListener);
    }

    public void removeMessageListener(TIMMessageListener tIMMessageListener) {
        this.msgListeners.remove(tIMMessageListener);
    }

    Set<TIMMessageListener> getMessageListeners() {
        return this.msgListeners;
    }

    public void addMessageUpdateListener(TIMMessageUpdateListener tIMMessageUpdateListener) {
        this.msgUpListeners.add(tIMMessageUpdateListener);
    }

    public void removeMessageUpdateListener(TIMMessageUpdateListener tIMMessageUpdateListener) {
        this.msgUpListeners.remove(tIMMessageUpdateListener);
    }

    Set<TIMMessageUpdateListener> getMessageUpdateListeners() {
        return this.msgUpListeners;
    }

    public void setConnectionListener(TIMConnListener tIMConnListener) {
        this.connListener = tIMConnListener;
    }

    @Deprecated
    public void setRefreshLiistener(TIMRefreshListener tIMRefreshListener) {
        this.refreshListener = tIMRefreshListener;
    }

    public void setRefreshListener(TIMRefreshListener tIMRefreshListener) {
        this.refreshListener = tIMRefreshListener;
    }

    TIMRefreshListener getRefreshListener() {
        return this.refreshListener;
    }

    public TIMConnListener getConnectionListener() {
        return this.connListener;
    }

    public void setExceptionListener(TIMExceptionListener tIMExceptionListener) {
        this.exceptionListener = tIMExceptionListener;
    }

    public TIMExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setLogListener(TIMLogListener tIMLogListener) {
        IMMsfCoreProxy.get().setTIMLogListener(tIMLogListener);
    }

    public void setLogListenCallBackLevel(TIMLogLevel tIMLogLevel) {
        IMMsfCoreProxy.get().setTIMLogCbLevel(tIMLogLevel);
    }

    public void log(int n, String string, String string2) {
        switch (n) {
            case 4: {
                QLog.d(string, 1, string2);
                return;
            }
            case 3: {
                QLog.i(string, 1, string2);
                return;
            }
            case 2: {
                QLog.w(string, 1, string2);
                return;
            }
            case 1: {
                QLog.e(string, 1, string2);
            }
        }
    }

    public boolean uploadLogFile(IMCoreUploadLogFileOpt iMCoreUploadLogFileOpt) {
        return IMMsfCoreProxy.get().uploadLogFile(this.identification, iMCoreUploadLogFileOpt);
    }

    public void initLogSettings(boolean bl2, String string) {
        if (!IMMsfCoreProxy.get().inited) {
            IMCoreWrapper.get().initLogSettings(bl2, string);
        }
    }

    public void setLogLevel(TIMLogLevel tIMLogLevel) {
        if (!IMMsfCoreProxy.get().inited) {
            IMCoreWrapper.get().setLogLevel(tIMLogLevel);
        }
    }

    public void setSoLibPath(String string) {
        if (!IMMsfCoreProxy.get().inited) {
            IMCoreWrapper.get().setSoLibPath(string);
        }
    }

    public TIMLogLevel getLogLevel() {
        return IMCoreWrapper.get().getLogLevel();
    }

    public String getLogPath() {
        return IMCoreWrapper.get().getLogPath();
    }

    public boolean getIsLogPrintEnabled() {
        return IMCoreWrapper.get().getIsLogPrintEnabled();
    }

    public TIMUserStatusListener getUserStatusListener() {
        return this.userStatusListener;
    }

    public void setUserStatusListener(TIMUserStatusListener tIMUserStatusListener) {
        this.userStatusListener = tIMUserStatusListener;
    }

    public void disableCrashReport() {
        IMMsfCoreProxy.get().disableCrashReport();
    }

    public void disableBeaconReport() {
        BeaconUtil.setEnable(false);
    }

    public void disableStorage() {
        this.userConfig.setStorageEnabled(false);
    }

    public void initStorage(int n, TIMUser tIMUser, String string, TIMCallBack tIMCallBack) {
        if (tIMCallBack == null) {
            return;
        }
        if (!IMMsfCoreProxy.get().inited || IMMsfCoreProxy.get().getMode() != 1) {
            return;
        }
        this.identification = tIMUser.getIdentifier();
        this.userConfig.setNotifyCallback(new IMCoreNotify(this.identification));
        IMCore.get().initUser(n, tIMUser.getAccountType(), tIMUser.getAppIdAt3rd(), tIMUser.getIdentifier(), "0", "0".getBytes(), IMCoreWrapper.get().getGateWayIp(), IMMsfCoreProxy.get().getContext().getFilesDir().toString(), this.userConfig.convertTo(this.identification), new gx(this, tIMCallBack));
    }

    public long getServerTimeDiff() {
        return QALSDKManager.getInstance().getServetTimeSecondInterv();
    }

    public TIMUploadProgressListener getUploadProgressListener() {
        return this.uploadProgressListener;
    }

    public void setUploadProgressListener(TIMUploadProgressListener tIMUploadProgressListener) {
        this.uploadProgressListener = tIMUploadProgressListener;
    }

    @Deprecated
    public void setLogPrintEanble(boolean bl2) {
        IMCoreWrapper.get().setIsLogPrintEnabled(bl2);
    }

    public void setLogPrintEnable(boolean bl2) {
        IMCoreWrapper.get().setIsLogPrintEnabled(bl2);
    }

    public String getLoginUser() {
        IMMsfUserInfo iMMsfUserInfo = IMMsfCoreProxy.get().getMsfUserInfo(this.identification);
        if (iMMsfUserInfo != null && iMMsfUserInfo.isLoggedIn()) {
            return this.identification;
        }
        iMMsfUserInfo = IMMsfCoreProxy.get().getAnyOnLineMsfUserInfo();
        if (iMMsfUserInfo != null && iMMsfUserInfo.isLoggedIn()) {
            return iMMsfUserInfo.getUserId();
        }
        return "";
    }

    public String getVersion() {
        String string = "2.5.0";
        string = string + ".8568.8571";
        return string;
    }

    String getVideoCachePath() {
        return IMCoreWrapper.get().getVideoCachePath();
    }

    String getFileCachePath() {
        return IMCoreWrapper.get().getFileCachePath();
    }

    public void setOfflinePushListener(TIMOfflinePushListener object) {
        QLog.d(tag, 1, "registering offline push listener");
        this.offlinePushListener = object;
        object = new he(this, (TIMOfflinePushListener)object);
        QALSDKManager.getInstance().setOffLinePushListener("im_open_push.msg_push", (QALOfflinePushListener)object);
    }

    public TIMOfflinePushListener getOfflinePushListener() {
        return this.offlinePushListener;
    }

    public void disableRecentContact() {
        this.userConfig.setRecentContactEnabled(false);
    }

    public void disableRecentContactNotify() {
        this.userConfig.setRecentContactNotifyEnabled(false);
    }

    public void sendMessageToMultiUsers(@NonNull List<String> object, @NonNull TIMMessage tIMMessage, TIMSendMsgToMultiUserCallback tIMSendMsgToMultiUserCallback) {
        if (tIMSendMsgToMultiUserCallback == null) {
            return;
        }
        if (object == null || object.isEmpty() || tIMMessage == null) {
            tIMSendMsgToMultiUserCallback.onError(6017, "invalid params, users or msg is null or empty", new TIMBatchOprDetailInfo());
            return;
        }
        if (!IMCoreWrapper.get().isReady()) {
            tIMSendMsgToMultiUserCallback.onError(6013, "sdk not initialized or not logged in.", new TIMBatchOprDetailInfo());
            return;
        }
        StrVec strVec = new StrVec();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (TextUtils.isEmpty((CharSequence)string)) continue;
            strVec.pushBack(string);
        }
        this.getCoreUser().sendMsgToMultiUsers(strVec, tIMMessage.getMsg(), new hf(this, tIMSendMsgToMultiUserCallback));
    }

    public void enableGroupInfoStorage(boolean bl2) {
        this.userConfig.setGroupStorageEnabled(bl2);
    }

    public boolean isGrpStorageEnabled() {
        return this.userConfig.isGroupStorageEnabled();
    }

    public void initGroupSettings(TIMGroupSettings tIMGroupSettings) {
        if (tIMGroupSettings != null) {
            this.userConfig.setGroupSettings(tIMGroupSettings);
        }
    }

    TIMGroupSettings getGroupSettings() {
        return this.userConfig.getGroupSettings();
    }

    public void setGroupAssistantListener(TIMGroupAssistantListener tIMGroupAssistantListener) {
        this.groupAssistantListener = tIMGroupAssistantListener;
    }

    TIMGroupAssistantListener getGroupAssistantListener() {
        return this.groupAssistantListener;
    }

    public void enableFriendshipStorage(boolean bl2) {
        this.userConfig.setFriendshipStorageEnabled(bl2);
    }

    public boolean isFriendshipStorageEnabled() {
        return this.userConfig.isFriendshipStorageEnabled();
    }

    public void initFriendshipSettings(long l, @Nullable List<String> list) {
        this.userConfig.getFriendshipSettings().setSettings(l, list);
    }

    TIMFriendshipSettings getFriendshipSettings() {
        return this.userConfig.getFriendshipSettings();
    }

    public void setFriendshipProxyListener(TIMFriendshipProxyListener tIMFriendshipProxyListener) {
        this.friendshipProxyListener = tIMFriendshipProxyListener;
    }

    TIMFriendshipProxyListener getFriendshipProxyListener() {
        return this.friendshipProxyListener;
    }

    public void disableAutoReport() {
        this.userConfig.setAutoReportEnabled(false);
    }

    public void enableReadReceipt() {
        this.userConfig.setReadReceiptEnabled(true);
    }

    @Deprecated
    public void setOfflinePushToken(TIMOfflinePushToken tIMOfflinePushToken) {
        IMMsfCoreProxy.get().setOfflinePushToken(this.identification, tIMOfflinePushToken, null);
    }

    public void setOfflinePushToken(TIMOfflinePushToken tIMOfflinePushToken, TIMCallBack tIMCallBack) {
        IMMsfCoreProxy.get().setOfflinePushToken(this.identification, tIMOfflinePushToken, tIMCallBack);
    }

    public void configOfflinePushSettings(TIMOfflinePushSettings tIMOfflinePushSettings) {
        IMMsfCoreProxy.get().initOfflinePushSettings(this.identification, tIMOfflinePushSettings);
    }

    public void getOfflinePushSettings(TIMValueCallBack<TIMOfflinePushSettings> tIMValueCallBack) {
        IMMsfCoreProxy.get().getOfflinePushSettings(this.identification, tIMValueCallBack);
    }

    public void stopQALService() {
        IMMsfCoreProxy.get().stopQALService();
    }

    public TIMMessageReceiptListener getMessageReceiptListener() {
        return this.receiptListener;
    }

    public void setMessageReceiptListener(TIMMessageReceiptListener tIMMessageReceiptListener) {
        this.receiptListener = tIMMessageReceiptListener;
    }

    public TIMUserDefinedStatusListener getUserDefinedStatusListener() {
        return this.userDefinedStatusListener;
    }

    public void setUserDefinedStatusListener(TIMUserDefinedStatusListener tIMUserDefinedStatusListener) {
        this.userDefinedStatusListener = tIMUserDefinedStatusListener;
    }

    public void getUserDefinedStatus(@NonNull List<String> object, @NonNull TIMValueCallBack<List<TIMUserDefinedStatus>> tIMValueCallBack) {
        if (object == null || object.isEmpty()) {
            tIMValueCallBack.onError(6017, "invalid param. users is empty");
            return;
        }
        if (!IMCoreWrapper.get().isReady()) {
            QLog.e(tag, 1, "sdk not initialized or not logged in.");
            tIMValueCallBack.onError(6013, "sdk not initialized or not logged in.");
            return;
        }
        IMCoreUser iMCoreUser = IMCore.get().getUser(this.identification);
        if (iMCoreUser.getStatusMgr() != null) {
            StrVec strVec = new StrVec();
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (TextUtils.isEmpty((CharSequence)string)) continue;
                strVec.pushBack(string);
            }
            object = new gy(this, tIMValueCallBack);
            iMCoreUser.getStatusMgr().getUserStatus(strVec, (IStatusCallback)object);
        }
    }

    public void setUserDefinedStatus(String object, @NonNull TIMCallBack object2) {
        IMCoreUser iMCoreUser;
        if (!IMCoreWrapper.get().isReady()) {
            QLog.e(tag, 1, "sdk not initialized or not logged in.");
            object2.onError(6013, "sdk not initialized or not logged in.");
            return;
        }
        if (object == null) {
            object = "";
        }
        if ((iMCoreUser = IMCore.get().getUser(this.identification)).getStatusMgr() != null) {
            object2 = new hb(this, (TIMCallBack)object2);
            try {
                iMCoreUser.getStatusMgr().setUsedefinedData(((String)object).getBytes("utf-8"), (IStatusSetUserDefCallback)object2);
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = unsupportedEncodingException;
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    protected IMCoreUserConfig getUserConfig() {
        return this.userConfig;
    }
}

