/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tencent.TIMCallBack;
import com.tencent.TIMImageType;
import com.tencent.TIMValueCallBack;
import com.tencent.imcore.QrEventType;
import com.tencent.imsdk.IMMsfCoreProxy;
import com.tencent.imsdk.QLog;
import com.tencent.imsdk.util.QualityReportHelper;
import java.util.Collections;

public class TIMImage {
    private static final String tag = "TIMImage";
    private static Handler mainHandler = new Handler(Looper.getMainLooper());
    private TIMImageType type;
    private String url;
    private String uuid;
    private long size;
    private long height;
    private long width;
    private String identifier = "";

    protected void setIdentifier(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.identifier = string;
        }
    }

    @Deprecated
    public void getImage(@NonNull TIMValueCallBack<byte[]> tIMValueCallBack) {
        if (tIMValueCallBack == null) {
            return;
        }
        QualityReportHelper qualityReportHelper = new QualityReportHelper(QrEventType.kEventRecvPic.swigValue());
        QLog.d(tag, 1, "getImage from url: " + this.url);
        IMMsfCoreProxy.get().downloadToBuff(Collections.singletonList(this.url), tIMValueCallBack, qualityReportHelper);
    }

    public void getImage(@NonNull String string, @NonNull TIMCallBack tIMCallBack) {
        if (tIMCallBack == null) {
            return;
        }
        QualityReportHelper qualityReportHelper = new QualityReportHelper(QrEventType.kEventRecvPic.swigValue());
        QLog.d(tag, 1, "getImage from url: " + this.url);
        IMMsfCoreProxy.get().downloadToFile(Collections.singletonList(this.url), string, tIMCallBack, qualityReportHelper);
    }

    public TIMImageType getType() {
        return this.type;
    }

    void setType(TIMImageType tIMImageType) {
        this.type = tIMImageType;
    }

    public String getUuid() {
        int n = 0;
        switch (this.type) {
            case Original: {
                n = 1;
                break;
            }
            case Thumb: {
                n = 2;
                break;
            }
            case Large: {
                n = 3;
            }
        }
        return String.format("%x_%s", n, this.uuid);
    }

    void setUuid(String string) {
        this.uuid = string;
    }

    public long getSize() {
        return this.size;
    }

    void setSize(long l) {
        this.size = l;
    }

    public long getHeight() {
        return this.height;
    }

    void setHeight(long l) {
        this.height = l;
    }

    public long getWidth() {
        return this.width;
    }

    void setWidth(long l) {
        this.width = l;
    }

    public String getUrl() {
        return this.url;
    }

    void setUrl(String string) {
        this.url = string;
    }
}

