/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import com.tencent.TIMCallBack;
import com.tencent.TIMGroupPendencyGetType;
import com.tencent.TIMGroupPendencyHandledStatus;
import com.tencent.TIMGroupPendencyOperationType;
import com.tencent.TIMManager;
import com.tencent.gs;
import com.tencent.gt;
import com.tencent.imcore.GroupPendencyItem;
import com.tencent.imcore.IGroupNotifyCallback;
import java.io.UnsupportedEncodingException;

public class TIMGroupPendencyItem {
    private static final String tag = "TIMGroupPendencyItem";
    private String identifer;
    private String groupId;
    private String fromUser;
    private String toUser;
    private long addTime;
    private long pendencyType;
    private long handledStatus;
    private long operationType;
    private String requestMsg;
    private String requestUserData;
    private String handledMsg;
    private String handledUserData;
    private byte[] key;
    private byte[] auth;

    TIMGroupPendencyItem(GroupPendencyItem groupPendencyItem) {
        this(TIMManager.getInstance().getIdentification(), groupPendencyItem);
    }

    TIMGroupPendencyItem(String object, GroupPendencyItem groupPendencyItem) {
        this.identifer = object;
        if (groupPendencyItem == null) {
            return;
        }
        this.groupId = groupPendencyItem.getGroup_id();
        this.fromUser = groupPendencyItem.getFrom_id();
        this.toUser = groupPendencyItem.getTo_id();
        this.addTime = groupPendencyItem.getAdd_time();
        this.pendencyType = groupPendencyItem.getPendency_type();
        this.handledStatus = groupPendencyItem.getHandled();
        this.operationType = groupPendencyItem.getHandle_result();
        try {
            this.requestMsg = new String(groupPendencyItem.getApply_invite_msg(), "utf-8");
            this.requestUserData = new String(groupPendencyItem.getFrom_user_defined_data(), "utf-8");
            this.handledMsg = new String(groupPendencyItem.getApproval_msg(), "utf-8");
            this.handledUserData = new String(groupPendencyItem.getTo_user_defined_data(), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
        }
        this.key = groupPendencyItem.getKey();
        this.auth = groupPendencyItem.getAuthentication();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public String getToUser() {
        return this.toUser;
    }

    public long getAddTime() {
        return this.addTime / 1000L;
    }

    public TIMGroupPendencyGetType getPendencyType() {
        if (this.pendencyType == (long)TIMGroupPendencyGetType.APPLY_BY_SELF.getValue()) {
            return TIMGroupPendencyGetType.APPLY_BY_SELF;
        }
        if (this.pendencyType == (long)TIMGroupPendencyGetType.INVITED_BY_OTHER.getValue()) {
            return TIMGroupPendencyGetType.INVITED_BY_OTHER;
        }
        if (this.pendencyType == (long)TIMGroupPendencyGetType.BOTH_SELFAPPLY_AND_INVITED.getValue()) {
            return TIMGroupPendencyGetType.BOTH_SELFAPPLY_AND_INVITED;
        }
        return TIMGroupPendencyGetType.APPLY_BY_SELF;
    }

    public TIMGroupPendencyHandledStatus getHandledStatus() {
        if (this.handledStatus == (long)TIMGroupPendencyHandledStatus.NOT_HANDLED.getValue()) {
            return TIMGroupPendencyHandledStatus.NOT_HANDLED;
        }
        if (this.handledStatus == (long)TIMGroupPendencyHandledStatus.HANDLED_BY_SELF.getValue()) {
            return TIMGroupPendencyHandledStatus.HANDLED_BY_SELF;
        }
        if (this.handledStatus == (long)TIMGroupPendencyHandledStatus.HANDLED_BY_OTHER.getValue()) {
            return TIMGroupPendencyHandledStatus.HANDLED_BY_OTHER;
        }
        return TIMGroupPendencyHandledStatus.NOT_HANDLED;
    }

    public TIMGroupPendencyOperationType getOperationType() {
        if (this.operationType == (long)TIMGroupPendencyOperationType.ACCEPT.getValue()) {
            return TIMGroupPendencyOperationType.ACCEPT;
        }
        if (this.operationType == (long)TIMGroupPendencyOperationType.REFUSE.getValue()) {
            return TIMGroupPendencyOperationType.REFUSE;
        }
        return TIMGroupPendencyOperationType.REFUSE;
    }

    public String getRequestMsg() {
        return this.requestMsg;
    }

    private String getRequestUserData() {
        return this.requestUserData;
    }

    public String getHandledMsg() {
        return this.handledMsg;
    }

    private String getHandledUserData() {
        return this.handledUserData;
    }

    public void accept(String object, TIMCallBack object2) {
        object2 = new gs(this, (TIMCallBack)object2);
        String string = "";
        if (object != null) {
            string = object;
        }
        try {
            if (this.getPendencyType() != TIMGroupPendencyGetType.APPLY_BY_SELF) {
                if (this.getPendencyType() == TIMGroupPendencyGetType.INVITED_BY_OTHER) {
                    TIMManager.getInstanceById(this.identifer).getCoreUser().getGroupMgr().handleInviteRequest(this.groupId, this.fromUser, string.getBytes("utf-8"), "".getBytes("utf-8"), 1L, 0L, this.auth, (IGroupNotifyCallback)object2);
                }
                return;
            }
            TIMManager.getInstanceById(this.identifer).getCoreUser().getGroupMgr().handleJoinRequest(this.groupId, this.fromUser, string.getBytes("utf-8"), "".getBytes("utf-8"), 1L, 0L, this.auth, (IGroupNotifyCallback)object2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void refuse(String object, TIMCallBack object2) {
        object2 = new gt(this, (TIMCallBack)object2);
        String string = "";
        if (object != null) {
            string = object;
        }
        try {
            if (this.getPendencyType() != TIMGroupPendencyGetType.APPLY_BY_SELF) {
                if (this.getPendencyType() == TIMGroupPendencyGetType.INVITED_BY_OTHER) {
                    TIMManager.getInstanceById(this.identifer).getCoreUser().getGroupMgr().handleInviteRequest(this.groupId, this.fromUser, string.getBytes("utf-8"), "".getBytes("utf-8"), 0L, 0L, this.auth, (IGroupNotifyCallback)object2);
                }
                return;
            }
            TIMManager.getInstanceById(this.identifer).getCoreUser().getGroupMgr().handleJoinRequest(this.groupId, this.fromUser, string.getBytes("utf-8"), "".getBytes("utf-8"), 0L, 0L, this.auth, (IGroupNotifyCallback)object2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
        }
    }

    abstract class aa
    extends IGroupNotifyCallback {
        public TIMCallBack a;

        public aa(TIMGroupPendencyItem tIMGroupPendencyItem, TIMCallBack tIMCallBack) {
            this.swigReleaseOwnership();
            this.a = tIMCallBack;
        }

        public abstract void a();

        public abstract void a(int var1, String var2);

        @Override
        public void done() {
            this.a();
            this.swigTakeOwnership();
        }

        @Override
        public void fail(int n, String string) {
            this.a(n, string);
            this.swigTakeOwnership();
        }
    }
}

