/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import android.text.TextUtils;
import com.tencent.IMFunc;
import com.tencent.TIMCustomElem;
import com.tencent.TIMElemType;
import com.tencent.TIMExceptionListener;
import com.tencent.TIMFaceElem;
import com.tencent.TIMFileElem;
import com.tencent.TIMGroupSystemElem;
import com.tencent.TIMGroupTipsElem;
import com.tencent.TIMImage;
import com.tencent.TIMImageElem;
import com.tencent.TIMImageType;
import com.tencent.TIMLocationElem;
import com.tencent.TIMManager;
import com.tencent.TIMProfileSystemElem;
import com.tencent.TIMSNSChangeInfo;
import com.tencent.TIMSNSSystemElem;
import com.tencent.TIMSnapshot;
import com.tencent.TIMSoundElem;
import com.tencent.TIMTextElem;
import com.tencent.TIMVideo;
import com.tencent.TIMVideoElem;
import com.tencent.cf;
import com.tencent.imcore.CustomElem;
import com.tencent.imcore.Elem;
import com.tencent.imcore.FaceElem;
import com.tencent.imcore.FileElem;
import com.tencent.imcore.FriendChangeInfoVec;
import com.tencent.imcore.ImageElem;
import com.tencent.imcore.LocationElem;
import com.tencent.imcore.MsgElemType;
import com.tencent.imcore.SoundElem;
import com.tencent.imcore.StrVec;
import com.tencent.imcore.TextElem;
import com.tencent.imcore.VideoElem;
import com.tencent.imsdk.QLog;
import java.io.UnsupportedEncodingException;

public abstract class TIMElem {
    private static final String tag = "imsdk.TIMElem";
    protected TIMElemType type = TIMElemType.Invalid;
    protected String identifier = "";

    public TIMElemType getType() {
        return this.type;
    }

    protected void setIdentifier(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.identifier = string;
        }
    }

    protected Elem convertTo() {
        if (this.getType() == TIMElemType.Invalid) {
            return null;
        }
        Elem elem = new Elem();
        if (this.getType() == TIMElemType.Text) {
            elem.setType(MsgElemType.kText);
            TextElem textElem = new TextElem();
            TIMTextElem tIMTextElem = (TIMTextElem)this;
            try {
                textElem.setContent(tIMTextElem.getText().getBytes("utf-8"));
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
                return null;
            }
            elem.setText(textElem);
        } else if (this.getType() == TIMElemType.Image) {
            elem.setType(MsgElemType.kPicNew);
            ImageElem imageElem = new ImageElem();
            TIMImageElem tIMImageElem = (TIMImageElem)this;
            if (tIMImageElem.getPath() == null) {
                return null;
            }
            imageElem.setLevel(tIMImageElem.getLevel());
            imageElem.setFormat(tIMImageElem.getImageFormat());
            try {
                elem.setResource(tIMImageElem.getPath().getBytes("utf-8"));
            }
            catch (Exception exception) {
                Exception exception3 = exception;
                exception.printStackTrace();
                return null;
            }
            elem.setImage(imageElem);
        } else if (this.getType() == TIMElemType.Sound) {
            elem.setType(MsgElemType.kPttNew);
            SoundElem soundElem = new SoundElem();
            TIMSoundElem tIMSoundElem = (TIMSoundElem)this;
            if (TextUtils.isEmpty((CharSequence)tIMSoundElem.getPath()) && tIMSoundElem.getData() == null) {
                return null;
            }
            if (tIMSoundElem.getData() != null) {
                elem.setResource(tIMSoundElem.getData());
            }
            soundElem.setFile_time((int)tIMSoundElem.getDuration());
            soundElem.setFile_size((int)tIMSoundElem.getDataSize());
            if (!TextUtils.isEmpty((CharSequence)tIMSoundElem.getPath())) {
                try {
                    soundElem.setFile_path(tIMSoundElem.getPath().getBytes("utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
            }
            elem.setSound(soundElem);
        } else if (this.getType() == TIMElemType.File) {
            elem.setType(MsgElemType.kFile);
            FileElem fileElem = new FileElem();
            TIMFileElem tIMFileElem = (TIMFileElem)this;
            if (TextUtils.isEmpty((CharSequence)tIMFileElem.getPath()) && tIMFileElem.getData() == null) {
                return null;
            }
            if (tIMFileElem.getData() != null) {
                elem.setResource(tIMFileElem.getData());
            }
            try {
                if (!TextUtils.isEmpty((CharSequence)tIMFileElem.getPath())) {
                    fileElem.setFile_path(tIMFileElem.getPath().getBytes("utf-8"));
                }
                if (!TextUtils.isEmpty((CharSequence)tIMFileElem.getFileName())) {
                    fileElem.setFile_name(tIMFileElem.getFileName().getBytes("utf-8"));
                }
            }
            catch (Exception exception) {
                Exception exception4 = exception;
                exception.printStackTrace();
            }
            fileElem.setFile_size(tIMFileElem.getFileSize());
            elem.setFile(fileElem);
        } else if (this.getType() == TIMElemType.Custom) {
            elem.setType(MsgElemType.kCustom);
            CustomElem customElem = new CustomElem();
            TIMCustomElem tIMCustomElem = (TIMCustomElem)this;
            customElem.setData(tIMCustomElem.getData());
            customElem.setExt(tIMCustomElem.getExt());
            customElem.setSound(tIMCustomElem.getSound());
            try {
                customElem.setDesc(tIMCustomElem.getDesc().getBytes("utf-8"));
            }
            catch (Exception exception) {
                Exception exception5 = exception;
                exception.printStackTrace();
            }
            elem.setCustom(customElem);
        } else if (this.getType() == TIMElemType.Location) {
            elem.setType(MsgElemType.kLocation);
            LocationElem locationElem = new LocationElem();
            TIMLocationElem tIMLocationElem = (TIMLocationElem)this;
            try {
                locationElem.setDesc(tIMLocationElem.getDesc().getBytes("utf-8"));
            }
            catch (Exception exception) {
                Exception exception6 = exception;
                exception.printStackTrace();
            }
            locationElem.setLatitude(tIMLocationElem.getLatitude());
            locationElem.setLongitude(tIMLocationElem.getLongitude());
            elem.setLocation(locationElem);
        } else if (this.getType() == TIMElemType.Face) {
            elem.setType(MsgElemType.kFace);
            FaceElem faceElem = new FaceElem();
            TIMFaceElem tIMFaceElem = (TIMFaceElem)this;
            faceElem.setIndex(tIMFaceElem.getIndex());
            if (tIMFaceElem.getData() != null) {
                faceElem.setBuf(tIMFaceElem.getData());
            }
            elem.setFace(faceElem);
        } else if (this.getType() == TIMElemType.Video) {
            elem.setType(MsgElemType.kVideo);
            VideoElem videoElem = new VideoElem();
            TIMVideoElem tIMVideoElem = (TIMVideoElem)this;
            if (tIMVideoElem.getSnapshotPath() == null || tIMVideoElem.getSnapshotPath().length() == 0) {
                return null;
            }
            if (tIMVideoElem.getSnapshotInfo() == null || tIMVideoElem.getSnapshotInfo().getType() == null) {
                return null;
            }
            if (tIMVideoElem.getVideoPath() == null || tIMVideoElem.getVideoPath().length() == 0) {
                return null;
            }
            if (tIMVideoElem.getVideoInfo() == null || tIMVideoElem.getVideoInfo().getType() == null) {
                return null;
            }
            try {
                videoElem.setVideo_path(tIMVideoElem.getVideoPath().getBytes("utf-8"));
                videoElem.setImage_path(tIMVideoElem.getSnapshotPath().getBytes("utf-8"));
                videoElem.setImage_type(tIMVideoElem.getSnapshotInfo().getType().getBytes("utf-8"));
                videoElem.setVideo_type(tIMVideoElem.getVideoInfo().getType().getBytes("utf-8"));
                elem.setResource(TIMManager.getInstance().getVideoCachePath().getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UnsupportedEncodingException unsupportedEncodingException3 = unsupportedEncodingException;
                unsupportedEncodingException.printStackTrace();
            }
            videoElem.setImage_height(tIMVideoElem.getSnapshotInfo().getHeight());
            videoElem.setImage_width(tIMVideoElem.getSnapshotInfo().getWidth());
            videoElem.setVideo_duration(tIMVideoElem.getVideoInfo().getDuaration());
            elem.setVideo(videoElem);
        } else {
            return null;
        }
        return elem;
    }

    protected static TIMElem convertFrom(Elem elem) {
        cf cf2 = new cf();
        try {
            Object object = elem.getType();
            if (object == MsgElemType.kInvalid) {
                return cf2;
            }
            if (object == MsgElemType.kText) {
                object = new TIMTextElem();
                String string = "";
                try {
                    ((TIMElem)object).setIdentifier(new String(elem.getSelf_identifier(), "utf-8"));
                    string = new String(elem.getText().getContent(), "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                ((TIMTextElem)object).setText(string);
                return object;
            }
            if (object == MsgElemType.kPicNew) {
                return TIMElem.buildImageElem(elem);
            }
            if (object == MsgElemType.kPttNew) {
                object = new TIMSoundElem();
                ((TIMSoundElem)object).setUuid(elem.getSound().getFileid());
                ((TIMSoundElem)object).setDataSize(elem.getSound().getFile_size());
                ((TIMSoundElem)object).setDuration(elem.getSound().getFile_time());
                ((TIMSoundElem)object).setTaskId(elem.getSound().getTaskid());
                ((TIMSoundElem)object).setBusinessId(elem.getSound().getBusiness_id());
                ((TIMSoundElem)object).setDownloadFlag(elem.getSound().getDownload_flag());
                StrVec strVec = elem.getSound().getUrls();
                int n = 0;
                while ((long)n < strVec.size()) {
                    ((TIMSoundElem)object).addUrl(strVec.get(n));
                    ++n;
                }
                try {
                    ((TIMElem)object).setIdentifier(new String(elem.getSelf_identifier(), "utf-8"));
                    ((TIMSoundElem)object).setPath(new String(elem.getSound().getFile_path(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException3 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                return object;
            }
            if (object == MsgElemType.kFile) {
                object = new TIMFileElem();
                ((TIMFileElem)object).setUuid(elem.getFile().getFileid());
                ((TIMFileElem)object).setFileSize(elem.getFile().getFile_size());
                ((TIMFileElem)object).setTaskId(elem.getFile().getTaskid());
                ((TIMFileElem)object).setBusinessId(elem.getFile().getBusiness_id());
                ((TIMFileElem)object).setDownloadFlag(elem.getFile().getDownload_flag());
                StrVec strVec = elem.getFile().getUrls();
                int n = 0;
                while ((long)n < strVec.size()) {
                    ((TIMFileElem)object).addUrl(strVec.get(n));
                    ++n;
                }
                try {
                    ((TIMElem)object).setIdentifier(new String(elem.getSelf_identifier(), "utf-8"));
                    ((TIMFileElem)object).setFileName(new String(elem.getFile().getFile_name(), "utf-8"));
                    ((TIMFileElem)object).setPath(new String(elem.getFile().getFile_path(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException4 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                return object;
            }
            if (object == MsgElemType.kLocation) {
                object = new TIMLocationElem();
                ((TIMLocationElem)object).setLongitude(elem.getLocation().getLongitude());
                ((TIMLocationElem)object).setLatitude(elem.getLocation().getLatitude());
                String string = "";
                try {
                    ((TIMElem)object).setIdentifier(new String(elem.getSelf_identifier(), "utf-8"));
                    string = new String(elem.getLocation().getDesc(), "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException5 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                ((TIMLocationElem)object).setDesc(string);
                return object;
            }
            if (object == MsgElemType.kCustom) {
                object = new TIMCustomElem();
                byte[] byArray = elem.getCustom().getExt();
                if (byArray != null && byArray.length > 0) {
                    ((TIMCustomElem)object).setExt(byArray);
                }
                ((TIMCustomElem)object).setData(elem.getCustom().getData());
                ((TIMCustomElem)object).setSound(elem.getCustom().getSound());
                ((TIMCustomElem)object).setExt(elem.getCustom().getExt());
                String string = "";
                try {
                    ((TIMElem)object).setIdentifier(new String(elem.getSelf_identifier(), "utf-8"));
                    string = new String(elem.getCustom().getDesc(), "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException6 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                ((TIMCustomElem)object).setDesc(string);
                return object;
            }
            if (object == MsgElemType.kFace) {
                object = new TIMFaceElem();
                try {
                    ((TIMElem)object).setIdentifier(new String(elem.getSelf_identifier(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException7 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                ((TIMFaceElem)object).setData(elem.getFace().getBuf());
                ((TIMFaceElem)object).setIndex(elem.getFace().getIndex());
                return object;
            }
            if (object == MsgElemType.kGroupTips) {
                object = new TIMGroupTipsElem(elem.getGroup_tips());
                try {
                    ((TIMElem)object).setIdentifier(new String(elem.getSelf_identifier(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException8 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                return object;
            }
            if (object == MsgElemType.kGroupReport) {
                object = new TIMGroupSystemElem(elem.getGroup_report());
                try {
                    ((TIMElem)object).setIdentifier(new String(elem.getSelf_identifier(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException9 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                return object;
            }
            if (object == MsgElemType.kFriendChange) {
                object = new TIMSNSSystemElem();
                ((TIMSNSSystemElem)object).setSubType(elem.getFriend_change().getType());
                FriendChangeInfoVec friendChangeInfoVec = elem.getFriend_change().getUsers();
                int n = 0;
                while ((long)n < friendChangeInfoVec.size()) {
                    TIMSNSChangeInfo tIMSNSChangeInfo = new TIMSNSChangeInfo(friendChangeInfoVec.get(n));
                    ((TIMSNSSystemElem)object).setPendencyReportTimestamp(elem.getFriend_change().getDdwPendencyReportTimestamp());
                    ((TIMSNSSystemElem)object).setDecideReportTimestamp(elem.getFriend_change().getDdwDecideReportTimestamp());
                    ((TIMSNSSystemElem)object).setRecommendReportTimestamp(elem.getFriend_change().getDdwRecommendReportTimestamp());
                    ((TIMSNSSystemElem)object).getChangeInfoList().add(tIMSNSChangeInfo);
                    ++n;
                }
                try {
                    ((TIMElem)object).setIdentifier(new String(elem.getSelf_identifier(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException10 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                return object;
            }
            if (object == MsgElemType.kProfileChange) {
                object = new TIMProfileSystemElem();
                ((TIMProfileSystemElem)object).setSubType(elem.getProfile_change().getType());
                ((TIMProfileSystemElem)object).setFromUser(elem.getProfile_change().getFrom());
                String string = "";
                try {
                    ((TIMElem)object).setIdentifier(new String(elem.getSelf_identifier(), "utf-8"));
                    string = new String(elem.getProfile_change().getNick(), "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException11 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
                ((TIMProfileSystemElem)object).setNickName(string);
                return object;
            }
            if (object == MsgElemType.kVideo) {
                return TIMElem.buildVideoElem(elem);
            }
        }
        catch (Throwable throwable) {
            Object object = throwable;
            object = IMFunc.getExceptionInfo(throwable);
            QLog.e(tag, 1, (String)object);
            TIMExceptionListener tIMExceptionListener = TIMManager.getInstance().getExceptionListener();
            if (tIMExceptionListener != null) {
                tIMExceptionListener.onException((String)object);
            }
            return cf2;
        }
        return cf2;
    }

    static TIMVideoElem buildVideoElem(Elem object) {
        TIMVideoElem tIMVideoElem;
        block8: {
            tIMVideoElem = new TIMVideoElem();
            try {
                Object object2 = new String(((Elem)object).getSelf_identifier(), "utf-8");
                tIMVideoElem.setIdentifier((String)object2);
                object = ((Elem)object).getVideo();
                if (object != null) {
                    tIMVideoElem.setTaskId(((VideoElem)object).getTaskid());
                    TIMVideo tIMVideo = new TIMVideo();
                    tIMVideo.setDuaration(((VideoElem)object).getVideo_duration());
                    tIMVideo.setSize(((VideoElem)object).getVideo_size());
                    if (((VideoElem)object).getVideo_type() != null && ((VideoElem)object).getVideoId() != null) {
                        tIMVideo.setType(new String(((VideoElem)object).getVideo_type(), "utf-8"));
                        tIMVideo.setUuid(new String(((VideoElem)object).getVideoId(), "utf-8"));
                    }
                    tIMVideo.setIdentifier((String)object2);
                    tIMVideo.setBusinessId(((VideoElem)object).getBusiness_id());
                    tIMVideo.setDownloadFlag(((VideoElem)object).getVideo_download_flag());
                    StrVec strVec = ((VideoElem)object).getVideo_urls();
                    int n = 0;
                    while ((long)n < strVec.size()) {
                        tIMVideo.addUrl(strVec.get(n));
                        ++n;
                    }
                    tIMVideoElem.setVideo(tIMVideo);
                    TIMSnapshot tIMSnapshot = new TIMSnapshot();
                    tIMSnapshot.setSize(((VideoElem)object).getImage_size());
                    tIMSnapshot.setHeight(((VideoElem)object).getImage_height());
                    tIMSnapshot.setWidth(((VideoElem)object).getImage_width());
                    if (((VideoElem)object).getImageId() != null && ((VideoElem)object).getImage_type() != null) {
                        tIMSnapshot.setUuid(new String(((VideoElem)object).getImageId(), "utf-8"));
                        tIMSnapshot.setType(new String(((VideoElem)object).getImage_type(), "utf-8"));
                    }
                    tIMSnapshot.setIdentifier((String)object2);
                    tIMSnapshot.setBusinessId(((VideoElem)object).getBusiness_id());
                    tIMSnapshot.setDownloadFlag(((VideoElem)object).getImage_download_flag());
                    object2 = ((VideoElem)object).getImage_urls();
                    int n2 = 0;
                    while ((long)n2 < ((StrVec)object2).size()) {
                        tIMVideo.addUrl(((StrVec)object2).get(n2));
                        ++n2;
                    }
                    tIMVideoElem.setSnapshot(tIMSnapshot);
                    if (((VideoElem)object).getImage_path() != null && ((VideoElem)object).getVideo_path() != null) {
                        tIMVideoElem.setSnapshotPath(new String(((VideoElem)object).getImage_path(), "utf-8"));
                        tIMVideoElem.setVideoPath(new String(((VideoElem)object).getVideo_path(), "utf-8"));
                    }
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                object = IMFunc.getExceptionInfo(throwable);
                QLog.e(tag, 1, (String)object);
                TIMExceptionListener tIMExceptionListener = TIMManager.getInstance().getExceptionListener();
                if (tIMExceptionListener == null) break block8;
                tIMExceptionListener.onException((String)object);
            }
        }
        return tIMVideoElem;
    }

    static TIMImageElem buildImageElem(Elem elem) {
        TIMImageElem tIMImageElem;
        block2: {
            tIMImageElem = new TIMImageElem();
            try {
                String string = new String(elem.getSelf_identifier(), "utf-8");
                String string2 = new String(elem.getResource(), "utf-8");
                ImageElem imageElem = elem.getImage();
                tIMImageElem = TIMElem.buildImageElem(imageElem, string);
                tIMImageElem.setIdentifier(string);
                tIMImageElem.setPath(string2);
                tIMImageElem.setImageFormat(elem.getImage().getFormat());
                tIMImageElem.setLevel(elem.getImage().getLevel());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                String string = IMFunc.getExceptionInfo(throwable);
                QLog.e(tag, 1, string);
                TIMExceptionListener tIMExceptionListener = TIMManager.getInstance().getExceptionListener();
                if (tIMExceptionListener == null) break block2;
                tIMExceptionListener.onException(string);
            }
        }
        return tIMImageElem;
    }

    static TIMImageElem buildImageElem(ImageElem imageElem, String string) {
        TIMImage tIMImage;
        TIMImageElem tIMImageElem = new TIMImageElem();
        if (imageElem.getOrig_url() != null && imageElem.getOrig_url().length() > 0) {
            tIMImage = new TIMImage();
            tIMImage.setType(TIMImageType.Original);
            tIMImage.setUuid(imageElem.getFileid());
            tIMImage.setHeight(imageElem.getPic_height());
            tIMImage.setWidth(imageElem.getPic_width());
            tIMImage.setSize(imageElem.getPic_size());
            tIMImage.setUrl(imageElem.getOrig_url());
            tIMImage.setIdentifier(string);
            tIMImageElem.getImageList().add(tIMImage);
        }
        if (imageElem.getThumb_url() != null && imageElem.getThumb_url().length() > 0) {
            tIMImage = new TIMImage();
            tIMImage.setType(TIMImageType.Thumb);
            tIMImage.setUuid(imageElem.getFileid());
            tIMImage.setHeight(imageElem.getPic_thumb_height());
            tIMImage.setWidth(imageElem.getPic_thumb_width());
            tIMImage.setSize(imageElem.getPic_thumb_size());
            tIMImage.setUrl(imageElem.getThumb_url());
            tIMImage.setIdentifier(string);
            tIMImageElem.getImageList().add(tIMImage);
        }
        if (imageElem.getLarge_url() != null && imageElem.getLarge_url().length() > 0) {
            tIMImage = new TIMImage();
            tIMImage.setType(TIMImageType.Large);
            tIMImage.setUuid(imageElem.getFileid());
            tIMImage.setHeight(imageElem.getPic_large_height());
            tIMImage.setWidth(imageElem.getPic_large_width());
            tIMImage.setSize(imageElem.getPic_large_size());
            tIMImage.setUrl(imageElem.getLarge_url());
            tIMImage.setIdentifier(string);
            tIMImageElem.getImageList().add(tIMImage);
        }
        tIMImageElem.setTaskId(imageElem.getTaskid());
        return tIMImageElem;
    }
}

