/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import com.tencent.IMCoreWrapper;
import com.tencent.IMErrInfo;
import com.tencent.TIMCallBack;
import com.tencent.TIMConversationType;
import com.tencent.TIMElem;
import com.tencent.TIMManager;
import com.tencent.TIMMessage;
import com.tencent.TIMMessageDraft;
import com.tencent.TIMNetworkStatus;
import com.tencent.TIMValueCallBack;
import com.tencent.bk;
import com.tencent.bl;
import com.tencent.bm;
import com.tencent.bn;
import com.tencent.bo;
import com.tencent.bp;
import com.tencent.bq;
import com.tencent.br;
import com.tencent.bs;
import com.tencent.bt;
import com.tencent.bu;
import com.tencent.bv;
import com.tencent.bw;
import com.tencent.bx;
import com.tencent.by;
import com.tencent.bz;
import com.tencent.ca;
import com.tencent.cb;
import com.tencent.cc;
import com.tencent.cd;
import com.tencent.imcore.Draft;
import com.tencent.imcore.IDeleteLocalMsg;
import com.tencent.imcore.IGetMsgs;
import com.tencent.imcore.IMCore;
import com.tencent.imcore.ISendMsg;
import com.tencent.imcore.ISetReadMsg;
import com.tencent.imcore.Msg;
import com.tencent.imcore.MsgVec;
import com.tencent.imcore.QrEventType;
import com.tencent.imcore.Session;
import com.tencent.imcore.SessionType;
import com.tencent.imsdk.IMMsfCoreProxy;
import com.tencent.imsdk.QLog;
import com.tencent.imsdk.util.QualityReportHelper;
import com.tencent.statistics.BeaconEvents;
import com.tencent.statistics.BeaconUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TIMConversation {
    private static final String tag = "MSF.C.IMConversation";
    private String identifer = "";
    private String peer = "";
    private TIMConversationType type = TIMConversationType.Invalid;

    public TIMConversation() {
        this.identifer = TIMManager.getInstance().getIdentification();
    }

    public TIMConversation(String string) {
        this.identifer = string;
    }

    public static String getTag() {
        return tag;
    }

    public void setIdentifer(String string) {
        this.identifer = string;
    }

    public String getIdentifer() {
        return this.identifer;
    }

    public String getPeer() {
        return this.peer;
    }

    void setPeer(String string) {
        this.peer = string;
    }

    Session getSession() {
        SessionType sessionType = TIMConversationType.getType(this.type);
        Session session = TIMManager.getInstanceById(this.identifer).getCoreUser().getSession(sessionType, this.peer);
        if (!session.isValid()) {
            session = TIMManager.getInstanceById(this.identifer).getCoreUser().newSession(sessionType, this.peer);
        }
        return session;
    }

    void fromSession(Session session) {
        this.type = TIMConversationType.Invalid;
        if (session != null) {
            this.type = !session.isValid() ? TIMConversationType.Invalid : TIMConversationType.getType(session.type());
            this.setPeer(session.sid());
        }
    }

    boolean valid() {
        return this.type != TIMConversationType.Invalid;
    }

    public TIMConversationType getType() {
        return this.type;
    }

    void setType(TIMConversationType tIMConversationType) {
        this.type = tIMConversationType;
    }

    protected boolean paramCheckForSendMsg(TIMMessage object, TIMValueCallBack<TIMMessage> tIMValueCallBack, QualityReportHelper qualityReportHelper) {
        if (tIMValueCallBack == null) {
            return false;
        }
        if (object == null) {
            object = new IMErrInfo(6017, "invalid parameters, msg is null");
            tIMValueCallBack.onError(((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.init(QrEventType.kEventSendMsg.swigValue(), ((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.report();
            return false;
        }
        if (!IMCoreWrapper.get().isReady()) {
            object = new IMErrInfo(6013, "sdk not initialized or not logged in.");
            tIMValueCallBack.onError(((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.init(QrEventType.kEventSendMsg.swigValue(), ((IMErrInfo)object).getCode(), ((IMErrInfo)object).getMsg());
            qualityReportHelper.report();
            return false;
        }
        return true;
    }

    public void sendMessage(TIMMessage tIMMessage, TIMValueCallBack<TIMMessage> tIMValueCallBack) {
        QualityReportHelper qualityReportHelper = new QualityReportHelper();
        if (!this.paramCheckForSendMsg(tIMMessage, tIMValueCallBack, qualityReportHelper)) {
            return;
        }
        tIMMessage.setConversation(this);
        QLog.i(tag, 1, "SendMsg|1-Begin|Succ|type=" + (Object)((Object)this.type) + ", conversation=" + this.peer);
        this.getSession().sendMsg(tIMMessage.getMsg(), new bk(this, tIMMessage, (TIMValueCallBack)tIMValueCallBack, qualityReportHelper));
    }

    public void sendOnlineMessage(TIMMessage tIMMessage, TIMValueCallBack<TIMMessage> tIMValueCallBack) {
        QualityReportHelper qualityReportHelper = new QualityReportHelper();
        if (!this.paramCheckForSendMsg(tIMMessage, tIMValueCallBack, qualityReportHelper)) {
            return;
        }
        tIMMessage.setConversation(this);
        this.getSession().sendCustomMsg(tIMMessage.getMsg(), new bn(this, tIMMessage, (TIMValueCallBack)tIMValueCallBack, qualityReportHelper), 0L);
    }

    public void sendRedPacketMessage(TIMMessage tIMMessage, TIMValueCallBack<TIMMessage> tIMValueCallBack) {
        QualityReportHelper qualityReportHelper = new QualityReportHelper();
        if (!this.paramCheckForSendMsg(tIMMessage, tIMValueCallBack, qualityReportHelper)) {
            return;
        }
        tIMMessage.setConversation(this);
        this.getSession().sendRedPacketMsg(tIMMessage.getMsg(), new bo(this, tIMMessage, (TIMValueCallBack)tIMValueCallBack, qualityReportHelper));
    }

    public void sendLikeMessage(TIMMessage tIMMessage, TIMValueCallBack<TIMMessage> tIMValueCallBack) {
        QualityReportHelper qualityReportHelper = new QualityReportHelper();
        if (!this.paramCheckForSendMsg(tIMMessage, tIMValueCallBack, qualityReportHelper)) {
            return;
        }
        tIMMessage.setConversation(this);
        this.getSession().sendLikeMsg(tIMMessage.getMsg(), new bp(this, tIMMessage, (TIMValueCallBack)tIMValueCallBack, qualityReportHelper));
    }

    public void getMessage(int n, TIMMessage tIMMessage, TIMValueCallBack<List<TIMMessage>> tIMValueCallBack) {
        if (tIMValueCallBack == null) {
            return;
        }
        if (!IMCoreWrapper.get().isReady()) {
            tIMValueCallBack.onError(6013, "sdk not initialized or not logged in.");
            return;
        }
        if (!this.valid()) {
            tIMValueCallBack.onError(6004, "invalid conversation. user not login or peer is null");
            return;
        }
        Msg msg2 = null;
        if (tIMMessage != null) {
            msg2 = tIMMessage.getMsg();
        }
        if (TIMManager.getInstanceById(this.identifer).getNetworkStatus() == TIMNetworkStatus.TIM_NETWORK_STATUS_DISCONNECTED) {
            QLog.d(tag, 1, "network disconnected, get Msgs from local");
            this.getSession().getLocalMsgs(n, msg2, new bq(this, (TIMValueCallBack)tIMValueCallBack));
            return;
        }
        this.getSession().getMsgs(n, msg2, new br(this, (TIMValueCallBack)tIMValueCallBack));
    }

    public void getMessageForward(int n, TIMMessage object, TIMValueCallBack<List<TIMMessage>> tIMValueCallBack) {
        if (tIMValueCallBack == null || object == null) {
            return;
        }
        if (!IMCoreWrapper.get().isReady()) {
            tIMValueCallBack.onError(6013, "sdk not initialized or not logged in.");
            return;
        }
        if (!this.valid()) {
            tIMValueCallBack.onError(6004, "invalid conversation. user not login or peer is null");
            return;
        }
        object = ((TIMMessage)object).getMsg();
        this.getSession().getMsgsForward(n, (Msg)object, new bs(this, (TIMValueCallBack)tIMValueCallBack));
    }

    public void setReadMessage(TIMMessage tIMMessage, TIMCallBack tIMCallBack) {
        if (tIMCallBack == null) {
            return;
        }
        if (!IMCoreWrapper.get().isReady()) {
            tIMCallBack.onError(6013, "sdk not initialized or not logged in.");
            return;
        }
        if (!this.valid()) {
            tIMCallBack.onError(6004, "invalid conversation. user not login or peer is null");
            return;
        }
        this.getSession().reportReaded(tIMMessage.getMsg(), new bt(this, tIMCallBack));
    }

    public void setReadMessage(TIMMessage tIMMessage) {
        if (!IMCoreWrapper.get().isReady()) {
            QLog.e(tag, 1, "sdk not initialized or not logged in.");
            return;
        }
        if (!this.valid()) {
            QLog.e(tag, 1, "invalid conversation. user not login or peer is null");
            return;
        }
        this.getSession().reportReaded(tIMMessage.getMsg());
    }

    public void setReadMessage() {
        if (!IMCoreWrapper.get().isReady()) {
            QLog.e(tag, 1, "sdk not initialized or not logged in.");
            return;
        }
        if (!this.valid()) {
            QLog.e(tag, 1, "invalid conversation. user not login or peer is null");
            return;
        }
        this.getSession().reportReaded();
    }

    public long getUnreadMessageNum() {
        if (!IMCoreWrapper.get().isReady()) {
            QLog.e(tag, 1, "sdk not initialized or not logged in.");
            return 0L;
        }
        if (!this.valid()) {
            QLog.e(tag, 1, "invalid conversation. user not login or peer is null");
            return 0L;
        }
        return this.getSession().msgUnread();
    }

    public int saveMessage(TIMMessage tIMMessage, String string, boolean bl2) {
        if (tIMMessage == null || tIMMessage.getMsg() == null || string == null || string.length() == 0) {
            return 6017;
        }
        if (!IMCoreWrapper.get().isReady()) {
            return 6013;
        }
        if (!this.valid()) {
            return 6004;
        }
        Session session = this.getSession();
        if (session == null || !session.isValid()) {
            return 6004;
        }
        return session.saveMsg(tIMMessage.getMsg(), string, bl2);
    }

    public void getLocalMessage(int n, TIMMessage tIMMessage, TIMValueCallBack<List<TIMMessage>> tIMValueCallBack) {
        if (tIMValueCallBack == null) {
            return;
        }
        if (!IMCoreWrapper.get().isReady()) {
            tIMValueCallBack.onError(6013, "sdk not initialized or not logged in.");
            return;
        }
        if (!this.valid()) {
            tIMValueCallBack.onError(6004, "invalid conversation. user not login or peer is null");
            return;
        }
        Msg msg2 = null;
        if (tIMMessage != null) {
            msg2 = tIMMessage.getMsg();
        }
        this.getSession().getLocalMsgs(n, msg2, new bu(this, (TIMValueCallBack)tIMValueCallBack));
    }

    public void deleteLocalMessage(TIMCallBack tIMCallBack) {
        if (tIMCallBack == null) {
            return;
        }
        if (!this.valid()) {
            tIMCallBack.onError(6004, "invalid conversation. user not login or peer is null");
            return;
        }
        this.getSession().deleteLocalMsg(null, new bl(this, tIMCallBack));
    }

    public List<TIMMessage> getLastMsgs(long l) {
        if (!this.valid()) {
            QLog.e(tag, 1, "getLastMsgs, invalid conversation. user not login or peer is null");
            return null;
        }
        ArrayList<TIMMessage> arrayList = new ArrayList<TIMMessage>();
        MsgVec msgVec = this.getSession().getUndeletedMsgsFromCache(l);
        if (msgVec != null) {
            long l2 = msgVec.size();
            int n = 0;
            while ((long)n < l2) {
                TIMMessage tIMMessage = new TIMMessage(msgVec.get(n));
                arrayList.add(tIMMessage);
                ++n;
            }
        }
        return arrayList;
    }

    public int importMsg(List<TIMMessage> object) {
        if (object == null || object.size() == 0) {
            return 0;
        }
        if (!IMCoreWrapper.get().isReady()) {
            QLog.e(tag, 1, "importMsg, sdk not initialized or not logged in.");
            return 6013;
        }
        if (!this.valid()) {
            QLog.e(tag, 1, "importMsg, invalid conversation. user not login or peer is null");
            return 6004;
        }
        MsgVec msgVec = new MsgVec();
        object = object.iterator();
        while (object.hasNext()) {
            TIMMessage tIMMessage = (TIMMessage)object.next();
            msgVec.pushBack(tIMMessage.getMsg());
        }
        return this.getSession().importMsg(msgVec);
    }

    public void setDraft(TIMMessageDraft tIMMessageDraft) {
        if (!IMCoreWrapper.get().isReady()) {
            QLog.e(tag, 1, "importMsg, sdk not initialized or not logged in.");
            return;
        }
        if (!this.valid()) {
            QLog.e(tag, 1, "importMsg, invalid conversation. user not login or peer is null");
            return;
        }
        Draft draft = new Draft();
        if (tIMMessageDraft != null) {
            draft = tIMMessageDraft.convertTo();
        }
        this.getSession().setDraft(draft);
    }

    public TIMMessageDraft getDraft() {
        if (!IMCoreWrapper.get().isReady()) {
            QLog.e(tag, 1, "importMsg, sdk not initialized or not logged in.");
            return null;
        }
        if (!this.valid()) {
            QLog.e(tag, 1, "importMsg, invalid conversation. user not login or peer is null");
            return null;
        }
        return TIMMessageDraft.convertFrom(this.getSession().getDraft());
    }

    public boolean hasDraft() {
        if (!IMCoreWrapper.get().isReady()) {
            QLog.e(tag, 1, "importMsg, sdk not initialized or not logged in.");
            return false;
        }
        if (!this.valid()) {
            QLog.e(tag, 1, "importMsg, invalid conversation. user not login or peer is null");
            return false;
        }
        return this.getSession().hasDraft();
    }

    public void disableStorage() {
        if (!IMCoreWrapper.get().isReady()) {
            QLog.e(tag, 1, "disableStorage, sdk not initialized or not logged in.");
            return;
        }
        if (!this.valid()) {
            QLog.e(tag, 1, "disableStorage, invalid conversation. user not login or peer is null");
            return;
        }
        IMCore.get().addIgnoreStoreSession(TIMConversationType.getType(this.type), this.peer);
    }

    abstract class ad
    extends ISetReadMsg {
        public TIMCallBack a;

        public ad(TIMConversation tIMConversation, TIMCallBack tIMCallBack) {
            this.swigReleaseOwnership();
            this.a = tIMCallBack;
        }

        public abstract void a();

        public abstract void a(int var1, String var2);

        @Override
        public void done() {
            IMMsfCoreProxy.mainHandler.post((Runnable)new cc(this));
            this.swigTakeOwnership();
        }

        @Override
        public void fail(int n, String string) {
            IMMsfCoreProxy.mainHandler.post((Runnable)new cd(this, n, string));
            this.swigTakeOwnership();
        }
    }

    abstract class aa
    extends IDeleteLocalMsg {
        public TIMCallBack a;

        public aa(TIMConversation tIMConversation, TIMCallBack tIMCallBack) {
            this.swigReleaseOwnership();
            this.a = tIMCallBack;
        }

        public abstract void a();

        public abstract void a(int var1, String var2);

        @Override
        public void done() {
            IMMsfCoreProxy.mainHandler.post((Runnable)new bv(this));
            this.swigTakeOwnership();
        }

        @Override
        public void fail(int n, String string) {
            IMMsfCoreProxy.mainHandler.post((Runnable)new bw(this, n, string));
            this.swigTakeOwnership();
        }
    }

    abstract class ab
    extends IGetMsgs {
        public TIMValueCallBack<List<TIMMessage>> a = null;

        ab(TIMConversation tIMConversation, TIMValueCallBack<List<TIMMessage>> tIMValueCallBack) {
            this.a = tIMValueCallBack;
            this.swigReleaseOwnership();
        }

        @Override
        public final void done(MsgVec msgVec) {
            ArrayList<TIMMessage> arrayList = new ArrayList<TIMMessage>();
            if (msgVec == null) {
                QLog.i(TIMConversation.tag, 1, "getmsgs return null");
                IMMsfCoreProxy.mainHandler.post((Runnable)new bx(this, arrayList));
                this.swigTakeOwnership();
                return;
            }
            int n = 0;
            while ((long)n < msgVec.size()) {
                TIMMessage tIMMessage = new TIMMessage(msgVec.get(n));
                if (tIMMessage.getConversation().valid()) {
                    arrayList.add(tIMMessage);
                }
                ++n;
            }
            IMMsfCoreProxy.mainHandler.post((Runnable)new by(this, arrayList));
            this.swigTakeOwnership();
        }

        @Override
        public final void fail(int n, String string) {
            QLog.e(TIMConversation.tag, 1, "getmsgs failed");
            IMMsfCoreProxy.mainHandler.post((Runnable)new bz(this, n, string));
            this.swigTakeOwnership();
        }
    }

    abstract class ac
    extends ISendMsg {
        public TIMValueCallBack<TIMMessage> a = null;
        TIMMessage b = null;
        private QualityReportHelper c;

        ac(TIMConversation tIMConversation, TIMMessage tIMMessage, TIMValueCallBack<TIMMessage> object, QualityReportHelper qualityReportHelper) {
            this.b = tIMMessage;
            this.a = object;
            this.c = qualityReportHelper;
            this.swigReleaseOwnership();
            long l = tIMMessage.getElementCount();
            int n = 0;
            while ((long)n < l) {
                object = tIMMessage.getElement(n);
                object = ((TIMElem)object).getType();
                ((Enum)object).ordinal();
                ++n;
            }
        }

        @Override
        public final void done() {
            if (this.a != null) {
                QLog.i(TIMConversation.tag, 1, "SendMsg|5-Callback|Succ|");
                IMMsfCoreProxy.mainHandler.post((Runnable)new ca(this));
            } else {
                QLog.i(TIMConversation.tag, 1, "SendMsg|5-Callback|Fail|user not set succ cb");
            }
            this.swigTakeOwnership();
            if (this.c != null) {
                this.c.init(QrEventType.kEventSendMsg.swigValue(), 0, "");
                this.c.report();
            }
            long l = this.b.getElementCount();
            int n = 0;
            while ((long)n < l) {
                Object object = this.b.getElement(n);
                object = ((TIMElem)object).getType();
                switch (bm.a[((Enum)object).ordinal()]) {
                    case 1: {
                        BeaconUtil.onEvent(BeaconEvents.sendTextMsg, true, -1L, -1L, null, false);
                        break;
                    }
                    case 2: {
                        BeaconUtil.onEvent(BeaconEvents.sendImgMsg, true, -1L, -1L, null, false);
                        break;
                    }
                    case 3: {
                        BeaconUtil.onEvent(BeaconEvents.sendAudioMsg, true, -1L, -1L, null, false);
                    }
                }
                ++n;
            }
        }

        @Override
        public final void fail(int n, String object) {
            if (this.a != null) {
                QLog.i(TIMConversation.tag, 1, "SendMsg|5-Callback|Succ|code=" + n + ", msg=" + (String)object);
                IMMsfCoreProxy.mainHandler.post((Runnable)new cb(this, n, (String)object));
            } else {
                QLog.i(TIMConversation.tag, 1, "SendMsg|5-Callback|Fail|user not set fail cb, code=" + n + ", msg=" + (String)object);
            }
            this.swigTakeOwnership();
            if (this.c != null) {
                this.c.init(QrEventType.kEventSendMsg.swigValue(), n, (String)object);
                this.c.report();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("param_FailCode", "bindID failed|code: " + n + " desc: " + (String)object);
            long l = this.b.getElementCount();
            n = 0;
            while ((long)n < l) {
                object = this.b.getElement(n);
                object = ((TIMElem)object).getType();
                switch (bm.a[((Enum)object).ordinal()]) {
                    case 1: {
                        BeaconUtil.onEvent(BeaconEvents.sendTextMsg, false, -1L, -1L, hashMap, false);
                        break;
                    }
                    case 2: {
                        BeaconUtil.onEvent(BeaconEvents.sendImgMsg, false, -1L, -1L, hashMap, false);
                        break;
                    }
                    case 3: {
                        BeaconUtil.onEvent(BeaconEvents.sendAudioMsg, false, -1L, -1L, hashMap, false);
                    }
                }
                ++n;
            }
        }
    }
}

